/*
 * Shannon Duvall
 * PhotoManipulation
 * The main applet
 */
package photomanipulation;

import processing.core.*;
import java.util.ArrayList;

public class PhotoManipulation extends PApplet {

	PhotoGUI gui;
	// This is the currently showing image, not necessarily the original.
	PImage currentPic;
	
	public void setup() {
		size(880,700);
		ArrayList<PImage>pics = new ArrayList<PImage>();
		// To load a new image, drop it in the data folder and copy and 
		// paste a line like this one, only with the name of your picture.
		// These two images are 400x600.
		pics.add(loadImage("lily.jpg"));
		pics.add(loadImage("wynn.jpg"));
		gui = new PhotoGUI(pics);
		currentPic = pics.get(0);
	}

	public void draw() {
		gui.draw(this);
		image(currentPic,0,gui.BUTTON_HEIGHT);
	}
	
	public void mouseClicked(){
		currentPic = gui.mouseClicked(mouseX, mouseY, currentPic, this);
	}
}
