/*
 * Shannon Duvall
 * Button.java
 * Draws a button at the top of the screen
 * with a label.  Note that the action of the 
 * button isn't part of this object.  They 
 * are connected by having the same collection 
 * index in PhotoGUI.
 */
package photomanipulation;

import java.awt.*;
import processing.core.PApplet;

public class Button {
	private String myLabel;
	private Point myUpperLeft;
	private Point myDimensions;
	
	public Button(String label, Point uL, Point dimensions,
			PhotoAction action){
		myLabel = label;
		myUpperLeft = uL;
		myDimensions = dimensions;
	}
	
	// A button is drawn as a white rectangle outlined in black, 
	// and its label is drawn centered in the rectangle with default font.
	public void draw(PApplet canvas){
		canvas.stroke(0);
		canvas.fill(255);
		canvas.strokeWeight(1);
		canvas.rect(myUpperLeft.x,myUpperLeft.y,myDimensions.x,myDimensions.y);
		canvas.fill(0);
		canvas.textAlign(canvas.CENTER);
		canvas.text(myLabel, myUpperLeft.x+myDimensions.x/2, myUpperLeft.y+myDimensions.y/2);
	}
	
}
