package pw6arrays;

import java.util.Scanner;

import processing.core.PApplet;

public class PW6Arrays extends PApplet {

	int ALIEN_SIZE = 30; // width and height of alien
	int[] ax = new int[0]; // alien x coordinates
	int[] ay = new int[0]; // alien y coordinates
	boolean[] alive = new boolean[0]; // whether an alien is alive or dead

	int[] sx = new int[0]; // shot x coordinates
	int[] sy = new int[0]; // shot y coordinates
	
	int[] rx = new int[2]; // rocket x coordinates
	String[] rName = {"P1", "P2"}; // rocket names, seeded with default values

	// PROVIDED - called at inception of program
	public void setup() {
		size(350, 700);
		smooth();
		
		setupGame(); // setup basic game information and difficulty level
		
		resetAliens();
		resetShots();
		resetRockets();  
	}

	// PROVIDED
	// Set the y coordinate of each shot to the special value -1
	// -1 indicates that the shot has not been fired by the rocket
	public void resetShots() {
		for (int i = 0; i < sx.length; i++) {
			sy[i] = -1;
		}
	}

	// PROVIDED
	// Sets the initial x coordinates of the two rockets
	public void resetRockets() {
		rx[0] = width/4;       // left side - middle
		rx[1] = width - rx[0]; // right side - middle
	}

	// PROVIDED - called continuously during program
	public void draw() {
		background(0); // clear the screen

		// move aliens and shots
		moveAliens();
		moveShots();

		// see if we shot any aliens
		killAliens();

		// see if we shot all the aliens
		if(allDeadAliens()) {
			resetAliens();
		}

		// draw everything in the game
		drawAliens();
		drawRockets();
		drawShots();
	}

	// PROVIDED - called when the user types a key
	// Player 1: z to move left
	//           c to move right
	//           x to fire shot from rocket
	// Player 2 can play the top row of numbers...
	//           8 to move left
	//           0 to move right
	//           9 to fire shot from rocket	
	//          ... or the keypad...
	//           1 to move left
	//           3 to move right
	//           2 to fire shot from rocket
	public void keyPressed() {
		int x = 0; // default: don't move
		int i = 0; // default: move first rocket
		
		if (key == 'z') {
			x = -10;
		}
		else if (key == 'c') {
			x = 10;
		}
		else if (key == 'x') {
			fireShot(0);
		}
		else if (key == '1' || key == '8') {
			x = -10;
			i = 1;
		}
		else if (key == '3' || key == '0') {
			x = 10;
			i = 1;
		}
		else if (key == '2' || key == '9') {
			fireShot(1);
		}
		
		rx[i] = rx[i] + x;
	}

	// PROVIDED - called when aliens need to be re-drawn
	public void drawAliens() {
		for (int i = 0; i < ax.length; i++) {
			if (alive[i]) {
				fill(255, 255, 0);
				stroke(0, 255, 0);
				rect(ax[i], ay[i], ALIEN_SIZE, ALIEN_SIZE); // head
				fill(0, 255, 0);
				noStroke();
				rect(ax[i] + ALIEN_SIZE/4, ay[i] + ALIEN_SIZE/4, ALIEN_SIZE/10, ALIEN_SIZE/10); // eye
				rect(ax[i] + 3*ALIEN_SIZE/4, ay[i] + ALIEN_SIZE/4, ALIEN_SIZE/10, ALIEN_SIZE/10); // eye
			}
		}
	}

	// PROVIDED - called when rockets need to be re-drawn
	public void drawRockets() {
		int h = height/20;
		int y1 = height - h;

		fill(255, 0, 255);
		stroke(0, 255, 0);
	
		for (int i = 0; i < rx.length; i++) {
			triangle(rx[i], y1, rx[i] + h/2, height, rx[i] - h/2, height);
			int x = rx[i] - ((int)textWidth(rName[i]))/2;
			text(rName[i], x, y1-1);
		}
	}

	// PROVIDED - called when shots need to be re-drawn
	public void drawShots() {

		fill(0, 255, 255);
		stroke(255, 0, 0);
		int d = ALIEN_SIZE / 6;

		for (int i = 0; i < sx.length; i++) {
			if (sy[i] > -1) {
				ellipse(sx[i], sy[i], d, d);
			}
		}
	}

	// PROBLEM 1
	// Set each alien's x coordinate to a random number
	//     (but ensure each alien is fully on screen)
	// Set each alien's y coordinate to 0
	// Set each alien to be alive
	//
	// Test it: run program, see if multiple aliens appear
	public void resetAliens() {
		// your code here
	}

	// PROBLEM 2
	// For each alien:
	//    If the alien is alive increase the y coordinate by 1
	//    If the alien is dead, don't do anything to it's y coordinate
	// Test it: run program, see if all aliens move down the screen
	public void moveAliens() {
		// your code here
	}

	// PROBLEM 3
	// input: rocketNum, an index of the rx array (x coordinates of the rockets)
	// 
	// If all shots have been fired, do nothing, but otherwise:
	//   Find any shot with a y coordinate value of -1
	//   Set the x coordinate at that shot to the x coordinate of the indicated rocket
	//   Set the y coordinate at that shot to be the height of the screen
	//
	// example:
	// suppose that the arrays look like this and rocketNum is 0 and the height of the screen is 700
	//
	//	index    0     1     2     3
	//	   sx | 237 |  -1 | 189 |  -1 |
	//	   sy | 100 |  -1 | 157 |  -1 |
	//     rx | 150 |  15 |
	//
	// then after your code runs, the arrays should look like this 
	//	index    0     1     2     3
	//	   sx | 237 | 150 | 189 |  -1 |
	//	   sy | 100 | 700 | 157 |  -1 |
	//     rx | 150 |  15 |
	// 
	// Test it: run program and start firing shots 
	//          the shots will appear at the bottom of the screen but won't move
	//          you should not be able to fire more than 4 shots
	public void fireShot(int rocketNum) {
		// your code here
	}

	// PROBLEM 4
	// For each shot that has a y coordinate above -1, decrease the y coordinate by 1
	// 
	// Test it: the shots should move now
	//          (but they won't kill any aliens)
	//          (and when they go off screen, you should be able to fire another shot...
	//           ... if you can't then PROBLEM 3 code has an error)
	public void moveShots() {
		// your code here
	}

	// PROBLEM 5A - PROVIDED - Read the code to see what it does
	public void killAliens() { 
		for (int i = 0; i < sx.length; i++) { // for each possible shot
			if (sy[i] > -1) {                 // if a rocket has fired the shot
				checkDeath(i);                // see if the shot has hit any aliens
			}
		}
	}
	
	// PROBLEM 5B
	// input: shotNum, an index of the sx and sy arrays (x, y coordinates of the shots)
	//
	// For each alive alien, see if the shot has hit the alien
	// If any aliens are killed, set the y coordinate of the shot to -1
	// Note that a shot is allowed to kill multiple aliens
	//
	// Test it: aliens disappear when shot (and shot disappears too)
	// Hint: borrow/modify the code from the Arrow/Paddle game (Lec08Arrow)
	public void checkDeath(int shotNum) {
		// your code here
	}

	// PROBLEM 6
	// Check if all the aliens are dead and return true or false accordingly
	//
	// Test it: when all aliens killed, new aliens attack from top
	public boolean allDeadAliens() {
		// your code here
		
		return false; // dummy line of code to keep programming running - you may delete this line
	}

	// PROBLEM 7
	// Part 1
	//     --> Ask the user for the name of each rocket
	//     --> Set the rName values to be the names entered by the user
	// Part 2
	//     --> Ask the user for the number of aliens and shots
	//     --> Create new arrays for ax, ay, alive, sx, and sy based on user-entered values
	// Test it: run it, check names, number of aliens, number of shots
	public void setupGame() {
		ax = new int[4];
		ay = new int[4];
		alive = new boolean[4];
		sx = new int[4];
		sy = new int[4];

		Scanner in = new Scanner(System.in);

		// your code here
	}

	// PROBLEM 8 (for fun only, not credit)
	// --> Go back to problem 2.  Have the alien also move one pixel left or right as it also moves down
	// --> Same for problem 4.
	// --> Modify drawAliens() to draw an X for the mouth when an alien dies instead of having it disappear
	// --> Add some code to the game to track points (1 point per alien killed)
}
