/*
 * Shannon Duvall
 * 
 * This animation draws the name, one line at a time, 
 * adding one letter per line.
 */
package pw5strings;

import processing.core.PFont;

public class TruncatedAnimation extends AnimationType{
	
	// This number tells me how much of the screen I can see at once.
	// This is so the truncation lines can appear gradually rather
	// than all at once.
	int seen;

	public TruncatedAnimation(StringPlay app, YourWork yourwork){
		myApp = app;
		yours = yourwork;
		theFont = myApp.createFont("Arial", fontSize, true);
		// At first, I can only see 1 line.
		seen = theFont.getSize();
	}

	public void reset(){
		seen = theFont.getSize();
	}

	public void draw(String logo){
		yours.resetToFirstLine();
		myApp.textFont(theFont);
		myApp.textAlign(myApp.LEFT);
		myApp.stroke(0);
		myApp.fill(0);
		yours.drawTruncations(logo);
		myApp.noStroke();
		myApp.fill(255,255,255);
		// This white rectangle covers up part of the screen - the
		// part that is not "seen"
		myApp.rect(0,seen,myApp.width, myApp.height-seen);
		seen = Math.min(myApp.height,seen+1);
	}

}
