/*
 * Shannon Duvall
 * This animation breaks up the 
 * logo name into 3 separate words and 
 * draws and moves the pieces separately.
 */
package pw5strings;
 

public class ThreePiecesAnimation extends AnimationType{
	// These are the location of the 3 pieces
	int y1, y2, y3, x1, x2, x3;
	
	public ThreePiecesAnimation(StringPlay app, YourWork yourwork){
		fontSize = 32;
		yours = yourwork;
		myApp = app;
		theFont = myApp.createFont("Arial", fontSize, true);
		reset();
	}
	
	public void reset(){
		// x's start out on the left side.  
		// y's start out on the middle, but on 
		// different lines for each piece.
		y1 = myApp.height/2;
		y2 = myApp.height/2 + fontSize; 
		y3 = myApp.height/2 + 2*fontSize;
		x1 = padx;
		x2 = padx;
		x3 = padx;
	}


	public void draw(String logo){
		myApp.background(255,255,255);
		myApp.textFont(theFont);
		myApp.textAlign(myApp.LEFT);
		myApp.stroke(0);
		myApp.fill(0);
		yours.drawEachWord(logo,x1,y1,x2,y2,x3,y3);
		// Piece 1 moves up
		y1 = Math.max(fontSize, y1-1);
		// Piece 2 moves to the right
		x2= Math.min(myApp.width-fontSize, x2+1);
		// Piece 3 moves down
		y3 = Math.min(myApp.height, y3+1);
	}

	


}
