/*
 * Shannon Duvall
 * The main file for running the Movie Logo Applet.
 */

package pw5strings;

import java.io.*;
import javax.sound.sampled.*;
import processing.core.PApplet;


public class StringPlay extends PApplet {
	
	// Default String.  You can change it with the "r" key
	String logo = "Movie Magic Images";
	
	YourWork resetter = new YourWork(this);
	AnimationType trunc = new TruncatedAnimation(this, resetter);
	AnimationType three = new ThreePiecesAnimation(this, resetter);
	AnimationType colors = new ColorsAnimation(this, resetter);
	AnimationType piece = new PieceFinderAnimation(this, resetter);
	AnimationType multiple = new MultipleAnimation(this, resetter);
	AnimationType current = trunc;

	
	// Just for fun I added sound.  Feel free to put more in the list.
	String[] soundFiles = {
			"doording.wav",
			"intro.wav", 
			"OMINOUS.WAV",
			"peeeooop_x.wav",
			"slide_whistle.wav",
			"splooge.wav"
			};
	
	// You can turn the sound off by setting this to false
	boolean soundOn = true;
	
	public void setup() {
		background(255,255,255);
		size(700, 700);
		smooth();
	}

	public void draw() {
		// React to the key presses
		if (keyPressed && key != ' '){
			background(255,255,255);
			if (key == '0'){
				logo = resetter.getUserString("Enter the Studio Name. \n It should be 3 words exactly.");
			}
			else if (key == '1'){
				current = multiple;
			}
			else if (key == '2'){
				current = three;
			}
			else if (key == '3'){
				current = piece;
			}
			else if (key == '4'){
				current = colors;
			}
			else if (key == '5'){
				current = trunc;
			}
			
			current.reset();
			if (soundOn) playSound();
			// Make sure the key press doesn't happen again.
			key = ' ';
			
		}
		// No matter what, keep drawing to the screen
		current.draw(logo);
	}
	
	// This is just for fun.
	public void playSound(){
		// Choose a sound at random & play it.
		int rand = (int)(Math.random()*soundFiles.length);
		try {
	         // Open an audio input stream.
			File soundFile = new File("data/"+soundFiles[rand]);
			AudioInputStream audioIn = AudioSystem.getAudioInputStream(soundFile);
	         // Get a sound clip resource.
	         Clip clip = AudioSystem.getClip();
	         // Open audio clip and load samples from the audio input stream.
	         clip.open(audioIn);
	         clip.start();
	      } catch (UnsupportedAudioFileException e) {
	    	  System.out.println(rand);
	         e.printStackTrace();
	      } catch (IOException e) {
	    	  System.out.println(rand);
	         e.printStackTrace();
	      } catch (LineUnavailableException e) {
	    	  System.out.println(rand);
	         e.printStackTrace();
	      }
	}	
}
