/*
 * Shannon Duvall
 * This animation finds a substring in the 
 * logo and makes every instance of the substring
 * shake and be drawn a different color.  The
 * substring finding should be case-independent.
 */
package pw5strings;

import java.util.ArrayList;

import javax.swing.JOptionPane;

public class PieceFinderAnimation extends AnimationType {
	// This is the list of indices where the substring is found in the logo.
	// The "your work" object has to fill this in.
	ArrayList<Integer> myIndices = new ArrayList<Integer>();
	// This will get reset later
	String part = "";
	
	public PieceFinderAnimation(StringPlay app, YourWork yourwork){
		myIndices = new ArrayList<Integer>();
		fontSize = 40;
		myApp = app;
		yours = yourwork;
		theFont = myApp.createFont("Arial", fontSize, true);
	}
	
	// On reset, ask for the substring
	public void reset(){
		part = yours.getUserString("Enter the partial text.");
	}
	
	public void draw(String logo){
		myIndices = new ArrayList<Integer>();
		myApp.background(255,255,255);
		myApp.textFont(theFont);
		myApp.textAlign(myApp.LEFT);
		myApp.stroke(0);
		myApp.fill(0);
		yours.findPart(logo,part, this);
		drawParts(logo);
	}
	
	public void drawParts(String logo){
		int x = padx;
		int y = myApp.height/2;
		myApp.fill(255,0,0);
		if(myIndices.size() == 0){
			myApp.text(logo,x,y);
		}
		else{
			int last = 0;
			for(Integer index:myIndices){
				// Draw 2 pieces - the part before the substring...
				String first = logo.substring(last,index);
				yours.procPrint(first,x,myApp.height/2,255,0,0);
				x = x + (int)myApp.textWidth(first);
				// and the substring itself
				myApp.fill(0,0,255);
				int crazyX = x + (int)(Math.random()*(2+2+1)-2);
				int crazyY = y + (int)(Math.random()*(2+2+1)-2);
				String thePart = logo.substring(index,index+part.length());
				myApp.text(thePart,crazyX,crazyY);
				x = x + (int)myApp.textWidth(thePart);
				last = index + part.length();
			}
			// If there is a tail bit after the last substring, print it too.
			if(last<logo.length()){
				yours.procPrint(logo.substring(last),x,y,255,0,0);
			}
		}
		
	}
	
	// Helper method to hide ArrayLists from the YourWork object.
	public void addIndex(int i){
		myIndices.add(i);
	}

}
