/*
 * Shannon Duvall
 * This animation draws a 
 * scrolling logo where each letter
 * is in an alternating color.
 */
package pw5strings;

public class ColorsAnimation extends AnimationType {
	// Where the logo is on the screen.
	int x;
	int y;

	public ColorsAnimation(StringPlay app, YourWork yourWork){
		fontSize = 40;
		myApp = app;
		yours = yourWork;
		theFont = myApp.createFont("Arial", fontSize, true);
		reset();
	}
	
	public void reset(){
		// On reset, find a new spot for the logo to start.
		x = myApp.width;
		y = (int)(Math.random()*(myApp.height-fontSize));
	}
	
	public void draw(String logo){
		myApp.background(255,255,255);
		myApp.textFont(theFont);
		myApp.textAlign(myApp.LEFT);
		myApp.stroke(0);
		myApp.fill(0);
		yours.drawAltName(logo,x,y);
		// Move to the left.
		x-=4;
		if(x+myApp.textWidth(logo)<=0){
			reset();
		}
	}

}
