/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import java.util.zip.GZIPInputStream;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PMatrix3D;
import processing.core.PShape;
import processing.core.PShapeSVG;
import processing.data.XML;
import processing.opengl.PGraphicsOpenGL;
import processing.opengl.PShapeOpenGL;

public class PGraphics2D
extends PGraphicsOpenGL {
    @Override
    public boolean is2D() {
        return true;
    }

    @Override
    public boolean is3D() {
        return false;
    }

    @Override
    public void hint(int which) {
        if (which == 7) {
            PGraphics2D.showWarning("Strokes cannot be perspective-corrected in 2D.");
            return;
        }
        super.hint(which);
    }

    @Override
    public void ortho() {
        PGraphics2D.showMethodWarning("ortho");
    }

    @Override
    public void ortho(float left, float right, float bottom, float top) {
        PGraphics2D.showMethodWarning("ortho");
    }

    @Override
    public void ortho(float left, float right, float bottom, float top, float near, float far) {
        PGraphics2D.showMethodWarning("ortho");
    }

    @Override
    public void perspective() {
        PGraphics2D.showMethodWarning("perspective");
    }

    @Override
    public void perspective(float fov, float aspect, float zNear, float zFar) {
        PGraphics2D.showMethodWarning("perspective");
    }

    @Override
    public void frustum(float left, float right, float bottom, float top, float znear, float zfar) {
        PGraphics2D.showMethodWarning("frustum");
    }

    @Override
    protected void defaultPerspective() {
        super.ortho(0.0f, this.width, 0.0f, this.height, -1.0f, 1.0f);
    }

    @Override
    public void beginCamera() {
        PGraphics2D.showMethodWarning("beginCamera");
    }

    @Override
    public void endCamera() {
        PGraphics2D.showMethodWarning("endCamera");
    }

    @Override
    public void camera() {
        PGraphics2D.showMethodWarning("camera");
    }

    @Override
    public void camera(float eyeX, float eyeY, float eyeZ, float centerX, float centerY, float centerZ, float upX, float upY, float upZ) {
        PGraphics2D.showMethodWarning("camera");
    }

    @Override
    protected void defaultCamera() {
        super.camera(this.width / 2, this.height / 2);
    }

    @Override
    protected void begin2D() {
        this.pushProjection();
        this.defaultPerspective();
        this.pushMatrix();
        this.defaultCamera();
    }

    @Override
    protected void end2D() {
        this.popMatrix();
        this.popProjection();
    }

    @Override
    public void shape(PShape shape) {
        if (shape.is2D()) {
            super.shape(shape);
        } else {
            PGraphics2D.showWarning("The shape object is not 2D, cannot be displayed with this renderer");
        }
    }

    @Override
    public void shape(PShape shape, float x, float y) {
        if (shape.is2D()) {
            super.shape(shape, x, y);
        } else {
            PGraphics2D.showWarning("The shape object is not 2D, cannot be displayed with this renderer");
        }
    }

    @Override
    public void shape(PShape shape, float a, float b, float c, float d) {
        if (shape.is2D()) {
            super.shape(shape, a, b, c, d);
        } else {
            PGraphics2D.showWarning("The shape object is not 2D, cannot be displayed with this renderer");
        }
    }

    @Override
    public void shape(PShape shape, float x, float y, float z) {
        PGraphics2D.showDepthWarningXYZ("shape");
    }

    @Override
    public void shape(PShape shape, float x, float y, float z, float c, float d, float e) {
        PGraphics2D.showDepthWarningXYZ("shape");
    }

    protected static boolean isSupportedExtension(String extension) {
        return extension.equals("svg") || extension.equals("svgz");
    }

    protected static PShape loadShapeImpl(PGraphics pg, String filename, String extension) {
        PShapeSVG svg = null;
        if (extension.equals("svg")) {
            svg = new PShapeSVG(pg.parent.loadXML(filename));
        } else if (extension.equals("svgz")) {
            try {
                GZIPInputStream input = new GZIPInputStream(pg.parent.createInput(filename));
                XML xml = new XML(PApplet.createReader(input));
                svg = new PShapeSVG(xml);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (svg != null) {
            PShapeOpenGL p2d = PShapeOpenGL.createShape2D(pg.parent, svg);
            return p2d;
        }
        return null;
    }

    @Override
    public PShape createShape(PShape source) {
        return PShapeOpenGL.createShape2D(this.parent, source);
    }

    @Override
    public PShape createShape() {
        return this.createShape(3);
    }

    @Override
    public PShape createShape(int type) {
        return PGraphics2D.createShapeImpl(this.parent, type);
    }

    @Override
    public PShape createShape(int kind, float ... p) {
        return PGraphics2D.createShapeImpl(this.parent, kind, p);
    }

    protected static PShapeOpenGL createShapeImpl(PApplet parent, int type) {
        PShapeOpenGL shape = null;
        if (type == 0) {
            shape = new PShapeOpenGL(parent, 0);
        } else if (type == 2) {
            shape = new PShapeOpenGL(parent, 2);
        } else if (type == 3) {
            shape = new PShapeOpenGL(parent, 3);
        }
        shape.is3D(false);
        return shape;
    }

    protected static PShapeOpenGL createShapeImpl(PApplet parent, int kind, float ... p) {
        PShapeOpenGL shape = null;
        int len = p.length;
        if (kind == 2) {
            if (len != 2) {
                PGraphics2D.showWarning("Wrong number of parameters");
                return null;
            }
            shape = new PShapeOpenGL(parent, 1);
            shape.setKind(2);
        } else if (kind == 4) {
            if (len != 4) {
                PGraphics2D.showWarning("Wrong number of parameters");
                return null;
            }
            shape = new PShapeOpenGL(parent, 1);
            shape.setKind(4);
        } else if (kind == 8) {
            if (len != 6) {
                PGraphics2D.showWarning("Wrong number of parameters");
                return null;
            }
            shape = new PShapeOpenGL(parent, 1);
            shape.setKind(8);
        } else if (kind == 16) {
            if (len != 8) {
                PGraphics2D.showWarning("Wrong number of parameters");
                return null;
            }
            shape = new PShapeOpenGL(parent, 1);
            shape.setKind(16);
        } else if (kind == 30) {
            if (len != 4 && len != 5 && len != 8) {
                PGraphics2D.showWarning("Wrong number of parameters");
                return null;
            }
            shape = new PShapeOpenGL(parent, 1);
            shape.setKind(30);
        } else if (kind == 31) {
            if (len != 4) {
                PGraphics2D.showWarning("Wrong number of parameters");
                return null;
            }
            shape = new PShapeOpenGL(parent, 1);
            shape.setKind(31);
        } else if (kind == 32) {
            if (len != 6 && len != 7) {
                PGraphics2D.showWarning("Wrong number of parameters");
                return null;
            }
            shape = new PShapeOpenGL(parent, 1);
            shape.setKind(32);
        } else if (kind == 41) {
            PGraphics2D.showWarning("Primitive not supported in 2D");
        } else if (kind == 40) {
            PGraphics2D.showWarning("Primitive not supported in 2D");
        } else {
            PGraphics2D.showWarning("Unrecognized primitive type");
        }
        if (shape != null) {
            shape.setParams(p);
        }
        shape.is3D(false);
        return shape;
    }

    @Override
    public void bezierVertex(float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        PGraphics2D.showDepthWarningXYZ("bezierVertex");
    }

    @Override
    public void quadraticVertex(float x2, float y2, float z2, float x4, float y4, float z4) {
        PGraphics2D.showDepthWarningXYZ("quadVertex");
    }

    @Override
    public void curveVertex(float x, float y, float z) {
        PGraphics2D.showDepthWarningXYZ("curveVertex");
    }

    @Override
    public void box(float w, float h, float d) {
        PGraphics2D.showMethodWarning("box");
    }

    @Override
    public void sphere(float r) {
        PGraphics2D.showMethodWarning("sphere");
    }

    @Override
    public void vertex(float x, float y, float z) {
        PGraphics2D.showDepthWarningXYZ("vertex");
    }

    @Override
    public void vertex(float x, float y, float z, float u, float v) {
        PGraphics2D.showDepthWarningXYZ("vertex");
    }

    @Override
    public void translate(float tx, float ty, float tz) {
        PGraphics2D.showDepthWarningXYZ("translate");
    }

    @Override
    public void rotateX(float angle) {
        PGraphics2D.showDepthWarning("rotateX");
    }

    @Override
    public void rotateY(float angle) {
        PGraphics2D.showDepthWarning("rotateY");
    }

    @Override
    public void rotateZ(float angle) {
        PGraphics2D.showDepthWarning("rotateZ");
    }

    @Override
    public void rotate(float angle, float vx, float vy, float vz) {
        PGraphics2D.showVariationWarning("rotate");
    }

    @Override
    public void applyMatrix(PMatrix3D source) {
        PGraphics2D.showVariationWarning("applyMatrix");
    }

    @Override
    public void applyMatrix(float n00, float n01, float n02, float n03, float n10, float n11, float n12, float n13, float n20, float n21, float n22, float n23, float n30, float n31, float n32, float n33) {
        PGraphics2D.showVariationWarning("applyMatrix");
    }

    @Override
    public void scale(float sx, float sy, float sz) {
        PGraphics2D.showDepthWarningXYZ("scale");
    }

    @Override
    public float screenX(float x, float y, float z) {
        PGraphics2D.showDepthWarningXYZ("screenX");
        return 0.0f;
    }

    @Override
    public float screenY(float x, float y, float z) {
        PGraphics2D.showDepthWarningXYZ("screenY");
        return 0.0f;
    }

    @Override
    public float screenZ(float x, float y, float z) {
        PGraphics2D.showDepthWarningXYZ("screenZ");
        return 0.0f;
    }

    @Override
    public PMatrix3D getMatrix(PMatrix3D target) {
        PGraphics2D.showVariationWarning("getMatrix");
        return target;
    }

    @Override
    public void setMatrix(PMatrix3D source) {
        PGraphics2D.showVariationWarning("setMatrix");
    }

    @Override
    public void lights() {
        PGraphics2D.showMethodWarning("lights");
    }

    @Override
    public void noLights() {
        PGraphics2D.showMethodWarning("noLights");
    }

    @Override
    public void ambientLight(float red, float green, float blue) {
        PGraphics2D.showMethodWarning("ambientLight");
    }

    @Override
    public void ambientLight(float red, float green, float blue, float x, float y, float z) {
        PGraphics2D.showMethodWarning("ambientLight");
    }

    @Override
    public void directionalLight(float red, float green, float blue, float nx, float ny, float nz) {
        PGraphics2D.showMethodWarning("directionalLight");
    }

    @Override
    public void pointLight(float red, float green, float blue, float x, float y, float z) {
        PGraphics2D.showMethodWarning("pointLight");
    }

    @Override
    public void spotLight(float red, float green, float blue, float x, float y, float z, float nx, float ny, float nz, float angle, float concentration) {
        PGraphics2D.showMethodWarning("spotLight");
    }

    @Override
    public void lightFalloff(float constant, float linear, float quadratic) {
        PGraphics2D.showMethodWarning("lightFalloff");
    }

    @Override
    public void lightSpecular(float v1, float v2, float v3) {
        PGraphics2D.showMethodWarning("lightSpecular");
    }
}

