/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl;

import com.jogamp.opengl.JoglVersion;
import java.util.Arrays;
import javax.media.opengl.GL;
import javax.media.opengl.GL2GL3;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.opengl.Debug;

public class FBObject {
    protected static final boolean DEBUG = Debug.debug("FBObject");
    private static final boolean forceMinimumFBOSupport = Debug.isPropertyDefined("jogl.fbo.force.min", true);
    private static final boolean FBOResizeQuirk = false;
    private boolean initialized = false;
    private boolean fullFBOSupport = false;
    private boolean rgba8Avail = false;
    private boolean depth24Avail = false;
    private boolean depth32Avail = false;
    private boolean stencil01Avail = false;
    private boolean stencil04Avail = false;
    private boolean stencil08Avail = false;
    private boolean stencil16Avail = false;
    private boolean packedDepthStencilAvail = false;
    private int maxColorAttachments = -1;
    private int maxSamples = -1;
    private int maxTextureSize = 0;
    private int maxRenderbufferSize = 0;
    private int width = 0;
    private int height = 0;
    private int samples = 0;
    private int vStatus = -1;
    private boolean ignoreStatus = false;
    private int fbName = 0;
    private boolean bound = false;
    private int colorAttachmentCount = 0;
    private Colorbuffer[] colorAttachmentPoints = null;
    private RenderAttachment depth = null;
    private RenderAttachment stencil = null;
    private FBObject samplingSink = null;
    private TextureAttachment samplingSinkTexture = null;
    private boolean samplingSinkDirty = true;

    static String toHexString(int n) {
        return "0x" + Integer.toHexString(n);
    }

    public static final TextureAttachment createColorTextureAttachment(GLProfile gLProfile, boolean bl, int n, int n2) {
        return FBObject.createColorTextureAttachment(gLProfile, bl, n, n2, 9728, 9728, 33071, 33071);
    }

    public static final TextureAttachment createColorTextureAttachment(GLProfile gLProfile, boolean bl, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8;
        int n9;
        if (gLProfile.isGLES()) {
            n9 = bl ? 6408 : 6407;
            n8 = bl ? 6408 : 6407;
            n7 = 5121;
        } else {
            n9 = bl ? 32856 : 32849;
            n8 = bl ? 32993 : 6407;
            n7 = bl ? 33639 : 5121;
        }
        return FBObject.createColorTextureAttachment(n9, n, n2, n8, n7, n3, n4, n5, n6);
    }

    public static final TextureAttachment createColorTextureAttachment(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        return new TextureAttachment(Attachment.Type.COLOR_TEXTURE, n, n2, n3, n4, n5, n6, n7, n8, n9, 0);
    }

    private static boolean hasAlpha(int n) {
        switch (n) {
            case 4: 
            case 6408: 
            case 32854: 
            case 32856: 
            case 32993: {
                return true;
            }
        }
        return false;
    }

    private final void validateColorAttachmentPointRange(int n) {
        if (!this.initialized) {
            throw new GLException("FBO not initialized");
        }
        if (this.maxColorAttachments != this.colorAttachmentPoints.length) {
            throw new InternalError("maxColorAttachments " + this.maxColorAttachments + ", array.lenght " + this.colorAttachmentPoints);
        }
        if (0 > n || n >= this.maxColorAttachments) {
            throw new IllegalArgumentException("attachment point out of range: " + n + ", should be within [0.." + (this.maxColorAttachments - 1) + "], " + this);
        }
    }

    private final void validateAddColorAttachment(int n, Colorbuffer colorbuffer) {
        this.validateColorAttachmentPointRange(n);
        if (null != this.colorAttachmentPoints[n]) {
            throw new IllegalArgumentException("Cannot attach " + colorbuffer + ", attachment point already in use by " + this.colorAttachmentPoints[n] + ", " + this);
        }
    }

    private final void addColorAttachment(int n, Colorbuffer colorbuffer) {
        this.validateColorAttachmentPointRange(n);
        Colorbuffer colorbuffer2 = this.colorAttachmentPoints[n];
        if (null != colorbuffer2 && colorbuffer2 != colorbuffer) {
            throw new IllegalArgumentException("Add failed: requested to add " + colorbuffer + " at " + n + ", but slot is holding " + colorbuffer2 + "; " + this);
        }
        this.colorAttachmentPoints[n] = colorbuffer;
        ++this.colorAttachmentCount;
    }

    private final void removeColorAttachment(int n, Colorbuffer colorbuffer) {
        this.validateColorAttachmentPointRange(n);
        Colorbuffer colorbuffer2 = this.colorAttachmentPoints[n];
        if (null != colorbuffer2 && colorbuffer2 != colorbuffer) {
            throw new IllegalArgumentException("Remove failed: requested to removed " + colorbuffer + " at " + n + ", but slot is holding " + colorbuffer2 + "; " + this);
        }
        this.colorAttachmentPoints[n] = null;
        --this.colorAttachmentCount;
    }

    public final Colorbuffer getColorbuffer(int n) {
        this.validateColorAttachmentPointRange(n);
        return this.colorAttachmentPoints[n];
    }

    public final int getColorbufferAttachmentPoint(Colorbuffer colorbuffer) {
        for (int i = 0; i < this.colorAttachmentPoints.length; ++i) {
            if (this.colorAttachmentPoints[i] != colorbuffer) continue;
            return i;
        }
        return -1;
    }

    public final Colorbuffer getColorbuffer(Colorbuffer colorbuffer) {
        int n = this.getColorbufferAttachmentPoint(colorbuffer);
        return n >= 0 ? this.getColorbuffer(n) : null;
    }

    private void init(GL gL, int n, int n2, int n3) throws GLException {
        if (this.initialized) {
            throw new GLException("FBO already initialized");
        }
        if (!gL.hasBasicFBOSupport()) {
            throw new GLException("FBO not supported w/ context: " + gL.getContext() + ", " + this);
        }
        this.fullFBOSupport = gL.hasFullFBOSupport();
        this.rgba8Avail = gL.isGL2GL3() || gL.isExtensionAvailable("GL_OES_rgb8_rgba8");
        this.depth24Avail = this.fullFBOSupport || gL.isExtensionAvailable("GL_OES_depth24");
        this.depth32Avail = this.fullFBOSupport || gL.isExtensionAvailable("GL_OES_depth32");
        this.stencil01Avail = this.fullFBOSupport || gL.isExtensionAvailable("GL_OES_stencil1");
        this.stencil04Avail = this.fullFBOSupport || gL.isExtensionAvailable("GL_OES_stencil4");
        this.stencil08Avail = this.fullFBOSupport || gL.isExtensionAvailable("GL_OES_stencil8");
        this.stencil16Avail = this.fullFBOSupport;
        this.packedDepthStencilAvail = this.fullFBOSupport || gL.isExtensionAvailable("GL_OES_packed_depth_stencil") || gL.isExtensionAvailable("GL_EXT_packed_depth_stencil");
        boolean bl = gL.isExtensionAvailable("GL_NV_fbo_color_attachments");
        int[] nArray = new int[1];
        FBObject.checkPreGLError(gL);
        int n4 = 1;
        this.maxColorAttachments = 1;
        if (this.fullFBOSupport || bl) {
            try {
                gL.glGetIntegerv(36063, nArray, 0);
                n4 = 1 <= nArray[0] ? nArray[0] : 1;
            }
            catch (GLException gLException) {
                gLException.printStackTrace();
            }
        }
        this.maxColorAttachments = n4 <= 8 ? n4 : 8;
        this.colorAttachmentPoints = new Colorbuffer[this.maxColorAttachments];
        this.colorAttachmentCount = 0;
        this.maxSamples = gL.getMaxRenderbufferSamples();
        if (!forceMinimumFBOSupport) {
            gL.glGetIntegerv(3379, nArray, 0);
            this.maxTextureSize = nArray[0];
            gL.glGetIntegerv(34024, nArray, 0);
            this.maxRenderbufferSize = nArray[0];
        } else {
            this.maxTextureSize = 2048;
            this.maxRenderbufferSize = 2048;
        }
        FBObject.checkPreGLError(gL);
        if (0 >= n) {
            n = 1;
        }
        if (0 >= n2) {
            n2 = 1;
        }
        this.width = n;
        this.height = n2;
        int n5 = this.samples = n3 <= this.maxSamples ? n3 : this.maxSamples;
        if (DEBUG) {
            System.err.println("FBObject " + n + "x" + n2 + ", " + n3 + " -> " + this.samples + " samples");
            System.err.println("fullFBOSupport:           " + this.fullFBOSupport);
            System.err.println("maxColorAttachments:      " + this.maxColorAttachments + "/" + n4 + " [capped/real]");
            System.err.println("maxSamples:               " + this.maxSamples);
            System.err.println("maxTextureSize:           " + this.maxTextureSize);
            System.err.println("maxRenderbufferSize:      " + this.maxRenderbufferSize);
            System.err.println("rgba8:                    " + this.rgba8Avail);
            System.err.println("depth24:                  " + this.depth24Avail);
            System.err.println("depth32:                  " + this.depth32Avail);
            System.err.println("stencil01:                " + this.stencil01Avail);
            System.err.println("stencil04:                " + this.stencil04Avail);
            System.err.println("stencil08:                " + this.stencil08Avail);
            System.err.println("stencil16:                " + this.stencil16Avail);
            System.err.println("packedDepthStencil:       " + this.packedDepthStencilAvail);
            System.err.println("NV_fbo_color_attachments: " + bl);
            System.err.println(gL.getContext().getGLVersion());
            System.err.println(JoglVersion.getGLStrings(gL, null).toString());
            System.err.println(gL.getContext());
        }
        this.checkNoError(null, gL.glGetError(), "FBObject Init.pre");
        if (n > 2 + this.maxTextureSize || n2 > 2 + this.maxTextureSize || n > this.maxRenderbufferSize || n2 > this.maxRenderbufferSize) {
            throw new GLException("size " + n + "x" + n2 + " exceeds on of the maxima [texture " + this.maxTextureSize + ", renderbuffer " + this.maxRenderbufferSize + "]");
        }
        this.resetSamplingSink(gL);
        gL.glGenFramebuffers(1, nArray, 0);
        this.fbName = nArray[0];
        if (0 == this.fbName) {
            throw new GLException("null framebuffer");
        }
        gL.glBindFramebuffer(36160, this.fbName);
        this.checkNoError(gL, gL.glGetError(), "FBObject Init.bindFB");
        if (!gL.glIsFramebuffer(this.fbName)) {
            this.checkNoError(gL, 1281, "FBObject Init.isFB");
        }
        this.bound = true;
        this.samplingSinkDirty = true;
        this.initialized = true;
        this.vStatus = 36055;
        if (DEBUG) {
            System.err.println("FBObject.init(): " + this);
        }
    }

    public final void reset(GL gL, int n, int n2) {
        this.reset(gL, n, n2, 0, false);
    }

    public final void reset(GL gL, int n, int n2, int n3, boolean bl) {
        if (!this.initialized) {
            this.init(gL, n, n2, n3);
            return;
        }
        int n4 = n3 = n3 <= this.maxSamples ? n3 : this.maxSamples;
        if (n != this.width || n2 != this.height || n3 != this.samples) {
            if (0 >= n) {
                n = 1;
            }
            if (0 >= n2) {
                n2 = 1;
            }
            if (n > 2 + this.maxTextureSize || n2 > 2 + this.maxTextureSize || n > this.maxRenderbufferSize || n2 > this.maxRenderbufferSize) {
                throw new GLException("size " + this.width + "x" + this.height + " exceeds on of the maxima [texture " + this.maxTextureSize + ", renderbuffer " + this.maxRenderbufferSize + "]");
            }
            if (DEBUG) {
                System.err.println("FBObject.reset - START - " + this.width + "x" + this.height + ", " + this.samples + " -> " + n + "x" + n2 + ", " + n3 + "; " + this);
            }
            boolean bl2 = this.isBound();
            this.width = n;
            this.height = n2;
            this.samples = n3;
            if (0 < this.samples && null == this.samplingSink) {
                this.samplingSink = new FBObject();
                this.samplingSink.init(gL, this.width, this.height, 0);
            }
            this.detachAllImpl(gL, true, true);
            if (bl) {
                this.resetSamplingSink(gL);
            }
            this.samplingSinkDirty = true;
            if (!bl2) {
                this.unbind(gL);
            }
            if (DEBUG) {
                System.err.println("FBObject.reset - END - " + this);
            }
        }
    }

    public final void formatToGLCapabilities(GLCapabilities gLCapabilities) {
        Colorbuffer colorbuffer;
        gLCapabilities.setSampleBuffers(this.samples > 0);
        gLCapabilities.setNumSamples(this.samples);
        gLCapabilities.setDepthBits(0);
        gLCapabilities.setStencilBits(0);
        Colorbuffer colorbuffer2 = colorbuffer = this.samples > 0 ? this.getSamplingSink() : this.getColorbuffer(0);
        if (null != colorbuffer) {
            colorbuffer.formatToGLCapabilities(gLCapabilities, this.rgba8Avail);
        }
        if (null != this.depth) {
            this.depth.formatToGLCapabilities(gLCapabilities, this.rgba8Avail);
        }
        if (null != this.stencil && this.stencil != this.depth) {
            this.stencil.formatToGLCapabilities(gLCapabilities, this.rgba8Avail);
        }
    }

    public final int getStatus() {
        return this.vStatus;
    }

    public final String getStatusString() {
        return FBObject.getStatusString(this.vStatus);
    }

    public static final String getStatusString(int n) {
        switch (n) {
            case -1: {
                return "NOT A FBO";
            }
            case 36053: {
                return "OK";
            }
            case 36054: {
                return "FBO incomplete attachment\n";
            }
            case 36055: {
                return "FBO missing attachment";
            }
            case 36057: {
                return "FBO attached images must have same dimensions";
            }
            case 36058: {
                return "FBO attached images must have same format";
            }
            case 36059: {
                return "FBO missing draw buffer";
            }
            case 36060: {
                return "FBO missing read buffer";
            }
            case 36182: {
                return "FBO missing multisample buffer";
            }
            case 36264: {
                return "FBO missing layer targets";
            }
            case 36061: {
                return "Unsupported FBO format";
            }
            case 33305: {
                return "FBO undefined";
            }
            case 0: {
                return "FBO implementation fault";
            }
        }
        return "FBO incomplete, implementation ERROR " + FBObject.toHexString(n);
    }

    public final boolean isStatusValid() {
        switch (this.vStatus) {
            case 36053: {
                return true;
            }
            case 36054: 
            case 36055: 
            case 36057: 
            case 36058: 
            case 36059: 
            case 36060: 
            case 36182: 
            case 36264: {
                if (0 != this.colorAttachmentCount && null != this.depth) break;
                return true;
            }
        }
        if (DEBUG) {
            System.err.println("Framebuffer " + this.fbName + " is incomplete, status = " + FBObject.toHexString(this.vStatus) + " : " + FBObject.getStatusString(this.vStatus));
        }
        return false;
    }

    private static int checkPreGLError(GL gL) {
        int n = gL.glGetError();
        if (DEBUG && 0 != n) {
            System.err.println("Pre-existing GL error: " + FBObject.toHexString(n));
            Thread.dumpStack();
        }
        return n;
    }

    private final boolean checkNoError(GL gL, int n, String string) throws GLException {
        if (0 != n) {
            if (null != gL) {
                this.destroy(gL);
            }
            if (null != string) {
                throw new GLException(string + " GL Error " + FBObject.toHexString(n) + " of " + this.toString());
            }
            return false;
        }
        return true;
    }

    private final void checkInitialized() throws GLException {
        if (!this.initialized) {
            throw new GLException("FBO not initialized, call init(GL) first.");
        }
    }

    public final TextureAttachment attachTexture2D(GL gL, int n, boolean bl) throws GLException {
        return (TextureAttachment)this.attachColorbuffer(gL, n, FBObject.createColorTextureAttachment(gL.getGLProfile(), bl, this.width, this.height));
    }

    public final TextureAttachment attachTexture2D(GL gL, int n, boolean bl, int n2, int n3, int n4, int n5) throws GLException {
        return (TextureAttachment)this.attachColorbuffer(gL, n, FBObject.createColorTextureAttachment(gL.getGLProfile(), bl, this.width, this.height, n2, n3, n4, n5));
    }

    public final TextureAttachment attachTexture2D(GL gL, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) throws GLException {
        return (TextureAttachment)this.attachColorbuffer(gL, n, FBObject.createColorTextureAttachment(n2, this.width, this.height, n3, n4, n5, n6, n7, n8));
    }

    public final ColorAttachment createColorAttachment(boolean bl) {
        int n = this.rgba8Avail ? (bl ? 32856 : 32849) : (bl ? 32854 : 36194);
        return new ColorAttachment(n, this.samples, this.width, this.height, 0);
    }

    public final ColorAttachment attachColorbuffer(GL gL, int n, boolean bl) throws GLException {
        return (ColorAttachment)this.attachColorbuffer(gL, n, this.createColorAttachment(bl));
    }

    public final ColorAttachment attachColorbuffer(GL gL, int n, int n2) throws GLException, IllegalArgumentException {
        Attachment.Type type = Attachment.Type.determine(n2);
        if (Attachment.Type.COLOR != type) {
            throw new IllegalArgumentException("colorformat invalid: " + FBObject.toHexString(n2) + ", " + this);
        }
        return (ColorAttachment)this.attachColorbuffer(gL, n, new ColorAttachment(n2, this.samples, this.width, this.height, 0));
    }

    public final Colorbuffer attachColorbuffer(GL gL, int n, Colorbuffer colorbuffer) throws GLException {
        this.bind(gL);
        return this.attachColorbufferImpl(gL, n, colorbuffer);
    }

    private final Colorbuffer attachColorbufferImpl(GL gL, int n, Colorbuffer colorbuffer) throws GLException {
        this.validateAddColorAttachment(n, colorbuffer);
        boolean bl = colorbuffer.initialize(gL);
        this.addColorAttachment(n, colorbuffer);
        if (colorbuffer instanceof TextureAttachment) {
            TextureAttachment textureAttachment = (TextureAttachment)colorbuffer;
            if (this.samples > 0) {
                this.removeColorAttachment(n, textureAttachment);
                if (bl) {
                    textureAttachment.free(gL);
                }
                throw new GLException("Texture2D not supported w/ MSAA. If you have enabled MSAA with exisiting texture attachments, you may want to detach them via detachAllTexturebuffer(gl).");
            }
            gL.glFramebufferTexture2D(36160, 36064 + n, 3553, textureAttachment.getName(), 0);
            if (!this.ignoreStatus) {
                this.updateStatus(gL);
                if (!this.isStatusValid()) {
                    this.detachColorbuffer(gL, n, true);
                    throw new GLException("attachTexture2D " + textureAttachment + " at " + n + " failed " + this.getStatusString() + ", " + this);
                }
            }
        } else if (colorbuffer instanceof ColorAttachment) {
            ColorAttachment colorAttachment = (ColorAttachment)colorbuffer;
            gL.glFramebufferRenderbuffer(36160, 36064 + n, 36161, colorAttachment.getName());
            if (!this.ignoreStatus) {
                this.updateStatus(gL);
                if (!this.isStatusValid()) {
                    this.detachColorbuffer(gL, n, true);
                    throw new GLException("attachColorbuffer " + colorAttachment + " at " + n + " failed " + this.getStatusString() + ", " + this);
                }
            }
        }
        if (DEBUG) {
            System.err.println("FBObject.attachColorbuffer.X: [attachmentPoint " + n + ", colbuf " + colorbuffer + "]: " + this);
        }
        return colorbuffer;
    }

    public final void attachRenderbuffer(GL gL, Attachment.Type type, int n) throws GLException, IllegalArgumentException {
        int n2;
        if (0 > n) {
            n = 24;
        }
        int n3 = -1;
        switch (type) {
            case DEPTH: {
                if (32 <= n && this.depth32Avail) {
                    n2 = 33191;
                    break;
                }
                if (24 <= n && this.depth24Avail) {
                    n2 = 33190;
                    break;
                }
                n2 = 33189;
                break;
            }
            case STENCIL: {
                if (16 <= n && this.stencil16Avail) {
                    n2 = 36169;
                    break;
                }
                if (8 <= n && this.stencil08Avail) {
                    n2 = 36168;
                    break;
                }
                if (4 <= n && this.stencil04Avail) {
                    n2 = 36167;
                    break;
                }
                if (1 <= n && this.stencil01Avail) {
                    n2 = 36166;
                    break;
                }
                throw new GLException("stencil buffer n/a");
            }
            case DEPTH_STENCIL: {
                if (this.packedDepthStencilAvail) {
                    n2 = 35056;
                    break;
                }
                n2 = 24 <= n && this.depth24Avail ? 33190 : 33189;
                if (this.stencil08Avail) {
                    n3 = 36168;
                    break;
                }
                if (this.stencil04Avail) {
                    n3 = 36167;
                    break;
                }
                if (this.stencil01Avail) {
                    n3 = 36166;
                    break;
                }
                throw new GLException("stencil buffer n/a");
            }
            default: {
                throw new IllegalArgumentException("only depth/stencil types allowed, was " + (Object)((Object)type) + ", " + this);
            }
        }
        this.attachRenderbufferImpl(gL, type, n2);
        if (0 <= n3) {
            this.attachRenderbufferImpl(gL, Attachment.Type.STENCIL, n3);
        }
    }

    public final void attachRenderbuffer(GL gL, int n) throws GLException, IllegalArgumentException {
        Attachment.Type type = Attachment.Type.determine(n);
        if (Attachment.Type.DEPTH != type && Attachment.Type.STENCIL != type && Attachment.Type.DEPTH_STENCIL != type) {
            throw new IllegalArgumentException("renderformat invalid: " + FBObject.toHexString(n) + ", " + this);
        }
        this.attachRenderbufferImpl(gL, type, n);
    }

    protected final void attachRenderbufferImpl(GL gL, Attachment.Type type, int n) throws GLException {
        if (null != this.depth && (Attachment.Type.DEPTH == type || Attachment.Type.DEPTH_STENCIL == type)) {
            throw new GLException("FBO depth buffer already attached (rb " + this.depth + "), type is " + (Object)((Object)type) + ", " + FBObject.toHexString(n) + ", " + this);
        }
        if (null != this.stencil && (Attachment.Type.STENCIL == type || Attachment.Type.DEPTH_STENCIL == type)) {
            throw new GLException("FBO stencil buffer already attached (rb " + this.stencil + "), type is " + (Object)((Object)type) + ", " + FBObject.toHexString(n) + ", " + this);
        }
        this.bind(gL);
        this.attachRenderbufferImpl2(gL, type, n);
    }

    private final void attachRenderbufferImpl2(GL gL, Attachment.Type type, int n) throws GLException {
        if (Attachment.Type.DEPTH == type) {
            if (null == this.depth) {
                this.depth = new RenderAttachment(Attachment.Type.DEPTH, n, this.samples, this.width, this.height, 0);
            } else {
                this.depth.setSize(this.width, this.height);
                this.depth.setSamples(this.samples);
            }
            this.depth.initialize(gL);
        } else if (Attachment.Type.STENCIL == type) {
            if (null == this.stencil) {
                this.stencil = new RenderAttachment(Attachment.Type.STENCIL, n, this.samples, this.width, this.height, 0);
            } else {
                this.stencil.setSize(this.width, this.height);
                this.stencil.setSamples(this.samples);
            }
            this.stencil.initialize(gL);
        } else if (Attachment.Type.DEPTH_STENCIL == type) {
            if (null == this.depth) {
                if (null != this.stencil) {
                    throw new InternalError("XXX: DEPTH_STENCIL, depth was null, stencil not: " + this.toString());
                }
                this.depth = new RenderAttachment(Attachment.Type.DEPTH_STENCIL, n, this.samples, this.width, this.height, 0);
            } else {
                this.depth.setSize(this.width, this.height);
                this.depth.setSamples(this.samples);
            }
            this.depth.initialize(gL);
            this.stencil = this.depth;
        }
        if (Attachment.Type.DEPTH == type) {
            gL.glFramebufferRenderbuffer(36160, 36096, 36161, this.depth.getName());
        } else if (Attachment.Type.STENCIL == type) {
            gL.glFramebufferRenderbuffer(36160, 36128, 36161, this.stencil.getName());
        } else if (Attachment.Type.DEPTH_STENCIL == type) {
            gL.glFramebufferRenderbuffer(36160, 36096, 36161, this.depth.getName());
            gL.glFramebufferRenderbuffer(36160, 36128, 36161, this.stencil.getName());
        }
        if (!this.ignoreStatus) {
            this.updateStatus(gL);
            if (!this.isStatusValid()) {
                this.detachRenderbuffer(gL, type, true);
                throw new GLException("renderbuffer [attachmentType " + (Object)((Object)type) + ", iformat " + FBObject.toHexString(n) + "] failed: " + this.getStatusString() + ": " + this.toString());
            }
        }
        if (DEBUG) {
            System.err.println("FBObject.attachRenderbuffer.X: [attachmentType " + (Object)((Object)type) + ", iformat " + FBObject.toHexString(n) + "]: " + this);
        }
    }

    public final Colorbuffer detachColorbuffer(GL gL, int n, boolean bl) throws IllegalArgumentException {
        this.bind(gL);
        Colorbuffer colorbuffer = this.detachColorbufferImpl(gL, n, bl ? DetachAction.DISPOSE : DetachAction.NONE);
        if (null == colorbuffer) {
            throw new IllegalArgumentException("ColorAttachment at " + n + ", not attached, " + this);
        }
        if (DEBUG) {
            System.err.println("FBObject.detachColorbuffer.X: [attachmentPoint " + n + ", dispose " + bl + "]: " + colorbuffer + ", " + this);
        }
        return colorbuffer;
    }

    private final Colorbuffer detachColorbufferImpl(GL gL, int n, DetachAction detachAction) {
        Colorbuffer colorbuffer = this.colorAttachmentPoints[n];
        if (null == colorbuffer) {
            return null;
        }
        this.removeColorAttachment(n, colorbuffer);
        if (colorbuffer instanceof TextureAttachment) {
            TextureAttachment textureAttachment = (TextureAttachment)colorbuffer;
            if (0 != textureAttachment.getName()) {
                gL.glFramebufferTexture2D(36160, 36064 + n, 3553, 0, 0);
                gL.glBindTexture(3553, 0);
                switch (detachAction) {
                    case DISPOSE: 
                    case RECREATE: {
                        textureAttachment.free(gL);
                        break;
                    }
                }
            }
            if (DetachAction.RECREATE == detachAction) {
                if (this.samples == 0) {
                    textureAttachment.setSize(this.width, this.height);
                } else {
                    colorbuffer = this.createColorAttachment(FBObject.hasAlpha(textureAttachment.format));
                }
                this.attachColorbufferImpl(gL, n, colorbuffer);
            }
        } else if (colorbuffer instanceof ColorAttachment) {
            ColorAttachment colorAttachment = (ColorAttachment)colorbuffer;
            if (0 != colorAttachment.getName()) {
                gL.glFramebufferRenderbuffer(36160, 36064 + n, 36161, 0);
                switch (detachAction) {
                    case DISPOSE: 
                    case RECREATE: {
                        colorAttachment.free(gL);
                        break;
                    }
                }
            }
            if (DetachAction.RECREATE == detachAction) {
                if (this.samples > 0) {
                    colorAttachment.setSize(this.width, this.height);
                    colorAttachment.setSamples(this.samples);
                } else {
                    colorbuffer = null != this.samplingSinkTexture ? FBObject.createColorTextureAttachment(this.samplingSinkTexture.format, this.width, this.height, this.samplingSinkTexture.dataFormat, this.samplingSinkTexture.dataType, this.samplingSinkTexture.magFilter, this.samplingSinkTexture.minFilter, this.samplingSinkTexture.wrapS, this.samplingSinkTexture.wrapT) : FBObject.createColorTextureAttachment(gL.getGLProfile(), true, this.width, this.height);
                }
                this.attachColorbuffer(gL, n, colorbuffer);
            }
        }
        return colorbuffer;
    }

    private final void freeAllColorbufferImpl(GL gL) {
        for (int i = 0; i < this.maxColorAttachments; ++i) {
            Attachment attachment;
            Colorbuffer colorbuffer = this.colorAttachmentPoints[i];
            if (null == colorbuffer) {
                return;
            }
            if (colorbuffer instanceof TextureAttachment) {
                attachment = (TextureAttachment)colorbuffer;
                if (0 != attachment.getName()) {
                    gL.glFramebufferTexture2D(36160, 36064 + i, 3553, 0, 0);
                    gL.glBindTexture(3553, 0);
                }
                ((TextureAttachment)attachment).free(gL);
                continue;
            }
            if (!(colorbuffer instanceof ColorAttachment)) continue;
            attachment = (ColorAttachment)colorbuffer;
            if (0 != attachment.getName()) {
                gL.glFramebufferRenderbuffer(36160, 36064 + i, 36161, 0);
            }
            ((RenderAttachment)attachment).free(gL);
        }
    }

    public final void detachRenderbuffer(GL gL, Attachment.Type type, boolean bl) throws IllegalArgumentException {
        this.bind(gL);
        this.detachRenderbufferImpl(gL, type, bl ? DetachAction.DISPOSE : DetachAction.NONE);
        if (DEBUG) {
            System.err.println("FBObject.detachRenderbuffer.X: [attachmentType " + (Object)((Object)type) + ", dispose " + bl + "]: " + this);
        }
    }

    public final boolean isDepthStencilPackedFormat() {
        boolean bl;
        boolean bl2 = bl = null != this.depth && null != this.stencil && this.depth.format == this.stencil.format;
        if (bl) {
            if (this.depth.getName() != this.stencil.getName()) {
                throw new InternalError("depth/stencil packed format not sharing: depth " + this.depth + ", stencil " + this.stencil);
            }
            if (this.depth != this.stencil) {
                throw new InternalError("depth/stencil packed format not a shared reference: depth " + this.depth + ", stencil " + this.stencil);
            }
        }
        return bl;
    }

    private final void detachRenderbufferImpl(GL gL, Attachment.Type type, DetachAction detachAction) throws IllegalArgumentException {
        switch (type) {
            case DEPTH_STENCIL: 
            case DEPTH: 
            case STENCIL: {
                break;
            }
            default: {
                throw new IllegalArgumentException("only depth/stencil types allowed, was " + (Object)((Object)type) + ", " + this);
            }
        }
        if (null == this.depth && null == this.stencil) {
            return;
        }
        boolean bl = this.isDepthStencilPackedFormat();
        if (bl) {
            type = Attachment.Type.DEPTH_STENCIL;
        }
        switch (type) {
            case DEPTH: {
                if (null == this.depth) break;
                int n = this.depth.format;
                if (0 != this.depth.getName()) {
                    gL.glFramebufferRenderbuffer(36160, 36096, 36161, 0);
                    switch (detachAction) {
                        case DISPOSE: 
                        case RECREATE: {
                            this.depth.free(gL);
                            break;
                        }
                    }
                }
                if (DetachAction.RECREATE == detachAction) {
                    this.attachRenderbufferImpl2(gL, type, n);
                    break;
                }
                this.depth = null;
                break;
            }
            case STENCIL: {
                if (null == this.stencil) break;
                int n = this.stencil.format;
                if (0 != this.stencil.getName()) {
                    gL.glFramebufferRenderbuffer(36160, 36128, 36161, 0);
                    switch (detachAction) {
                        case DISPOSE: 
                        case RECREATE: {
                            this.stencil.free(gL);
                            break;
                        }
                    }
                }
                if (DetachAction.RECREATE == detachAction) {
                    this.attachRenderbufferImpl2(gL, type, n);
                    break;
                }
                this.stencil = null;
                break;
            }
            case DEPTH_STENCIL: {
                int n;
                if (null != this.depth) {
                    n = this.depth.format;
                    if (0 != this.depth.getName()) {
                        gL.glFramebufferRenderbuffer(36160, 36096, 36161, 0);
                        if (bl) {
                            gL.glFramebufferRenderbuffer(36160, 36128, 36161, 0);
                        }
                        switch (detachAction) {
                            case DISPOSE: 
                            case RECREATE: {
                                this.depth.free(gL);
                                break;
                            }
                        }
                    }
                    if (DetachAction.RECREATE == detachAction) {
                        this.attachRenderbufferImpl2(gL, bl ? Attachment.Type.DEPTH_STENCIL : Attachment.Type.DEPTH, n);
                    } else {
                        this.depth = null;
                        if (bl) {
                            this.stencil = null;
                        }
                    }
                }
                if (bl || null == this.stencil) break;
                n = this.stencil.format;
                if (0 != this.stencil.getName()) {
                    gL.glFramebufferRenderbuffer(36160, 36128, 36161, 0);
                    switch (detachAction) {
                        case DISPOSE: 
                        case RECREATE: {
                            this.stencil.free(gL);
                            break;
                        }
                    }
                }
                if (DetachAction.RECREATE == detachAction) {
                    this.attachRenderbufferImpl2(gL, Attachment.Type.STENCIL, n);
                    break;
                }
                this.stencil = null;
                break;
            }
        }
    }

    private final void freeAllRenderbufferImpl(GL gL) throws IllegalArgumentException {
        boolean bl = this.isDepthStencilPackedFormat();
        if (null != this.depth && 0 != this.depth.getName()) {
            gL.glFramebufferRenderbuffer(36160, 36096, 36161, 0);
            if (bl) {
                gL.glFramebufferRenderbuffer(36160, 36128, 36161, 0);
            }
            this.depth.free(gL);
        }
        if (!bl && null != this.stencil && 0 != this.stencil.getName()) {
            gL.glFramebufferRenderbuffer(36160, 36128, 36161, 0);
            this.stencil.free(gL);
        }
    }

    public final void detachAll(GL gL) {
        if (null != this.samplingSink) {
            this.samplingSink.detachAll(gL);
        }
        this.detachAllImpl(gL, true, false);
    }

    public final void detachAllColorbuffer(GL gL) {
        if (null != this.samplingSink) {
            this.samplingSink.detachAllColorbuffer(gL);
        }
        this.detachAllImpl(gL, false, false);
    }

    public final void detachAllTexturebuffer(GL gL) {
        if (!this.isInitialized()) {
            return;
        }
        if (null != this.samplingSink) {
            this.samplingSink.detachAllTexturebuffer(gL);
        }
        this.bind(gL);
        for (int i = 0; i < this.maxColorAttachments; ++i) {
            if (!(this.colorAttachmentPoints[i] instanceof TextureAttachment)) continue;
            this.detachColorbufferImpl(gL, i, DetachAction.DISPOSE);
        }
        if (DEBUG) {
            System.err.println("FBObject.detachAllTexturebuffer.X: " + this);
        }
    }

    public final void detachAllRenderbuffer(GL gL) {
        if (!this.isInitialized()) {
            return;
        }
        if (null != this.samplingSink) {
            this.samplingSink.detachAllRenderbuffer(gL);
        }
        this.bind(gL);
        this.detachRenderbufferImpl(gL, Attachment.Type.DEPTH_STENCIL, DetachAction.DISPOSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void detachAllImpl(GL gL, boolean bl, boolean bl2) {
        if (!this.isInitialized()) {
            return;
        }
        this.ignoreStatus = bl2;
        try {
            this.bind(gL);
            for (int i = 0; i < this.maxColorAttachments; ++i) {
                this.detachColorbufferImpl(gL, i, bl2 ? DetachAction.RECREATE : DetachAction.DISPOSE);
            }
            if (!bl2 && this.colorAttachmentCount > 0) {
                throw new InternalError("Non zero ColorAttachments " + this);
            }
            if (bl) {
                this.detachRenderbufferImpl(gL, Attachment.Type.DEPTH_STENCIL, bl2 ? DetachAction.RECREATE : DetachAction.DISPOSE);
            }
            if (this.ignoreStatus) {
                this.updateStatus(gL);
                if (!this.isStatusValid()) {
                    throw new GLException("detachAllImpl failed " + this.getStatusString() + ", " + this);
                }
            }
        }
        finally {
            this.ignoreStatus = false;
        }
        if (DEBUG) {
            System.err.println("FBObject.detachAll.X: [resetNonColorbuffer " + bl + ", recreate " + bl2 + "]: " + this);
        }
    }

    public final void destroy(GL gL) {
        if (!this.initialized) {
            return;
        }
        if (DEBUG) {
            System.err.println("FBObject.destroy.0: " + this);
        }
        if (null != this.samplingSink && this.samplingSink.isInitialized()) {
            this.samplingSink.destroy(gL);
        }
        this.detachAllImpl(gL, true, false);
        int n = this.fbName;
        this.fbName = 0;
        int[] nArray = new int[1];
        if (0 != n) {
            nArray[0] = n;
            gL.glDeleteFramebuffers(1, nArray, 0);
        }
        this.initialized = false;
        this.bound = false;
        if (DEBUG) {
            System.err.println("FBObject.destroy.X: " + this);
        }
    }

    private final boolean sampleSinkSizeMismatch() {
        return this.samplingSink.getWidth() != this.width || this.samplingSink.getHeight() != this.height;
    }

    private final boolean sampleSinkTexMismatch() {
        return null == this.samplingSinkTexture || 0 == this.samplingSinkTexture.getName();
    }

    private final boolean sampleSinkDepthStencilMismatch() {
        boolean bl = null != this.depth && null == this.samplingSink.depth || null != this.depth && null != this.samplingSink.depth && this.depth.format != this.samplingSink.depth.format;
        boolean bl2 = null != this.stencil && null == this.samplingSink.stencil || null != this.stencil && null != this.samplingSink.stencil && this.stencil.format != this.samplingSink.stencil.format;
        return bl || bl2;
    }

    public final void resetSamplingSink(GL gL) throws GLException {
        if (0 == this.samples) {
            if (null != this.samplingSink && this.samplingSink.initialized) {
                this.samplingSink.detachAll(gL);
            }
            return;
        }
        if (null == this.samplingSink) {
            this.samplingSink = new FBObject();
        }
        if (!this.samplingSink.initialized) {
            this.samplingSink.init(gL, this.width, this.height, 0);
        }
        boolean bl = this.sampleSinkSizeMismatch();
        boolean bl2 = this.sampleSinkTexMismatch();
        boolean bl3 = this.sampleSinkDepthStencilMismatch();
        if (!(bl || bl2 || bl3)) {
            return;
        }
        this.unbind(gL);
        if (DEBUG) {
            System.err.println("FBObject.resetSamplingSink: BEGIN\n\tTHIS " + this + ",\n\tSINK " + this.samplingSink + "\n\t size " + bl + ", tex " + bl2 + ", depthStencil " + bl3);
        }
        if (bl3) {
            this.samplingSink.detachAllRenderbuffer(gL);
        }
        if (bl) {
            this.samplingSink.reset(gL, this.width, this.height);
        }
        if (null == this.samplingSinkTexture) {
            this.samplingSinkTexture = this.samplingSink.attachTexture2D(gL, 0, true);
        } else if (0 == this.samplingSinkTexture.getName()) {
            this.samplingSinkTexture.setSize(this.width, this.height);
            this.samplingSink.attachColorbuffer(gL, 0, this.samplingSinkTexture);
        }
        if (bl3) {
            this.samplingSink.attachRenderbuffer(gL, this.depth.format);
            if (null != this.stencil && !this.isDepthStencilPackedFormat()) {
                this.samplingSink.attachRenderbuffer(gL, this.stencil.format);
            }
        }
        bl = this.sampleSinkSizeMismatch();
        bl2 = this.sampleSinkTexMismatch();
        bl3 = this.sampleSinkDepthStencilMismatch();
        if (bl || bl2 || bl3) {
            throw new InternalError("Samples sink mismatch after reset: \n\tTHIS " + this + ",\n\t SINK " + this.samplingSink + "\n\t size " + bl + ", tex " + bl2 + ", depthStencil " + bl3);
        }
        if (DEBUG) {
            System.err.println("FBObject.resetSamplingSink: END\n\tTHIS " + this + ",\n\tSINK " + this.samplingSink + "\n\t size " + bl + ", tex " + bl2 + ", depthStencil " + bl3);
        }
    }

    public FBObject setSamplingSink(FBObject fBObject) throws GLException {
        FBObject fBObject2 = this.samplingSink;
        if (null == fBObject) {
            this.samplingSink = null;
            this.samplingSinkTexture = null;
        } else if (this.samples > 0) {
            if (fBObject.getNumSamples() > 0) {
                throw new GLException("SamplingSink FBO cannot use MSAA itself: " + fBObject);
            }
            this.samplingSink = fBObject;
            this.samplingSinkTexture = (TextureAttachment)fBObject.getColorbuffer(0);
        } else {
            throw new GLException("Setting SamplingSink for non MSAA FBO not allowed: " + this);
        }
        this.samplingSinkDirty = true;
        return fBObject2;
    }

    public final void bind(GL gL) throws GLException {
        if (!this.bound || this.fbName != gL.getBoundFramebuffer(36160)) {
            this.checkInitialized();
            if (this.samples > 0 && this.fullFBOSupport) {
                gL.glBindFramebuffer(36009, this.getWriteFramebuffer());
                gL.glBindFramebuffer(36008, this.getReadFramebuffer());
            } else {
                gL.glBindFramebuffer(36160, this.getWriteFramebuffer());
            }
            this.bound = true;
            this.samplingSinkDirty = true;
        }
    }

    public final void unbind(GL gL) throws GLException {
        if (this.bound) {
            if (this.fullFBOSupport) {
                gL.glBindFramebuffer(36009, 0);
                gL.glBindFramebuffer(36008, 0);
            } else {
                gL.glBindFramebuffer(36160, 0);
            }
            this.bound = false;
        }
    }

    public final void markUnbound() {
        this.bound = false;
    }

    public final boolean isBound(GL gL) {
        this.bound = this.bound && this.fbName != gL.getBoundFramebuffer(36160);
        return this.bound;
    }

    public final boolean isBound() {
        return this.bound;
    }

    public final void syncSamplingSink(GL gL) {
        this.markUnbound();
        if (this.samples > 0 && this.samplingSinkDirty) {
            this.samplingSinkDirty = false;
            this.resetSamplingSink(gL);
            FBObject.checkPreGLError(gL);
            gL.glBindFramebuffer(36008, this.fbName);
            gL.glBindFramebuffer(36009, this.samplingSink.getWriteFramebuffer());
            ((GL2GL3)gL).glBlitFramebuffer(0, 0, this.width, this.height, 0, 0, this.width, this.height, 16384, 9728);
            this.checkNoError(null, gL.glGetError(), "FBObject syncSampleSink");
        }
        if (this.fullFBOSupport) {
            gL.glBindFramebuffer(36009, 0);
            gL.glBindFramebuffer(36008, 0);
        } else {
            gL.glBindFramebuffer(36160, 0);
        }
    }

    public final void use(GL gL, TextureAttachment textureAttachment) throws IllegalArgumentException {
        if (null == textureAttachment) {
            throw new IllegalArgumentException("Null TextureAttachment, this: " + this.toString());
        }
        this.syncSamplingSink(gL);
        gL.glBindTexture(3553, textureAttachment.getName());
    }

    public final void unuse(GL gL) {
        this.unbind(gL);
        gL.glBindTexture(3553, 0);
    }

    public final boolean hasFullFBOSupport() throws GLException {
        this.checkInitialized();
        return this.fullFBOSupport;
    }

    public final boolean supportsRGBA8() throws GLException {
        this.checkInitialized();
        return this.rgba8Avail;
    }

    public final boolean supportsDepth(int n) throws GLException {
        this.checkInitialized();
        switch (n) {
            case 16: {
                return true;
            }
            case 24: {
                return this.depth24Avail;
            }
            case 32: {
                return this.depth32Avail;
            }
        }
        return false;
    }

    public final boolean supportsStencil(int n) throws GLException {
        this.checkInitialized();
        switch (n) {
            case 1: {
                return this.stencil01Avail;
            }
            case 4: {
                return this.stencil04Avail;
            }
            case 8: {
                return this.stencil08Avail;
            }
            case 16: {
                return this.stencil16Avail;
            }
        }
        return false;
    }

    public final boolean supportsPackedDepthStencil() throws GLException {
        this.checkInitialized();
        return this.packedDepthStencilAvail;
    }

    public final int getMaxColorAttachments() throws GLException {
        this.checkInitialized();
        return this.maxColorAttachments;
    }

    public final int getMaxTextureSize() throws GLException {
        this.checkInitialized();
        return this.maxTextureSize;
    }

    public final int getMaxRenderbufferSize() throws GLException {
        this.checkInitialized();
        return this.maxRenderbufferSize;
    }

    public final int getMaxSamples() throws GLException {
        this.checkInitialized();
        return this.maxSamples;
    }

    public final boolean isInitialized() {
        return this.initialized;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getNumSamples() {
        return this.samples;
    }

    public final int getWriteFramebuffer() {
        return this.fbName;
    }

    public final int getReadFramebuffer() {
        return this.samples > 0 ? this.samplingSink.getReadFramebuffer() : this.fbName;
    }

    public final int getDefaultReadBuffer() {
        return 36064;
    }

    public final int getColorAttachmentCount() {
        return this.colorAttachmentCount;
    }

    public final RenderAttachment getStencilAttachment() {
        return this.stencil;
    }

    public final RenderAttachment getDepthAttachment() {
        return this.depth;
    }

    public final FBObject getSamplingSinkFBO() {
        return this.samplingSink;
    }

    public final TextureAttachment getSamplingSink() {
        return this.samplingSinkTexture;
    }

    public final boolean isSamplingBufferDirty() {
        return this.samplingSinkDirty;
    }

    int objectHashCode() {
        return super.hashCode();
    }

    public final String toString() {
        String string = null != this.colorAttachmentPoints ? Arrays.asList(this.colorAttachmentPoints).toString() : null;
        return "FBO[name r/w " + this.fbName + "/" + this.getReadFramebuffer() + ", init " + this.initialized + ", bound " + this.bound + ", size " + this.width + "x" + this.height + ", samples " + this.samples + "/" + this.maxSamples + ", depth " + this.depth + ", stencil " + this.stencil + ", color attachments: " + this.colorAttachmentCount + "/" + this.maxColorAttachments + ": " + string + ", msaa-sink " + this.samplingSinkTexture + ", hasSamplesSink " + (null != this.samplingSink) + ", state " + this.getStatusString() + ", obj " + FBObject.toHexString(this.objectHashCode()) + "]";
    }

    private final void updateStatus(GL gL) {
        this.vStatus = 0 == this.fbName ? -1 : gL.glCheckFramebufferStatus(36160);
    }

    public static class TextureAttachment
    extends Attachment
    implements Colorbuffer {
        public final int dataFormat;
        public final int dataType;
        public final int magFilter;
        public final int minFilter;
        public final int wrapS;
        public final int wrapT;

        public TextureAttachment(Attachment.Type type, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
            super(TextureAttachment.validateType(type), n, n2, n3, n10);
            this.dataFormat = n4;
            this.dataType = n5;
            this.magFilter = n6;
            this.minFilter = n7;
            this.wrapS = n8;
            this.wrapT = n9;
        }

        private static Attachment.Type validateType(Attachment.Type type) {
            switch (type) {
                case COLOR_TEXTURE: 
                case DEPTH_TEXTURE: 
                case STENCIL_TEXTURE: {
                    return type;
                }
            }
            throw new IllegalArgumentException("Invalid type: " + (Object)((Object)type));
        }

        @Override
        public boolean initialize(GL gL) throws GLException {
            boolean bl;
            boolean bl2 = bl = 0 == this.getName();
            if (bl) {
                FBObject.checkPreGLError(gL);
                int[] nArray = new int[]{-1};
                gL.glGenTextures(1, nArray, 0);
                if (0 == nArray[0]) {
                    throw new GLException("null texture, " + this);
                }
                this.setName(nArray[0]);
                gL.glBindTexture(3553, nArray[0]);
                if (0 < this.magFilter) {
                    gL.glTexParameteri(3553, 10240, this.magFilter);
                }
                if (0 < this.minFilter) {
                    gL.glTexParameteri(3553, 10241, this.minFilter);
                }
                if (0 < this.wrapS) {
                    gL.glTexParameteri(3553, 10242, this.wrapS);
                }
                if (0 < this.wrapT) {
                    gL.glTexParameteri(3553, 10243, this.wrapT);
                }
                boolean bl3 = true;
                int n = gL.glGetError();
                if (0 == n) {
                    bl3 = false;
                    gL.glTexImage2D(3553, 0, this.format, this.getWidth(), this.getHeight(), 0, this.dataFormat, this.dataType, null);
                    n = gL.glGetError();
                }
                if (0 != n) {
                    gL.glDeleteTextures(1, nArray, 0);
                    this.setName(0);
                    throw new GLException("GL Error " + FBObject.toHexString(n) + " while creating (pre TexImage2D " + bl3 + ") " + this);
                }
                if (DEBUG) {
                    System.err.println("Attachment.init.X: " + this);
                }
            }
            return bl;
        }

        @Override
        public void free(GL gL) {
            int[] nArray = new int[]{this.getName()};
            if (0 != nArray[0]) {
                if (DEBUG) {
                    System.err.println("Attachment.free.0: " + this);
                }
                gL.glDeleteTextures(1, nArray, 0);
                this.setName(0);
            }
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "[type " + (Object)((Object)this.type) + ", target GL_TEXTURE_2D, level 0, format " + FBObject.toHexString(this.format) + ", " + this.getWidth() + "x" + this.getHeight() + ", border 0, dataFormat " + FBObject.toHexString(this.dataFormat) + ", dataType " + FBObject.toHexString(this.dataType) + "; min/mag " + FBObject.toHexString(this.minFilter) + "/" + FBObject.toHexString(this.magFilter) + ", wrap S/T " + FBObject.toHexString(this.wrapS) + "/" + FBObject.toHexString(this.wrapT) + "; name " + FBObject.toHexString(this.getName()) + ", obj " + FBObject.toHexString(this.objectHashCode()) + "]";
        }
    }

    public static class ColorAttachment
    extends RenderAttachment
    implements Colorbuffer {
        public ColorAttachment(int n, int n2, int n3, int n4, int n5) {
            super(Attachment.Type.COLOR, n, n2, n3, n4, n5);
        }
    }

    public static class RenderAttachment
    extends Attachment {
        private int samples;

        public RenderAttachment(Attachment.Type type, int n, int n2, int n3, int n4, int n5) {
            super(RenderAttachment.validateType(type), n, n3, n4, n5);
            this.samples = n2;
        }

        public final int getSamples() {
            return this.samples;
        }

        final void setSamples(int n) {
            this.samples = n;
        }

        private static Attachment.Type validateType(Attachment.Type type) {
            switch (type) {
                case DEPTH_STENCIL: 
                case DEPTH: 
                case STENCIL: 
                case COLOR: {
                    return type;
                }
            }
            throw new IllegalArgumentException("Invalid type: " + (Object)((Object)type));
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof RenderAttachment)) {
                return false;
            }
            return super.equals(object) && this.samples == ((RenderAttachment)object).samples;
        }

        @Override
        public int hashCode() {
            int n = super.hashCode();
            n = (n << 5) - n + this.samples;
            return n;
        }

        @Override
        public boolean initialize(GL gL) throws GLException {
            boolean bl;
            boolean bl2 = bl = 0 == this.getName();
            if (bl) {
                FBObject.checkPreGLError(gL);
                int[] nArray = new int[]{-1};
                gL.glGenRenderbuffers(1, nArray, 0);
                this.setName(nArray[0]);
                gL.glBindRenderbuffer(36161, this.getName());
                if (this.samples > 0) {
                    ((GL2GL3)gL).glRenderbufferStorageMultisample(36161, this.samples, this.format, this.getWidth(), this.getHeight());
                } else {
                    gL.glRenderbufferStorage(36161, this.format, this.getWidth(), this.getHeight());
                }
                int n = gL.glGetError();
                if (0 != n) {
                    gL.glDeleteRenderbuffers(1, nArray, 0);
                    this.setName(0);
                    throw new GLException("GL Error " + FBObject.toHexString(n) + " while creating " + this);
                }
                if (DEBUG) {
                    System.err.println("Attachment.init.X: " + this);
                }
            }
            return bl;
        }

        @Override
        public void free(GL gL) {
            int[] nArray = new int[]{this.getName()};
            if (0 != nArray[0]) {
                if (DEBUG) {
                    System.err.println("Attachment.free.0: " + this);
                }
                gL.glDeleteRenderbuffers(1, nArray, 0);
                this.setName(0);
            }
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "[type " + (Object)((Object)this.type) + ", format " + FBObject.toHexString(this.format) + ", samples " + this.samples + ", " + this.getWidth() + "x" + this.getHeight() + ", name " + FBObject.toHexString(this.getName()) + ", obj " + FBObject.toHexString(this.objectHashCode()) + "]";
        }
    }

    public static abstract class Attachment {
        public final Type type;
        public final int format;
        private int width;
        private int height;
        private int name;

        protected Attachment(Type type, int n, int n2, int n3, int n4) {
            this.type = type;
            this.format = n;
            this.width = n2;
            this.height = n3;
            this.name = n4;
        }

        public final void formatToGLCapabilities(GLCapabilities gLCapabilities, boolean bl) {
            int n;
            switch (this.format) {
                case 4: 
                case 6408: {
                    n = bl ? 32856 : 32854;
                    break;
                }
                case 3: 
                case 6407: {
                    n = bl ? 32849 : 36194;
                    break;
                }
                default: {
                    n = this.format;
                }
            }
            switch (n) {
                case 32854: {
                    gLCapabilities.setRedBits(4);
                    gLCapabilities.setGreenBits(4);
                    gLCapabilities.setBlueBits(4);
                    gLCapabilities.setAlphaBits(4);
                    break;
                }
                case 32855: {
                    gLCapabilities.setRedBits(5);
                    gLCapabilities.setGreenBits(5);
                    gLCapabilities.setBlueBits(5);
                    gLCapabilities.setAlphaBits(1);
                    break;
                }
                case 36194: {
                    gLCapabilities.setRedBits(5);
                    gLCapabilities.setGreenBits(6);
                    gLCapabilities.setBlueBits(5);
                    gLCapabilities.setAlphaBits(0);
                    break;
                }
                case 32849: {
                    gLCapabilities.setRedBits(8);
                    gLCapabilities.setGreenBits(8);
                    gLCapabilities.setBlueBits(8);
                    gLCapabilities.setAlphaBits(0);
                    break;
                }
                case 32856: {
                    gLCapabilities.setRedBits(8);
                    gLCapabilities.setGreenBits(8);
                    gLCapabilities.setBlueBits(8);
                    gLCapabilities.setAlphaBits(8);
                    break;
                }
                case 33189: {
                    gLCapabilities.setDepthBits(16);
                    break;
                }
                case 33190: {
                    gLCapabilities.setDepthBits(24);
                    break;
                }
                case 33191: {
                    gLCapabilities.setDepthBits(32);
                    break;
                }
                case 36166: {
                    gLCapabilities.setStencilBits(1);
                    break;
                }
                case 36167: {
                    gLCapabilities.setStencilBits(4);
                    break;
                }
                case 36168: {
                    gLCapabilities.setStencilBits(8);
                    break;
                }
                case 35056: {
                    gLCapabilities.setDepthBits(24);
                    gLCapabilities.setStencilBits(8);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("format invalid: " + FBObject.toHexString(this.format));
                }
            }
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        final void setSize(int n, int n2) {
            this.width = n;
            this.height = n2;
        }

        public final int getName() {
            return this.name;
        }

        final void setName(int n) {
            this.name = n;
        }

        public abstract boolean initialize(GL var1) throws GLException;

        public abstract void free(GL var1) throws GLException;

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Attachment)) {
                return false;
            }
            Attachment attachment = (Attachment)object;
            return this.type == attachment.type && this.format == attachment.format && this.width == attachment.width && this.height == attachment.height && this.name == attachment.name;
        }

        public int hashCode() {
            int n = 31 + this.type.ordinal();
            n = (n << 5) - n + this.format;
            n = (n << 5) - n + this.width;
            n = (n << 5) - n + this.height;
            n = (n << 5) - n + this.name;
            return n;
        }

        int objectHashCode() {
            return super.hashCode();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[type " + (Object)((Object)this.type) + ", format " + FBObject.toHexString(this.format) + ", " + this.width + "x" + this.height + "; name " + FBObject.toHexString(this.name) + ", obj " + FBObject.toHexString(this.objectHashCode()) + "]";
        }

        public static Type getType(int n, int n2) {
            if (36064 <= n && n < 36064 + n2) {
                return Type.COLOR;
            }
            switch (n) {
                case 36096: {
                    return Type.DEPTH;
                }
                case 36128: {
                    return Type.STENCIL;
                }
            }
            throw new IllegalArgumentException("Invalid attachment point " + FBObject.toHexString(n));
        }

        public static enum Type {
            NONE,
            DEPTH,
            STENCIL,
            DEPTH_STENCIL,
            COLOR,
            COLOR_TEXTURE,
            DEPTH_TEXTURE,
            STENCIL_TEXTURE;


            public static Type determine(int n) throws IllegalArgumentException {
                switch (n) {
                    case 32849: 
                    case 32854: 
                    case 32855: 
                    case 32856: 
                    case 36194: {
                        return COLOR;
                    }
                    case 33189: 
                    case 33190: 
                    case 33191: {
                        return DEPTH;
                    }
                    case 36166: 
                    case 36167: 
                    case 36168: {
                        return STENCIL;
                    }
                    case 35056: {
                        return DEPTH_STENCIL;
                    }
                }
                throw new IllegalArgumentException("format invalid: " + FBObject.toHexString(n));
            }
        }
    }

    public static interface Colorbuffer {
        public boolean initialize(GL var1) throws GLException;

        public void free(GL var1) throws GLException;

        public void formatToGLCapabilities(GLCapabilities var1, boolean var2);
    }

    private static enum DetachAction {
        NONE,
        DISPOSE,
        RECREATE;

    }
}

