/*
 * Name(s): 
 * Visual Coin and Hi-Lo
 * Concept from Shannon Duavll
 * Implementation from Duke Hutchings 
 */

package pw4loops;

import processing.core.PApplet;
import javax.swing.*;

public class PW4Loops extends PApplet {

	// game codes
	final int GAME_NONE = 0;  // for when no game is selected
	final int GAME_HILO = 1;  // Hi-Lo game
	final int GAME_BABY = 2;  // 3 Boys game
	int currGame = GAME_NONE; // the game currently being played
	
	// setup method
	// you don't need to change anything here,
	// but you can change the size if you want to
	// recommended: keep width bigger than height
	public void setup() {
		size(800, 600); // fits most desktop screens
		smooth(); // lots of circles, draw smooth ones
		noStroke(); // don't need borders
	}

	// draw method
	// you don't need to change anything here
	public void draw() {
		if (currGame == GAME_HILO) {
			playHilo();
		}
		else if (currGame == GAME_BABY) {
			playBaby();
		}
	}
	
	// drawBaby method
	// input parameters:
	//   x: x-coordinate at which to draw the baby
	//   y: y-coordinate at which to draw the baby
	//   diam: the diameter of the baby icon
	//   aboy: whether the baby is a boy
	// output type: void
	// method purpose
	//   draws a crude baby icon
	//   draws blue if aboy is true; pink otherwise
	public void drawBaby(int x, int y, int diam, boolean aboy) {
		if (aboy) {
			fill(223,223,255);
		}
		else {
			fill(255,223,223);
		}

		ellipse(x, y, diam, diam);

		if (aboy) {
			fill(127,127,255);
		}
		else {
			fill(255,127,127);
		}

		int off = diam/4;
		int eye = off/2;
		ellipse(x-off, y-off, eye, eye);
		ellipse(x+off, y-off, eye, eye);
		arc(x, y, off, off, 0, PI);
	}

	// ----- PROBLEM 1 -----  Create a method header and implement it
	// itsABoy method
	// input parameters: none
	// output type: boolean
	// method purpose
	//   simulates a birth and reports whether the baby is a boy
	//     so half of the time, this method should return true
	//     and the other half of the time, return false
	//   HINT: the following line of code assigns a random decimal-point
	//         number between 0 and 0.99999999 to r
	//   double r = Math.random();

	// YOUR CODE HERE
	
	// Recommended: have the instructor check your work when complete, but
	//              if he's detained, move ahead (but grab him when he's free)
	
	// ----- END PROBLEM 1 -----


	// playBaby method
	// input parameters: none
	// output type: void
	// method purpose
	//   simulates having babies until three boys in a row are born
	//   visualizes the sequence of children born
	public void playBaby() {
		background(0); // reset the drawing space

		// drawing stuff
		int diam = width / 20; // baby diameter (accounts for 20 babies across)
		int r = diam / 2; // baby radius
		int x = r; // initial x position to draw baby
		int y = r; // initial y position to draw baby

		// game stuff
		int boys = 0; // number of *consecutive* baby boys

		// ----- PROBLEM 2 -----  Write a loop here
		//   [ read the code above to understand the context ]
		//   loop details:
		//   1. repeat steps 2-6 until the value in boys is 3
		//   2. call the itsABoy method you wrote in Problem 1
		//   3. update the value in the boys variable based on the result 
		//   4. draw a baby using the drawBaby method
		//   5. move to the right by increasing x by the value in diam
		//   6. check if the next face would be drawn off-screen
		//      6a. if so, reset x to its initial value and
		//                 also increase y by the value in diam

		// YOUR CODE HERE

		// Recommended: run your code and type B on the keyboard
		//              does it draw babies until there are three boys in a row?
		//              (note: if right edge of screen is reached, wraps to next row)
		//              you can keep typing B to see additional results
		
		// ----- END PROBLEM 2 -----
		
		currGame = GAME_NONE; // game over
	}


	// drawDotRow method
	// input parameters:
	//   numDots: the number of dots to draw in the row
	//   diam: the diameter of the dot
	//   y: the y coordinate at which to draw the dots
	// output type: void
	// method purpose
	//   draws a row of dots, starting at the left edge
	//   of the drawing space, and subject to the input
	//   parameters described above
	public void drawDotRow(int numDots, int diam, int y) {
		// ----- PROBLEM 3 -----  Implement the method here using a loop
		
		// YOUR CODE HERE

		// Recommended: to test your work, run the code and type H
		//              then enter a small number and see if that many dots were drawn
		//              just below the top area of the drawing space
		
		// ----- END PROBLEM 3 -----
	}


	// drawHiloHelperDots method
	// input parameters:
	//   diam: the diameter of the dot
	//   y: the y coordinate at which to draw the dots
	// output type: void
	// method purpose
	//   draws a row of 19 blue dots spaced evenly (to mark groups of 5)
	//   draws a row of 4 red dots spaced evenly (to mark groups of 20)
	//   hint: draw the blue dots first, then draw the red dots on top
	//   see PW4 Web video for illustration of helper dots
	public void drawHiloHelperDots(int diam, int y) {
		// ----- PROBLEM 4 -----  Implement the method here using a loop

		// YOUR CODE HERE

		// Recommended: to test your work, run the code and type H
		//              enter a large number divisible by 5
		//              helper dots should appear above and below the row of dots

		// ----- END PROBLEM 4 -----
	}
	

	// getHiloNum method
	// input parameters
	//   first: a boolean indicating if this is the first guess
	//   prevGuess: an integer indicating the previous guess made
	//   target: an integer indicating the number attempted to be guessed
	// output
	//   the number the user has guessed, if input was valid
	//   the value in prevGuess, if input was invalid
	// method purpose
	//   allows user to guess a number
	//   if a previous guess was made, also tells user to guess higher or lower
	// NOTES
	//   this method has already been implemented, no code necessary here
	//   BUT you will need to properly call this method in Problem 5
	public int getHiloNum(boolean first, int prevGuess, int target) {
		String response = Integer.toString(target);
		if (first) {
			response = JOptionPane.showInputDialog(null, "What number do you guess?");
		}
		else if (prevGuess < target) {
			response = JOptionPane.showInputDialog(null, "What number do you guess higher than " + prevGuess + "?");
		}
		else if (prevGuess > target) {
			response = JOptionPane.showInputDialog(null, "What number do you guess lower than " + prevGuess + "?");
		}

		int ans = prevGuess;
		try {
			ans = Integer.parseInt(response);
		}
		catch (Exception e) {
			// don't do anything, but don't crash either
		}
		
		return ans;
	}

	// playHilo method
	// input parameters: none
	// output type: void
	// method purpose
	//   simulates playing the hi-lo game
	//   visualizes the sequences of guesses
	public void playHilo() {
		background(0); // reset the drawing space
		int diam = width / 100; // make enough room for 100 dots
		int y = diam / 2; // start drawing dots at top of screen
		int target = 1+(int)(Math.random()*100); // the number that the user is trying to guess.
		int guess = getHiloNum(true, -1, -1);  // the number that the user has most recently guessed
		
		drawHiloHelperDots(diam, y); // draw helper dots
		y = y + diam; // move to next row of dots
		fill(255);
		
		// ----- PROBLEM 5 -----  Write a loop
		// 1. inspect the code above so you get some context on what is happening
		// 2. repeat steps 2a through 2c until the user has guessed the number
		//    2a. call drawDotRow using guess as the number of dots, diam, and y
		//    2b. update y to get ready to draw the next row of dots
		//    2c. assign to guess the value returned from getHiloNum
		//        (hint: this is not a first guess; check comments for getHiloNum)

		// YOUR CODE HERE

		// Recommended: to test your work, play the game by typing H
		//              at first, the answer will always be 60 (this helps you test)
		//              once you are sure your game is working...
		//                 - change the line of code above setting target to 60
		//                 - instead of 60, assign a random integer between 1 and 100
		//                 - hint: use the Math.random() method you learned in Problem 1
		//              test your code again after making this change

		// ----- END PROBLEM 5 -----
		
		fill(255, 255, 0);
		drawDotRow(guess, diam, y);
		drawHiloHelperDots(diam, y + diam);
		currGame = GAME_NONE;
	}

	
	public void keyPressed() {
		if (keyCode == 'B') {
			currGame = GAME_BABY;
		}
		else if (keyCode == 'H') {
			background(0);
			currGame = GAME_HILO;
		}
	}
}
