package pw3rps;

import java.awt.Color;

import processing.core.*;

public class PW3RPS extends PApplet {
	
	// ----- You may refer to these variables as you solve the problems -----
	// ----- But you won't change any code up here --------------------------
	// ----- Scroll down to the first method definition ---------------------
	
	public final int STAGE_PLAY = 1;
	public final int STAGE_DET_WIN = 2; // determine winner
	public final int STAGE_RESULTS = 3;
	public final int STAGE_RESET = 4;
	public int stage = STAGE_RESET;
	public Color backColor = new Color(0, 0, 0);
	public Color foreColor = new Color(255, 255, 255);
	
	public int lWins = 0; // left-player, number of wins
	public int rWins = 0; // right-player, number of wins
	public int draws = 0; // number of draws
	
	public final int ptSize = 10; // size of a point visualization
	public final int ptPad = 2;   // padding around a point visualization
	
	public final int NOTYET = 0;
	public final int ROCK = 1;
	public final int PAPER = 2;
	public final int SCISSORS = 3;
	public int lChoice = NOTYET; // left-players choice
	public int rChoice = NOTYET; // right-players choice
	public int lChoiceX = 0;
	public int lChoiceY = 0;
	public int rChoiceX = 0;
	public int rChoiceY = 0;
	public int choiceSize = 0;
	
	public boolean imgDraw = true;
	public PImage imageR = loadImage("rock.png");
	public PImage imageP = loadImage("paper.png");
	public PImage imageS = loadImage("scissors.png");
	
	// ----- OK you make it to the first method definition -----
	// ----- Your code goes in the five areas below here -------
	

	public void mouseClicked() {
		// ----- START PROBLEM 1 -----
		// check if the stage variable is equal to STAGE_RESULTS
		// if so, set stage to the new value STAGE_RESET
		// if not, do nothing
		
		// REPLACE THIS COMMENT WITH YOUR CODE
		
		// you will notice no change in the game after completing this code
		// move onto the next problem

		// ----- END PROBLEM 1 -----
	}

	public void keyPressed() {
		if (keyCode == 'D') {
			imgDraw = !imgDraw;
			resetColors();
		}

		if (keyCode == ' ' && stage == STAGE_RESULTS) {
			stage = STAGE_RESET;
		}
		else if (stage == STAGE_PLAY) {
			// ----- START PROBLEM 2 -----
			// if keyCode is the character 1 set lChoice to the value ROCK
			// if keyCode is the character 2 set lChoice to the value PAPER
			// if keyCode is the character 3 set lChoice to the value SCISSORS
			// if keyCode is the character 7 or the integer 103, set rChoice to the value ROCK
			// if keyCode is the character 8 or the integer 104, set rChoice to the value PAPER
			// if keyCode is the character 9 or the integer 105, set rChoice to the value SCISSORS
			
			// REPLACE THIS COMMENT WITH YOUR CODE
			
			// after you correctly complete this code, you will start to be able to play the game
			// left player uses 1, 2, or 3 (at top of keyboard)
			// right player uses 7, 8, or 9 (at top of keyboard or in number pad)
			// result displayed after both players choose
			// reset the game using space (built-in) or clicking the mouse (problem 1)

			// STRONGLY RECOMMENDED: have the instructor check your work before proceeding to next problems

			// ----- END PROBLEM 2 -----
		}
	}

	public boolean leftPlayerWins() {
		boolean wins = false;
	
		// ----- START PROBLEM 3 -----
		// if any one of the following statements is true then
		// change the value of the wins variable to true 
		//   lChoice is ROCK and rChoice is SCISSORS
		//   lChoice is PAPER and rChoice is ROCK
		//   lChoice is SCISSORS and rChoice is PAPER
		
		// REPLACE THIS COMMENT WITH YOUR CODE
		
		// after you correctly implement this code,
		// you will not notice any change in your program
		// move onto the next problem

		// ----- END PROBLEM 3 -----

		return wins;
	}

	public void determineWinner() {
		// ----- START PROBLEM 4 -----
		// create a boolean variable called leftWinner
		// assign to leftWinner the result of calling the leftPlayerWins() method
		// now check if leftWinner is true
		//    if so, increase the lWins variable by 1
		//    if not, check if lChoice and rChoice have the same value
		//       if so, increase draws by 1
		//       if not, increase rWins by 1

		// REPLACE THIS COMMENT WITH YOUR CODE

		// after you correctly implement this code
		// you will notice score being kept on the sides
		// if the score is wrong, check this code or code in the previous problem
		
		// ----- END PROBLEM 4 -----

		stage = STAGE_RESULTS;
	}

	public void genDrawScore(int x, int numWins) {
		rectMode(CORNER);
		noStroke();
		resetFill();
		int x1 = x;
		int y = ptPad;
		int x5 = x1 + ptSize + ptPad; // vis for 5 points
		int h5 = 5*ptSize + 4*ptPad;
		for (int i = 0; i < numWins; i++) {
			rect(x1, y, ptSize, ptSize);

			// ----- START PROBLEM 5 -----
			// if i is evenly divisible by 5, then
			// draw a rectangle at x5, y with width ptSize and height h5

			// REPLACE THIS COMMENT WITH YOUR CODE
			
			// after you complete this code correctly, a long bar will appear
			// in the scoring area when 1, 6, 11, etc. points are scored per player
			
			// ----- END PROBLEM 5 -----

			y = y + ptSize + ptPad;
		}
	}

	
	// You won't make any changes from here down, but feel free to inspect the code
	
	public void draw() {
		background(backColor.getRed(), backColor.getGreen(), backColor.getBlue());
		drawScore();
		if (stage == STAGE_PLAY) {
			drawForPlaying();
		}
		else if (stage == STAGE_DET_WIN) {
			determineWinner();
		}
		else if (stage == STAGE_RESULTS) {
			drawForResults();
		}
		else if (stage == STAGE_RESET) {
			nextGame();
		}
	}
	
	public void drawForPlaying() {
		// don't show anything... just see if it's time to show results
		if (lChoice != NOTYET && rChoice != NOTYET) {
			stage = STAGE_DET_WIN;
		}
	}
	
	public void genDrawChoice(int x, int y, int choice) {
		if (choice == ROCK) {
			drawRock(x, y);
		}
		else if (choice == PAPER) {
			drawPaper(x, y);
		}
		else if (choice == SCISSORS) {
			drawScissors(x, y);
		}
	}

	public void setup() {
		smooth();
		size(800, 450);
		choiceSize = Math.min(width / 5, height / 5);
		lChoiceX = width / 4;
		lChoiceY = height / 2;
		rChoiceX = lChoiceX * 3;
		rChoiceY = lChoiceY;
		imageMode(CENTER);
	}

	public void resetFill() {
		fill(foreColor.getRed(), foreColor.getGreen(), foreColor.getBlue());
	}
	
	public void resetStroke() {
		stroke(foreColor.getRed(), foreColor.getGreen(), foreColor.getBlue());
	}
	
	public void drawScore() {
		genDrawScore(ptPad, lWins);
		genDrawScore(width - 1 - 2*(ptPad + ptSize), rWins);
	}
	
	public void drawForResults() {
		genDrawChoice(lChoiceX, lChoiceY, lChoice);
		genDrawChoice(rChoiceX, rChoiceY, rChoice);
	}
	
	public void drawRock(int x, int y) {
		if (imgDraw) {
			image(imageR, x, y);

//          WORKS, SORTA... TOO UGLY
//			imageR = loadImage("rock.png");
//			imageR.loadPixels();
//			for (int i = 0; i < imageR.pixels.length; i++) {
//				if (red(imageR.pixels[i]) >= 240 && green(imageR.pixels[i]) >= 240 && blue(imageR.pixels[i]) >= 240) {
//					imageR.pixels[i] = color(backColor.getRed(), backColor.getGreen(), backColor.getBlue());
//				}
//			}
//			imageR.updatePixels();
		}
		else {
			ellipseMode(CENTER);
			noStroke();
			resetFill();
			ellipse(x, y, choiceSize, choiceSize);
		}
	}
	
	public void drawPaper(int x, int y) {
		if (imgDraw) {
			imageP = loadImage("paper.png");
			image(imageP, x, y);
		}
		else {
			rectMode(CENTER);
			noStroke();
			resetFill();
			rect(x, y, choiceSize, choiceSize);
		}
	}
	
	public void drawScissors(int x, int y) {
		if (imgDraw) {
			imageS = loadImage("scissors.png");
			image(imageS, x, y);
		}
		else {
			int h = choiceSize / 2;
			int s = Math.max(h / 5, 1);
			resetStroke();
			strokeWeight(s);
			line(x - h, y - h, x + h, y + h);
			line(x - h, y + h, x + h, y - h);
		}
	}
	
	public void nextGame() {
		resetColors();
		lChoice = NOTYET;
		rChoice = NOTYET;
		stage = STAGE_PLAY;
	}
	
	public void resetColors() {
		int cap = 127;
		int rb = (int) (Math.random() * cap);
		int gb = (int) (Math.random() * cap);
		int bb = (int) (Math.random() * cap);
		int rf = rb + cap;
		int gf = gb + cap;
		int bf = bb + cap;
		if (imgDraw) {
			rf = rb;
			gf = gb;
			bf = bb;
			rb = 255;
			gb = 255;
			bb = 255;
		}
		backColor = new Color(rb, gb, bb);
		foreColor = new Color(rf, gf, bf);
	}
	
}
