package lec21ints2d;

import processing.core.PApplet;


public class Lec21Ints2D extends PApplet {

	int[][] nums; // some numbers for practicing 2D array manipulation

	boolean[][] fives;    // locations in nums that have 5 as a value
	boolean[][] smallest; // locations in nums with the smallest value
	boolean[][] neighbor; // locations in nums with a matching neighbor

	public void setup() {
		smooth();
		size(600, 600);

		setupInts(); // create a randomly sized and randomly assigned 2D array
	}

	// sets up the nums array with random numbers between 1 and 9
	// resets the boolean arrays to be the right size and all values to false
	public void setupInts() {
		int numRows = (int)(Math.random()*5) + 3; // between 3 and 7
		int numCols = (int)(Math.random()*5) + 3; // between 3 and 7

		System.out.println("Rows: " + numRows + "  Cols: " + numCols);
		
		nums = new int[numRows][numCols];
		fives = new boolean[numRows][numCols];
		smallest = new boolean[numRows][numCols];
		neighbor = new boolean[numRows][numCols];
		for (int r = 0; r < numRows; r++) {
			for (int c = 0; c < numCols; c++) {
				nums[r][c] = (int)(Math.random()*9) + 1; // between 1 and 9
			}
		}
	}

	// draws the numbers and highlights different types of values
	public void draw() {
		background(255);

		drawInts();
		highlightFives();
		highlightSmallest();
		highlightNeighbors();
	}

	// PROBLEM 1 ///////////////////////////////////////////////////////////////
	// for each location in nums that has the value 5, set the corresponding
	// value in fives to be true.  For example, if nums[1][2] was equal to 5
	// then set fives[1][2] equal to true
	// TEST: your code is working when you click the mouse button and all of the
	// squares with five dots in them are highlighted in green
	public void highlightFives() {

	}


	// PROBLEM 2 ///////////////////////////////////////////////////////////////
	// determine the smallest value in the array.  for each location that has
	// that value, set the corresponding value in smallest to be true.  For
	// example, if the smallest value in the array is 2 and nums[2][1] has the
	// value 2, then set smallest[2][1] to true
	// TEST: your code is working when you click the mouse button and all of the
	// squares with the smallest value are highlighted in red.  this will 
	// usually be the value 1, but keep clicking until you see a 2 highlighted
	// (and make sure it's actually the smallest)
	public void highlightSmallest() {

	}


	// PROBLEM 3 ///////////////////////////////////////////////////////////////
	// for each value in the array, determine if the value to the right is the
	// same.  if so, set both corresponding values in neighbor to be true.  For
	// example, if nums[3][2] and nums[3][3] were both 7, then set both
	// neighbor[3][2] and neighbor[3][3] to be true.
	// TEST: your code is working when you click the mouse button and all of the
	// squares that are next to the same value are blue (or purple if the value
	// is also the smallest value or teal if the value is also 5)
	public void highlightNeighbors() {

	}
	
	
	// PROBLEM 4 ///////////////////////////////////////////////////////////////
	// Go back to problem 3 and comment out your working solution.  Create new  
	// code that highlights neighbors up and down instead of left and right.

	
	// PROBLEM 5 ///////////////////////////////////////////////////////////////
	// Go back to problem 3 and comment out your working solution.  Create new  
	// code that highlights diagonal neighbors.

	
	// PROBLEM 6 ///////////////////////////////////////////////////////////////
	// Go back to problem 2 and comment out your working solution.  Create new  
	// code that highlights the smallest value in each row.  For example,
	// if the 2D array looked like this:
	// |3|7|5|
	// |6|4|2|
	// then highlight nums[0][0] (the 3) and nums[1][2] (the 2)

	// PROBLEM 7 ///////////////////////////////////////////////////////////////
	// Go back to problem 2 and comment out your working solution.  Create new  
	// code that highlights the smallest value in each column.  For example,
	// if the 2D array looked like this:
	// |3|7|5|
	// |6|4|2|
	// then highlight nums[0][0] (the 3) and nums[1][1] (the 4) and nums[1][2] (the 2)
	

	// OTHER STUFF /////////////////////////////////////////////////////////////
	// Feel free to poke around the code below here, but you don't need to
	// change any of it to complete the problems.

	public void mouseClicked() {
		setupInts();
	}

	// comment-free, for your learning enjoyment
	public void drawInts() {
		int s = Math.min(height / (nums.length + 2), width / (nums[0].length + 2));
		textSize(s);
		textAlign(CENTER);

		int y = 0;
		for (int i = 0; i < nums.length; i++) {
			y = y + s;
			int x = s;
			for (int j = 0; j < nums[0].length; j++) {
				stroke(0);
				fill(255);
				rect(x, y, s, s);

				fill(0);
				noStroke();
				text(nums[i][j], x + s / 2, y + s - 4);

				if (smallest[i][j]) {
					fill(255,0,0,127);
					rect(x, y, s, s);
				}
				if (neighbor[i][j]) {
					fill(0,0,255,127);
					rect(x, y, s, s);
				}
				if (fives[i][j]) {
					fill(0,255,0,127);
					rect(x, y, s, s);
				}

				x = x + s;
			}			
		}
	}
}
