/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.av;

public class SyncedRingbuffer<T> {
    protected final Object sync = new Object();
    protected final T[] array;
    protected final int capacity;
    protected int readPos;
    protected int writePos;
    protected int size;

    public final String toString() {
        return "SyncedRingbuffer<?>[filled " + this.size + " / " + this.capacity + ", writePos " + this.writePos + ", readPos " + this.readPos + "]";
    }

    public SyncedRingbuffer(T[] TArray, boolean bl) {
        this.array = TArray;
        this.capacity = TArray.length;
        this.clearImpl(false);
        if (bl) {
            this.size = this.capacity;
        }
    }

    public final int capacity() {
        return this.capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear(boolean bl) {
        Object object = this.sync;
        synchronized (object) {
            this.clearImpl(bl);
        }
    }

    private final void clearImpl(boolean bl) {
        this.readPos = 0;
        this.writePos = 0;
        this.size = 0;
        if (bl) {
            for (int i = 0; i < this.capacity; ++i) {
                this.array[i] = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int size() {
        Object object = this.sync;
        synchronized (object) {
            return this.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getFreeSlots() {
        Object object = this.sync;
        synchronized (object) {
            return this.capacity - this.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isEmpty() {
        Object object = this.sync;
        synchronized (object) {
            return 0 == this.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isFull() {
        Object object = this.sync;
        synchronized (object) {
            return this.capacity == this.size;
        }
    }

    public final T get(boolean bl) {
        try {
            return this.getImpl(bl, false, false);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    public final T getBlocking(boolean bl) throws InterruptedException {
        return this.getImpl(bl, true, false);
    }

    public final T peek() throws InterruptedException {
        return this.getImpl(false, false, true);
    }

    public final T peekBlocking() throws InterruptedException {
        return this.getImpl(false, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final T getImpl(boolean bl, boolean bl2, boolean bl3) throws InterruptedException {
        Object object = this.sync;
        synchronized (object) {
            if (0 == this.size) {
                if (bl2) {
                    while (0 == this.size) {
                        this.sync.wait();
                    }
                } else {
                    return null;
                }
            }
            T t = this.array[this.readPos];
            if (!bl3) {
                if (bl) {
                    this.array[this.readPos] = null;
                }
                this.readPos = (this.readPos + 1) % this.capacity;
                --this.size;
                this.sync.notifyAll();
            }
            return t;
        }
    }

    public final boolean put(T t) {
        try {
            return this.putImpl(t, false, false);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    public final void putBlocking(T t) throws InterruptedException {
        if (!this.putImpl(t, false, true)) {
            throw new InternalError("Blocking put failed: " + this);
        }
    }

    public final boolean putSame(boolean bl) throws InterruptedException {
        return this.putImpl(null, true, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean putImpl(T t, boolean bl, boolean bl2) throws InterruptedException {
        Object object = this.sync;
        synchronized (object) {
            if (this.capacity <= this.size) {
                if (bl2) {
                    while (this.capacity <= this.size) {
                        this.sync.wait();
                    }
                } else {
                    return false;
                }
            }
            if (!bl) {
                this.array[this.writePos] = t;
            }
            this.writePos = (this.writePos + 1) % this.capacity;
            ++this.size;
            this.sync.notifyAll();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void waitForFreeSlots(int n) throws InterruptedException {
        Object object = this.sync;
        synchronized (object) {
            if (this.capacity - this.size < n) {
                while (this.capacity - this.size < n) {
                    System.err.println("XXXX AAA XXX");
                    this.sync.wait();
                }
            }
        }
    }
}

