/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import java.net.URL;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.WeakHashMap;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PMatrix;
import processing.core.PMatrix2D;
import processing.core.PMatrix3D;
import processing.core.PShape;
import processing.core.PVector;
import processing.opengl.FontTexture;
import processing.opengl.FrameBuffer;
import processing.opengl.LinePath;
import processing.opengl.PGL;
import processing.opengl.PGraphics2D;
import processing.opengl.PGraphics3D;
import processing.opengl.PShader;
import processing.opengl.Texture;

public class PGraphicsOpenGL
extends PGraphics {
    public static PGL pgl;
    protected static PGraphicsOpenGL pgPrimary;
    protected static PGraphicsOpenGL pgCurrent;
    protected WeakHashMap<PFont, FontTexture> fontMap = new WeakHashMap();
    static final String OPENGL_THREAD_ERROR = "Cannot run the OpenGL renderer outside the main thread, change your code\nso the drawing calls are all inside the main thread, \nor use the default renderer instead.";
    static final String BLEND_DRIVER_ERROR = "blendMode(%1$s) is not supported by this hardware (or driver)";
    static final String BLEND_RENDERER_ERROR = "blendMode(%1$s) is not supported by this renderer";
    static final String ALREADY_DRAWING_ERROR = "Already called beginDraw()";
    static final String NO_BEGIN_DRAW_ERROR = "Cannot call endDraw() before beginDraw()";
    static final String NESTED_DRAW_ERROR = "Already called drawing on another PGraphicsOpenGL object";
    static final String ALREADY_BEGAN_CONTOUR_ERROR = "Already called beginContour()";
    static final String NO_BEGIN_CONTOUR_ERROR = "Need to call beginContour() first";
    static final String UNSUPPORTED_SMOOTH_LEVEL_ERROR = "Smooth level %1$s is not available. Using %2$s instead";
    static final String UNSUPPORTED_SMOOTH_ERROR = "Smooth is not supported by this hardware (or driver)";
    static final String TOO_MANY_SMOOTH_CALLS_ERROR = "The smooth/noSmooth functions are being called too often.\nThis results in screen flickering, so they will be disabled\nfor the rest of the sketch's execution";
    static final String UNSUPPORTED_SHAPE_FORMAT_ERROR = "Unsupported shape format";
    static final String INVALID_FILTER_SHADER_ERROR = "Your shader needs to be of TEXTURE type to be used as a filter";
    static final String INVALID_PROCESSING_SHADER_ERROR = "The GLSL code doesn't seem to contain a valid shader to use in Processing";
    static final String WRONG_SHADER_TYPE_ERROR = "shader() called with a wrong shader";
    static final String UNKNOWN_SHADER_KIND_ERROR = "Unknown shader kind";
    static final String NO_TEXLIGHT_SHADER_ERROR = "Your shader needs to be of TEXLIGHT type to render this geometry properly, using default shader instead.";
    static final String NO_LIGHT_SHADER_ERROR = "Your shader needs to be of LIGHT type to render this geometry properly, using default shader instead.";
    static final String NO_TEXTURE_SHADER_ERROR = "Your shader needs to be of TEXTURE type to render this geometry properly, using default shader instead.";
    static final String NO_COLOR_SHADER_ERROR = "Your shader needs to be of COLOR type to render this geometry properly, using default shader instead.";
    static final String TOO_LONG_STROKE_PATH_ERROR = "Stroke path is too long, some bevel triangles won't be added";
    static final String TESSELLATION_ERROR = "Tessellation Error: %1$s";
    public boolean initialized;
    protected static final int FLUSH_CONTINUOUSLY = 0;
    protected static final int FLUSH_WHEN_FULL = 1;
    protected static final int IMMEDIATE = 0;
    protected static final int RETAINED = 1;
    protected int flushMode = 1;
    public int glPolyVertex;
    public int glPolyColor;
    public int glPolyNormal;
    public int glPolyTexcoord;
    public int glPolyAmbient;
    public int glPolySpecular;
    public int glPolyEmissive;
    public int glPolyShininess;
    public int glPolyIndex;
    protected boolean polyBuffersCreated = false;
    protected int polyBuffersContext;
    public int glLineVertex;
    public int glLineColor;
    public int glLineAttrib;
    public int glLineIndex;
    protected boolean lineBuffersCreated = false;
    protected int lineBuffersContext;
    public int glPointVertex;
    public int glPointColor;
    public int glPointAttrib;
    public int glPointIndex;
    protected boolean pointBuffersCreated = false;
    protected int pointBuffersContext;
    protected static final int INIT_VERTEX_BUFFER_SIZE = 256;
    protected static final int INIT_INDEX_BUFFER_SIZE = 512;
    protected static boolean glParamsRead;
    public static boolean npotTexSupported;
    public static boolean autoMipmapGenSupported;
    public static boolean fboMultisampleSupported;
    public static boolean packedDepthStencilSupported;
    public static boolean anisoSamplingSupported;
    public static boolean blendEqSupported;
    public static int maxTextureSize;
    public static int maxSamples;
    public static float maxPointSize;
    public static float maxLineWidth;
    public static float maxAnisoAmount;
    public static int depthBits;
    public static int stencilBits;
    public static String OPENGL_VENDOR;
    public static String OPENGL_RENDERER;
    public static String OPENGL_VERSION;
    public static String OPENGL_EXTENSIONS;
    public static String GLSL_VERSION;
    protected static HashMap<GLResource, Boolean> glTextureObjects;
    protected static HashMap<GLResource, Boolean> glVertexBuffers;
    protected static HashMap<GLResource, Boolean> glFrameBuffers;
    protected static HashMap<GLResource, Boolean> glRenderBuffers;
    protected static HashMap<GLResource, Boolean> glslPrograms;
    protected static HashMap<GLResource, Boolean> glslVertexShaders;
    protected static HashMap<GLResource, Boolean> glslFragmentShaders;
    protected static URL defColorShaderVertURL;
    protected static URL defTextureShaderVertURL;
    protected static URL defLightShaderVertURL;
    protected static URL defTexlightShaderVertURL;
    protected static URL defColorShaderFragURL;
    protected static URL defTextureShaderFragURL;
    protected static URL defLineShaderVertURL;
    protected static URL defLineShaderFragURL;
    protected static URL defPointShaderVertURL;
    protected static URL defPointShaderFragURL;
    protected static ColorShader defColorShader;
    protected static TextureShader defTextureShader;
    protected static LightShader defLightShader;
    protected static TexlightShader defTexlightShader;
    protected static LineShader defLineShader;
    protected static PointShader defPointShader;
    protected static URL maskShaderFragURL;
    protected static TextureShader maskShader;
    protected ColorShader colorShader;
    protected TextureShader textureShader;
    protected LightShader lightShader;
    protected TexlightShader texlightShader;
    protected LineShader lineShader;
    protected PointShader pointShader;
    protected boolean shaderWarningsEnabled = true;
    protected InGeometry inGeo;
    protected TessGeometry tessGeo;
    protected static Tessellator tessellator;
    protected TexCache texCache;
    public float cameraFOV;
    public float cameraX;
    public float cameraY;
    public float cameraZ;
    public float cameraNear;
    public float cameraFar;
    public float cameraAspect;
    protected float cameraEyeX;
    protected float cameraEyeY;
    protected float cameraEyeZ;
    protected boolean manipulatingCamera;
    public PMatrix3D projection;
    public PMatrix3D camera;
    public PMatrix3D cameraInv;
    public PMatrix3D modelview;
    public PMatrix3D modelviewInv;
    public PMatrix3D projmodelview;
    protected float[] glProjection;
    protected float[] glModelview;
    protected float[] glProjmodelview;
    protected float[] glNormal;
    protected static PMatrix3D identity;
    protected boolean matricesAllocated = false;
    protected boolean sized;
    protected static final int MATRIX_STACK_DEPTH = 32;
    protected int modelviewStackDepth;
    protected int projectionStackDepth;
    protected float[][] modelviewStack = new float[32][16];
    protected float[][] modelviewInvStack = new float[32][16];
    protected float[][] cameraStack = new float[32][16];
    protected float[][] cameraInvStack = new float[32][16];
    protected float[][] projectionStack = new float[32][16];
    public boolean lights;
    public int lightCount = 0;
    public int[] lightType;
    public float[] lightPosition;
    public float[] lightNormal;
    public float[] lightAmbient;
    public float[] lightDiffuse;
    public float[] lightSpecular;
    public float[] lightFalloffCoefficients;
    public float[] lightSpotParameters;
    public float[] currentLightSpecular;
    public float currentLightFalloffConstant;
    public float currentLightFalloffLinear;
    public float currentLightFalloffQuadratic;
    protected boolean lightsAllocated = false;
    protected int textureWrap = 0;
    protected int textureSampling = 5;
    protected boolean clip = false;
    protected int[] clipRect = new int[]{0, 0, 0, 0};
    FontTexture textTex;
    protected static final int FB_STACK_DEPTH = 16;
    protected static int fbStackDepth;
    protected static FrameBuffer[] fbStack;
    protected static FrameBuffer drawFramebuffer;
    protected static FrameBuffer readFramebuffer;
    protected static FrameBuffer currentFramebuffer;
    protected FrameBuffer offscreenFramebuffer;
    protected FrameBuffer multisampleFramebuffer;
    protected boolean offscreenMultisample;
    protected boolean pixOpChangedFB;
    protected Texture texture;
    protected Texture ptexture;
    protected IntBuffer pixelBuffer;
    protected int[] nativePixels;
    protected IntBuffer nativePixelBuffer;
    protected Texture filterTexture;
    protected PImage filterImage;
    protected boolean setgetPixels;
    protected boolean drawing = false;
    protected boolean restoreSurface = false;
    protected boolean smoothDisabled = false;
    protected int smoothCallCount = 0;
    protected int lastSmoothCall = -10;
    protected static final int OP_NONE = 0;
    protected static final int OP_READ = 1;
    protected static final int OP_WRITE = 2;
    protected int pixelsOp = 0;
    protected IntBuffer viewport;
    protected boolean clearColorBuffer;
    protected boolean clearColorBuffer0;
    protected boolean openContour = false;
    protected boolean breakShape = false;
    protected boolean defaultEdges = false;
    protected PImage textureImage0;
    protected static final int EDGE_MIDDLE = 0;
    protected static final int EDGE_START = 1;
    protected static final int EDGE_STOP = 2;
    protected static final int EDGE_SINGLE = 3;
    protected static final int EDGE_CLOSE = -1;
    protected static final int MIN_POINT_ACCURACY = 20;
    protected static final float POINT_ACCURACY_FACTOR = 10.0f;
    protected final float[][] QUAD_POINT_SIGNS = new float[][]{{-1.0f, 1.0f}, {-1.0f, -1.0f}, {1.0f, -1.0f}, {1.0f, 1.0f}};
    protected static IntBuffer intBuffer;
    protected static FloatBuffer floatBuffer;

    public PGraphicsOpenGL() {
        if (pgl == null) {
            pgl = new PGL(this);
        }
        if (tessellator == null) {
            tessellator = new Tessellator();
        }
        if (intBuffer == null) {
            intBuffer = PGL.allocateIntBuffer(2);
            floatBuffer = PGL.allocateFloatBuffer(2);
        }
        this.viewport = PGL.allocateIntBuffer(4);
        this.inGeo = this.newInGeometry(0);
        this.tessGeo = this.newTessGeometry(0);
        this.texCache = this.newTexCache();
        this.initialized = false;
    }

    @Override
    public void setPrimary(boolean primary) {
        super.setPrimary(primary);
        this.format = 2;
    }

    @Override
    public void setFrameRate(float frameRate) {
        pgl.setFps(frameRate);
    }

    @Override
    public void setSize(int iwidth, int iheight) {
        this.width = iwidth;
        this.height = iheight;
        this.allocate();
        this.reapplySettings();
        this.cameraFOV = 1.0471976f;
        this.cameraX = (float)this.width / 2.0f;
        this.cameraY = (float)this.height / 2.0f;
        this.cameraZ = this.cameraY / (float)Math.tan(this.cameraFOV / 2.0f);
        this.cameraNear = this.cameraZ / 10.0f;
        this.cameraFar = this.cameraZ * 10.0f;
        this.cameraAspect = (float)this.width / (float)this.height;
        this.restartPGL();
        this.sized = true;
    }

    @Override
    protected void allocate() {
        super.allocate();
        if (!this.matricesAllocated) {
            this.projection = new PMatrix3D();
            this.camera = new PMatrix3D();
            this.cameraInv = new PMatrix3D();
            this.modelview = new PMatrix3D();
            this.modelviewInv = new PMatrix3D();
            this.projmodelview = new PMatrix3D();
            this.matricesAllocated = true;
        }
        if (!this.lightsAllocated) {
            this.lightType = new int[8];
            this.lightPosition = new float[32];
            this.lightNormal = new float[24];
            this.lightAmbient = new float[24];
            this.lightDiffuse = new float[24];
            this.lightSpecular = new float[24];
            this.lightFalloffCoefficients = new float[24];
            this.lightSpotParameters = new float[16];
            this.currentLightSpecular = new float[3];
            this.lightsAllocated = true;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        pgl.swapBuffers();
        this.deletePolyBuffers();
        this.deleteLineBuffers();
        this.deletePointBuffers();
        this.deleteSurfaceTextures();
        if (this.primarySurface) {
            this.deleteDefaultShaders();
        } else {
            if (this.offscreenFramebuffer != null) {
                this.offscreenFramebuffer.dispose();
            }
            if (this.multisampleFramebuffer != null) {
                this.multisampleFramebuffer.dispose();
            }
        }
        PGraphicsOpenGL.deleteFinalizedGLResources();
        if (this.primarySurface) {
            pgl.deleteSurface();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.deletePolyBuffers();
            this.deleteLineBuffers();
            this.deletePointBuffers();
            this.deleteSurfaceTextures();
            if (!this.primarySurface) {
                if (this.offscreenFramebuffer != null) {
                    this.offscreenFramebuffer.dispose();
                    this.offscreenFramebuffer = null;
                }
                if (this.multisampleFramebuffer != null) {
                    this.multisampleFramebuffer.dispose();
                    this.multisampleFramebuffer = null;
                }
            }
        }
        finally {
            super.finalize();
        }
    }

    protected void setFlushMode(int mode) {
        this.flushMode = mode;
    }

    protected void setFontTexture(PFont font, FontTexture fontTexture) {
        this.fontMap.put(font, fontTexture);
    }

    protected FontTexture getFontTexture(PFont font) {
        return this.fontMap.get(font);
    }

    protected void removeFontTexture(PFont font) {
        this.fontMap.remove(font);
    }

    protected static int createTextureObject(int context) {
        PGraphicsOpenGL.deleteFinalizedTextureObjects();
        pgl.genTextures(1, intBuffer);
        int id = intBuffer.get(0);
        GLResource res = new GLResource(id, context);
        if (!glTextureObjects.containsKey(res)) {
            glTextureObjects.put(res, false);
        }
        return id;
    }

    protected static void deleteTextureObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glTextureObjects.containsKey(res)) {
            intBuffer.put(0, id);
            if (pgl.threadIsCurrent()) {
                pgl.deleteTextures(1, intBuffer);
            }
            glTextureObjects.remove(res);
        }
    }

    protected static void deleteAllTextureObjects() {
        for (GLResource res : glTextureObjects.keySet()) {
            intBuffer.put(0, res.id);
            if (!pgl.threadIsCurrent()) continue;
            pgl.deleteTextures(1, intBuffer);
        }
        glTextureObjects.clear();
    }

    protected static synchronized void finalizeTextureObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glTextureObjects.containsKey(res)) {
            glTextureObjects.put(res, true);
        }
    }

    protected static void deleteFinalizedTextureObjects() {
        HashSet<GLResource> finalized = new HashSet<GLResource>();
        for (GLResource res : glTextureObjects.keySet()) {
            if (!glTextureObjects.get(res).booleanValue()) continue;
            finalized.add(res);
            intBuffer.put(0, res.id);
            if (!pgl.threadIsCurrent()) continue;
            pgl.deleteTextures(1, intBuffer);
        }
        for (GLResource res : finalized) {
            glTextureObjects.remove(res);
        }
    }

    protected static void removeTextureObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glTextureObjects.containsKey(res)) {
            glTextureObjects.remove(res);
        }
    }

    protected static int createVertexBufferObject(int context) {
        PGraphicsOpenGL.deleteFinalizedVertexBufferObjects();
        pgl.genBuffers(1, intBuffer);
        int id = intBuffer.get(0);
        GLResource res = new GLResource(id, context);
        if (!glVertexBuffers.containsKey(res)) {
            glVertexBuffers.put(res, false);
        }
        return id;
    }

    protected static void deleteVertexBufferObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glVertexBuffers.containsKey(res)) {
            intBuffer.put(0, id);
            if (pgl.threadIsCurrent()) {
                pgl.deleteBuffers(1, intBuffer);
            }
            glVertexBuffers.remove(res);
        }
    }

    protected static void deleteAllVertexBufferObjects() {
        for (GLResource res : glVertexBuffers.keySet()) {
            intBuffer.put(0, res.id);
            if (!pgl.threadIsCurrent()) continue;
            pgl.deleteBuffers(1, intBuffer);
        }
        glVertexBuffers.clear();
    }

    protected static synchronized void finalizeVertexBufferObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glVertexBuffers.containsKey(res)) {
            glVertexBuffers.put(res, true);
        }
    }

    protected static void deleteFinalizedVertexBufferObjects() {
        HashSet<GLResource> finalized = new HashSet<GLResource>();
        for (GLResource res : glVertexBuffers.keySet()) {
            if (!glVertexBuffers.get(res).booleanValue()) continue;
            finalized.add(res);
            intBuffer.put(0, res.id);
            if (!pgl.threadIsCurrent()) continue;
            pgl.deleteBuffers(1, intBuffer);
        }
        for (GLResource res : finalized) {
            glVertexBuffers.remove(res);
        }
    }

    protected static void removeVertexBufferObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glVertexBuffers.containsKey(res)) {
            glVertexBuffers.remove(res);
        }
    }

    protected static int createFrameBufferObject(int context) {
        PGraphicsOpenGL.deleteFinalizedFrameBufferObjects();
        pgl.genFramebuffers(1, intBuffer);
        int id = intBuffer.get(0);
        GLResource res = new GLResource(id, context);
        if (!glFrameBuffers.containsKey(res)) {
            glFrameBuffers.put(res, false);
        }
        return id;
    }

    protected static void deleteFrameBufferObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glFrameBuffers.containsKey(res)) {
            intBuffer.put(0, id);
            if (pgl.threadIsCurrent()) {
                pgl.deleteFramebuffers(1, intBuffer);
            }
            glFrameBuffers.remove(res);
        }
    }

    protected static void deleteAllFrameBufferObjects() {
        for (GLResource res : glFrameBuffers.keySet()) {
            intBuffer.put(0, res.id);
            if (!pgl.threadIsCurrent()) continue;
            pgl.deleteFramebuffers(1, intBuffer);
        }
        glFrameBuffers.clear();
    }

    protected static synchronized void finalizeFrameBufferObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glFrameBuffers.containsKey(res)) {
            glFrameBuffers.put(res, true);
        }
    }

    protected static void deleteFinalizedFrameBufferObjects() {
        HashSet<GLResource> finalized = new HashSet<GLResource>();
        for (GLResource res : glFrameBuffers.keySet()) {
            if (!glFrameBuffers.get(res).booleanValue()) continue;
            finalized.add(res);
            intBuffer.put(0, res.id);
            if (!pgl.threadIsCurrent()) continue;
            pgl.deleteFramebuffers(1, intBuffer);
        }
        for (GLResource res : finalized) {
            glFrameBuffers.remove(res);
        }
    }

    protected static void removeFrameBufferObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glFrameBuffers.containsKey(res)) {
            glFrameBuffers.remove(res);
        }
    }

    protected static int createRenderBufferObject(int context) {
        PGraphicsOpenGL.deleteFinalizedRenderBufferObjects();
        pgl.genRenderbuffers(1, intBuffer);
        int id = intBuffer.get(0);
        GLResource res = new GLResource(id, context);
        if (!glRenderBuffers.containsKey(res)) {
            glRenderBuffers.put(res, false);
        }
        return id;
    }

    protected static void deleteRenderBufferObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glRenderBuffers.containsKey(res)) {
            intBuffer.put(0, id);
            if (pgl.threadIsCurrent()) {
                pgl.deleteRenderbuffers(1, intBuffer);
            }
            glRenderBuffers.remove(res);
        }
    }

    protected static void deleteAllRenderBufferObjects() {
        for (GLResource res : glRenderBuffers.keySet()) {
            intBuffer.put(0, res.id);
            if (!pgl.threadIsCurrent()) continue;
            pgl.deleteRenderbuffers(1, intBuffer);
        }
        glRenderBuffers.clear();
    }

    protected static synchronized void finalizeRenderBufferObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glRenderBuffers.containsKey(res)) {
            glRenderBuffers.put(res, true);
        }
    }

    protected static void deleteFinalizedRenderBufferObjects() {
        HashSet<GLResource> finalized = new HashSet<GLResource>();
        for (GLResource res : glRenderBuffers.keySet()) {
            if (!glRenderBuffers.get(res).booleanValue()) continue;
            finalized.add(res);
            intBuffer.put(0, res.id);
            if (!pgl.threadIsCurrent()) continue;
            pgl.deleteRenderbuffers(1, intBuffer);
        }
        for (GLResource res : finalized) {
            glRenderBuffers.remove(res);
        }
    }

    protected static void removeRenderBufferObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glRenderBuffers.containsKey(res)) {
            glRenderBuffers.remove(res);
        }
    }

    protected static int createGLSLProgramObject(int context) {
        PGraphicsOpenGL.deleteFinalizedGLSLProgramObjects();
        int id = pgl.createProgram();
        GLResource res = new GLResource(id, context);
        if (!glslPrograms.containsKey(res)) {
            glslPrograms.put(res, false);
        }
        return id;
    }

    protected static void deleteGLSLProgramObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glslPrograms.containsKey(res)) {
            if (pgl.threadIsCurrent()) {
                pgl.deleteProgram(res.id);
            }
            glslPrograms.remove(res);
        }
    }

    protected static void deleteAllGLSLProgramObjects() {
        for (GLResource res : glslPrograms.keySet()) {
            if (!pgl.threadIsCurrent()) continue;
            pgl.deleteProgram(res.id);
        }
        glslPrograms.clear();
    }

    protected static synchronized void finalizeGLSLProgramObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glslPrograms.containsKey(res)) {
            glslPrograms.put(res, true);
        }
    }

    protected static void deleteFinalizedGLSLProgramObjects() {
        HashSet<GLResource> finalized = new HashSet<GLResource>();
        for (GLResource res : glslPrograms.keySet()) {
            if (!glslPrograms.get(res).booleanValue()) continue;
            finalized.add(res);
            if (!pgl.threadIsCurrent()) continue;
            pgl.deleteProgram(res.id);
        }
        for (GLResource res : finalized) {
            glslPrograms.remove(res);
        }
    }

    protected static void removeGLSLProgramObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glslPrograms.containsKey(res)) {
            glslPrograms.remove(res);
        }
    }

    protected static int createGLSLVertShaderObject(int context) {
        PGraphicsOpenGL.deleteFinalizedGLSLVertShaderObjects();
        int id = pgl.createShader(35633);
        GLResource res = new GLResource(id, context);
        if (!glslVertexShaders.containsKey(res)) {
            glslVertexShaders.put(res, false);
        }
        return id;
    }

    protected static void deleteGLSLVertShaderObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glslVertexShaders.containsKey(res)) {
            if (pgl.threadIsCurrent()) {
                pgl.deleteShader(res.id);
            }
            glslVertexShaders.remove(res);
        }
    }

    protected static void deleteAllGLSLVertShaderObjects() {
        for (GLResource res : glslVertexShaders.keySet()) {
            if (!pgl.threadIsCurrent()) continue;
            pgl.deleteShader(res.id);
        }
        glslVertexShaders.clear();
    }

    protected static synchronized void finalizeGLSLVertShaderObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glslVertexShaders.containsKey(res)) {
            glslVertexShaders.put(res, true);
        }
    }

    protected static void deleteFinalizedGLSLVertShaderObjects() {
        HashSet<GLResource> finalized = new HashSet<GLResource>();
        for (GLResource res : glslVertexShaders.keySet()) {
            if (!glslVertexShaders.get(res).booleanValue()) continue;
            finalized.add(res);
            if (!pgl.threadIsCurrent()) continue;
            pgl.deleteShader(res.id);
        }
        for (GLResource res : finalized) {
            glslVertexShaders.remove(res);
        }
    }

    protected static void removeGLSLVertShaderObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glslVertexShaders.containsKey(res)) {
            glslVertexShaders.remove(res);
        }
    }

    protected static int createGLSLFragShaderObject(int context) {
        PGraphicsOpenGL.deleteFinalizedGLSLFragShaderObjects();
        int id = pgl.createShader(35632);
        GLResource res = new GLResource(id, context);
        if (!glslFragmentShaders.containsKey(res)) {
            glslFragmentShaders.put(res, false);
        }
        return id;
    }

    protected static void deleteGLSLFragShaderObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glslFragmentShaders.containsKey(res)) {
            if (pgl.threadIsCurrent()) {
                pgl.deleteShader(res.id);
            }
            glslFragmentShaders.remove(res);
        }
    }

    protected static void deleteAllGLSLFragShaderObjects() {
        for (GLResource res : glslFragmentShaders.keySet()) {
            if (!pgl.threadIsCurrent()) continue;
            pgl.deleteShader(res.id);
        }
        glslFragmentShaders.clear();
    }

    protected static synchronized void finalizeGLSLFragShaderObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glslFragmentShaders.containsKey(res)) {
            glslFragmentShaders.put(res, true);
        }
    }

    protected static void deleteFinalizedGLSLFragShaderObjects() {
        HashSet<GLResource> finalized = new HashSet<GLResource>();
        for (GLResource res : glslFragmentShaders.keySet()) {
            if (!glslFragmentShaders.get(res).booleanValue()) continue;
            finalized.add(res);
            if (!pgl.threadIsCurrent()) continue;
            pgl.deleteShader(res.id);
        }
        for (GLResource res : finalized) {
            glslFragmentShaders.remove(res);
        }
    }

    protected static void removeGLSLFragShaderObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glslFragmentShaders.containsKey(res)) {
            glslFragmentShaders.remove(res);
        }
    }

    protected static void deleteFinalizedGLResources() {
        PGraphicsOpenGL.deleteFinalizedTextureObjects();
        PGraphicsOpenGL.deleteFinalizedVertexBufferObjects();
        PGraphicsOpenGL.deleteFinalizedFrameBufferObjects();
        PGraphicsOpenGL.deleteFinalizedRenderBufferObjects();
        PGraphicsOpenGL.deleteFinalizedGLSLProgramObjects();
        PGraphicsOpenGL.deleteFinalizedGLSLVertShaderObjects();
        PGraphicsOpenGL.deleteFinalizedGLSLFragShaderObjects();
    }

    protected static void pushFramebuffer() {
        if (fbStackDepth == 16) {
            throw new RuntimeException("Too many pushFramebuffer calls");
        }
        PGraphicsOpenGL.fbStack[PGraphicsOpenGL.fbStackDepth] = currentFramebuffer;
        ++fbStackDepth;
    }

    protected static void setFramebuffer(FrameBuffer fbo) {
        if (currentFramebuffer != fbo) {
            currentFramebuffer = fbo;
            currentFramebuffer.bind();
        }
    }

    protected static void popFramebuffer() {
        FrameBuffer fbo;
        if (fbStackDepth == 0) {
            throw new RuntimeException("popFramebuffer call is unbalanced.");
        }
        if (currentFramebuffer != (fbo = fbStack[--fbStackDepth])) {
            currentFramebuffer.finish(pgPrimary);
            currentFramebuffer = fbo;
            currentFramebuffer.bind();
        }
    }

    protected void createPolyBuffers() {
        if (!this.polyBuffersCreated || this.polyBuffersContextIsOutdated()) {
            this.polyBuffersContext = pgl.getCurrentContext();
            int sizef = 1024;
            int sizei = 1024;
            int sizex = 1024;
            this.glPolyVertex = PGraphicsOpenGL.createVertexBufferObject(this.polyBuffersContext);
            pgl.bindBuffer(34962, this.glPolyVertex);
            pgl.bufferData(34962, 3 * sizef, null, 35044);
            this.glPolyColor = PGraphicsOpenGL.createVertexBufferObject(this.polyBuffersContext);
            pgl.bindBuffer(34962, this.glPolyColor);
            pgl.bufferData(34962, sizei, null, 35044);
            this.glPolyNormal = PGraphicsOpenGL.createVertexBufferObject(this.polyBuffersContext);
            pgl.bindBuffer(34962, this.glPolyNormal);
            pgl.bufferData(34962, 3 * sizef, null, 35044);
            this.glPolyTexcoord = PGraphicsOpenGL.createVertexBufferObject(this.polyBuffersContext);
            pgl.bindBuffer(34962, this.glPolyTexcoord);
            pgl.bufferData(34962, 2 * sizef, null, 35044);
            this.glPolyAmbient = PGraphicsOpenGL.createVertexBufferObject(this.polyBuffersContext);
            pgl.bindBuffer(34962, this.glPolyAmbient);
            pgl.bufferData(34962, sizei, null, 35044);
            this.glPolySpecular = PGraphicsOpenGL.createVertexBufferObject(this.polyBuffersContext);
            pgl.bindBuffer(34962, this.glPolySpecular);
            pgl.bufferData(34962, sizei, null, 35044);
            this.glPolyEmissive = PGraphicsOpenGL.createVertexBufferObject(this.polyBuffersContext);
            pgl.bindBuffer(34962, this.glPolyEmissive);
            pgl.bufferData(34962, sizei, null, 35044);
            this.glPolyShininess = PGraphicsOpenGL.createVertexBufferObject(this.polyBuffersContext);
            pgl.bindBuffer(34962, this.glPolyShininess);
            pgl.bufferData(34962, sizef, null, 35044);
            pgl.bindBuffer(34962, 0);
            this.glPolyIndex = PGraphicsOpenGL.createVertexBufferObject(this.polyBuffersContext);
            pgl.bindBuffer(34963, this.glPolyIndex);
            pgl.bufferData(34963, sizex, null, 35044);
            pgl.bindBuffer(34963, 0);
            this.polyBuffersCreated = true;
        }
    }

    protected void updatePolyBuffers(boolean lit, boolean tex) {
        this.createPolyBuffers();
        int size = this.tessGeo.polyVertexCount;
        int sizef = size * 4;
        int sizei = size * 4;
        this.tessGeo.updatePolyVerticesBuffer();
        pgl.bindBuffer(34962, this.glPolyVertex);
        pgl.bufferData(34962, 4 * sizef, this.tessGeo.polyVerticesBuffer, 35044);
        this.tessGeo.updatePolyColorsBuffer();
        pgl.bindBuffer(34962, this.glPolyColor);
        pgl.bufferData(34962, sizei, this.tessGeo.polyColorsBuffer, 35044);
        if (lit) {
            this.tessGeo.updatePolyNormalsBuffer();
            pgl.bindBuffer(34962, this.glPolyNormal);
            pgl.bufferData(34962, 3 * sizef, this.tessGeo.polyNormalsBuffer, 35044);
            this.tessGeo.updatePolyAmbientBuffer();
            pgl.bindBuffer(34962, this.glPolyAmbient);
            pgl.bufferData(34962, sizei, this.tessGeo.polyAmbientBuffer, 35044);
            this.tessGeo.updatePolySpecularBuffer();
            pgl.bindBuffer(34962, this.glPolySpecular);
            pgl.bufferData(34962, sizei, this.tessGeo.polySpecularBuffer, 35044);
            this.tessGeo.updatePolyEmissiveBuffer();
            pgl.bindBuffer(34962, this.glPolyEmissive);
            pgl.bufferData(34962, sizei, this.tessGeo.polyEmissiveBuffer, 35044);
            this.tessGeo.updatePolyShininessBuffer();
            pgl.bindBuffer(34962, this.glPolyShininess);
            pgl.bufferData(34962, sizef, this.tessGeo.polyShininessBuffer, 35044);
        }
        if (tex) {
            this.tessGeo.updatePolyTexCoordsBuffer();
            pgl.bindBuffer(34962, this.glPolyTexcoord);
            pgl.bufferData(34962, 2 * sizef, this.tessGeo.polyTexCoordsBuffer, 35044);
        }
        this.tessGeo.updatePolyIndicesBuffer();
        pgl.bindBuffer(34963, this.glPolyIndex);
        pgl.bufferData(34963, this.tessGeo.polyIndexCount * 2, this.tessGeo.polyIndicesBuffer, 35044);
    }

    protected void unbindPolyBuffers() {
        pgl.bindBuffer(34962, 0);
        pgl.bindBuffer(34963, 0);
    }

    protected boolean polyBuffersContextIsOutdated() {
        return !pgl.contextIsCurrent(this.polyBuffersContext);
    }

    protected void deletePolyBuffers() {
        if (this.polyBuffersCreated) {
            PGraphicsOpenGL.deleteVertexBufferObject(this.glPolyVertex, this.polyBuffersContext);
            this.glPolyVertex = 0;
            PGraphicsOpenGL.deleteVertexBufferObject(this.glPolyColor, this.polyBuffersContext);
            this.glPolyColor = 0;
            PGraphicsOpenGL.deleteVertexBufferObject(this.glPolyNormal, this.polyBuffersContext);
            this.glPolyNormal = 0;
            PGraphicsOpenGL.deleteVertexBufferObject(this.glPolyTexcoord, this.polyBuffersContext);
            this.glPolyTexcoord = 0;
            PGraphicsOpenGL.deleteVertexBufferObject(this.glPolyAmbient, this.polyBuffersContext);
            this.glPolyAmbient = 0;
            PGraphicsOpenGL.deleteVertexBufferObject(this.glPolySpecular, this.polyBuffersContext);
            this.glPolySpecular = 0;
            PGraphicsOpenGL.deleteVertexBufferObject(this.glPolyEmissive, this.polyBuffersContext);
            this.glPolyEmissive = 0;
            PGraphicsOpenGL.deleteVertexBufferObject(this.glPolyShininess, this.polyBuffersContext);
            this.glPolyShininess = 0;
            PGraphicsOpenGL.deleteVertexBufferObject(this.glPolyIndex, this.polyBuffersContext);
            this.glPolyIndex = 0;
            this.polyBuffersCreated = false;
        }
    }

    protected void createLineBuffers() {
        if (!this.lineBuffersCreated || this.lineBufferContextIsOutdated()) {
            this.lineBuffersContext = pgl.getCurrentContext();
            int sizef = 1024;
            int sizei = 1024;
            int sizex = 1024;
            this.glLineVertex = PGraphicsOpenGL.createVertexBufferObject(this.lineBuffersContext);
            pgl.bindBuffer(34962, this.glLineVertex);
            pgl.bufferData(34962, 3 * sizef, null, 35044);
            this.glLineColor = PGraphicsOpenGL.createVertexBufferObject(this.lineBuffersContext);
            pgl.bindBuffer(34962, this.glLineColor);
            pgl.bufferData(34962, sizei, null, 35044);
            this.glLineAttrib = PGraphicsOpenGL.createVertexBufferObject(this.lineBuffersContext);
            pgl.bindBuffer(34962, this.glLineAttrib);
            pgl.bufferData(34962, 4 * sizef, null, 35044);
            pgl.bindBuffer(34962, 0);
            this.glLineIndex = PGraphicsOpenGL.createVertexBufferObject(this.lineBuffersContext);
            pgl.bindBuffer(34963, this.glLineIndex);
            pgl.bufferData(34963, sizex, null, 35044);
            pgl.bindBuffer(34963, 0);
            this.lineBuffersCreated = true;
        }
    }

    protected void updateLineBuffers() {
        this.createLineBuffers();
        int size = this.tessGeo.lineVertexCount;
        int sizef = size * 4;
        int sizei = size * 4;
        this.tessGeo.updateLineVerticesBuffer();
        pgl.bindBuffer(34962, this.glLineVertex);
        pgl.bufferData(34962, 4 * sizef, this.tessGeo.lineVerticesBuffer, 35044);
        this.tessGeo.updateLineColorsBuffer();
        pgl.bindBuffer(34962, this.glLineColor);
        pgl.bufferData(34962, sizei, this.tessGeo.lineColorsBuffer, 35044);
        this.tessGeo.updateLineDirectionsBuffer();
        pgl.bindBuffer(34962, this.glLineAttrib);
        pgl.bufferData(34962, 4 * sizef, this.tessGeo.lineDirectionsBuffer, 35044);
        this.tessGeo.updateLineIndicesBuffer();
        pgl.bindBuffer(34963, this.glLineIndex);
        pgl.bufferData(34963, this.tessGeo.lineIndexCount * 2, this.tessGeo.lineIndicesBuffer, 35044);
    }

    protected void unbindLineBuffers() {
        pgl.bindBuffer(34962, 0);
        pgl.bindBuffer(34963, 0);
    }

    protected boolean lineBufferContextIsOutdated() {
        return !pgl.contextIsCurrent(this.lineBuffersContext);
    }

    protected void deleteLineBuffers() {
        if (this.lineBuffersCreated) {
            PGraphicsOpenGL.deleteVertexBufferObject(this.glLineVertex, this.lineBuffersContext);
            this.glLineVertex = 0;
            PGraphicsOpenGL.deleteVertexBufferObject(this.glLineColor, this.lineBuffersContext);
            this.glLineColor = 0;
            PGraphicsOpenGL.deleteVertexBufferObject(this.glLineAttrib, this.lineBuffersContext);
            this.glLineAttrib = 0;
            PGraphicsOpenGL.deleteVertexBufferObject(this.glLineIndex, this.lineBuffersContext);
            this.glLineIndex = 0;
            this.lineBuffersCreated = false;
        }
    }

    protected void createPointBuffers() {
        if (!this.pointBuffersCreated || this.pointBuffersContextIsOutdated()) {
            this.pointBuffersContext = pgl.getCurrentContext();
            int sizef = 1024;
            int sizei = 1024;
            int sizex = 1024;
            this.glPointVertex = PGraphicsOpenGL.createVertexBufferObject(this.pointBuffersContext);
            pgl.bindBuffer(34962, this.glPointVertex);
            pgl.bufferData(34962, 3 * sizef, null, 35044);
            this.glPointColor = PGraphicsOpenGL.createVertexBufferObject(this.pointBuffersContext);
            pgl.bindBuffer(34962, this.glPointColor);
            pgl.bufferData(34962, sizei, null, 35044);
            this.glPointAttrib = PGraphicsOpenGL.createVertexBufferObject(this.pointBuffersContext);
            pgl.bindBuffer(34962, this.glPointAttrib);
            pgl.bufferData(34962, 2 * sizef, null, 35044);
            pgl.bindBuffer(34962, 0);
            this.glPointIndex = PGraphicsOpenGL.createVertexBufferObject(this.pointBuffersContext);
            pgl.bindBuffer(34963, this.glPointIndex);
            pgl.bufferData(34963, sizex, null, 35044);
            pgl.bindBuffer(34963, 0);
            this.pointBuffersCreated = true;
        }
    }

    protected void updatePointBuffers() {
        this.createPointBuffers();
        int size = this.tessGeo.pointVertexCount;
        int sizef = size * 4;
        int sizei = size * 4;
        this.tessGeo.updatePointVerticesBuffer();
        pgl.bindBuffer(34962, this.glPointVertex);
        pgl.bufferData(34962, 4 * sizef, this.tessGeo.pointVerticesBuffer, 35044);
        this.tessGeo.updatePointColorsBuffer();
        pgl.bindBuffer(34962, this.glPointColor);
        pgl.bufferData(34962, sizei, this.tessGeo.pointColorsBuffer, 35044);
        this.tessGeo.updatePointOffsetsBuffer();
        pgl.bindBuffer(34962, this.glPointAttrib);
        pgl.bufferData(34962, 2 * sizef, this.tessGeo.pointOffsetsBuffer, 35044);
        this.tessGeo.updatePointIndicesBuffer();
        pgl.bindBuffer(34963, this.glPointIndex);
        pgl.bufferData(34963, this.tessGeo.pointIndexCount * 2, this.tessGeo.pointIndicesBuffer, 35044);
    }

    protected void unbindPointBuffers() {
        pgl.bindBuffer(34962, 0);
        pgl.bindBuffer(34963, 0);
    }

    protected boolean pointBuffersContextIsOutdated() {
        return !pgl.contextIsCurrent(this.pointBuffersContext);
    }

    protected void deletePointBuffers() {
        if (this.pointBuffersCreated) {
            PGraphicsOpenGL.deleteVertexBufferObject(this.glPointVertex, this.pointBuffersContext);
            this.glPointVertex = 0;
            PGraphicsOpenGL.deleteVertexBufferObject(this.glPointColor, this.pointBuffersContext);
            this.glPointColor = 0;
            PGraphicsOpenGL.deleteVertexBufferObject(this.glPointAttrib, this.pointBuffersContext);
            this.glPointAttrib = 0;
            PGraphicsOpenGL.deleteVertexBufferObject(this.glPointIndex, this.pointBuffersContext);
            this.glPointIndex = 0;
            this.pointBuffersCreated = false;
        }
    }

    @Override
    public void requestFocus() {
    }

    @Override
    public boolean canDraw() {
        return pgl.canDraw();
    }

    @Override
    public void requestDraw() {
        if (this.primarySurface) {
            if (this.initialized) {
                pgl.requestDraw();
            } else {
                this.initPrimary();
            }
        }
    }

    @Override
    public void beginDraw() {
        this.report("top beginDraw()");
        if (!this.checkGLThread()) {
            return;
        }
        if (this.drawing) {
            PGraphics.showWarning(ALREADY_DRAWING_ERROR);
            return;
        }
        if (pgCurrent != null && !PGraphicsOpenGL.pgCurrent.primarySurface && !this.primarySurface) {
            PGraphics.showWarning(NESTED_DRAW_ERROR);
            return;
        }
        if (!this.primarySurface && PGraphicsOpenGL.pgPrimary.texCache.containsTexture(this)) {
            pgPrimary.flush();
        }
        if (!glParamsRead) {
            this.getGLParameters();
        }
        this.setViewport();
        if (this.primarySurface) {
            this.beginOnscreenDraw();
        } else {
            this.beginOffscreenDraw();
        }
        this.setDrawDefaults();
        pgCurrent = this;
        this.drawing = true;
        this.report("bot beginDraw()");
    }

    @Override
    public void endDraw() {
        this.report("top endDraw()");
        if (!this.drawing) {
            PGraphics.showWarning(NO_BEGIN_DRAW_ERROR);
            return;
        }
        this.flush();
        if (!PGraphicsOpenGL.pgPrimary.initialized || this.parent.frameCount == 0) {
            this.saveSurfaceToPixels();
            this.restoreSurface = true;
        }
        if (this.primarySurface) {
            this.endOnscreenDraw();
        } else {
            this.endOffscreenDraw();
        }
        pgCurrent = pgCurrent == pgPrimary ? null : pgPrimary;
        this.drawing = false;
        this.report("bot endDraw()");
    }

    @Override
    public PGL beginPGL() {
        this.flush();
        pgl.beginGL();
        return pgl;
    }

    @Override
    public void endPGL() {
        pgl.endGL();
        this.restoreGL();
    }

    public void updateProjmodelview() {
        this.projmodelview.set(this.projection);
        this.projmodelview.apply(this.modelview);
    }

    protected void restartPGL() {
        this.initialized = false;
    }

    protected void restoreGL() {
        this.blendMode(this.blendMode);
        if (this.hints[2]) {
            pgl.disable(2929);
        } else {
            pgl.enable(2929);
        }
        pgl.depthFunc(515);
        if (this.quality < 2) {
            pgl.disable(32925);
        } else {
            pgl.enable(32925);
            pgl.disable(2832);
            pgl.disable(2848);
            pgl.disable(2881);
        }
        pgl.viewport(this.viewport.get(0), this.viewport.get(1), this.viewport.get(2), this.viewport.get(3));
        if (this.clip) {
            pgl.enable(3089);
            pgl.scissor(this.clipRect[0], this.clipRect[1], this.clipRect[2], this.clipRect[3]);
        } else {
            pgl.disable(3089);
        }
        pgl.frontFace(2304);
        pgl.disable(2884);
        pgl.activeTexture(33984);
        if (this.hints[5]) {
            pgl.depthMask(false);
        } else {
            pgl.depthMask(true);
        }
        currentFramebuffer.bind();
        pgl.drawBuffer(currentFramebuffer.getDefaultDrawBuffer());
    }

    protected void beginPixelsOp(int op) {
        FrameBuffer pixfb = null;
        if (this.primarySurface) {
            if (op == 1) {
                if (pgl.isFBOBacked() && pgl.isMultisampled()) {
                    pgl.syncBackTexture();
                    pixfb = readFramebuffer;
                } else {
                    pixfb = drawFramebuffer;
                }
            } else if (op == 2) {
                pixfb = drawFramebuffer;
            }
        } else if (op == 1) {
            if (this.offscreenMultisample) {
                this.multisampleFramebuffer.copy(this.offscreenFramebuffer, currentFramebuffer);
            }
            pixfb = this.offscreenFramebuffer;
        } else if (op == 2) {
            FrameBuffer frameBuffer = pixfb = this.offscreenMultisample ? this.multisampleFramebuffer : this.offscreenFramebuffer;
        }
        if (pixfb != currentFramebuffer) {
            PGraphicsOpenGL.pushFramebuffer();
            PGraphicsOpenGL.setFramebuffer(pixfb);
            this.pixOpChangedFB = true;
        }
        if (op == 1) {
            pgl.readBuffer(currentFramebuffer.getDefaultDrawBuffer());
        } else if (op == 2) {
            pgl.drawBuffer(currentFramebuffer.getDefaultDrawBuffer());
        }
        this.pixelsOp = op;
    }

    protected void endPixelsOp() {
        if (this.pixOpChangedFB) {
            PGraphicsOpenGL.popFramebuffer();
            this.pixOpChangedFB = false;
        }
        pgl.readBuffer(currentFramebuffer.getDefaultReadBuffer());
        pgl.drawBuffer(currentFramebuffer.getDefaultDrawBuffer());
        this.pixelsOp = 0;
    }

    protected void updateGLProjection() {
        if (this.glProjection == null) {
            this.glProjection = new float[16];
        }
        this.glProjection[0] = this.projection.m00;
        this.glProjection[1] = this.projection.m10;
        this.glProjection[2] = this.projection.m20;
        this.glProjection[3] = this.projection.m30;
        this.glProjection[4] = this.projection.m01;
        this.glProjection[5] = this.projection.m11;
        this.glProjection[6] = this.projection.m21;
        this.glProjection[7] = this.projection.m31;
        this.glProjection[8] = this.projection.m02;
        this.glProjection[9] = this.projection.m12;
        this.glProjection[10] = this.projection.m22;
        this.glProjection[11] = this.projection.m32;
        this.glProjection[12] = this.projection.m03;
        this.glProjection[13] = this.projection.m13;
        this.glProjection[14] = this.projection.m23;
        this.glProjection[15] = this.projection.m33;
    }

    protected void updateGLModelview() {
        if (this.glModelview == null) {
            this.glModelview = new float[16];
        }
        this.glModelview[0] = this.modelview.m00;
        this.glModelview[1] = this.modelview.m10;
        this.glModelview[2] = this.modelview.m20;
        this.glModelview[3] = this.modelview.m30;
        this.glModelview[4] = this.modelview.m01;
        this.glModelview[5] = this.modelview.m11;
        this.glModelview[6] = this.modelview.m21;
        this.glModelview[7] = this.modelview.m31;
        this.glModelview[8] = this.modelview.m02;
        this.glModelview[9] = this.modelview.m12;
        this.glModelview[10] = this.modelview.m22;
        this.glModelview[11] = this.modelview.m32;
        this.glModelview[12] = this.modelview.m03;
        this.glModelview[13] = this.modelview.m13;
        this.glModelview[14] = this.modelview.m23;
        this.glModelview[15] = this.modelview.m33;
    }

    protected void updateGLProjmodelview() {
        if (this.glProjmodelview == null) {
            this.glProjmodelview = new float[16];
        }
        this.glProjmodelview[0] = this.projmodelview.m00;
        this.glProjmodelview[1] = this.projmodelview.m10;
        this.glProjmodelview[2] = this.projmodelview.m20;
        this.glProjmodelview[3] = this.projmodelview.m30;
        this.glProjmodelview[4] = this.projmodelview.m01;
        this.glProjmodelview[5] = this.projmodelview.m11;
        this.glProjmodelview[6] = this.projmodelview.m21;
        this.glProjmodelview[7] = this.projmodelview.m31;
        this.glProjmodelview[8] = this.projmodelview.m02;
        this.glProjmodelview[9] = this.projmodelview.m12;
        this.glProjmodelview[10] = this.projmodelview.m22;
        this.glProjmodelview[11] = this.projmodelview.m32;
        this.glProjmodelview[12] = this.projmodelview.m03;
        this.glProjmodelview[13] = this.projmodelview.m13;
        this.glProjmodelview[14] = this.projmodelview.m23;
        this.glProjmodelview[15] = this.projmodelview.m33;
    }

    protected void updateGLNormal() {
        if (this.glNormal == null) {
            this.glNormal = new float[9];
        }
        this.glNormal[0] = this.modelviewInv.m00;
        this.glNormal[1] = this.modelviewInv.m01;
        this.glNormal[2] = this.modelviewInv.m02;
        this.glNormal[3] = this.modelviewInv.m10;
        this.glNormal[4] = this.modelviewInv.m11;
        this.glNormal[5] = this.modelviewInv.m12;
        this.glNormal[6] = this.modelviewInv.m20;
        this.glNormal[7] = this.modelviewInv.m21;
        this.glNormal[8] = this.modelviewInv.m22;
    }

    @Override
    protected void defaultSettings() {
        super.defaultSettings();
        this.manipulatingCamera = false;
        this.clearColorBuffer = false;
        this.textureMode(2);
        this.ambient(255);
        this.specular(125);
        this.emissive(0);
        this.shininess(1.0f);
        this.setAmbient = false;
    }

    @Override
    public void hint(int which) {
        boolean oldValue = this.hints[PApplet.abs(which)];
        super.hint(which);
        boolean newValue = this.hints[PApplet.abs(which)];
        if (oldValue == newValue) {
            return;
        }
        if (which == 2) {
            this.flush();
            pgl.disable(2929);
        } else if (which == -2) {
            this.flush();
            pgl.enable(2929);
        } else if (which == 5) {
            this.flush();
            pgl.depthMask(false);
        } else if (which == -5) {
            this.flush();
            pgl.depthMask(true);
        } else if (which == -6) {
            this.flush();
            this.setFlushMode(1);
        } else if (which == 6) {
            if (this.is2D()) {
                PGraphics.showWarning("Optimized strokes can only be disabled in 3D");
            } else {
                this.flush();
                this.setFlushMode(0);
            }
        } else if (which == -7) {
            if (0 < this.tessGeo.lineVertexCount && 0 < this.tessGeo.lineIndexCount) {
                this.flush();
            }
        } else if (which == 7 && 0 < this.tessGeo.lineVertexCount && 0 < this.tessGeo.lineIndexCount) {
            this.flush();
        }
    }

    protected boolean getHint(int which) {
        if (which > 0) {
            return this.hints[which];
        }
        return !this.hints[-which];
    }

    @Override
    public void beginShape(int kind) {
        this.shape = kind;
        this.curveVertexCount = 0;
        this.inGeo.clear();
        this.breakShape = true;
        this.defaultEdges = true;
        this.textureImage0 = this.textureImage;
        super.noTexture();
        this.normalMode = 0;
    }

    @Override
    public void endShape(int mode) {
        this.tessellate(mode);
        if (this.flushMode == 0 || this.flushMode == 1 && this.tessGeo.isFull()) {
            this.flush();
        }
    }

    protected void endShape(int[] indices) {
        if (this.shape != 8 && this.shape != 9) {
            throw new RuntimeException("Indices and edges can only be set for TRIANGLE shapes");
        }
        this.tessellate(indices);
        if (this.flushMode == 0 || this.flushMode == 1 && this.tessGeo.isFull()) {
            this.flush();
        }
    }

    @Override
    public void textureWrap(int wrap) {
        this.textureWrap = wrap;
    }

    public void textureSampling(int sampling) {
        this.textureSampling = sampling;
    }

    @Override
    public void beginContour() {
        if (this.openContour) {
            PGraphics.showWarning(ALREADY_BEGAN_CONTOUR_ERROR);
            return;
        }
        this.openContour = true;
        this.breakShape = true;
    }

    @Override
    public void endContour() {
        if (!this.openContour) {
            PGraphics.showWarning(NO_BEGIN_CONTOUR_ERROR);
            return;
        }
        this.openContour = false;
    }

    @Override
    public void vertex(float x, float y) {
        this.vertexImpl(x, y, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public void vertex(float x, float y, float u, float v) {
        this.vertexImpl(x, y, 0.0f, u, v);
    }

    @Override
    public void vertex(float x, float y, float z) {
        this.vertexImpl(x, y, z, 0.0f, 0.0f);
    }

    @Override
    public void vertex(float x, float y, float z, float u, float v) {
        this.vertexImpl(x, y, z, u, v);
    }

    protected void vertexImpl(float x, float y, float z, float u, float v) {
        boolean textured = this.textureImage != null;
        int fcolor = 0;
        if (this.fill || textured) {
            fcolor = !textured ? this.fillColor : (this.tint ? this.tintColor : -1);
        }
        int scolor = 0;
        float sweight = 0.0f;
        if (this.stroke) {
            scolor = this.strokeColor;
            sweight = this.strokeWeight;
        }
        if (textured && this.textureMode == 2) {
            u /= (float)this.textureImage.width;
            v /= (float)this.textureImage.height;
        }
        this.inGeo.addVertex(x, y, z, fcolor, this.normalX, this.normalY, this.normalZ, u, v, scolor, sweight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess, this.vertexCode());
    }

    protected int vertexCode() {
        int code = 0;
        if (this.breakShape) {
            code = 4;
            this.breakShape = false;
        }
        return code;
    }

    @Override
    protected void clipImpl(float x1, float y1, float x2, float y2) {
        this.flush();
        pgl.enable(3089);
        float h = y2 - y1;
        this.clipRect[0] = (int)x1;
        this.clipRect[1] = (int)((float)this.height - y1 - h);
        this.clipRect[2] = (int)(x2 - x1);
        this.clipRect[3] = (int)h;
        pgl.scissor(this.clipRect[0], this.clipRect[1], this.clipRect[2], this.clipRect[3]);
        this.clip = true;
    }

    @Override
    public void noClip() {
        if (this.clip) {
            this.flush();
            pgl.disable(3089);
            this.clip = false;
        }
    }

    protected void tessellate(int mode) {
        tessellator.setInGeometry(this.inGeo);
        tessellator.setTessGeometry(this.tessGeo);
        tessellator.setFill(this.fill || this.textureImage != null);
        tessellator.setStroke(this.stroke);
        tessellator.setStrokeColor(this.strokeColor);
        tessellator.setStrokeWeight(this.strokeWeight);
        tessellator.setStrokeCap(this.strokeCap);
        tessellator.setStrokeJoin(this.strokeJoin);
        tessellator.setTexCache(this.texCache, this.textureImage0, this.textureImage);
        tessellator.setTransform(this.modelview);
        tessellator.set3D(this.is3D());
        if (this.shape == 3) {
            tessellator.tessellatePoints();
        } else if (this.shape == 5) {
            tessellator.tessellateLines();
        } else if (this.shape == 50) {
            tessellator.tessellateLineStrip();
        } else if (this.shape == 51) {
            tessellator.tessellateLineLoop();
        } else if (this.shape == 8 || this.shape == 9) {
            if (this.stroke && this.defaultEdges) {
                this.inGeo.addTrianglesEdges();
            }
            if (this.normalMode == 0) {
                this.inGeo.calcTrianglesNormals();
            }
            tessellator.tessellateTriangles();
        } else if (this.shape == 11) {
            if (this.stroke && this.defaultEdges) {
                this.inGeo.addTriangleFanEdges();
            }
            if (this.normalMode == 0) {
                this.inGeo.calcTriangleFanNormals();
            }
            tessellator.tessellateTriangleFan();
        } else if (this.shape == 10) {
            if (this.stroke && this.defaultEdges) {
                this.inGeo.addTriangleStripEdges();
            }
            if (this.normalMode == 0) {
                this.inGeo.calcTriangleStripNormals();
            }
            tessellator.tessellateTriangleStrip();
        } else if (this.shape == 16 || this.shape == 17) {
            if (this.stroke && this.defaultEdges) {
                this.inGeo.addQuadsEdges();
            }
            if (this.normalMode == 0) {
                this.inGeo.calcQuadsNormals();
            }
            tessellator.tessellateQuads();
        } else if (this.shape == 18) {
            if (this.stroke && this.defaultEdges) {
                this.inGeo.addQuadStripEdges();
            }
            if (this.normalMode == 0) {
                this.inGeo.calcQuadStripNormals();
            }
            tessellator.tessellateQuadStrip();
        } else if (this.shape == 20) {
            if (this.stroke && this.defaultEdges) {
                this.inGeo.addPolygonEdges(mode == 2);
            }
            tessellator.tessellatePolygon(false, mode == 2, this.normalMode == 0);
        }
    }

    protected void tessellate(int[] indices) {
        tessellator.setInGeometry(this.inGeo);
        tessellator.setTessGeometry(this.tessGeo);
        tessellator.setFill(this.fill || this.textureImage != null);
        tessellator.setStroke(this.stroke);
        tessellator.setStrokeColor(this.strokeColor);
        tessellator.setStrokeWeight(this.strokeWeight);
        tessellator.setStrokeCap(this.strokeCap);
        tessellator.setStrokeJoin(this.strokeJoin);
        tessellator.setTexCache(this.texCache, this.textureImage0, this.textureImage);
        tessellator.setTransform(this.modelview);
        tessellator.set3D(this.is3D());
        if (this.stroke && this.defaultEdges) {
            this.inGeo.addTrianglesEdges();
        }
        if (this.normalMode == 0) {
            this.inGeo.calcTrianglesNormals();
        }
        tessellator.tessellateTriangles(indices);
    }

    @Override
    public void flush() {
        boolean hasPixels;
        boolean hasPolys = 0 < this.tessGeo.polyVertexCount && 0 < this.tessGeo.polyIndexCount;
        boolean hasLines = 0 < this.tessGeo.lineVertexCount && 0 < this.tessGeo.lineIndexCount;
        boolean hasPoints = 0 < this.tessGeo.pointVertexCount && 0 < this.tessGeo.pointIndexCount;
        boolean bl = hasPixels = this.modified && this.pixels != null;
        if (hasPixels) {
            this.flushPixels();
        }
        if (hasPoints || hasLines || hasPolys) {
            PMatrix3D modelview0 = null;
            PMatrix3D modelviewInv0 = null;
            if (this.flushMode == 1) {
                modelview0 = this.modelview;
                modelviewInv0 = this.modelviewInv;
                this.modelview = this.modelviewInv = identity;
                this.projmodelview.set(this.projection);
            }
            if (hasPolys) {
                this.flushPolys();
                if (this.raw != null) {
                    this.rawPolys();
                }
            }
            if (this.is3D()) {
                if (hasLines) {
                    this.flushLines();
                    if (this.raw != null) {
                        this.rawLines();
                    }
                }
                if (hasPoints) {
                    this.flushPoints();
                    if (this.raw != null) {
                        this.rawPoints();
                    }
                }
            }
            if (this.flushMode == 1) {
                this.modelview = modelview0;
                this.modelviewInv = modelviewInv0;
                this.updateProjmodelview();
            }
        }
        this.tessGeo.clear();
        this.texCache.clear();
        this.setgetPixels = false;
    }

    protected void flushPixels() {
        this.drawPixels(this.mx1, this.my1, this.mx2 - this.mx1, this.my2 - this.my1);
        this.modified = false;
    }

    protected void flushPolys() {
        this.updatePolyBuffers(this.lights, this.texCache.hasTextures);
        for (int i = 0; i < this.texCache.size; ++i) {
            Texture tex = this.texCache.getTexture(i);
            BaseShader shader = this.getPolyShader(this.lights, tex != null);
            shader.bind();
            int first = this.texCache.firstCache[i];
            int last = this.texCache.lastCache[i];
            IndexCache cache = this.tessGeo.polyIndexCache;
            for (int n = first; n <= last; ++n) {
                int ioffset = n == first ? this.texCache.firstIndex[i] : cache.indexOffset[n];
                int icount = n == last ? this.texCache.lastIndex[i] - ioffset + 1 : cache.indexOffset[n] + cache.indexCount[n] - ioffset;
                int voffset = cache.vertexOffset[n];
                shader.setVertexAttribute(this.glPolyVertex, 4, 5126, 0, 4 * voffset * 4);
                shader.setColorAttribute(this.glPolyColor, 4, 5121, 0, 4 * voffset * 1);
                if (this.lights) {
                    shader.setNormalAttribute(this.glPolyNormal, 3, 5126, 0, 3 * voffset * 4);
                    shader.setAmbientAttribute(this.glPolyAmbient, 4, 5121, 0, 4 * voffset * 1);
                    shader.setSpecularAttribute(this.glPolySpecular, 4, 5121, 0, 4 * voffset * 1);
                    shader.setEmissiveAttribute(this.glPolyEmissive, 4, 5121, 0, 4 * voffset * 1);
                    shader.setShininessAttribute(this.glPolyShininess, 1, 5126, 0, voffset * 4);
                }
                if (tex != null) {
                    shader.setNormalAttribute(this.glPolyNormal, 3, 5126, 0, 3 * voffset * 4);
                    shader.setTexcoordAttribute(this.glPolyTexcoord, 2, 5126, 0, 2 * voffset * 4);
                    shader.setTexture(tex);
                }
                pgl.bindBuffer(34963, this.glPolyIndex);
                pgl.drawElements(4, icount, 5123, ioffset * 2);
                pgl.bindBuffer(34963, 0);
            }
            shader.unbind();
        }
        this.unbindPolyBuffers();
    }

    void rawPolys() {
        this.raw.colorMode(1);
        this.raw.noStroke();
        this.raw.beginShape(9);
        float[] vertices = this.tessGeo.polyVertices;
        int[] color = this.tessGeo.polyColors;
        float[] uv = this.tessGeo.polyTexCoords;
        short[] indices = this.tessGeo.polyIndices;
        for (int i = 0; i < this.texCache.size; ++i) {
            PImage textureImage = this.texCache.getTextureImage(i);
            int first = this.texCache.firstCache[i];
            int last = this.texCache.lastCache[i];
            IndexCache cache = this.tessGeo.polyIndexCache;
            for (int n = first; n <= last; ++n) {
                int ioffset = n == first ? this.texCache.firstIndex[i] : cache.indexOffset[n];
                int icount = n == last ? this.texCache.lastIndex[i] - ioffset + 1 : cache.indexOffset[n] + cache.indexCount[n] - ioffset;
                int voffset = cache.vertexOffset[n];
                for (int tr = ioffset / 3; tr < (ioffset + icount) / 3; ++tr) {
                    float sy2;
                    float sx2;
                    float sy1;
                    int i0 = voffset + indices[3 * tr + 0];
                    int i1 = voffset + indices[3 * tr + 1];
                    int i2 = voffset + indices[3 * tr + 2];
                    float[] pt0 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                    float[] pt1 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                    float[] pt2 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                    int argb0 = PGL.nativeToJavaARGB(color[i0]);
                    int argb1 = PGL.nativeToJavaARGB(color[i1]);
                    int argb2 = PGL.nativeToJavaARGB(color[i2]);
                    if (this.flushMode == 0) {
                        float[] src0 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                        float[] src1 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                        float[] src2 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                        PApplet.arrayCopy(vertices, 4 * i0, src0, 0, 4);
                        PApplet.arrayCopy(vertices, 4 * i1, src1, 0, 4);
                        PApplet.arrayCopy(vertices, 4 * i2, src2, 0, 4);
                        this.modelview.mult(src0, pt0);
                        this.modelview.mult(src1, pt1);
                        this.modelview.mult(src2, pt2);
                    } else {
                        PApplet.arrayCopy(vertices, 4 * i0, pt0, 0, 4);
                        PApplet.arrayCopy(vertices, 4 * i1, pt1, 0, 4);
                        PApplet.arrayCopy(vertices, 4 * i2, pt2, 0, 4);
                    }
                    if (textureImage != null) {
                        this.raw.texture(textureImage);
                        if (this.raw.is3D()) {
                            this.raw.fill(argb0);
                            this.raw.vertex(pt0[0], pt0[1], pt0[2], uv[2 * i0 + 0], uv[2 * i0 + 1]);
                            this.raw.fill(argb1);
                            this.raw.vertex(pt1[0], pt1[1], pt1[2], uv[2 * i1 + 0], uv[2 * i1 + 1]);
                            this.raw.fill(argb2);
                            this.raw.vertex(pt2[0], pt2[1], pt2[2], uv[2 * i2 + 0], uv[2 * i2 + 1]);
                            continue;
                        }
                        if (!this.raw.is2D()) continue;
                        float sx0 = this.screenXImpl(pt0[0], pt0[1], pt0[2], pt0[3]);
                        float sy0 = this.screenYImpl(pt0[0], pt0[1], pt0[2], pt0[3]);
                        float sx1 = this.screenXImpl(pt1[0], pt1[1], pt1[2], pt1[3]);
                        sy1 = this.screenYImpl(pt1[0], pt1[1], pt1[2], pt1[3]);
                        sx2 = this.screenXImpl(pt2[0], pt2[1], pt2[2], pt2[3]);
                        sy2 = this.screenYImpl(pt2[0], pt2[1], pt2[2], pt2[3]);
                        this.raw.fill(argb0);
                        this.raw.vertex(sx0, sy0, uv[2 * i0 + 0], uv[2 * i0 + 1]);
                        this.raw.fill(argb1);
                        this.raw.vertex(sx1, sy1, uv[2 * i1 + 0], uv[2 * i1 + 1]);
                        this.raw.fill(argb1);
                        this.raw.vertex(sx2, sy2, uv[2 * i2 + 0], uv[2 * i2 + 1]);
                        continue;
                    }
                    if (this.raw.is3D()) {
                        this.raw.fill(argb0);
                        this.raw.vertex(pt0[0], pt0[1], pt0[2]);
                        this.raw.fill(argb1);
                        this.raw.vertex(pt1[0], pt1[1], pt1[2]);
                        this.raw.fill(argb2);
                        this.raw.vertex(pt2[0], pt2[1], pt2[2]);
                        continue;
                    }
                    if (!this.raw.is2D()) continue;
                    float sx0 = this.screenXImpl(pt0[0], pt0[1], pt0[2], pt0[3]);
                    float sy0 = this.screenYImpl(pt0[0], pt0[1], pt0[2], pt0[3]);
                    float sx1 = this.screenXImpl(pt1[0], pt1[1], pt1[2], pt1[3]);
                    sy1 = this.screenYImpl(pt1[0], pt1[1], pt1[2], pt1[3]);
                    sx2 = this.screenXImpl(pt2[0], pt2[1], pt2[2], pt2[3]);
                    sy2 = this.screenYImpl(pt2[0], pt2[1], pt2[2], pt2[3]);
                    this.raw.fill(argb0);
                    this.raw.vertex(sx0, sy0);
                    this.raw.fill(argb1);
                    this.raw.vertex(sx1, sy1);
                    this.raw.fill(argb2);
                    this.raw.vertex(sx2, sy2);
                }
            }
        }
        this.raw.endShape();
    }

    protected void flushLines() {
        this.updateLineBuffers();
        LineShader shader = this.getLineShader();
        shader.bind();
        IndexCache cache = this.tessGeo.lineIndexCache;
        for (int n = 0; n < cache.size; ++n) {
            int ioffset = cache.indexOffset[n];
            int icount = cache.indexCount[n];
            int voffset = cache.vertexOffset[n];
            shader.setVertexAttribute(this.glLineVertex, 4, 5126, 0, 4 * voffset * 4);
            shader.setColorAttribute(this.glLineColor, 4, 5121, 0, 4 * voffset * 1);
            shader.setLineAttribute(this.glLineAttrib, 4, 5126, 0, 4 * voffset * 4);
            pgl.bindBuffer(34963, this.glLineIndex);
            pgl.drawElements(4, icount, 5123, ioffset * 2);
            pgl.bindBuffer(34963, 0);
        }
        shader.unbind();
        this.unbindLineBuffers();
    }

    void rawLines() {
        this.raw.colorMode(1);
        this.raw.noFill();
        this.raw.strokeCap(this.strokeCap);
        this.raw.strokeJoin(this.strokeJoin);
        this.raw.beginShape(5);
        float[] vertices = this.tessGeo.lineVertices;
        int[] color = this.tessGeo.lineColors;
        float[] attribs = this.tessGeo.lineDirections;
        short[] indices = this.tessGeo.lineIndices;
        IndexCache cache = this.tessGeo.lineIndexCache;
        for (int n = 0; n < cache.size; ++n) {
            int ioffset = cache.indexOffset[n];
            int icount = cache.indexCount[n];
            int voffset = cache.vertexOffset[n];
            for (int ln = ioffset / 6; ln < (ioffset + icount) / 6; ++ln) {
                int i0 = voffset + indices[6 * ln + 0];
                int i1 = voffset + indices[6 * ln + 5];
                float sw0 = 2.0f * attribs[4 * i0 + 3];
                float sw1 = 2.0f * attribs[4 * i1 + 3];
                if (PGraphicsOpenGL.zero(sw0)) continue;
                float[] pt0 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                float[] pt1 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                int argb0 = PGL.nativeToJavaARGB(color[i0]);
                int argb1 = PGL.nativeToJavaARGB(color[i1]);
                if (this.flushMode == 0) {
                    float[] src0 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                    float[] src1 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                    PApplet.arrayCopy(vertices, 4 * i0, src0, 0, 4);
                    PApplet.arrayCopy(vertices, 4 * i1, src1, 0, 4);
                    this.modelview.mult(src0, pt0);
                    this.modelview.mult(src1, pt1);
                } else {
                    PApplet.arrayCopy(vertices, 4 * i0, pt0, 0, 4);
                    PApplet.arrayCopy(vertices, 4 * i1, pt1, 0, 4);
                }
                if (this.raw.is3D()) {
                    this.raw.strokeWeight(sw0);
                    this.raw.stroke(argb0);
                    this.raw.vertex(pt0[0], pt0[1], pt0[2]);
                    this.raw.strokeWeight(sw1);
                    this.raw.stroke(argb1);
                    this.raw.vertex(pt1[0], pt1[1], pt1[2]);
                    continue;
                }
                if (!this.raw.is2D()) continue;
                float sx0 = this.screenXImpl(pt0[0], pt0[1], pt0[2], pt0[3]);
                float sy0 = this.screenYImpl(pt0[0], pt0[1], pt0[2], pt0[3]);
                float sx1 = this.screenXImpl(pt1[0], pt1[1], pt1[2], pt1[3]);
                float sy1 = this.screenYImpl(pt1[0], pt1[1], pt1[2], pt1[3]);
                this.raw.strokeWeight(sw0);
                this.raw.stroke(argb0);
                this.raw.vertex(sx0, sy0);
                this.raw.strokeWeight(sw1);
                this.raw.stroke(argb1);
                this.raw.vertex(sx1, sy1);
            }
        }
        this.raw.endShape();
    }

    protected void flushPoints() {
        this.updatePointBuffers();
        PointShader shader = this.getPointShader();
        shader.bind();
        IndexCache cache = this.tessGeo.pointIndexCache;
        for (int n = 0; n < cache.size; ++n) {
            int ioffset = cache.indexOffset[n];
            int icount = cache.indexCount[n];
            int voffset = cache.vertexOffset[n];
            shader.setVertexAttribute(this.glPointVertex, 4, 5126, 0, 4 * voffset * 4);
            shader.setColorAttribute(this.glPointColor, 4, 5121, 0, 4 * voffset * 1);
            shader.setPointAttribute(this.glPointAttrib, 2, 5126, 0, 2 * voffset * 4);
            pgl.bindBuffer(34963, this.glPointIndex);
            pgl.drawElements(4, icount, 5123, ioffset * 2);
            pgl.bindBuffer(34963, 0);
        }
        shader.unbind();
        this.unbindPointBuffers();
    }

    void rawPoints() {
        this.raw.colorMode(1);
        this.raw.noFill();
        this.raw.strokeCap(this.strokeCap);
        this.raw.beginShape(3);
        float[] vertices = this.tessGeo.pointVertices;
        int[] color = this.tessGeo.pointColors;
        float[] attribs = this.tessGeo.pointOffsets;
        short[] indices = this.tessGeo.pointIndices;
        IndexCache cache = this.tessGeo.pointIndexCache;
        for (int n = 0; n < cache.size; ++n) {
            int perim;
            int ioffset = cache.indexOffset[n];
            int icount = cache.indexCount[n];
            int voffset = cache.vertexOffset[n];
            for (int pt = ioffset; pt < (ioffset + icount) / 3; pt += perim) {
                float weight;
                float size = attribs[2 * pt + 2];
                if (0.0f < size) {
                    weight = size / 0.5f;
                    perim = PApplet.max(20, (int)((float)Math.PI * 2 * weight / 10.0f)) + 1;
                } else {
                    weight = -size / 0.5f;
                    perim = 5;
                }
                int i0 = voffset + indices[3 * pt];
                int argb0 = PGL.nativeToJavaARGB(color[i0]);
                float[] pt0 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                if (this.flushMode == 0) {
                    float[] src0 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                    PApplet.arrayCopy(vertices, 4 * i0, src0, 0, 4);
                    this.modelview.mult(src0, pt0);
                } else {
                    PApplet.arrayCopy(vertices, 4 * i0, pt0, 0, 4);
                }
                if (this.raw.is3D()) {
                    this.raw.strokeWeight(weight);
                    this.raw.stroke(argb0);
                    this.raw.vertex(pt0[0], pt0[1], pt0[2]);
                    continue;
                }
                if (!this.raw.is2D()) continue;
                float sx0 = this.screenXImpl(pt0[0], pt0[1], pt0[2], pt0[3]);
                float sy0 = this.screenYImpl(pt0[0], pt0[1], pt0[2], pt0[3]);
                this.raw.strokeWeight(weight);
                this.raw.stroke(argb0);
                this.raw.vertex(sx0, sy0);
            }
        }
        this.raw.endShape();
    }

    @Override
    public void bezierVertex(float x2, float y2, float x3, float y3, float x4, float y4) {
        this.bezierVertexImpl(x2, y2, 0.0f, x3, y3, 0.0f, x4, y4, 0.0f);
    }

    @Override
    public void bezierVertex(float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        this.bezierVertexImpl(x2, y2, z2, x3, y3, z3, x4, y4, z4);
    }

    protected void bezierVertexImpl(float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addBezierVertex(x2, y2, z2, x3, y3, z3, x4, y4, z4, this.fill, this.stroke, this.bezierDetail, this.vertexCode(), this.shape);
    }

    @Override
    public void quadraticVertex(float cx, float cy, float x3, float y3) {
        this.quadraticVertexImpl(cx, cy, 0.0f, x3, y3, 0.0f);
    }

    @Override
    public void quadraticVertex(float cx, float cy, float cz, float x3, float y3, float z3) {
        this.quadraticVertexImpl(cx, cy, cz, x3, y3, z3);
    }

    protected void quadraticVertexImpl(float cx, float cy, float cz, float x3, float y3, float z3) {
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addQuadraticVertex(cx, cy, cz, x3, y3, z3, this.fill, this.stroke, this.bezierDetail, this.vertexCode(), this.shape);
    }

    @Override
    public void curveVertex(float x, float y) {
        this.curveVertexImpl(x, y, 0.0f);
    }

    @Override
    public void curveVertex(float x, float y, float z) {
        this.curveVertexImpl(x, y, z);
    }

    protected void curveVertexImpl(float x, float y, float z) {
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addCurveVertex(x, y, z, this.fill, this.stroke, this.curveDetail, this.vertexCode(), this.shape);
    }

    @Override
    public void point(float x, float y) {
        this.pointImpl(x, y, 0.0f);
    }

    @Override
    public void point(float x, float y, float z) {
        this.pointImpl(x, y, z);
    }

    protected void pointImpl(float x, float y, float z) {
        this.beginShape(3);
        this.defaultEdges = false;
        this.normalMode = 1;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addPoint(x, y, z, this.fill, this.stroke);
        this.endShape();
    }

    @Override
    public void line(float x1, float y1, float x2, float y2) {
        this.lineImpl(x1, y1, 0.0f, x2, y2, 0.0f);
    }

    @Override
    public void line(float x1, float y1, float z1, float x2, float y2, float z2) {
        this.lineImpl(x1, y1, z1, x2, y2, z2);
    }

    protected void lineImpl(float x1, float y1, float z1, float x2, float y2, float z2) {
        this.beginShape(5);
        this.defaultEdges = false;
        this.normalMode = 1;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addLine(x1, y1, z1, x2, y2, z2, this.fill, this.stroke);
        this.endShape();
    }

    @Override
    public void triangle(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.beginShape(9);
        this.defaultEdges = false;
        this.normalMode = 1;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addTriangle(x1, y1, 0.0f, x2, y2, 0.0f, x3, y3, 0.0f, this.fill, this.stroke);
        this.endShape();
    }

    @Override
    public void quad(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        this.beginShape(17);
        this.defaultEdges = false;
        this.normalMode = 1;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addQuad(x1, y1, 0.0f, x2, y2, 0.0f, x3, y3, 0.0f, x4, y4, 0.0f, this.fill, this.stroke);
        this.endShape();
    }

    @Override
    public void rect(float a, float b, float c, float d) {
        this.beginShape(17);
        this.defaultEdges = false;
        this.normalMode = 1;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addRect(a, b, c, d, this.fill, this.stroke, this.rectMode);
        this.endShape();
    }

    @Override
    public void rect(float a, float b, float c, float d, float tl, float tr, float br, float bl) {
        this.beginShape(20);
        this.defaultEdges = false;
        this.normalMode = 1;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addRect(a, b, c, d, tl, tr, br, bl, this.fill, this.stroke, this.bezierDetail, this.rectMode);
        this.endShape(2);
    }

    @Override
    public void ellipse(float a, float b, float c, float d) {
        this.beginShape(11);
        this.defaultEdges = false;
        this.normalMode = 1;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addEllipse(a, b, c, d, this.fill, this.stroke, this.ellipseMode);
        this.endShape();
    }

    @Override
    protected void arcImpl(float x, float y, float w, float h, float start, float stop, int mode) {
        this.beginShape(11);
        this.defaultEdges = false;
        this.normalMode = 1;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addArc(x, y, w, h, start, stop, this.fill, this.stroke, mode);
        this.endShape();
    }

    @Override
    public void box(float w, float h, float d) {
        this.beginShape(17);
        this.defaultEdges = false;
        this.normalMode = 2;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.addBox(w, h, d, this.fill, this.stroke);
        this.endShape();
    }

    @Override
    public void sphere(float r) {
        this.beginShape(9);
        this.defaultEdges = false;
        this.normalMode = 2;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        int[] indices = this.inGeo.addSphere(r, this.sphereDetailU, this.sphereDetailV, this.fill, this.stroke);
        this.endShape(indices);
    }

    @Override
    public void smooth() {
        this.smooth(2);
    }

    @Override
    public void smooth(int level) {
        if (this.smoothDisabled) {
            return;
        }
        this.smooth = true;
        if (maxSamples < level) {
            if (0 < maxSamples) {
                PGraphics.showWarning(UNSUPPORTED_SMOOTH_LEVEL_ERROR, level, maxSamples);
            } else {
                PGraphics.showWarning(UNSUPPORTED_SMOOTH_ERROR);
            }
            level = maxSamples;
        }
        if (this.quality != level) {
            ++this.smoothCallCount;
            if (this.parent.frameCount - this.lastSmoothCall < 30 && 5 < this.smoothCallCount) {
                this.smoothDisabled = true;
                PGraphics.showWarning(TOO_MANY_SMOOTH_CALLS_ERROR);
            }
            this.lastSmoothCall = this.parent.frameCount;
            this.quality = level;
            if (this.quality == 1) {
                this.quality = 0;
            }
            this.restartPGL();
        }
    }

    @Override
    public void noSmooth() {
        if (this.smoothDisabled) {
            return;
        }
        this.smooth = false;
        if (1 < this.quality) {
            ++this.smoothCallCount;
            if (this.parent.frameCount - this.lastSmoothCall < 30 && 5 < this.smoothCallCount) {
                this.smoothDisabled = true;
                PGraphics.showWarning(TOO_MANY_SMOOTH_CALLS_ERROR);
            }
            this.lastSmoothCall = this.parent.frameCount;
            this.quality = 0;
            this.restartPGL();
        }
    }

    @Override
    protected void shape(PShape shape, float x, float y, float z) {
        if (shape.isVisible()) {
            this.flush();
            this.pushMatrix();
            if (this.shapeMode == 3) {
                this.translate(x - shape.getWidth() / 2.0f, y - shape.getHeight() / 2.0f, z - shape.getDepth() / 2.0f);
            } else if (this.shapeMode == 0 || this.shapeMode == 1) {
                this.translate(x, y, z);
            }
            shape.draw(this);
            this.popMatrix();
        }
    }

    @Override
    protected void shape(PShape shape, float x, float y, float z, float c, float d, float e) {
        if (shape.isVisible()) {
            this.flush();
            this.pushMatrix();
            if (this.shapeMode == 3) {
                this.translate(x - c / 2.0f, y - d / 2.0f, z - e / 2.0f);
                this.scale(c / shape.getWidth(), d / shape.getHeight(), e / shape.getDepth());
            } else if (this.shapeMode == 0) {
                this.translate(x, y, z);
                this.scale(c / shape.getWidth(), d / shape.getHeight(), e / shape.getDepth());
            } else if (this.shapeMode == 1) {
                this.translate(x, y, z);
                this.scale((c -= x) / shape.getWidth(), (d -= y) / shape.getHeight(), (e -= z) / shape.getDepth());
            }
            shape.draw(this);
            this.popMatrix();
        }
    }

    @Override
    public PShape loadShape(String filename) {
        String ext = PApplet.getExtension(filename);
        if (PGraphics2D.isSupportedExtension(ext)) {
            return PGraphics2D.loadShapeImpl(this, filename, ext);
        }
        if (PGraphics3D.isSupportedExtension(ext)) {
            return PGraphics3D.loadShapeImpl(this, filename, ext);
        }
        PGraphics.showWarning(UNSUPPORTED_SHAPE_FORMAT_ERROR);
        return null;
    }

    @Override
    protected boolean textModeCheck(int mode) {
        return mode == 4 || mode == 5;
    }

    @Override
    protected void textLineImpl(char[] buffer, int start, int stop, float x, float y) {
        if (this.textMode == 4) {
            this.textTex = pgPrimary.getFontTexture(this.textFont);
            if (this.textTex == null || this.textTex.contextIsOutdated()) {
                this.textTex = new FontTexture(pgPrimary, this.textFont, this.is3D());
                pgPrimary.setFontTexture(this.textFont, this.textTex);
            }
            this.textTex.begin();
            int savedTextureMode = this.textureMode;
            boolean savedStroke = this.stroke;
            float savedNormalX = this.normalX;
            float savedNormalY = this.normalY;
            float savedNormalZ = this.normalZ;
            boolean savedTint = this.tint;
            int savedTintColor = this.tintColor;
            int savedBlendMode = this.blendMode;
            this.textureMode = 1;
            this.stroke = false;
            this.normalX = 0.0f;
            this.normalY = 0.0f;
            this.normalZ = 1.0f;
            this.tint = true;
            this.tintColor = this.fillColor;
            this.blendMode(1);
            super.textLineImpl(buffer, start, stop, x, y);
            this.textureMode = savedTextureMode;
            this.stroke = savedStroke;
            this.normalX = savedNormalX;
            this.normalY = savedNormalY;
            this.normalZ = savedNormalZ;
            this.tint = savedTint;
            this.tintColor = savedTintColor;
            this.blendMode(savedBlendMode);
            this.textTex.end();
        } else if (this.textMode == 5) {
            super.textLineImpl(buffer, start, stop, x, y);
        }
    }

    @Override
    protected void textCharImpl(char ch, float x, float y) {
        PFont.Glyph glyph = this.textFont.getGlyph(ch);
        if (glyph != null) {
            if (this.textMode == 4) {
                FontTexture.TextureInfo tinfo = this.textTex.getTexInfo(glyph);
                if (tinfo == null) {
                    tinfo = this.textTex.addToTexture(pgPrimary, glyph);
                }
                float high = (float)glyph.height / (float)this.textFont.getSize();
                float bwidth = (float)glyph.width / (float)this.textFont.getSize();
                float lextent = (float)glyph.leftExtent / (float)this.textFont.getSize();
                float textent = (float)glyph.topExtent / (float)this.textFont.getSize();
                float x1 = x + lextent * this.textSize;
                float y1 = y - textent * this.textSize;
                float x2 = x1 + bwidth * this.textSize;
                float y2 = y1 + high * this.textSize;
                this.textCharModelImpl(tinfo, x1, y1, x2, y2);
            } else if (this.textMode == 5) {
                this.textCharShapeImpl(ch, x, y);
            }
        }
    }

    protected void textCharModelImpl(FontTexture.TextureInfo info, float x0, float y0, float x1, float y1) {
        if (this.textTex.currentTex != info.texIndex) {
            this.textTex.setTexture(info.texIndex);
        }
        PImage tex = this.textTex.getCurrentTexture();
        this.beginShape(17);
        this.texture(tex);
        this.vertex(x0, y0, info.u0, info.v0);
        this.vertex(x1, y0, info.u1, info.v0);
        this.vertex(x1, y1, info.u1, info.v1);
        this.vertex(x0, y1, info.u0, info.v1);
        this.endShape();
    }

    protected void textCharShapeImpl(char ch, float x, float y) {
        boolean strokeSaved = this.stroke;
        this.stroke = false;
        PGL.FontOutline outline = pgl.createFontOutline(ch, this.textFont.getNative());
        float[] textPoints = new float[6];
        float lastX = 0.0f;
        float lastY = 0.0f;
        this.beginShape();
        while (!outline.isDone()) {
            int type = outline.currentSegment(textPoints);
            switch (type) {
                case 0: 
                case 1: {
                    if (type == 0) {
                        this.beginContour();
                    }
                    this.vertex(x + textPoints[0], y + textPoints[1]);
                    lastX = textPoints[0];
                    lastY = textPoints[1];
                    break;
                }
                case 2: {
                    float t;
                    int i;
                    for (i = 1; i < this.bezierDetail; ++i) {
                        t = (float)i / (float)this.bezierDetail;
                        this.vertex(x + this.bezierPoint(lastX, lastX + (float)((double)((textPoints[0] - lastX) * 2.0f) / 3.0), textPoints[2] + (float)((double)((textPoints[0] - textPoints[2]) * 2.0f) / 3.0), textPoints[2], t), y + this.bezierPoint(lastY, lastY + (float)((double)((textPoints[1] - lastY) * 2.0f) / 3.0), textPoints[3] + (float)((double)((textPoints[1] - textPoints[3]) * 2.0f) / 3.0), textPoints[3], t));
                    }
                    lastX = textPoints[2];
                    lastY = textPoints[3];
                    break;
                }
                case 3: {
                    float t;
                    int i;
                    for (i = 1; i < this.bezierDetail; ++i) {
                        t = (float)i / (float)this.bezierDetail;
                        this.vertex(x + this.bezierPoint(lastX, textPoints[0], textPoints[2], textPoints[4], t), y + this.bezierPoint(lastY, textPoints[1], textPoints[3], textPoints[5], t));
                    }
                    lastX = textPoints[4];
                    lastY = textPoints[5];
                    break;
                }
                case 4: {
                    this.endContour();
                }
            }
            outline.next();
        }
        this.endShape();
        this.stroke = strokeSaved;
    }

    @Override
    public void pushMatrix() {
        if (this.modelviewStackDepth == 32) {
            throw new RuntimeException("Too many calls to pushMatrix().");
        }
        this.modelview.get(this.modelviewStack[this.modelviewStackDepth]);
        this.modelviewInv.get(this.modelviewInvStack[this.modelviewStackDepth]);
        this.camera.get(this.cameraStack[this.modelviewStackDepth]);
        this.cameraInv.get(this.cameraInvStack[this.modelviewStackDepth]);
        ++this.modelviewStackDepth;
    }

    @Override
    public void popMatrix() {
        if (this.modelviewStackDepth == 0) {
            throw new RuntimeException("Too many calls to popMatrix(), and not enough to pushMatrix().");
        }
        --this.modelviewStackDepth;
        this.modelview.set(this.modelviewStack[this.modelviewStackDepth]);
        this.modelviewInv.set(this.modelviewInvStack[this.modelviewStackDepth]);
        this.camera.set(this.cameraStack[this.modelviewStackDepth]);
        this.cameraInv.set(this.cameraInvStack[this.modelviewStackDepth]);
        this.updateProjmodelview();
    }

    @Override
    public void translate(float tx, float ty) {
        this.translateImpl(tx, ty, 0.0f);
    }

    @Override
    public void translate(float tx, float ty, float tz) {
        this.translateImpl(tx, ty, tz);
    }

    protected void translateImpl(float tx, float ty, float tz) {
        this.modelview.translate(tx, ty, tz);
        PGraphicsOpenGL.invTranslate(this.modelviewInv, tx, ty, tz);
        this.projmodelview.translate(tx, ty, tz);
    }

    protected static void invTranslate(PMatrix3D matrix, float tx, float ty, float tz) {
        matrix.preApply(1.0f, 0.0f, 0.0f, -tx, 0.0f, 1.0f, 0.0f, -ty, 0.0f, 0.0f, 1.0f, -tz, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void rotate(float angle) {
        this.rotateImpl(angle, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void rotateX(float angle) {
        this.rotateImpl(angle, 1.0f, 0.0f, 0.0f);
    }

    @Override
    public void rotateY(float angle) {
        this.rotateImpl(angle, 0.0f, 1.0f, 0.0f);
    }

    @Override
    public void rotateZ(float angle) {
        this.rotateImpl(angle, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void rotate(float angle, float v0, float v1, float v2) {
        this.rotateImpl(angle, v0, v1, v2);
    }

    protected void rotateImpl(float angle, float v0, float v1, float v2) {
        float norm2 = v0 * v0 + v1 * v1 + v2 * v2;
        if (PGraphicsOpenGL.zero(norm2)) {
            return;
        }
        if (PGraphicsOpenGL.diff(norm2, 1.0f)) {
            float norm = PApplet.sqrt(norm2);
            v0 /= norm;
            v1 /= norm;
            v2 /= norm;
        }
        this.modelview.rotate(angle, v0, v1, v2);
        PGraphicsOpenGL.invRotate(this.modelviewInv, angle, v0, v1, v2);
        this.updateProjmodelview();
    }

    private static void invRotate(PMatrix3D matrix, float angle, float v0, float v1, float v2) {
        float c = PApplet.cos(-angle);
        float s = PApplet.sin(-angle);
        float t = 1.0f - c;
        matrix.preApply(t * v0 * v0 + c, t * v0 * v1 - s * v2, t * v0 * v2 + s * v1, 0.0f, t * v0 * v1 + s * v2, t * v1 * v1 + c, t * v1 * v2 - s * v0, 0.0f, t * v0 * v2 - s * v1, t * v1 * v2 + s * v0, t * v2 * v2 + c, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void scale(float s) {
        this.scaleImpl(s, s, s);
    }

    @Override
    public void scale(float sx, float sy) {
        this.scaleImpl(sx, sy, 1.0f);
    }

    @Override
    public void scale(float sx, float sy, float sz) {
        this.scaleImpl(sx, sy, sz);
    }

    protected void scaleImpl(float sx, float sy, float sz) {
        this.modelview.scale(sx, sy, sz);
        PGraphicsOpenGL.invScale(this.modelviewInv, sx, sy, sz);
        this.projmodelview.scale(sx, sy, sz);
    }

    protected static void invScale(PMatrix3D matrix, float x, float y, float z) {
        matrix.preApply(1.0f / x, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f / y, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f / z, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void shearX(float angle) {
        float t = (float)Math.tan(angle);
        this.applyMatrixImpl(1.0f, t, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void shearY(float angle) {
        float t = (float)Math.tan(angle);
        this.applyMatrixImpl(1.0f, 0.0f, 0.0f, 0.0f, t, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void resetMatrix() {
        this.modelview.reset();
        this.modelviewInv.reset();
        this.projmodelview.set(this.projection);
        this.camera.reset();
        this.cameraInv.reset();
    }

    @Override
    public void applyMatrix(PMatrix2D source) {
        this.applyMatrixImpl(source.m00, source.m01, 0.0f, source.m02, source.m10, source.m11, 0.0f, source.m12, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void applyMatrix(float n00, float n01, float n02, float n10, float n11, float n12) {
        this.applyMatrixImpl(n00, n01, 0.0f, n02, n10, n11, 0.0f, n12, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void applyMatrix(PMatrix3D source) {
        this.applyMatrixImpl(source.m00, source.m01, source.m02, source.m03, source.m10, source.m11, source.m12, source.m13, source.m20, source.m21, source.m22, source.m23, source.m30, source.m31, source.m32, source.m33);
    }

    @Override
    public void applyMatrix(float n00, float n01, float n02, float n03, float n10, float n11, float n12, float n13, float n20, float n21, float n22, float n23, float n30, float n31, float n32, float n33) {
        this.applyMatrixImpl(n00, n01, n02, n03, n10, n11, n12, n13, n20, n21, n22, n23, n30, n31, n32, n33);
    }

    protected void applyMatrixImpl(float n00, float n01, float n02, float n03, float n10, float n11, float n12, float n13, float n20, float n21, float n22, float n23, float n30, float n31, float n32, float n33) {
        this.modelview.apply(n00, n01, n02, n03, n10, n11, n12, n13, n20, n21, n22, n23, n30, n31, n32, n33);
        this.modelviewInv.set(this.modelview);
        this.modelviewInv.invert();
        this.projmodelview.apply(n00, n01, n02, n03, n10, n11, n12, n13, n20, n21, n22, n23, n30, n31, n32, n33);
    }

    protected void begin2D() {
    }

    protected void end2D() {
    }

    @Override
    public PMatrix getMatrix() {
        return this.modelview.get();
    }

    @Override
    public PMatrix3D getMatrix(PMatrix3D target) {
        if (target == null) {
            target = new PMatrix3D();
        }
        target.set(this.modelview);
        return target;
    }

    @Override
    public void setMatrix(PMatrix2D source) {
        this.resetMatrix();
        this.applyMatrix(source);
    }

    @Override
    public void setMatrix(PMatrix3D source) {
        this.resetMatrix();
        this.applyMatrix(source);
    }

    @Override
    public void printMatrix() {
        this.modelview.print();
    }

    public void pushProjection() {
        if (this.projectionStackDepth == 32) {
            throw new RuntimeException("Too many calls to pushMatrix().");
        }
        this.projection.get(this.projectionStack[this.projectionStackDepth]);
        ++this.projectionStackDepth;
    }

    public void popProjection() {
        this.flush();
        if (this.projectionStackDepth == 0) {
            throw new RuntimeException("Too many calls to popMatrix(), and not enough to pushMatrix().");
        }
        --this.projectionStackDepth;
        this.projection.set(this.projectionStack[this.projectionStackDepth]);
        this.updateProjmodelview();
    }

    public void resetProjection() {
        this.flush();
        this.projection.reset();
        this.updateProjmodelview();
    }

    public void applyProjection(PMatrix3D mat) {
        this.flush();
        this.projection.apply(mat);
        this.updateProjmodelview();
    }

    public void applyProjection(float n00, float n01, float n02, float n03, float n10, float n11, float n12, float n13, float n20, float n21, float n22, float n23, float n30, float n31, float n32, float n33) {
        this.flush();
        this.projection.apply(n00, n01, n02, n03, n10, n11, n12, n13, n20, n21, n22, n23, n30, n31, n32, n33);
        this.updateProjmodelview();
    }

    public void setProjection(PMatrix3D mat) {
        this.flush();
        this.projection.set(mat);
        this.updateProjmodelview();
    }

    protected boolean orthoProjection() {
        return PGraphicsOpenGL.zero(this.projection.m01) && PGraphicsOpenGL.zero(this.projection.m02) && PGraphicsOpenGL.zero(this.projection.m10) && PGraphicsOpenGL.zero(this.projection.m12) && PGraphicsOpenGL.zero(this.projection.m20) && PGraphicsOpenGL.zero(this.projection.m21) && PGraphicsOpenGL.zero(this.projection.m30) && PGraphicsOpenGL.zero(this.projection.m31) && PGraphicsOpenGL.zero(this.projection.m32) && PGraphicsOpenGL.same(this.projection.m33, 1.0f);
    }

    protected boolean nonOrthoProjection() {
        return PGraphicsOpenGL.nonZero(this.projection.m01) || PGraphicsOpenGL.nonZero(this.projection.m02) || PGraphicsOpenGL.nonZero(this.projection.m10) || PGraphicsOpenGL.nonZero(this.projection.m12) || PGraphicsOpenGL.nonZero(this.projection.m20) || PGraphicsOpenGL.nonZero(this.projection.m21) || PGraphicsOpenGL.nonZero(this.projection.m30) || PGraphicsOpenGL.nonZero(this.projection.m31) || PGraphicsOpenGL.nonZero(this.projection.m32) || PGraphicsOpenGL.diff(this.projection.m33, 1.0f);
    }

    protected static boolean same(float a, float b) {
        return Math.abs(a - b) < PGL.FLOAT_EPS;
    }

    protected static boolean diff(float a, float b) {
        return PGL.FLOAT_EPS <= Math.abs(a - b);
    }

    protected static boolean zero(float a) {
        return Math.abs(a) < PGL.FLOAT_EPS;
    }

    protected static boolean nonZero(float a) {
        return PGL.FLOAT_EPS <= Math.abs(a);
    }

    @Override
    public void beginCamera() {
        if (this.manipulatingCamera) {
            throw new RuntimeException("beginCamera() cannot be called again before endCamera()");
        }
        this.manipulatingCamera = true;
    }

    @Override
    public void endCamera() {
        if (!this.manipulatingCamera) {
            throw new RuntimeException("Cannot call endCamera() without first calling beginCamera()");
        }
        this.camera.set(this.modelview);
        this.cameraInv.set(this.modelviewInv);
        this.manipulatingCamera = false;
    }

    @Override
    public void camera() {
        this.camera(this.cameraX, this.cameraY, this.cameraZ, this.cameraX, this.cameraY, 0.0f, 0.0f, 1.0f, 0.0f);
    }

    @Override
    public void camera(float eyeX, float eyeY, float eyeZ, float centerX, float centerY, float centerZ, float upX, float upY, float upZ) {
        float z0 = eyeX - centerX;
        float z1 = eyeY - centerY;
        float z2 = eyeZ - centerZ;
        float mag = PApplet.sqrt(z0 * z0 + z1 * z1 + z2 * z2);
        if (PGraphicsOpenGL.nonZero(mag)) {
            z0 /= mag;
            z1 /= mag;
            z2 /= mag;
        }
        this.cameraEyeX = eyeX;
        this.cameraEyeY = eyeY;
        this.cameraEyeZ = eyeZ;
        float y0 = upX;
        float y1 = upY;
        float y2 = upZ;
        float x0 = y1 * z2 - y2 * z1;
        float x1 = -y0 * z2 + y2 * z0;
        float x2 = y0 * z1 - y1 * z0;
        y0 = z1 * x2 - z2 * x1;
        y1 = -z0 * x2 + z2 * x0;
        y2 = z0 * x1 - z1 * x0;
        mag = PApplet.sqrt(x0 * x0 + x1 * x1 + x2 * x2);
        if (PGraphicsOpenGL.nonZero(mag)) {
            x0 /= mag;
            x1 /= mag;
            x2 /= mag;
        }
        if (PGraphicsOpenGL.nonZero(mag = PApplet.sqrt(y0 * y0 + y1 * y1 + y2 * y2))) {
            y0 /= mag;
            y1 /= mag;
            y2 /= mag;
        }
        this.modelview.set(x0, x1, x2, 0.0f, y0, y1, y2, 0.0f, z0, z1, z2, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        float tx = -eyeX;
        float ty = -eyeY;
        float tz = -eyeZ;
        this.modelview.translate(tx, ty, tz);
        this.modelviewInv.set(this.modelview);
        this.modelviewInv.invert();
        this.camera.set(this.modelview);
        this.cameraInv.set(this.modelviewInv);
        this.updateProjmodelview();
    }

    public void camera(float centerX, float centerY) {
        this.modelview.reset();
        this.modelview.translate(-centerX, -centerY);
        this.modelviewInv.set(this.modelview);
        this.modelviewInv.invert();
        this.camera.set(this.modelview);
        this.cameraInv.set(this.modelviewInv);
        this.updateProjmodelview();
    }

    @Override
    public void printCamera() {
        this.camera.print();
    }

    protected void defaultCamera() {
        this.camera();
    }

    @Override
    public void ortho() {
        this.ortho(0.0f, this.width, 0.0f, this.height, this.cameraNear, this.cameraFar);
    }

    @Override
    public void ortho(float left, float right, float bottom, float top) {
        this.ortho(left, right, bottom, top, this.cameraNear, this.cameraFar);
    }

    @Override
    public void ortho(float left, float right, float bottom, float top, float near, float far) {
        this.flush();
        float x = 2.0f / ((right -= (float)(this.width / 2)) - (left -= (float)(this.width / 2)));
        float y = 2.0f / ((top -= (float)(this.height / 2)) - (bottom -= (float)(this.height / 2)));
        float z = -2.0f / (far - near);
        float tx = -(right + left) / (right - left);
        float ty = -(top + bottom) / (top - bottom);
        float tz = -(far + near) / (far - near);
        this.projection.set(x, 0.0f, 0.0f, tx, 0.0f, -y, 0.0f, ty, 0.0f, 0.0f, z, tz, 0.0f, 0.0f, 0.0f, 1.0f);
        this.updateProjmodelview();
    }

    @Override
    public void perspective() {
        this.perspective(this.cameraFOV, this.cameraAspect, this.cameraNear, this.cameraFar);
    }

    @Override
    public void perspective(float fov, float aspect, float zNear, float zFar) {
        float ymax = zNear * (float)Math.tan(fov / 2.0f);
        float ymin = -ymax;
        float xmin = ymin * aspect;
        float xmax = ymax * aspect;
        this.frustum(xmin, xmax, ymin, ymax, zNear, zFar);
    }

    @Override
    public void frustum(float left, float right, float bottom, float top, float znear, float zfar) {
        this.flush();
        float n2 = 2.0f * znear;
        float w = right - left;
        float h = top - bottom;
        float d = zfar - znear;
        this.projection.set(n2 / w, 0.0f, (right + left) / w, 0.0f, 0.0f, -n2 / h, (top + bottom) / h, 0.0f, 0.0f, 0.0f, -(zfar + znear) / d, -(n2 * zfar) / d, 0.0f, 0.0f, -1.0f, 0.0f);
        this.updateProjmodelview();
    }

    @Override
    public void printProjection() {
        this.projection.print();
    }

    protected void defaultPerspective() {
        this.perspective();
    }

    @Override
    public float screenX(float x, float y) {
        return this.screenXImpl(x, y, 0.0f);
    }

    @Override
    public float screenY(float x, float y) {
        return this.screenYImpl(x, y, 0.0f);
    }

    @Override
    public float screenX(float x, float y, float z) {
        return this.screenXImpl(x, y, z);
    }

    @Override
    public float screenY(float x, float y, float z) {
        return this.screenYImpl(x, y, z);
    }

    @Override
    public float screenZ(float x, float y, float z) {
        return this.screenZImpl(x, y, z);
    }

    protected float screenXImpl(float x, float y, float z) {
        float ax = this.modelview.m00 * x + this.modelview.m01 * y + this.modelview.m02 * z + this.modelview.m03;
        float ay = this.modelview.m10 * x + this.modelview.m11 * y + this.modelview.m12 * z + this.modelview.m13;
        float az = this.modelview.m20 * x + this.modelview.m21 * y + this.modelview.m22 * z + this.modelview.m23;
        float aw = this.modelview.m30 * x + this.modelview.m31 * y + this.modelview.m32 * z + this.modelview.m33;
        return this.screenXImpl(ax, ay, az, aw);
    }

    protected float screenXImpl(float x, float y, float z, float w) {
        float ox = this.projection.m00 * x + this.projection.m01 * y + this.projection.m02 * z + this.projection.m03 * w;
        float ow = this.projection.m30 * x + this.projection.m31 * y + this.projection.m32 * z + this.projection.m33 * w;
        if (PGraphicsOpenGL.nonZero(ow)) {
            ox /= ow;
        }
        float sx = (float)this.width * (1.0f + ox) / 2.0f;
        return sx;
    }

    protected float screenYImpl(float x, float y, float z) {
        float ax = this.modelview.m00 * x + this.modelview.m01 * y + this.modelview.m02 * z + this.modelview.m03;
        float ay = this.modelview.m10 * x + this.modelview.m11 * y + this.modelview.m12 * z + this.modelview.m13;
        float az = this.modelview.m20 * x + this.modelview.m21 * y + this.modelview.m22 * z + this.modelview.m23;
        float aw = this.modelview.m30 * x + this.modelview.m31 * y + this.modelview.m32 * z + this.modelview.m33;
        return this.screenYImpl(ax, ay, az, aw);
    }

    protected float screenYImpl(float x, float y, float z, float w) {
        float oy = this.projection.m10 * x + this.projection.m11 * y + this.projection.m12 * z + this.projection.m13 * w;
        float ow = this.projection.m30 * x + this.projection.m31 * y + this.projection.m32 * z + this.projection.m33 * w;
        if (PGraphicsOpenGL.nonZero(ow)) {
            oy /= ow;
        }
        float sy = (float)this.height * (1.0f + oy) / 2.0f;
        sy = (float)this.height - sy;
        return sy;
    }

    protected float screenZImpl(float x, float y, float z) {
        float ax = this.modelview.m00 * x + this.modelview.m01 * y + this.modelview.m02 * z + this.modelview.m03;
        float ay = this.modelview.m10 * x + this.modelview.m11 * y + this.modelview.m12 * z + this.modelview.m13;
        float az = this.modelview.m20 * x + this.modelview.m21 * y + this.modelview.m22 * z + this.modelview.m23;
        float aw = this.modelview.m30 * x + this.modelview.m31 * y + this.modelview.m32 * z + this.modelview.m33;
        return this.screenZImpl(ax, ay, az, aw);
    }

    protected float screenZImpl(float x, float y, float z, float w) {
        float oz = this.projection.m20 * x + this.projection.m21 * y + this.projection.m22 * z + this.projection.m23 * w;
        float ow = this.projection.m30 * x + this.projection.m31 * y + this.projection.m32 * z + this.projection.m33 * w;
        if (PGraphicsOpenGL.nonZero(ow)) {
            oz /= ow;
        }
        float sz = (oz + 1.0f) / 2.0f;
        return sz;
    }

    @Override
    public float modelX(float x, float y, float z) {
        float ax = this.modelview.m00 * x + this.modelview.m01 * y + this.modelview.m02 * z + this.modelview.m03;
        float ay = this.modelview.m10 * x + this.modelview.m11 * y + this.modelview.m12 * z + this.modelview.m13;
        float az = this.modelview.m20 * x + this.modelview.m21 * y + this.modelview.m22 * z + this.modelview.m23;
        float aw = this.modelview.m30 * x + this.modelview.m31 * y + this.modelview.m32 * z + this.modelview.m33;
        float ox = this.cameraInv.m00 * ax + this.cameraInv.m01 * ay + this.cameraInv.m02 * az + this.cameraInv.m03 * aw;
        float ow = this.cameraInv.m30 * ax + this.cameraInv.m31 * ay + this.cameraInv.m32 * az + this.cameraInv.m33 * aw;
        return PGraphicsOpenGL.nonZero(ow) ? ox / ow : ox;
    }

    @Override
    public float modelY(float x, float y, float z) {
        float ax = this.modelview.m00 * x + this.modelview.m01 * y + this.modelview.m02 * z + this.modelview.m03;
        float ay = this.modelview.m10 * x + this.modelview.m11 * y + this.modelview.m12 * z + this.modelview.m13;
        float az = this.modelview.m20 * x + this.modelview.m21 * y + this.modelview.m22 * z + this.modelview.m23;
        float aw = this.modelview.m30 * x + this.modelview.m31 * y + this.modelview.m32 * z + this.modelview.m33;
        float oy = this.cameraInv.m10 * ax + this.cameraInv.m11 * ay + this.cameraInv.m12 * az + this.cameraInv.m13 * aw;
        float ow = this.cameraInv.m30 * ax + this.cameraInv.m31 * ay + this.cameraInv.m32 * az + this.cameraInv.m33 * aw;
        return PGraphicsOpenGL.nonZero(ow) ? oy / ow : oy;
    }

    @Override
    public float modelZ(float x, float y, float z) {
        float ax = this.modelview.m00 * x + this.modelview.m01 * y + this.modelview.m02 * z + this.modelview.m03;
        float ay = this.modelview.m10 * x + this.modelview.m11 * y + this.modelview.m12 * z + this.modelview.m13;
        float az = this.modelview.m20 * x + this.modelview.m21 * y + this.modelview.m22 * z + this.modelview.m23;
        float aw = this.modelview.m30 * x + this.modelview.m31 * y + this.modelview.m32 * z + this.modelview.m33;
        float oz = this.cameraInv.m20 * ax + this.cameraInv.m21 * ay + this.cameraInv.m22 * az + this.cameraInv.m23 * aw;
        float ow = this.cameraInv.m30 * ax + this.cameraInv.m31 * ay + this.cameraInv.m32 * az + this.cameraInv.m33 * aw;
        return PGraphicsOpenGL.nonZero(ow) ? oz / ow : oz;
    }

    @Override
    public void strokeWeight(float weight) {
        this.strokeWeight = weight;
    }

    @Override
    public void strokeJoin(int join) {
        this.strokeJoin = join;
    }

    @Override
    public void strokeCap(int cap) {
        this.strokeCap = cap;
    }

    @Override
    protected void fillFromCalc() {
        super.fillFromCalc();
        if (!this.setAmbient) {
            this.ambientFromCalc();
            this.setAmbient = false;
        }
    }

    @Override
    public void lights() {
        this.enableLighting();
        int colorModeSaved = this.colorMode;
        this.colorMode = 1;
        this.lightFalloff(1.0f, 0.0f, 0.0f);
        this.lightSpecular(0.0f, 0.0f, 0.0f);
        this.ambientLight(this.colorModeX * 0.5f, this.colorModeY * 0.5f, this.colorModeZ * 0.5f);
        this.directionalLight(this.colorModeX * 0.5f, this.colorModeY * 0.5f, this.colorModeZ * 0.5f, 0.0f, 0.0f, -1.0f);
        this.colorMode = colorModeSaved;
    }

    @Override
    public void noLights() {
        this.disableLighting();
        this.lightCount = 0;
    }

    @Override
    public void ambientLight(float r, float g, float b) {
        this.ambientLight(r, g, b, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public void ambientLight(float r, float g, float b, float x, float y, float z) {
        this.enableLighting();
        if (this.lightCount == 8) {
            throw new RuntimeException("can only create 8 lights");
        }
        this.lightType[this.lightCount] = 0;
        this.lightPosition(this.lightCount, x, y, z, false);
        this.lightNormal(this.lightCount, 0.0f, 0.0f, 0.0f);
        this.lightAmbient(this.lightCount, r, g, b);
        this.noLightDiffuse(this.lightCount);
        this.noLightSpecular(this.lightCount);
        this.noLightSpot(this.lightCount);
        this.lightFalloff(this.lightCount, this.currentLightFalloffConstant, this.currentLightFalloffLinear, this.currentLightFalloffQuadratic);
        ++this.lightCount;
    }

    @Override
    public void directionalLight(float r, float g, float b, float dx, float dy, float dz) {
        this.enableLighting();
        if (this.lightCount == 8) {
            throw new RuntimeException("can only create 8 lights");
        }
        this.lightType[this.lightCount] = 1;
        this.lightPosition(this.lightCount, 0.0f, 0.0f, 0.0f, true);
        this.lightNormal(this.lightCount, dx, dy, dz);
        this.noLightAmbient(this.lightCount);
        this.lightDiffuse(this.lightCount, r, g, b);
        this.lightSpecular(this.lightCount, this.currentLightSpecular[0], this.currentLightSpecular[1], this.currentLightSpecular[2]);
        this.noLightSpot(this.lightCount);
        this.noLightFalloff(this.lightCount);
        ++this.lightCount;
    }

    @Override
    public void pointLight(float r, float g, float b, float x, float y, float z) {
        this.enableLighting();
        if (this.lightCount == 8) {
            throw new RuntimeException("can only create 8 lights");
        }
        this.lightType[this.lightCount] = 2;
        this.lightPosition(this.lightCount, x, y, z, false);
        this.lightNormal(this.lightCount, 0.0f, 0.0f, 0.0f);
        this.noLightAmbient(this.lightCount);
        this.lightDiffuse(this.lightCount, r, g, b);
        this.lightSpecular(this.lightCount, this.currentLightSpecular[0], this.currentLightSpecular[1], this.currentLightSpecular[2]);
        this.noLightSpot(this.lightCount);
        this.lightFalloff(this.lightCount, this.currentLightFalloffConstant, this.currentLightFalloffLinear, this.currentLightFalloffQuadratic);
        ++this.lightCount;
    }

    @Override
    public void spotLight(float r, float g, float b, float x, float y, float z, float dx, float dy, float dz, float angle, float concentration) {
        this.enableLighting();
        if (this.lightCount == 8) {
            throw new RuntimeException("can only create 8 lights");
        }
        this.lightType[this.lightCount] = 3;
        this.lightPosition(this.lightCount, x, y, z, false);
        this.lightNormal(this.lightCount, dx, dy, dz);
        this.noLightAmbient(this.lightCount);
        this.lightDiffuse(this.lightCount, r, g, b);
        this.lightSpecular(this.lightCount, this.currentLightSpecular[0], this.currentLightSpecular[1], this.currentLightSpecular[2]);
        this.lightSpot(this.lightCount, angle, concentration);
        this.lightFalloff(this.lightCount, this.currentLightFalloffConstant, this.currentLightFalloffLinear, this.currentLightFalloffQuadratic);
        ++this.lightCount;
    }

    @Override
    public void lightFalloff(float constant, float linear, float quadratic) {
        this.currentLightFalloffConstant = constant;
        this.currentLightFalloffLinear = linear;
        this.currentLightFalloffQuadratic = quadratic;
    }

    @Override
    public void lightSpecular(float x, float y, float z) {
        this.colorCalc(x, y, z);
        this.currentLightSpecular[0] = this.calcR;
        this.currentLightSpecular[1] = this.calcG;
        this.currentLightSpecular[2] = this.calcB;
    }

    protected void enableLighting() {
        if (!this.lights) {
            this.flush();
            this.lights = true;
        }
    }

    protected void disableLighting() {
        if (this.lights) {
            this.flush();
            this.lights = false;
        }
    }

    protected void lightPosition(int num, float x, float y, float z, boolean dir) {
        this.lightPosition[4 * num + 0] = x * this.modelview.m00 + y * this.modelview.m01 + z * this.modelview.m02 + this.modelview.m03;
        this.lightPosition[4 * num + 1] = x * this.modelview.m10 + y * this.modelview.m11 + z * this.modelview.m12 + this.modelview.m13;
        this.lightPosition[4 * num + 2] = x * this.modelview.m20 + y * this.modelview.m21 + z * this.modelview.m22 + this.modelview.m23;
        this.lightPosition[4 * num + 3] = dir ? 1.0f : 0.0f;
    }

    protected void lightNormal(int num, float dx, float dy, float dz) {
        float nx = dx * this.modelviewInv.m00 + dy * this.modelviewInv.m10 + dz * this.modelviewInv.m20;
        float ny = dx * this.modelviewInv.m01 + dy * this.modelviewInv.m11 + dz * this.modelviewInv.m21;
        float nz = dx * this.modelviewInv.m02 + dy * this.modelviewInv.m12 + dz * this.modelviewInv.m22;
        float invn = 1.0f / PApplet.dist(0.0f, 0.0f, 0.0f, nx, ny, nz);
        this.lightNormal[3 * num + 0] = invn * nx;
        this.lightNormal[3 * num + 1] = invn * ny;
        this.lightNormal[3 * num + 2] = invn * nz;
    }

    protected void lightAmbient(int num, float r, float g, float b) {
        this.colorCalc(r, g, b);
        this.lightAmbient[3 * num + 0] = this.calcR;
        this.lightAmbient[3 * num + 1] = this.calcG;
        this.lightAmbient[3 * num + 2] = this.calcB;
    }

    protected void noLightAmbient(int num) {
        this.lightAmbient[3 * num + 0] = 0.0f;
        this.lightAmbient[3 * num + 1] = 0.0f;
        this.lightAmbient[3 * num + 2] = 0.0f;
    }

    protected void lightDiffuse(int num, float r, float g, float b) {
        this.colorCalc(r, g, b);
        this.lightDiffuse[3 * num + 0] = this.calcR;
        this.lightDiffuse[3 * num + 1] = this.calcG;
        this.lightDiffuse[3 * num + 2] = this.calcB;
    }

    protected void noLightDiffuse(int num) {
        this.lightDiffuse[3 * num + 0] = 0.0f;
        this.lightDiffuse[3 * num + 1] = 0.0f;
        this.lightDiffuse[3 * num + 2] = 0.0f;
    }

    protected void lightSpecular(int num, float r, float g, float b) {
        this.lightSpecular[3 * num + 0] = r;
        this.lightSpecular[3 * num + 1] = g;
        this.lightSpecular[3 * num + 2] = b;
    }

    protected void noLightSpecular(int num) {
        this.lightSpecular[3 * num + 0] = 0.0f;
        this.lightSpecular[3 * num + 1] = 0.0f;
        this.lightSpecular[3 * num + 2] = 0.0f;
    }

    protected void lightFalloff(int num, float c0, float c1, float c2) {
        this.lightFalloffCoefficients[3 * num + 0] = c0;
        this.lightFalloffCoefficients[3 * num + 1] = c1;
        this.lightFalloffCoefficients[3 * num + 2] = c2;
    }

    protected void noLightFalloff(int num) {
        this.lightFalloffCoefficients[3 * num + 0] = 1.0f;
        this.lightFalloffCoefficients[3 * num + 1] = 0.0f;
        this.lightFalloffCoefficients[3 * num + 2] = 0.0f;
    }

    protected void lightSpot(int num, float angle, float exponent) {
        this.lightSpotParameters[2 * num + 0] = Math.max(0.0f, PApplet.cos(angle));
        this.lightSpotParameters[2 * num + 1] = exponent;
    }

    protected void noLightSpot(int num) {
        this.lightSpotParameters[2 * num + 0] = 0.0f;
        this.lightSpotParameters[2 * num + 1] = 0.0f;
    }

    @Override
    protected void backgroundImpl(PImage image) {
        this.backgroundImpl();
        this.set(0, 0, image);
        if (0 < this.parent.frameCount) {
            this.clearColorBuffer = true;
        }
    }

    @Override
    protected void backgroundImpl() {
        this.flush();
        pgl.depthMask(true);
        pgl.clearDepth(1.0f);
        pgl.clear(256);
        if (this.hints[5]) {
            pgl.depthMask(false);
        } else {
            pgl.depthMask(true);
        }
        pgl.clearColor(this.backgroundR, this.backgroundG, this.backgroundB, this.backgroundA);
        pgl.clear(16384);
        if (0 < this.parent.frameCount) {
            this.clearColorBuffer = true;
        }
    }

    public void report(String where) {
        int err;
        if (!this.hints[4] && (err = pgl.getError()) != 0) {
            String errString = pgl.errorString(err);
            String msg = "OpenGL error " + err + " at " + where + ": " + errString;
            PGraphics.showWarning(msg);
        }
    }

    @Override
    public boolean isGL() {
        return true;
    }

    @Override
    public void loadPixels() {
        if (this.primarySurface && this.sized) {
            return;
        }
        boolean needEndDraw = false;
        if (!this.drawing) {
            this.beginDraw();
            needEndDraw = true;
        }
        if (!this.setgetPixels) {
            this.flush();
        }
        this.allocatePixels();
        if (!this.setgetPixels) {
            this.readPixels();
        }
        if (needEndDraw) {
            this.endDraw();
        }
    }

    protected void allocatePixels() {
        if (this.pixels == null || this.pixels.length != this.width * this.height) {
            this.pixels = new int[this.width * this.height];
            this.pixelBuffer = PGL.allocateIntBuffer(this.pixels);
        }
    }

    protected void saveSurfaceToPixels() {
        this.allocatePixels();
        this.readPixels();
    }

    protected void restoreSurfaceFromPixels() {
        this.drawPixels(0, 0, this.width, this.height);
    }

    protected void readPixels() {
        this.beginPixelsOp(1);
        try {
            pgl.readPixelsImpl(0, 0, this.width, this.height, 6408, 5121, this.pixelBuffer);
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        this.endPixelsOp();
        try {
            PGL.getIntArray(this.pixelBuffer, this.pixels);
            PGL.nativeToJavaARGB(this.pixels, this.width, this.height);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    protected void drawPixels(int x, int y, int w, int h) {
        boolean needToDrawTex;
        int len = w * h;
        if (this.nativePixels == null || this.nativePixels.length < len) {
            this.nativePixels = new int[len];
            this.nativePixelBuffer = PGL.allocateIntBuffer(this.nativePixels);
        }
        try {
            if (0 < x || 0 < y || w < this.width || h < this.height) {
                int offset0 = y * this.width + x;
                int offset1 = 0;
                for (int yc = y; yc < y + h; ++yc) {
                    System.arraycopy(this.pixels, offset0, this.nativePixels, offset1, w);
                    offset0 += this.width;
                    offset1 += w;
                }
            } else {
                PApplet.arrayCopy(this.pixels, 0, this.nativePixels, 0, len);
            }
            PGL.javaToNativeARGB(this.nativePixels, w, h);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        PGL.putIntArray(this.nativePixelBuffer, this.nativePixels);
        if (this.primarySurface && !pgl.isFBOBacked()) {
            this.loadTextureImpl(2, false);
        }
        boolean bl = needToDrawTex = this.primarySurface && (!pgl.isFBOBacked() || pgl.isFBOBacked() && pgl.isMultisampled()) || this.offscreenMultisample;
        if (needToDrawTex) {
            pgl.copyToTexture(this.texture.glTarget, this.texture.glFormat, this.texture.glName, x, y, w, h, this.nativePixelBuffer);
            this.beginPixelsOp(2);
            this.drawTexture(x, y, w, h);
            this.endPixelsOp();
        } else {
            pgl.copyToTexture(this.texture.glTarget, this.texture.glFormat, this.texture.glName, x, this.height - (y + h), w, h, this.nativePixelBuffer);
        }
    }

    @Override
    public int get(int x, int y) {
        this.loadPixels();
        this.setgetPixels = true;
        return super.get(x, y);
    }

    @Override
    protected void getImpl(int sourceX, int sourceY, int sourceWidth, int sourceHeight, PImage target, int targetX, int targetY) {
        this.loadPixels();
        this.setgetPixels = true;
        super.getImpl(sourceX, sourceY, sourceWidth, sourceHeight, target, targetX, targetY);
    }

    @Override
    public void set(int x, int y, int argb) {
        this.loadPixels();
        this.setgetPixels = true;
        super.set(x, y, argb);
    }

    @Override
    protected void setImpl(PImage sourceImage, int sourceX, int sourceY, int sourceWidth, int sourceHeight, int targetX, int targetY) {
        this.loadPixels();
        this.setgetPixels = true;
        super.setImpl(sourceImage, sourceX, sourceY, sourceWidth, sourceHeight, targetX, targetY);
    }

    public void loadTexture() {
        boolean needEndDraw = false;
        if (!this.drawing) {
            this.beginDraw();
            needEndDraw = true;
        }
        this.flush();
        if (this.primarySurface) {
            if (pgl.isFBOBacked()) {
                pgl.syncBackTexture();
            } else {
                this.loadTextureImpl(2, false);
                if (this.nativePixels == null || this.nativePixels.length < this.width * this.height) {
                    this.nativePixels = new int[this.width * this.height];
                    this.nativePixelBuffer = PGL.allocateIntBuffer(this.nativePixels);
                }
                this.beginPixelsOp(1);
                try {
                    pgl.readPixelsImpl(0, 0, this.width, this.height, 6408, 5121, this.nativePixelBuffer);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                this.endPixelsOp();
                this.texture.setNative(this.nativePixelBuffer, 0, 0, this.width, this.height);
            }
        } else if (this.offscreenMultisample) {
            this.multisampleFramebuffer.copy(this.offscreenFramebuffer, currentFramebuffer);
        }
        if (needEndDraw) {
            this.endDraw();
        }
    }

    public void updateTexture() {
        this.texture.updateTexels();
    }

    public void updateTexture(int x, int y, int w, int h) {
        this.texture.updateTexels(x, y, w, h);
    }

    public void updateDisplay() {
        this.flush();
        this.beginPixelsOp(2);
        this.drawTexture();
        this.endPixelsOp();
    }

    protected void loadTextureImpl(int sampling, boolean mipmap) {
        if (this.width == 0 || this.height == 0) {
            return;
        }
        if (this.texture == null || this.texture.contextIsOutdated()) {
            Texture.Parameters params = new Texture.Parameters(2, sampling, mipmap);
            this.texture = new Texture(this.width, this.height, params);
            this.texture.invertedY(true);
            this.texture.colorBuffer(true);
            pgPrimary.setCache(this, this.texture);
        }
    }

    protected void createPTexture() {
        this.ptexture = new Texture(this.width, this.height, this.texture.getParameters());
        this.ptexture.invertedY(true);
        this.ptexture.colorBuffer(true);
    }

    protected void swapOffscreenTextures() {
        if (this.ptexture != null) {
            int temp = this.texture.glName;
            this.texture.glName = this.ptexture.glName;
            this.ptexture.glName = temp;
            this.offscreenFramebuffer.setColorBuffer(this.texture);
        }
    }

    protected void drawTexture() {
        pgl.disable(3042);
        pgl.drawTexture(this.texture.glTarget, this.texture.glName, this.texture.glWidth, this.texture.glHeight, 0, 0, this.width, this.height);
        pgl.enable(3042);
    }

    protected void drawTexture(int x, int y, int w, int h) {
        pgl.disable(3042);
        pgl.drawTexture(this.texture.glTarget, this.texture.glName, this.texture.glWidth, this.texture.glHeight, this.width, this.height, x, y, x + w, y + h, x, this.height - (y + h), x + w, this.height - y);
        pgl.enable(3042);
    }

    protected void drawPTexture() {
        if (this.ptexture != null) {
            pgl.disable(3042);
            pgl.drawTexture(this.ptexture.glTarget, this.ptexture.glName, this.ptexture.glWidth, this.ptexture.glHeight, 0, 0, this.width, this.height);
            pgl.enable(3042);
        }
    }

    @Override
    public void mask(PImage alpha) {
        if (alpha.width != this.width || alpha.height != this.height) {
            throw new RuntimeException("The PImage used with mask() must be the same size as the applet.");
        }
        if (maskShader == null) {
            maskShader = new TextureShader(this.parent, defTextureShaderVertURL, maskShaderFragURL);
        }
        maskShader.set("mask", alpha);
        this.filter(maskShader);
    }

    @Override
    public void filter(int kind) {
        PImage temp = this.get();
        temp.filter(kind);
        this.set(0, 0, temp);
    }

    @Override
    public void filter(int kind, float param) {
        PImage temp = this.get();
        temp.filter(kind, param);
        this.set(0, 0, temp);
    }

    @Override
    public void filter(PShader shader) {
        if (!(shader instanceof TextureShader)) {
            PGraphics.showWarning(INVALID_FILTER_SHADER_ERROR);
            return;
        }
        boolean needEndDraw = false;
        if (this.primarySurface) {
            pgl.requestFBOLayer();
        } else if (!this.drawing) {
            this.beginDraw();
            needEndDraw = true;
        }
        this.loadTexture();
        if (this.filterTexture == null || this.filterTexture.contextIsOutdated()) {
            this.filterTexture = new Texture(this.texture.width, this.texture.height, this.texture.getParameters());
            this.filterTexture.invertedY(true);
            this.filterImage = this.wrapTexture(this.filterTexture);
        }
        this.filterTexture.set(this.texture);
        pgl.depthMask(false);
        pgl.disable(2929);
        this.begin2D();
        boolean prevLights = this.lights;
        this.lights = false;
        int prevTextureMode = this.textureMode;
        this.textureMode = 1;
        boolean prevStroke = this.stroke;
        this.stroke = false;
        int prevBlendMode = this.blendMode;
        this.blendMode(0);
        TextureShader prevTexShader = this.textureShader;
        this.textureShader = (TextureShader)shader;
        this.beginShape(17);
        this.texture(this.filterImage);
        this.vertex(0.0f, 0.0f, 0.0f, 0.0f);
        this.vertex(this.width, 0.0f, 1.0f, 0.0f);
        this.vertex(this.width, this.height, 1.0f, 1.0f);
        this.vertex(0.0f, this.height, 0.0f, 1.0f);
        this.endShape();
        this.end2D();
        this.textureShader = prevTexShader;
        this.stroke = prevStroke;
        this.lights = prevLights;
        this.textureMode = prevTextureMode;
        this.blendMode(prevBlendMode);
        if (!this.hints[2]) {
            pgl.enable(2929);
        }
        if (!this.hints[5]) {
            pgl.depthMask(true);
        }
        if (needEndDraw) {
            this.endDraw();
        }
    }

    @Override
    protected void blendModeImpl() {
        this.flush();
        pgl.enable(3042);
        if (this.blendMode == 0) {
            if (blendEqSupported) {
                pgl.blendEquation(32774);
            }
            pgl.blendFunc(1, 0);
        } else if (this.blendMode == 1) {
            if (blendEqSupported) {
                pgl.blendEquation(32774);
            }
            pgl.blendFunc(770, 771);
        } else if (this.blendMode == 2) {
            if (blendEqSupported) {
                pgl.blendEquation(32774);
            }
            pgl.blendFunc(770, 1);
        } else if (this.blendMode == 4) {
            if (blendEqSupported) {
                pgl.blendEquation(32774);
            }
            pgl.blendFunc(775, 0);
        } else if (this.blendMode == 8) {
            if (blendEqSupported) {
                pgl.blendEquation(32776);
                pgl.blendFunc(770, 772);
            } else {
                PGraphics.showWarning(BLEND_DRIVER_ERROR, "LIGHTEST");
            }
        } else if (this.blendMode == 16) {
            if (blendEqSupported) {
                pgl.blendEquation(32775);
                pgl.blendFunc(770, 772);
            } else {
                PGraphics.showWarning(BLEND_DRIVER_ERROR, "DARKEST");
            }
        } else if (this.blendMode == 32) {
            if (blendEqSupported) {
                pgl.blendEquation(32779);
                pgl.blendFunc(1, 1);
            } else {
                PGraphics.showWarning(BLEND_DRIVER_ERROR, "DIFFERENCE");
            }
        } else if (this.blendMode == 64) {
            if (blendEqSupported) {
                pgl.blendEquation(32774);
            }
            pgl.blendFunc(775, 769);
        } else if (this.blendMode == 128) {
            if (blendEqSupported) {
                pgl.blendEquation(32774);
            }
            pgl.blendFunc(774, 768);
        } else if (this.blendMode == 256) {
            if (blendEqSupported) {
                pgl.blendEquation(32774);
            }
            pgl.blendFunc(775, 1);
        } else if (this.blendMode == 512) {
            PGraphics.showWarning(BLEND_RENDERER_ERROR, "OVERLAY");
        } else if (this.blendMode == 1024) {
            PGraphics.showWarning(BLEND_RENDERER_ERROR, "HARD_LIGHT");
        } else if (this.blendMode == 2048) {
            PGraphics.showWarning(BLEND_RENDERER_ERROR, "SOFT_LIGHT");
        } else if (this.blendMode == 4096) {
            PGraphics.showWarning(BLEND_RENDERER_ERROR, "DODGE");
        } else if (this.blendMode == 8192) {
            PGraphics.showWarning(BLEND_RENDERER_ERROR, "BURN");
        }
    }

    public Texture getTexture() {
        this.loadTexture();
        return this.texture;
    }

    public Texture getTexture(PImage img) {
        Texture tex = (Texture)this.initCache(img);
        if (tex == null) {
            return null;
        }
        if (img.isModified() || img.isLoaded()) {
            if (img.width != tex.width || img.height != tex.height) {
                tex.init(img.width, img.height);
            }
            this.updateTexture(img, tex);
        }
        if (tex.hasBuffers()) {
            tex.bufferUpdate();
        }
        this.checkTexture(tex);
        return tex;
    }

    protected Object initCache(PImage img) {
        if (!this.checkGLThread()) {
            return null;
        }
        Texture tex = (Texture)pgPrimary.getCache(img);
        if ((tex == null || tex.contextIsOutdated()) && (tex = this.addTexture(img)) != null) {
            img.loadPixels();
            tex.set(img.pixels, img.format);
            img.setLoaded(false);
        }
        return tex;
    }

    protected void bindFrontTexture() {
        if (this.primarySurface) {
            pgl.bindFrontTexture();
        } else {
            if (this.ptexture == null) {
                this.createPTexture();
            }
            this.ptexture.bind();
        }
    }

    protected void unbindFrontTexture() {
        if (this.primarySurface) {
            pgl.unbindFrontTexture();
        } else {
            this.ptexture.unbind();
        }
    }

    protected Texture addTexture(PImage img) {
        Texture.Parameters params = new Texture.Parameters(2, this.textureSampling, this.getHint(-8), this.textureWrap);
        return this.addTexture(img, params);
    }

    protected Texture addTexture(PImage img, Texture.Parameters params) {
        if (img.width == 0 || img.height == 0) {
            return null;
        }
        if (img.parent == null) {
            img.parent = this.parent;
        }
        Texture tex = new Texture(img.width, img.height, params);
        pgPrimary.setCache(img, tex);
        return tex;
    }

    protected void checkTexture(Texture tex) {
        if (!tex.colorBuffer() && tex.usingMipmaps == this.hints[8]) {
            if (this.hints[8]) {
                tex.usingMipmaps(false, this.textureSampling);
            } else {
                tex.usingMipmaps(true, this.textureSampling);
            }
        }
        if (tex.usingRepeat && this.textureWrap == 0 || !tex.usingRepeat && this.textureWrap == 1) {
            if (this.textureWrap == 0) {
                tex.usingRepeat(false);
            } else {
                tex.usingRepeat(true);
            }
        }
    }

    protected PImage wrapTexture(Texture tex) {
        PImage img = new PImage();
        img.parent = this.parent;
        img.width = tex.width;
        img.height = tex.height;
        img.format = 2;
        pgPrimary.setCache(img, tex);
        return img;
    }

    protected void updateTexture(PImage img, Texture tex) {
        if (tex != null) {
            int x = img.getModifiedX1();
            int y = img.getModifiedY1();
            int w = img.getModifiedX2() - x;
            int h = img.getModifiedY2() - y;
            tex.set(img.pixels, x, y, w, h, img.format);
        }
        img.setModified(false);
        img.setLoaded(false);
    }

    protected void deleteSurfaceTextures() {
        if (this.texture != null) {
            this.texture.dispose();
        }
        if (this.ptexture != null) {
            this.ptexture.dispose();
        }
        if (this.filterTexture != null) {
            this.filterTexture.dispose();
        }
    }

    protected boolean checkGLThread() {
        if (pgl.threadIsCurrent()) {
            return true;
        }
        PGraphics.showWarning(OPENGL_THREAD_ERROR);
        return false;
    }

    @Override
    public void resize(int wide, int high) {
        PGraphics.showMethodWarning("resize");
    }

    protected void initPrimary() {
        pgl.initSurface(this.quality);
        if (this.texture != null) {
            pgPrimary.removeCache(this);
            this.ptexture = null;
            this.texture = null;
        }
        pgPrimary = this;
        this.initialized = true;
    }

    protected void beginOnscreenDraw() {
        pgl.beginDraw(this.clearColorBuffer);
        if (drawFramebuffer == null) {
            drawFramebuffer = new FrameBuffer(this.width, this.height, true);
        }
        drawFramebuffer.setFBO(pgl.getDrawFramebuffer());
        if (readFramebuffer == null) {
            readFramebuffer = new FrameBuffer(this.width, this.height, true);
        }
        readFramebuffer.setFBO(pgl.getReadFramebuffer());
        if (currentFramebuffer == null) {
            PGraphicsOpenGL.setFramebuffer(drawFramebuffer);
        }
        if (pgl.isFBOBacked()) {
            this.texture = pgl.wrapBackTexture(this.texture);
            this.ptexture = pgl.wrapFrontTexture(this.ptexture);
        }
    }

    protected void endOnscreenDraw() {
        pgl.endDraw(this.clearColorBuffer0);
    }

    protected void initOffscreen() {
        boolean packed;
        this.loadTextureImpl(4, false);
        if (this.offscreenFramebuffer != null) {
            this.offscreenFramebuffer.dispose();
        }
        if (this.multisampleFramebuffer != null) {
            this.multisampleFramebuffer.dispose();
        }
        boolean bl = packed = depthBits == 24 && stencilBits == 8 && packedDepthStencilSupported;
        if (fboMultisampleSupported && 1 < this.quality) {
            this.multisampleFramebuffer = new FrameBuffer(this.texture.glWidth, this.texture.glHeight, this.quality, 0, depthBits, stencilBits, packed, false);
            this.multisampleFramebuffer.clear();
            this.offscreenMultisample = true;
            this.offscreenFramebuffer = new FrameBuffer(this.texture.glWidth, this.texture.glHeight, 1, 1, 0, 0, false, false);
        } else {
            this.quality = 0;
            this.offscreenFramebuffer = new FrameBuffer(this.texture.glWidth, this.texture.glHeight, 1, 1, depthBits, stencilBits, packed, false);
            this.offscreenMultisample = false;
        }
        this.offscreenFramebuffer.setColorBuffer(this.texture);
        this.offscreenFramebuffer.clear();
        this.initialized = true;
    }

    protected void beginOffscreenDraw() {
        if (!this.initialized) {
            this.initOffscreen();
        } else {
            boolean outdatedMulti;
            boolean outdated = this.offscreenFramebuffer != null && this.offscreenFramebuffer.contextIsOutdated();
            boolean bl = outdatedMulti = this.multisampleFramebuffer != null && this.multisampleFramebuffer.contextIsOutdated();
            if (outdated || outdatedMulti) {
                this.restartPGL();
                this.initOffscreen();
            } else {
                this.swapOffscreenTextures();
            }
        }
        PGraphicsOpenGL.pushFramebuffer();
        if (this.offscreenMultisample) {
            PGraphicsOpenGL.setFramebuffer(this.multisampleFramebuffer);
        } else {
            PGraphicsOpenGL.setFramebuffer(this.offscreenFramebuffer);
        }
        this.drawPTexture();
        if (this.clip) {
            pgl.enable(3089);
            pgl.scissor(this.clipRect[0], this.clipRect[1], this.clipRect[2], this.clipRect[3]);
        } else {
            pgl.disable(3089);
        }
    }

    protected void endOffscreenDraw() {
        if (this.offscreenMultisample) {
            this.multisampleFramebuffer.copy(this.offscreenFramebuffer, currentFramebuffer);
        }
        PGraphicsOpenGL.popFramebuffer();
        this.texture.updateTexels();
        pgPrimary.restoreGL();
    }

    protected void setViewport() {
        this.viewport.put(0, 0);
        this.viewport.put(1, 0);
        this.viewport.put(2, this.width);
        this.viewport.put(3, this.height);
        pgl.viewport(this.viewport.get(0), this.viewport.get(1), this.viewport.get(2), this.viewport.get(3));
    }

    protected void setDrawDefaults() {
        this.inGeo.clear();
        this.tessGeo.clear();
        this.texCache.clear();
        super.noTexture();
        if (this.hints[2]) {
            pgl.disable(2929);
        } else {
            pgl.enable(2929);
        }
        pgl.depthFunc(515);
        this.flushMode = this.hints[6] ? 0 : 1;
        if (this.primarySurface) {
            pgl.getIntegerv(32937, intBuffer);
            int temp = intBuffer.get(0);
            if (this.quality != temp && 1 < temp && 1 < this.quality) {
                this.quality = temp;
            }
        }
        if (this.quality < 2) {
            pgl.disable(32925);
        } else {
            pgl.enable(32925);
        }
        pgl.disable(2832);
        pgl.disable(2848);
        pgl.disable(2881);
        if (this.sized) {
            this.background(this.backgroundColor);
            this.defaultPerspective();
            this.defaultCamera();
            this.sized = false;
        } else {
            this.modelview.set(this.camera);
            this.modelviewInv.set(this.cameraInv);
            this.updateProjmodelview();
        }
        if (this.is3D()) {
            this.noLights();
            this.lightFalloff(1.0f, 0.0f, 0.0f);
            this.lightSpecular(0.0f, 0.0f, 0.0f);
        }
        pgl.frontFace(2304);
        pgl.disable(2884);
        pgl.activeTexture(33984);
        this.normalZ = 0.0f;
        this.normalY = 0.0f;
        this.normalX = 0.0f;
        pgl.depthMask(true);
        pgl.clearDepth(1.0f);
        pgl.clearStencil(0);
        pgl.clear(1280);
        if (!this.settingsInited) {
            this.defaultSettings();
        }
        if (this.restoreSurface) {
            this.restoreSurfaceFromPixels();
            this.restoreSurface = false;
        }
        if (this.hints[5]) {
            pgl.depthMask(false);
        } else {
            pgl.depthMask(true);
        }
        this.pixelsOp = 0;
        this.clearColorBuffer0 = this.clearColorBuffer;
        this.clearColorBuffer = false;
        this.modified = false;
        this.setgetPixels = false;
    }

    protected void getGLParameters() {
        OPENGL_VENDOR = pgl.getString(7936);
        OPENGL_RENDERER = pgl.getString(7937);
        OPENGL_VERSION = pgl.getString(7938);
        OPENGL_EXTENSIONS = pgl.getString(7939);
        GLSL_VERSION = pgl.getString(35724);
        npotTexSupported = -1 < OPENGL_EXTENSIONS.indexOf("_texture_non_power_of_two");
        autoMipmapGenSupported = -1 < OPENGL_EXTENSIONS.indexOf("_generate_mipmap");
        fboMultisampleSupported = -1 < OPENGL_EXTENSIONS.indexOf("_framebuffer_multisample");
        packedDepthStencilSupported = -1 < OPENGL_EXTENSIONS.indexOf("_packed_depth_stencil");
        anisoSamplingSupported = -1 < OPENGL_EXTENSIONS.indexOf("_texture_filter_anisotropic");
        try {
            pgl.blendEquation(32774);
            blendEqSupported = true;
        }
        catch (Exception e) {
            blendEqSupported = false;
        }
        depthBits = pgl.getDepthBits();
        stencilBits = pgl.getStencilBits();
        pgl.getIntegerv(3379, intBuffer);
        maxTextureSize = intBuffer.get(0);
        pgl.getIntegerv(36183, intBuffer);
        maxSamples = intBuffer.get(0);
        pgl.getIntegerv(33902, intBuffer);
        maxLineWidth = intBuffer.get(0);
        pgl.getIntegerv(33901, intBuffer);
        maxPointSize = intBuffer.get(0);
        if (anisoSamplingSupported) {
            pgl.getFloatv(34047, floatBuffer);
            maxAnisoAmount = floatBuffer.get(0);
        }
        glParamsRead = true;
    }

    @Override
    public PShader loadShader(String fragFilename) {
        int shaderType = this.getShaderType(fragFilename);
        if (shaderType == -1) {
            PGraphics.showWarning(INVALID_PROCESSING_SHADER_ERROR);
            return null;
        }
        BaseShader shader = null;
        if (shaderType == 5) {
            shader = new PointShader(this.parent);
            shader.setVertexShader(defPointShaderVertURL);
        } else if (shaderType == 4) {
            shader = new LineShader(this.parent);
            shader.setVertexShader(defLineShaderVertURL);
        } else if (shaderType == 3) {
            shader = new TexlightShader(this.parent);
            shader.setVertexShader(defTexlightShaderVertURL);
        } else if (shaderType == 1) {
            shader = new LightShader(this.parent);
            shader.setVertexShader(defLightShaderVertURL);
        } else if (shaderType == 2) {
            shader = new TextureShader(this.parent);
            shader.setVertexShader(defTextureShaderVertURL);
        } else if (shaderType == 0) {
            shader = new ColorShader(this.parent);
            shader.setVertexShader(defColorShaderVertURL);
        }
        shader.setFragmentShader(fragFilename);
        return shader;
    }

    @Override
    public PShader loadShader(String fragFilename, String vertFilename) {
        int shaderType = this.getShaderType(vertFilename);
        if (shaderType == -1) {
            shaderType = this.getShaderType(fragFilename);
        }
        if (shaderType == -1) {
            PGraphics.showWarning(INVALID_PROCESSING_SHADER_ERROR);
            return null;
        }
        BaseShader shader = null;
        if (fragFilename == null || fragFilename.equals("")) {
            if (shaderType == 5) {
                shader = new PointShader(this.parent);
                shader.setFragmentShader(defPointShaderFragURL);
            } else if (shaderType == 4) {
                shader = new LineShader(this.parent);
                shader.setFragmentShader(defLineShaderFragURL);
            } else if (shaderType == 3) {
                shader = new TexlightShader(this.parent);
                shader.setFragmentShader(defTextureShaderFragURL);
            } else if (shaderType == 1) {
                shader = new LightShader(this.parent);
                shader.setFragmentShader(defColorShaderFragURL);
            } else if (shaderType == 2) {
                shader = new TextureShader(this.parent);
                shader.setFragmentShader(defTextureShaderFragURL);
            } else if (shaderType == 0) {
                shader = new ColorShader(this.parent);
                shader.setFragmentShader(defColorShaderFragURL);
            }
            if (shader != null) {
                shader.setVertexShader(vertFilename);
            }
        } else if (shaderType == 5) {
            shader = new PointShader(this.parent, vertFilename, fragFilename);
        } else if (shaderType == 4) {
            shader = new LineShader(this.parent, vertFilename, fragFilename);
        } else if (shaderType == 3) {
            shader = new TexlightShader(this.parent, vertFilename, fragFilename);
        } else if (shaderType == 1) {
            shader = new LightShader(this.parent, vertFilename, fragFilename);
        } else if (shaderType == 2) {
            shader = new TextureShader(this.parent, vertFilename, fragFilename);
        } else if (shaderType == 0) {
            shader = new ColorShader(this.parent, vertFilename, fragFilename);
        }
        return shader;
    }

    @Override
    public void shader(PShader shader) {
        this.shader(shader, 20);
    }

    @Override
    public void shader(PShader shader, int kind) {
        this.flush();
        if (kind == 9 || kind == 17 || kind == 20) {
            if (shader instanceof TextureShader) {
                this.textureShader = (TextureShader)shader;
            } else if (shader instanceof ColorShader) {
                this.colorShader = (ColorShader)shader;
            } else if (shader instanceof TexlightShader) {
                this.texlightShader = (TexlightShader)shader;
            } else if (shader instanceof LightShader) {
                this.lightShader = (LightShader)shader;
            } else {
                PGraphics.showWarning(WRONG_SHADER_TYPE_ERROR);
            }
        } else if (kind == 5) {
            if (shader instanceof LineShader) {
                this.lineShader = (LineShader)shader;
            } else {
                PGraphics.showWarning(WRONG_SHADER_TYPE_ERROR);
            }
        } else if (kind == 3) {
            if (shader instanceof PointShader) {
                this.pointShader = (PointShader)shader;
            } else {
                PGraphics.showWarning(WRONG_SHADER_TYPE_ERROR);
            }
        } else {
            PGraphics.showWarning(UNKNOWN_SHADER_KIND_ERROR);
        }
    }

    @Override
    public void resetShader() {
        this.resetShader(20);
    }

    @Override
    public void resetShader(int kind) {
        this.flush();
        if (kind == 9 || kind == 17 || kind == 20) {
            this.textureShader = null;
            this.colorShader = null;
            this.texlightShader = null;
            this.lightShader = null;
        } else if (kind == 5) {
            this.lineShader = null;
        } else if (kind == 3) {
            this.pointShader = null;
        } else {
            PGraphics.showWarning(UNKNOWN_SHADER_KIND_ERROR);
        }
    }

    public void shaderWarnings(boolean enable) {
        this.shaderWarningsEnabled = enable;
    }

    protected int getShaderType(String filename) {
        String[] source = this.parent.loadStrings(filename);
        int type = -1;
        for (int i = 0; i < source.length; ++i) {
            String line = source[i].trim();
            if (line.indexOf("#define PROCESSING_POINT_SHADER") == 0) {
                type = 5;
                continue;
            }
            if (line.indexOf("#define PROCESSING_LINE_SHADER") == 0) {
                type = 4;
                continue;
            }
            if (line.indexOf("#define PROCESSING_COLOR_SHADER") == 0) {
                type = 0;
                continue;
            }
            if (line.indexOf("#define PROCESSING_LIGHT_SHADER") == 0) {
                type = 1;
                continue;
            }
            if (line.indexOf("#define PROCESSING_TEXTURE_SHADER") == 0) {
                type = 2;
                continue;
            }
            if (line.indexOf("#define PROCESSING_TEXLIGHT_SHADER") != 0) continue;
            type = 3;
        }
        return type;
    }

    protected void deleteDefaultShaders() {
        defColorShader = null;
        defTextureShader = null;
        defLightShader = null;
        defTexlightShader = null;
        defLineShader = null;
        defPointShader = null;
        maskShader = null;
    }

    protected BaseShader getPolyShader(boolean lit, boolean tex) {
        BaseShader shader;
        if (lit) {
            if (tex) {
                if (this.texlightShader == null) {
                    if (defTexlightShader == null) {
                        defTexlightShader = new TexlightShader(this.parent, defTexlightShaderVertURL, defTextureShaderFragURL);
                    }
                    shader = defTexlightShader;
                    this.texlightShaderCheck();
                } else {
                    shader = this.texlightShader;
                }
            } else if (this.lightShader == null) {
                if (defLightShader == null) {
                    defLightShader = new LightShader(this.parent, defLightShaderVertURL, defColorShaderFragURL);
                }
                shader = defLightShader;
                this.lightShaderCheck();
            } else {
                shader = this.lightShader;
            }
        } else if (tex) {
            if (this.textureShader == null) {
                if (defTextureShader == null) {
                    defTextureShader = new TextureShader(this.parent, defTextureShaderVertURL, defTextureShaderFragURL);
                }
                shader = defTextureShader;
                this.textureShaderCheck();
            } else {
                shader = this.textureShader;
            }
        } else if (this.colorShader == null) {
            if (defColorShader == null) {
                defColorShader = new ColorShader(this.parent, defColorShaderVertURL, defColorShaderFragURL);
            }
            shader = defColorShader;
            this.colorShaderCheck();
        } else {
            shader = this.colorShader;
        }
        shader.setRenderer(this);
        shader.loadAttributes();
        shader.loadUniforms();
        return shader;
    }

    protected void texlightShaderCheck() {
        if (this.shaderWarningsEnabled && (this.lightShader != null || this.textureShader != null || this.colorShader != null)) {
            PGraphics.showWarning(NO_TEXLIGHT_SHADER_ERROR);
        }
    }

    protected void lightShaderCheck() {
        if (this.shaderWarningsEnabled && (this.texlightShader != null || this.textureShader != null || this.colorShader != null)) {
            PGraphics.showWarning(NO_LIGHT_SHADER_ERROR);
        }
    }

    protected void textureShaderCheck() {
        if (this.shaderWarningsEnabled && (this.texlightShader != null || this.lightShader != null || this.colorShader != null)) {
            PGraphics.showWarning(NO_TEXTURE_SHADER_ERROR);
        }
    }

    protected void colorShaderCheck() {
        if (this.shaderWarningsEnabled && (this.texlightShader != null || this.lightShader != null || this.textureShader != null)) {
            PGraphics.showWarning(NO_COLOR_SHADER_ERROR);
        }
    }

    protected LineShader getLineShader() {
        LineShader shader;
        if (this.lineShader == null) {
            if (defLineShader == null) {
                defLineShader = new LineShader(this.parent, defLineShaderVertURL, defLineShaderFragURL);
            }
            shader = defLineShader;
        } else {
            shader = this.lineShader;
        }
        shader.setRenderer(this);
        shader.loadAttributes();
        shader.loadUniforms();
        return shader;
    }

    protected PointShader getPointShader() {
        PointShader shader;
        if (this.pointShader == null) {
            if (defPointShader == null) {
                defPointShader = new PointShader(this.parent, defPointShaderVertURL, defPointShaderFragURL);
            }
            shader = defPointShader;
        } else {
            shader = this.pointShader;
        }
        shader.setRenderer(this);
        shader.loadAttributes();
        shader.loadUniforms();
        return shader;
    }

    protected static int expandArraySize(int currSize, int newMinSize) {
        int newSize;
        for (newSize = currSize; newSize < newMinSize; newSize <<= 1) {
        }
        return newSize;
    }

    protected InGeometry newInGeometry(int mode) {
        return new InGeometry(mode);
    }

    protected TessGeometry newTessGeometry(int mode) {
        return new TessGeometry(mode);
    }

    protected TexCache newTexCache() {
        return new TexCache();
    }

    static {
        pgPrimary = null;
        pgCurrent = null;
        glParamsRead = false;
        glTextureObjects = new HashMap();
        glVertexBuffers = new HashMap();
        glFrameBuffers = new HashMap();
        glRenderBuffers = new HashMap();
        glslPrograms = new HashMap();
        glslVertexShaders = new HashMap();
        glslFragmentShaders = new HashMap();
        defColorShaderVertURL = PGraphicsOpenGL.class.getResource("ColorVert.glsl");
        defTextureShaderVertURL = PGraphicsOpenGL.class.getResource("TextureVert.glsl");
        defLightShaderVertURL = PGraphicsOpenGL.class.getResource("LightVert.glsl");
        defTexlightShaderVertURL = PGraphicsOpenGL.class.getResource("TexlightVert.glsl");
        defColorShaderFragURL = PGraphicsOpenGL.class.getResource("ColorFrag.glsl");
        defTextureShaderFragURL = PGraphicsOpenGL.class.getResource("TextureFrag.glsl");
        defLineShaderVertURL = PGraphicsOpenGL.class.getResource("LineVert.glsl");
        defLineShaderFragURL = PGraphicsOpenGL.class.getResource("LineFrag.glsl");
        defPointShaderVertURL = PGraphicsOpenGL.class.getResource("PointVert.glsl");
        defPointShaderFragURL = PGraphicsOpenGL.class.getResource("PointFrag.glsl");
        maskShaderFragURL = PGraphicsOpenGL.class.getResource("MaskFrag.glsl");
        identity = new PMatrix3D();
        fbStack = new FrameBuffer[16];
    }

    protected class Tessellator {
        InGeometry in;
        TessGeometry tess;
        TexCache texCache;
        PImage prevTexImage;
        PImage newTexImage;
        int firstTexIndex;
        int firstTexCache;
        PGL.Tessellator gluTess;
        TessellatorCallback callback = new TessellatorCallback();
        boolean fill;
        boolean stroke;
        int strokeColor;
        float strokeWeight;
        int strokeJoin;
        int strokeCap;
        boolean accurate2DStrokes = true;
        PMatrix transform = null;
        float transformScale;
        boolean is2D = false;
        boolean is3D = true;
        int[] rawIndices;
        int rawSize;
        int[] dupIndices;
        int dupCount;
        int firstPolyIndexCache;
        int lastPolyIndexCache;
        int firstLineIndexCache;
        int lastLineIndexCache;
        int firstPointIndexCache;
        int lastPointIndexCache;

        public Tessellator() {
            this.gluTess = pgl.createTessellator(this.callback);
            this.rawIndices = new int[512];
        }

        void setInGeometry(InGeometry in) {
            this.in = in;
            this.firstPolyIndexCache = -1;
            this.lastPolyIndexCache = -1;
            this.firstLineIndexCache = -1;
            this.lastLineIndexCache = -1;
            this.firstPointIndexCache = -1;
            this.lastPointIndexCache = -1;
        }

        void setTessGeometry(TessGeometry tess) {
            this.tess = tess;
        }

        void setFill(boolean fill) {
            this.fill = fill;
        }

        void setStroke(boolean stroke) {
            this.stroke = stroke;
        }

        void setStrokeColor(int color) {
            this.strokeColor = PGL.javaToNativeARGB(color);
        }

        void setStrokeWeight(float weight) {
            this.strokeWeight = weight;
        }

        void setStrokeJoin(int strokeJoin) {
            this.strokeJoin = strokeJoin;
        }

        void setStrokeCap(int strokeCap) {
            this.strokeCap = strokeCap;
        }

        void setAccurate2DStrokes(boolean accurate) {
            this.accurate2DStrokes = accurate;
        }

        void setTexCache(TexCache texCache, PImage prevTexImage, PImage newTexImage) {
            this.texCache = texCache;
            this.prevTexImage = prevTexImage;
            this.newTexImage = newTexImage;
        }

        void set3D(boolean value) {
            if (value) {
                this.is2D = false;
                this.is3D = true;
            } else {
                this.is2D = true;
                this.is3D = false;
            }
        }

        void setTransform(PMatrix transform) {
            this.transform = transform;
            this.transformScale = -1.0f;
        }

        void tessellatePoints() {
            if (this.strokeCap == 2) {
                this.tessellateRoundPoints();
            } else {
                this.tessellateSquarePoints();
            }
        }

        void tessellateRoundPoints() {
            int nInVert = this.in.lastVertex - this.in.firstVertex + 1;
            if (this.stroke && 1 <= nInVert) {
                int nPtVert = PApplet.max(20, (int)((float)Math.PI * 2 * this.strokeWeight / 10.0f)) + 1;
                if (32768 <= nPtVert) {
                    throw new RuntimeException("Error in point tessellation.");
                }
                this.updateTex();
                int nvertTot = nPtVert * nInVert;
                int nindTot = 3 * (nPtVert - 1) * nInVert;
                if (this.is3D) {
                    this.tessellateRoundPoints3D(nvertTot, nindTot, nPtVert);
                } else if (this.is2D) {
                    this.beginNoTex();
                    this.tessellateRoundPoints2D(nvertTot, nindTot, nPtVert);
                    this.endNoTex();
                }
            }
        }

        void tessellateRoundPoints3D(int nvertTot, int nindTot, int nPtVert) {
            int index;
            int perim = nPtVert - 1;
            this.tess.pointVertexCheck(nvertTot);
            this.tess.pointIndexCheck(nindTot);
            int vertIdx = this.tess.firstPointVertex;
            int attribIdx = this.tess.firstPointVertex;
            int indIdx = this.tess.firstPointIndex;
            IndexCache cache = this.tess.pointIndexCache;
            this.firstPointIndexCache = index = this.in.renderMode == 1 ? cache.addNew() : cache.getLast();
            for (int i = this.in.firstVertex; i <= this.in.lastVertex; ++i) {
                int k;
                int count = cache.vertexCount[index];
                if (32768 <= count + nPtVert) {
                    index = cache.addNew();
                    count = 0;
                }
                for (int k2 = 0; k2 < nPtVert; ++k2) {
                    this.tess.setPointVertex(vertIdx, this.in, i);
                    ++vertIdx;
                }
                this.tess.pointOffsets[2 * attribIdx + 0] = 0.0f;
                this.tess.pointOffsets[2 * attribIdx + 1] = 0.0f;
                ++attribIdx;
                float val = 0.0f;
                float inc = 720.0f / (float)perim;
                for (k = 0; k < perim; ++k) {
                    this.tess.pointOffsets[2 * attribIdx + 0] = 0.5f * cosLUT[(int)val] * this.strokeWeight;
                    this.tess.pointOffsets[2 * attribIdx + 1] = 0.5f * sinLUT[(int)val] * this.strokeWeight;
                    val = (val + inc) % 720.0f;
                    ++attribIdx;
                }
                for (k = 1; k < nPtVert - 1; ++k) {
                    this.tess.pointIndices[indIdx++] = (short)(count + 0);
                    this.tess.pointIndices[indIdx++] = (short)(count + k);
                    this.tess.pointIndices[indIdx++] = (short)(count + k + 1);
                }
                this.tess.pointIndices[indIdx++] = (short)(count + 0);
                this.tess.pointIndices[indIdx++] = (short)(count + 1);
                this.tess.pointIndices[indIdx++] = (short)(count + nPtVert - 1);
                cache.incCounts(index, 3 * (nPtVert - 1), nPtVert);
            }
            this.lastPointIndexCache = index;
        }

        void tessellateRoundPoints2D(int nvertTot, int nindTot, int nPtVert) {
            int index;
            int perim = nPtVert - 1;
            this.tess.polyVertexCheck(nvertTot);
            this.tess.polyIndexCheck(nindTot);
            int vertIdx = this.tess.firstPolyVertex;
            int indIdx = this.tess.firstPolyIndex;
            IndexCache cache = this.tess.polyIndexCache;
            this.firstPointIndexCache = index = this.in.renderMode == 1 ? cache.addNew() : cache.getLast();
            for (int i = this.in.firstVertex; i <= this.in.lastVertex; ++i) {
                int k;
                int count = cache.vertexCount[index];
                if (32768 <= count + nPtVert) {
                    index = cache.addNew();
                    count = 0;
                }
                float x0 = this.in.vertices[3 * i + 0];
                float y0 = this.in.vertices[3 * i + 1];
                int rgba = this.in.strokeColors[i];
                float val = 0.0f;
                float inc = 720.0f / (float)perim;
                this.tess.setPolyVertex(vertIdx, x0, y0, 0.0f, rgba, false);
                ++vertIdx;
                for (k = 0; k < perim; ++k) {
                    this.tess.setPolyVertex(vertIdx, x0 + 0.5f * cosLUT[(int)val] * this.strokeWeight, y0 + 0.5f * sinLUT[(int)val] * this.strokeWeight, 0.0f, rgba, false);
                    ++vertIdx;
                    val = (val + inc) % 720.0f;
                }
                for (k = 1; k < nPtVert - 1; ++k) {
                    this.tess.polyIndices[indIdx++] = (short)(count + 0);
                    this.tess.polyIndices[indIdx++] = (short)(count + k);
                    this.tess.polyIndices[indIdx++] = (short)(count + k + 1);
                }
                this.tess.polyIndices[indIdx++] = (short)(count + 0);
                this.tess.polyIndices[indIdx++] = (short)(count + 1);
                this.tess.polyIndices[indIdx++] = (short)(count + nPtVert - 1);
                cache.incCounts(index, 3 * (nPtVert - 1), nPtVert);
            }
            this.lastPointIndexCache = this.lastPolyIndexCache = index;
        }

        void tessellateSquarePoints() {
            int nInVert = this.in.lastVertex - this.in.firstVertex + 1;
            if (this.stroke && 1 <= nInVert) {
                this.updateTex();
                int quadCount = nInVert;
                int nvertTot = 5 * quadCount;
                int nindTot = 12 * quadCount;
                if (this.is3D) {
                    this.tessellateSquarePoints3D(nvertTot, nindTot);
                } else if (this.is2D) {
                    this.beginNoTex();
                    this.tessellateSquarePoints2D(nvertTot, nindTot);
                    this.endNoTex();
                }
            }
        }

        void tessellateSquarePoints3D(int nvertTot, int nindTot) {
            int index;
            this.tess.pointVertexCheck(nvertTot);
            this.tess.pointIndexCheck(nindTot);
            int vertIdx = this.tess.firstPointVertex;
            int attribIdx = this.tess.firstPointVertex;
            int indIdx = this.tess.firstPointIndex;
            IndexCache cache = this.tess.pointIndexCache;
            this.firstPointIndexCache = index = this.in.renderMode == 1 ? cache.addNew() : cache.getLast();
            for (int i = this.in.firstVertex; i <= this.in.lastVertex; ++i) {
                int k;
                int count = cache.vertexCount[index];
                int nvert = 5;
                if (32768 <= count + nvert) {
                    index = cache.addNew();
                    count = 0;
                }
                for (k = 0; k < nvert; ++k) {
                    this.tess.setPointVertex(vertIdx, this.in, i);
                    ++vertIdx;
                }
                this.tess.pointOffsets[2 * attribIdx + 0] = 0.0f;
                this.tess.pointOffsets[2 * attribIdx + 1] = 0.0f;
                ++attribIdx;
                for (k = 0; k < 4; ++k) {
                    this.tess.pointOffsets[2 * attribIdx + 0] = 0.5f * PGraphicsOpenGL.this.QUAD_POINT_SIGNS[k][0] * this.strokeWeight;
                    this.tess.pointOffsets[2 * attribIdx + 1] = 0.5f * PGraphicsOpenGL.this.QUAD_POINT_SIGNS[k][1] * this.strokeWeight;
                    ++attribIdx;
                }
                for (k = 1; k < nvert - 1; ++k) {
                    this.tess.pointIndices[indIdx++] = (short)(count + 0);
                    this.tess.pointIndices[indIdx++] = (short)(count + k);
                    this.tess.pointIndices[indIdx++] = (short)(count + k + 1);
                }
                this.tess.pointIndices[indIdx++] = (short)(count + 0);
                this.tess.pointIndices[indIdx++] = (short)(count + 1);
                this.tess.pointIndices[indIdx++] = (short)(count + nvert - 1);
                cache.incCounts(index, 12, 5);
            }
            this.lastPointIndexCache = index;
        }

        void tessellateSquarePoints2D(int nvertTot, int nindTot) {
            int index;
            this.tess.polyVertexCheck(nvertTot);
            this.tess.polyIndexCheck(nindTot);
            boolean clamp = this.clampSquarePoints2D();
            int vertIdx = this.tess.firstPolyVertex;
            int indIdx = this.tess.firstPolyIndex;
            IndexCache cache = this.tess.polyIndexCache;
            this.firstPointIndexCache = index = this.in.renderMode == 1 ? cache.addNew() : cache.getLast();
            for (int i = this.in.firstVertex; i <= this.in.lastVertex; ++i) {
                int k;
                int count = cache.vertexCount[index];
                int nvert = 5;
                if (32768 <= count + nvert) {
                    index = cache.addNew();
                    count = 0;
                }
                float x0 = this.in.vertices[3 * i + 0];
                float y0 = this.in.vertices[3 * i + 1];
                int rgba = this.in.strokeColors[i];
                this.tess.setPolyVertex(vertIdx, x0, y0, 0.0f, rgba, clamp);
                ++vertIdx;
                for (k = 0; k < nvert - 1; ++k) {
                    this.tess.setPolyVertex(vertIdx, x0 + 0.5f * PGraphicsOpenGL.this.QUAD_POINT_SIGNS[k][0] * this.strokeWeight, y0 + 0.5f * PGraphicsOpenGL.this.QUAD_POINT_SIGNS[k][1] * this.strokeWeight, 0.0f, rgba, clamp);
                    ++vertIdx;
                }
                for (k = 1; k < nvert - 1; ++k) {
                    this.tess.polyIndices[indIdx++] = (short)(count + 0);
                    this.tess.polyIndices[indIdx++] = (short)(count + k);
                    this.tess.polyIndices[indIdx++] = (short)(count + k + 1);
                }
                this.tess.polyIndices[indIdx++] = (short)(count + 0);
                this.tess.polyIndices[indIdx++] = (short)(count + 1);
                this.tess.polyIndices[indIdx++] = (short)(count + nvert - 1);
                cache.incCounts(index, 12, 5);
            }
            this.lastPointIndexCache = this.lastPolyIndexCache = index;
        }

        boolean clamp2D() {
            return this.is2D && this.tess.renderMode == 0 && PGraphicsOpenGL.zero(PGraphicsOpenGL.this.modelview.m01) && PGraphicsOpenGL.zero(PGraphicsOpenGL.this.modelview.m10);
        }

        boolean clampSquarePoints2D() {
            return this.clamp2D();
        }

        void tessellateLines() {
            int nInVert = this.in.lastVertex - this.in.firstVertex + 1;
            if (this.stroke && 2 <= nInVert) {
                this.updateTex();
                int lineCount = nInVert / 2;
                if (this.is3D) {
                    this.tessellateLines3D(lineCount);
                } else if (this.is2D) {
                    this.beginNoTex();
                    this.tessellateLines2D(lineCount);
                    this.endNoTex();
                }
            }
        }

        void tessellateLines3D(int lineCount) {
            int index;
            int nvert = lineCount * 4;
            int nind = lineCount * 2 * 3;
            int first = this.in.firstVertex;
            this.tess.lineVertexCheck(nvert);
            this.tess.lineIndexCheck(nind);
            this.firstLineIndexCache = index = this.in.renderMode == 1 ? this.tess.lineIndexCache.addNew() : this.tess.lineIndexCache.getLast();
            for (int ln = 0; ln < lineCount; ++ln) {
                int i0 = first + 2 * ln + 0;
                int i1 = first + 2 * ln + 1;
                index = this.addLineSegment3D(i0, i1, index, null, false);
            }
            this.lastLineIndexCache = index;
        }

        void tessellateLines2D(int lineCount) {
            int nvert = lineCount * 4;
            int nind = lineCount * 2 * 3;
            int first = this.in.firstVertex;
            if (this.noCapsJoins(nvert)) {
                int index;
                this.tess.polyVertexCheck(nvert);
                this.tess.polyIndexCheck(nind);
                this.firstLineIndexCache = index = this.in.renderMode == 1 ? this.tess.polyIndexCache.addNew() : this.tess.polyIndexCache.getLast();
                if (this.firstPolyIndexCache == -1) {
                    this.firstPolyIndexCache = index;
                }
                boolean clamp = this.clampLines2D(lineCount);
                for (int ln = 0; ln < lineCount; ++ln) {
                    int i0 = first + 2 * ln + 0;
                    int i1 = first + 2 * ln + 1;
                    index = this.addLineSegment2D(i0, i1, index, false, clamp);
                }
                this.lastLineIndexCache = this.lastPolyIndexCache = index;
            } else {
                LinePath path = new LinePath(1);
                for (int ln = 0; ln < lineCount; ++ln) {
                    int i0 = first + 2 * ln + 0;
                    int i1 = first + 2 * ln + 1;
                    path.moveTo(this.in.vertices[3 * i0 + 0], this.in.vertices[3 * i0 + 1], this.in.strokeColors[i0]);
                    path.lineTo(this.in.vertices[3 * i1 + 0], this.in.vertices[3 * i1 + 1], this.in.strokeColors[i1]);
                }
                this.tessellateLinePath(path);
            }
        }

        boolean clampLines2D(int lineCount) {
            boolean res = this.clamp2D();
            if (res) {
                int i1;
                int i0;
                int first = this.in.firstVertex;
                for (int ln = 0; ln < lineCount && (res = this.segmentIsAxisAligned(i0 = first + 2 * ln + 0, i1 = first + 2 * ln + 1)); ++ln) {
                }
            }
            return res;
        }

        void tessellateLineStrip() {
            int nInVert = this.in.lastVertex - this.in.firstVertex + 1;
            if (this.stroke && 2 <= nInVert) {
                this.updateTex();
                int lineCount = nInVert - 1;
                if (this.is3D) {
                    this.tessellateLineStrip3D(lineCount);
                } else if (this.is2D) {
                    this.beginNoTex();
                    this.tessellateLineStrip2D(lineCount);
                    this.endNoTex();
                }
            }
        }

        void tessellateLineStrip3D(int lineCount) {
            int index;
            int nBevelTr = this.noCapsJoins() ? 0 : lineCount - 1;
            int nvert = lineCount * 4 + nBevelTr;
            int nind = lineCount * 2 * 3 + nBevelTr * 2 * 3;
            this.tess.lineVertexCheck(nvert);
            this.tess.lineIndexCheck(nind);
            this.firstLineIndexCache = index = this.in.renderMode == 1 ? this.tess.lineIndexCache.addNew() : this.tess.lineIndexCache.getLast();
            int i0 = this.in.firstVertex;
            short[] lastInd = new short[]{-1, -1};
            for (int ln = 0; ln < lineCount; ++ln) {
                int i1 = this.in.firstVertex + ln + 1;
                index = 0 < nBevelTr ? this.addLineSegment3D(i0, i1, index, lastInd, false) : this.addLineSegment3D(i0, i1, index, null, false);
                i0 = i1;
            }
            this.lastLineIndexCache = index;
        }

        void tessellateLineStrip2D(int lineCount) {
            int nvert = lineCount * 4;
            int nind = lineCount * 2 * 3;
            if (this.noCapsJoins(nvert)) {
                int index;
                this.tess.polyVertexCheck(nvert);
                this.tess.polyIndexCheck(nind);
                this.firstLineIndexCache = index = this.in.renderMode == 1 ? this.tess.polyIndexCache.addNew() : this.tess.polyIndexCache.getLast();
                if (this.firstPolyIndexCache == -1) {
                    this.firstPolyIndexCache = index;
                }
                int i0 = this.in.firstVertex;
                boolean clamp = this.clampLineStrip2D(lineCount);
                for (int ln = 0; ln < lineCount; ++ln) {
                    int i1 = this.in.firstVertex + ln + 1;
                    index = this.addLineSegment2D(i0, i1, index, false, clamp);
                    i0 = i1;
                }
                this.lastLineIndexCache = this.lastPolyIndexCache = index;
            } else {
                int first = this.in.firstVertex;
                LinePath path = new LinePath(1);
                path.moveTo(this.in.vertices[3 * first + 0], this.in.vertices[3 * first + 1], this.in.strokeColors[first]);
                for (int ln = 0; ln < lineCount; ++ln) {
                    int i1 = first + ln + 1;
                    path.lineTo(this.in.vertices[3 * i1 + 0], this.in.vertices[3 * i1 + 1], this.in.strokeColors[i1]);
                }
                this.tessellateLinePath(path);
            }
        }

        boolean clampLineStrip2D(int lineCount) {
            boolean res = this.clamp2D();
            if (res) {
                int i1;
                int i0 = this.in.firstVertex;
                for (int ln = 0; ln < lineCount && (res = this.segmentIsAxisAligned(i0, i1 = this.in.firstVertex + ln + 1)); ++ln) {
                }
            }
            return res;
        }

        void tessellateLineLoop() {
            int nInVert = this.in.lastVertex - this.in.firstVertex + 1;
            if (this.stroke && 2 <= nInVert) {
                this.updateTex();
                int lineCount = nInVert;
                if (this.is3D) {
                    this.tessellateLineLoop3D(lineCount);
                } else if (this.is2D) {
                    this.beginNoTex();
                    this.tessellateLineLoop2D(lineCount);
                    this.endNoTex();
                }
            }
        }

        void tessellateLineLoop3D(int lineCount) {
            int index;
            int nBevelTr = this.noCapsJoins() ? 0 : lineCount;
            int nvert = lineCount * 4 + nBevelTr;
            int nind = lineCount * 2 * 3 + nBevelTr * 2 * 3;
            this.tess.lineVertexCheck(nvert);
            this.tess.lineIndexCheck(nind);
            this.firstLineIndexCache = index = this.in.renderMode == 1 ? this.tess.lineIndexCache.addNew() : this.tess.lineIndexCache.getLast();
            int i0 = this.in.firstVertex;
            short[] lastInd = new short[]{-1, -1};
            short firstInd = -1;
            for (int ln = 0; ln < lineCount - 1; ++ln) {
                int i1 = this.in.firstVertex + ln + 1;
                if (0 < nBevelTr) {
                    index = this.addLineSegment3D(i0, i1, index, lastInd, false);
                    if (ln == 0) {
                        firstInd = (short)(lastInd[0] - 2);
                    }
                } else {
                    index = this.addLineSegment3D(i0, i1, index, null, false);
                }
                i0 = i1;
            }
            index = this.addLineSegment3D(this.in.lastVertex, this.in.firstVertex, index, lastInd, false);
            if (0 < nBevelTr) {
                index = this.addBevel3D(this.in.firstVertex, index, lastInd, firstInd, false);
            }
            this.lastLineIndexCache = index;
        }

        void tessellateLineLoop2D(int lineCount) {
            int nvert = lineCount * 4;
            int nind = lineCount * 2 * 3;
            if (this.noCapsJoins(nvert)) {
                int index;
                this.tess.polyVertexCheck(nvert);
                this.tess.polyIndexCheck(nind);
                this.firstLineIndexCache = index = this.in.renderMode == 1 ? this.tess.polyIndexCache.addNew() : this.tess.polyIndexCache.getLast();
                if (this.firstPolyIndexCache == -1) {
                    this.firstPolyIndexCache = index;
                }
                int i0 = this.in.firstVertex;
                boolean clamp = this.clampLineLoop2D(lineCount);
                for (int ln = 0; ln < lineCount - 1; ++ln) {
                    int i1 = this.in.firstVertex + ln + 1;
                    index = this.addLineSegment2D(i0, i1, index, false, clamp);
                    i0 = i1;
                }
                this.lastLineIndexCache = this.lastPolyIndexCache = (index = this.addLineSegment2D(this.in.lastVertex, this.in.firstVertex, index, false, clamp));
            } else {
                int first = this.in.firstVertex;
                LinePath path = new LinePath(1);
                path.moveTo(this.in.vertices[3 * first + 0], this.in.vertices[3 * first + 1], this.in.strokeColors[first]);
                for (int ln = 0; ln < lineCount - 1; ++ln) {
                    int i1 = first + ln + 1;
                    path.lineTo(this.in.vertices[3 * i1 + 0], this.in.vertices[3 * i1 + 1], this.in.strokeColors[i1]);
                }
                path.closePath();
                this.tessellateLinePath(path);
            }
        }

        boolean clampLineLoop2D(int lineCount) {
            boolean res = this.clamp2D();
            if (res) {
                int i1;
                int i0 = this.in.firstVertex;
                for (int ln = 0; ln < lineCount && (res = this.segmentIsAxisAligned(i0, i1 = this.in.firstVertex + ln + 1)); ++ln) {
                }
            }
            return res;
        }

        void tessellateEdges() {
            if (this.stroke) {
                if (this.in.edgeCount == 0) {
                    return;
                }
                if (this.is3D) {
                    this.tessellateEdges3D();
                } else if (this.is2D) {
                    this.beginNoTex();
                    this.tessellateEdges2D();
                    this.endNoTex();
                }
            }
        }

        void tessellateEdges3D() {
            int index;
            boolean bevel = !this.noCapsJoins();
            int nInVert = this.in.getNumEdgeVertices(bevel);
            int nInInd = this.in.getNumEdgeIndices(bevel);
            this.tess.lineVertexCheck(nInVert);
            this.tess.lineIndexCheck(nInInd);
            this.firstLineIndexCache = index = this.in.renderMode == 1 ? this.tess.lineIndexCache.addNew() : this.tess.lineIndexCache.getLast();
            short[] lastInd = new short[]{-1, -1};
            short firstInd = -1;
            for (int i = this.in.firstEdge; i <= this.in.lastEdge; ++i) {
                int[] edge = this.in.edges[i];
                int i0 = edge[0];
                int i1 = edge[1];
                if (bevel) {
                    if (edge[2] == -1) {
                        index = this.addBevel3D(edge[1], index, lastInd, firstInd, false);
                        lastInd[1] = -1;
                        lastInd[0] = -1;
                        continue;
                    }
                    index = this.addLineSegment3D(i0, i1, index, lastInd, false);
                    if (edge[2] == 1) {
                        firstInd = (short)(lastInd[0] - 2);
                    }
                    if (edge[2] != 2 && edge[2] != 3) continue;
                    lastInd[1] = -1;
                    lastInd[0] = -1;
                    continue;
                }
                if (edge[2] == -1) continue;
                index = this.addLineSegment3D(i0, i1, index, null, false);
            }
            this.lastLineIndexCache = index;
        }

        void tessellateEdges2D() {
            int nInVert = this.in.getNumEdgeVertices(false);
            if (this.noCapsJoins(nInVert)) {
                int index;
                int nInInd = this.in.getNumEdgeIndices(false);
                this.tess.polyVertexCheck(nInVert);
                this.tess.polyIndexCheck(nInInd);
                this.firstLineIndexCache = index = this.in.renderMode == 1 ? this.tess.polyIndexCache.addNew() : this.tess.polyIndexCache.getLast();
                if (this.firstPolyIndexCache == -1) {
                    this.firstPolyIndexCache = index;
                }
                boolean clamp = this.clampEdges2D();
                for (int i = this.in.firstEdge; i <= this.in.lastEdge; ++i) {
                    int[] edge = this.in.edges[i];
                    if (edge[2] == -1) continue;
                    int i0 = edge[0];
                    int i1 = edge[1];
                    index = this.addLineSegment2D(i0, i1, index, false, clamp);
                }
                this.lastLineIndexCache = this.lastPolyIndexCache = index;
            } else {
                LinePath path = new LinePath(1);
                block8: for (int i = this.in.firstEdge; i <= this.in.lastEdge; ++i) {
                    int[] edge = this.in.edges[i];
                    int i0 = edge[0];
                    int i1 = edge[1];
                    switch (edge[2]) {
                        case 0: {
                            path.lineTo(this.in.vertices[3 * i1 + 0], this.in.vertices[3 * i1 + 1], this.in.strokeColors[i1]);
                            continue block8;
                        }
                        case 1: {
                            path.moveTo(this.in.vertices[3 * i0 + 0], this.in.vertices[3 * i0 + 1], this.in.strokeColors[i0]);
                            path.lineTo(this.in.vertices[3 * i1 + 0], this.in.vertices[3 * i1 + 1], this.in.strokeColors[i1]);
                            continue block8;
                        }
                        case 2: {
                            path.lineTo(this.in.vertices[3 * i1 + 0], this.in.vertices[3 * i1 + 1], this.in.strokeColors[i1]);
                            path.moveTo(this.in.vertices[3 * i1 + 0], this.in.vertices[3 * i1 + 1], this.in.strokeColors[i1]);
                            continue block8;
                        }
                        case 3: {
                            path.moveTo(this.in.vertices[3 * i0 + 0], this.in.vertices[3 * i0 + 1], this.in.strokeColors[i0]);
                            path.lineTo(this.in.vertices[3 * i1 + 0], this.in.vertices[3 * i1 + 1], this.in.strokeColors[i1]);
                            path.moveTo(this.in.vertices[3 * i1 + 0], this.in.vertices[3 * i1 + 1], this.in.strokeColors[i1]);
                            continue block8;
                        }
                        case -1: {
                            path.closePath();
                        }
                    }
                }
                this.tessellateLinePath(path);
            }
        }

        boolean clampEdges2D() {
            boolean res = this.clamp2D();
            if (res) {
                int i1;
                int i0;
                int[] edge;
                for (int i = this.in.firstEdge; i <= this.in.lastEdge && ((edge = this.in.edges[i])[2] == -1 || (res = this.segmentIsAxisAligned(i0 = edge[0], i1 = edge[1]))); ++i) {
                }
            }
            return res;
        }

        int addLineSegment3D(int i0, int i1, int index, short[] lastInd, boolean constStroke) {
            IndexCache cache = this.tess.lineIndexCache;
            int count = cache.vertexCount[index];
            boolean addBevel = lastInd != null && -1 < lastInd[0] && -1 < lastInd[1];
            boolean newCache = false;
            if (32768 <= count + 4 + (addBevel ? 1 : 0)) {
                index = cache.addNew();
                count = 0;
                newCache = true;
            }
            int iidx = cache.indexOffset[index] + cache.indexCount[index];
            int vidx = cache.vertexOffset[index] + cache.vertexCount[index];
            int color = constStroke ? this.strokeColor : this.in.strokeColors[i0];
            int color0 = color;
            float weight = constStroke ? this.strokeWeight : this.in.strokeWeights[i0];
            this.tess.setLineVertex(vidx++, this.in, i0, i1, color, weight / 2.0f);
            this.tess.lineIndices[iidx++] = (short)(count + 0);
            this.tess.setLineVertex(vidx++, this.in, i0, i1, color, -weight / 2.0f);
            this.tess.lineIndices[iidx++] = (short)(count + 1);
            color = constStroke ? this.strokeColor : this.in.strokeColors[i1];
            weight = constStroke ? this.strokeWeight : this.in.strokeWeights[i1];
            this.tess.setLineVertex(vidx++, this.in, i1, i0, color, -weight / 2.0f);
            this.tess.lineIndices[iidx++] = (short)(count + 2);
            this.tess.lineIndices[iidx++] = (short)(count + 2);
            this.tess.lineIndices[iidx++] = (short)(count + 1);
            this.tess.setLineVertex(vidx++, this.in, i1, i0, color, weight / 2.0f);
            this.tess.lineIndices[iidx++] = (short)(count + 3);
            cache.incCounts(index, 6, 4);
            if (lastInd != null) {
                if (-1 < lastInd[0] && -1 < lastInd[1]) {
                    this.tess.setLineVertex(vidx, this.in, i0, color0);
                    if (newCache) {
                        PGraphics.showWarning(PGraphicsOpenGL.TOO_LONG_STROKE_PATH_ERROR);
                        this.tess.lineIndices[iidx++] = (short)(count + 4);
                        this.tess.lineIndices[iidx++] = (short)(count + 0);
                        this.tess.lineIndices[iidx++] = (short)(count + 0);
                        this.tess.lineIndices[iidx++] = (short)(count + 4);
                        this.tess.lineIndices[iidx++] = (short)(count + 1);
                        this.tess.lineIndices[iidx] = (short)(count + 1);
                    } else {
                        this.tess.lineIndices[iidx++] = (short)(count + 4);
                        this.tess.lineIndices[iidx++] = lastInd[0];
                        this.tess.lineIndices[iidx++] = (short)(count + 0);
                        this.tess.lineIndices[iidx++] = (short)(count + 4);
                        this.tess.lineIndices[iidx++] = lastInd[1];
                        this.tess.lineIndices[iidx] = (short)(count + 1);
                    }
                    cache.incCounts(index, 6, 1);
                }
                lastInd[0] = (short)(count + 2);
                lastInd[1] = (short)(count + 3);
            }
            return index;
        }

        int addBevel3D(int i0, int index, short[] lastInd, short firstInd, boolean constStroke) {
            int color0;
            IndexCache cache = this.tess.lineIndexCache;
            int count = cache.vertexCount[index];
            boolean addBevel = lastInd != null && -1 < lastInd[0] && -1 < lastInd[1];
            boolean newCache = false;
            if (32768 <= count + (addBevel ? 1 : 0)) {
                index = cache.addNew();
                count = 0;
                newCache = true;
            }
            int iidx = cache.indexOffset[index] + cache.indexCount[index];
            int vidx = cache.vertexOffset[index] + cache.vertexCount[index];
            int n = color0 = constStroke ? this.strokeColor : this.in.strokeColors[i0];
            if (lastInd != null && -1 < lastInd[0] && -1 < lastInd[1]) {
                this.tess.setLineVertex(vidx, this.in, i0, color0);
                if (newCache) {
                    PGraphics.showWarning(PGraphicsOpenGL.TOO_LONG_STROKE_PATH_ERROR);
                } else {
                    this.tess.lineIndices[iidx++] = (short)(count + 0);
                    this.tess.lineIndices[iidx++] = lastInd[0];
                    this.tess.lineIndices[iidx++] = (short)(firstInd + 0);
                    this.tess.lineIndices[iidx++] = (short)(count + 0);
                    this.tess.lineIndices[iidx++] = lastInd[1];
                    this.tess.lineIndices[iidx] = (short)(firstInd + 1);
                }
                cache.incCounts(index, 6, 1);
            }
            return index;
        }

        int addLineSegment2D(int i0, int i1, int index, boolean constStroke, boolean clamp) {
            float ybc;
            float xbc;
            float yac;
            float xac;
            float weight;
            IndexCache cache = this.tess.polyIndexCache;
            int count = cache.vertexCount[index];
            if (32768 <= count + 4) {
                index = cache.addNew();
                count = 0;
            }
            int iidx = cache.indexOffset[index] + cache.indexCount[index];
            int vidx = cache.vertexOffset[index] + cache.vertexCount[index];
            int color = constStroke ? this.strokeColor : this.in.strokeColors[i0];
            float f = weight = constStroke ? this.strokeWeight : this.in.strokeWeights[i0];
            if (this.subPixelStroke(weight)) {
                clamp = false;
            }
            float x0 = this.in.vertices[3 * i0 + 0];
            float y0 = this.in.vertices[3 * i0 + 1];
            float x1 = this.in.vertices[3 * i1 + 0];
            float y1 = this.in.vertices[3 * i1 + 1];
            float dirx = x1 - x0;
            float diry = y1 - y0;
            float llen = PApplet.sqrt(dirx * dirx + diry * diry);
            float normx = 0.0f;
            float normy = 0.0f;
            float dirdx = 0.0f;
            float dirdy = 0.0f;
            if (PGraphicsOpenGL.nonZero(llen)) {
                normx = -diry / llen;
                normy = dirx / llen;
                dirdx = dirx / llen * PApplet.min(0.75f, weight / 2.0f);
                dirdy = diry / llen * PApplet.min(0.75f, weight / 2.0f);
            }
            float normdx = normx * weight / 2.0f;
            float normdy = normy * weight / 2.0f;
            this.tess.setPolyVertex(vidx++, x0 + normdx - dirdx, y0 + normdy - dirdy, 0.0f, color, clamp);
            this.tess.polyIndices[iidx++] = (short)(count + 0);
            this.tess.setPolyVertex(vidx++, x0 - normdx - dirdx, y0 - normdy - dirdy, 0.0f, color, clamp);
            this.tess.polyIndices[iidx++] = (short)(count + 1);
            if (clamp) {
                xac = this.tess.polyVertices[4 * (vidx - 2) + 0];
                yac = this.tess.polyVertices[4 * (vidx - 2) + 1];
                xbc = this.tess.polyVertices[4 * (vidx - 1) + 0];
                ybc = this.tess.polyVertices[4 * (vidx - 1) + 1];
                if (PGraphicsOpenGL.same(xac, xbc) && PGraphicsOpenGL.same(yac, ybc)) {
                    this.unclampLine2D(vidx - 2, x0 + normdx - dirdx, y0 + normdy - dirdy);
                    this.unclampLine2D(vidx - 1, x0 - normdx - dirdx, y0 - normdy - dirdy);
                }
            }
            if (!constStroke) {
                color = this.in.strokeColors[i1];
                weight = this.in.strokeWeights[i1];
                normdx = normx * weight / 2.0f;
                normdy = normy * weight / 2.0f;
                if (this.subPixelStroke(weight)) {
                    clamp = false;
                }
            }
            this.tess.setPolyVertex(vidx++, x1 - normdx + dirdx, y1 - normdy + dirdy, 0.0f, color, clamp);
            this.tess.polyIndices[iidx++] = (short)(count + 2);
            this.tess.polyIndices[iidx++] = (short)(count + 2);
            this.tess.polyIndices[iidx++] = (short)(count + 0);
            this.tess.setPolyVertex(vidx++, x1 + normdx + dirdx, y1 + normdy + dirdy, 0.0f, color, clamp);
            this.tess.polyIndices[iidx++] = (short)(count + 3);
            if (clamp) {
                xac = this.tess.polyVertices[4 * (vidx - 2) + 0];
                yac = this.tess.polyVertices[4 * (vidx - 2) + 1];
                xbc = this.tess.polyVertices[4 * (vidx - 1) + 0];
                ybc = this.tess.polyVertices[4 * (vidx - 1) + 1];
                if (PGraphicsOpenGL.same(xac, xbc) && PGraphicsOpenGL.same(yac, ybc)) {
                    this.unclampLine2D(vidx - 2, x1 - normdx + dirdx, y1 - normdy + dirdy);
                    this.unclampLine2D(vidx - 1, x1 + normdx + dirdx, y1 + normdy + dirdy);
                }
            }
            cache.incCounts(index, 6, 4);
            return index;
        }

        void unclampLine2D(int tessIdx, float x, float y) {
            PMatrix3D mm = PGraphicsOpenGL.this.modelview;
            int index = 4 * tessIdx;
            this.tess.polyVertices[index++] = x * mm.m00 + y * mm.m01 + mm.m03;
            this.tess.polyVertices[index++] = x * mm.m10 + y * mm.m11 + mm.m13;
        }

        boolean noCapsJoins(int nInVert) {
            if (!this.accurate2DStrokes) {
                return true;
            }
            if (5000 <= nInVert) {
                return true;
            }
            return this.noCapsJoins();
        }

        boolean subPixelStroke(float weight) {
            float sw = this.transformScale() * weight;
            return PApplet.abs(sw - (float)((int)sw)) > 0.0f;
        }

        boolean noCapsJoins() {
            return this.tess.renderMode == 0 && this.transformScale() * this.strokeWeight < 2.0f;
        }

        float transformScale() {
            if (-1.0f < this.transformScale) {
                return this.transformScale;
            }
            float factor = 1.0f;
            if (this.transform != null) {
                if (this.transform instanceof PMatrix2D) {
                    PMatrix2D tr = (PMatrix2D)this.transform;
                    float areaScaleFactor = Math.abs(tr.m00 * tr.m11 - tr.m01 * tr.m10);
                    factor = (float)Math.sqrt(areaScaleFactor);
                } else if (this.transform instanceof PMatrix3D) {
                    PMatrix3D tr = (PMatrix3D)this.transform;
                    float volumeScaleFactor = Math.abs(tr.m00 * (tr.m11 * tr.m22 - tr.m12 * tr.m21) + tr.m01 * (tr.m12 * tr.m20 - tr.m10 * tr.m22) + tr.m02 * (tr.m10 * tr.m21 - tr.m11 * tr.m20));
                    factor = (float)Math.pow(volumeScaleFactor, 0.3333333432674408);
                }
            }
            this.transformScale = factor;
            return this.transformScale;
        }

        boolean segmentIsAxisAligned(int i0, int i1) {
            return PGraphicsOpenGL.zero(this.in.vertices[3 * i0 + 0] - this.in.vertices[3 * i1 + 0]) || PGraphicsOpenGL.zero(this.in.vertices[3 * i0 + 1] - this.in.vertices[3 * i1 + 1]);
        }

        void tessellateTriangles() {
            this.beginTex();
            int nTri = (this.in.lastVertex - this.in.firstVertex + 1) / 3;
            if (this.fill && 1 <= nTri) {
                int nInInd = 3 * nTri;
                this.setRawSize(nInInd);
                int idx = 0;
                boolean clamp = this.clampTriangles();
                int i = this.in.firstVertex;
                while (i < this.in.firstVertex + 3 * nTri) {
                    this.rawIndices[idx++] = i++;
                }
                this.splitRawIndices(clamp);
            }
            this.endTex();
            this.tessellateEdges();
        }

        boolean clampTriangles() {
            boolean res = this.clamp2D();
            if (res) {
                int nTri = (this.in.lastVertex - this.in.firstVertex + 1) / 3;
                for (int i = 0; i < nTri; ++i) {
                    int i0 = 3 * i + 0;
                    int i1 = 3 * i + 1;
                    int i2 = 3 * i + 2;
                    int count = 0;
                    if (this.segmentIsAxisAligned(i0, i1)) {
                        ++count;
                    }
                    if (this.segmentIsAxisAligned(i0, i2)) {
                        ++count;
                    }
                    if (this.segmentIsAxisAligned(i1, i2)) {
                        ++count;
                    }
                    boolean bl = res = 1 < count;
                    if (!res) break;
                }
            }
            return res;
        }

        void tessellateTriangles(int[] indices) {
            this.beginTex();
            int nInVert = this.in.lastVertex - this.in.firstVertex + 1;
            if (this.fill && 3 <= nInVert) {
                int nInInd = indices.length;
                this.setRawSize(nInInd);
                PApplet.arrayCopy(indices, this.rawIndices, nInInd);
                boolean clamp = this.clampTriangles(indices);
                this.splitRawIndices(clamp);
            }
            this.endTex();
            this.tessellateEdges();
        }

        boolean clampTriangles(int[] indices) {
            boolean res = this.clamp2D();
            if (res) {
                int nTri = indices.length;
                for (int i = 0; i < nTri; ++i) {
                    int i0 = indices[3 * i + 0];
                    int i1 = indices[3 * i + 1];
                    int i2 = indices[3 * i + 2];
                    int count = 0;
                    if (this.segmentIsAxisAligned(i0, i1)) {
                        ++count;
                    }
                    if (this.segmentIsAxisAligned(i0, i2)) {
                        ++count;
                    }
                    if (this.segmentIsAxisAligned(i1, i2)) {
                        ++count;
                    }
                    boolean bl = res = 1 < count;
                    if (!res) break;
                }
            }
            return res;
        }

        void tessellateTriangleFan() {
            this.beginTex();
            int nInVert = this.in.lastVertex - this.in.firstVertex + 1;
            if (this.fill && 3 <= nInVert) {
                int nInInd = 3 * (nInVert - 2);
                this.setRawSize(nInInd);
                int idx = 0;
                boolean clamp = this.clampTriangleFan();
                for (int i = this.in.firstVertex + 1; i < this.in.lastVertex; ++i) {
                    this.rawIndices[idx++] = this.in.firstVertex;
                    this.rawIndices[idx++] = i;
                    this.rawIndices[idx++] = i + 1;
                }
                this.splitRawIndices(clamp);
            }
            this.endTex();
            this.tessellateEdges();
        }

        boolean clampTriangleFan() {
            boolean res = this.clamp2D();
            if (res) {
                for (int i = this.in.firstVertex + 1; i < this.in.lastVertex; ++i) {
                    int i0 = this.in.firstVertex;
                    int i1 = i;
                    int i2 = i + 1;
                    int count = 0;
                    if (this.segmentIsAxisAligned(i0, i1)) {
                        ++count;
                    }
                    if (this.segmentIsAxisAligned(i0, i2)) {
                        ++count;
                    }
                    if (this.segmentIsAxisAligned(i1, i2)) {
                        ++count;
                    }
                    boolean bl = res = 1 < count;
                    if (!res) break;
                }
            }
            return res;
        }

        void tessellateTriangleStrip() {
            this.beginTex();
            int nInVert = this.in.lastVertex - this.in.firstVertex + 1;
            if (this.fill && 3 <= nInVert) {
                int nInInd = 3 * (nInVert - 2);
                this.setRawSize(nInInd);
                int idx = 0;
                boolean clamp = this.clampTriangleStrip();
                for (int i = this.in.firstVertex + 1; i < this.in.lastVertex; ++i) {
                    this.rawIndices[idx++] = i;
                    if (i % 2 == 0) {
                        this.rawIndices[idx++] = i - 1;
                        this.rawIndices[idx++] = i + 1;
                        continue;
                    }
                    this.rawIndices[idx++] = i + 1;
                    this.rawIndices[idx++] = i - 1;
                }
                this.splitRawIndices(clamp);
            }
            this.endTex();
            this.tessellateEdges();
        }

        boolean clampTriangleStrip() {
            boolean res = this.clamp2D();
            if (res) {
                for (int i = this.in.firstVertex + 1; i < this.in.lastVertex; ++i) {
                    int i2;
                    int i1;
                    int i0 = i;
                    if (i % 2 == 0) {
                        i1 = i - 1;
                        i2 = i + 1;
                    } else {
                        i1 = i + 1;
                        i2 = i - 1;
                    }
                    int count = 0;
                    if (this.segmentIsAxisAligned(i0, i1)) {
                        ++count;
                    }
                    if (this.segmentIsAxisAligned(i0, i2)) {
                        ++count;
                    }
                    if (this.segmentIsAxisAligned(i1, i2)) {
                        ++count;
                    }
                    boolean bl = res = 1 < count;
                    if (!res) break;
                }
            }
            return res;
        }

        void tessellateQuads() {
            this.beginTex();
            int quadCount = (this.in.lastVertex - this.in.firstVertex + 1) / 4;
            if (this.fill && 1 <= quadCount) {
                int nInInd = 6 * quadCount;
                this.setRawSize(nInInd);
                int idx = 0;
                boolean clamp = this.clampQuads(quadCount);
                for (int qd = 0; qd < quadCount; ++qd) {
                    int i0 = this.in.firstVertex + 4 * qd + 0;
                    int i1 = this.in.firstVertex + 4 * qd + 1;
                    int i2 = this.in.firstVertex + 4 * qd + 2;
                    int i3 = this.in.firstVertex + 4 * qd + 3;
                    this.rawIndices[idx++] = i0;
                    this.rawIndices[idx++] = i1;
                    this.rawIndices[idx++] = i2;
                    this.rawIndices[idx++] = i2;
                    this.rawIndices[idx++] = i3;
                    this.rawIndices[idx++] = i0;
                }
                this.splitRawIndices(clamp);
            }
            this.endTex();
            this.tessellateEdges();
        }

        boolean clampQuads(int quadCount) {
            boolean res = this.clamp2D();
            if (res) {
                for (int qd = 0; qd < quadCount; ++qd) {
                    int i0 = this.in.firstVertex + 4 * qd + 0;
                    int i1 = this.in.firstVertex + 4 * qd + 1;
                    int i2 = this.in.firstVertex + 4 * qd + 2;
                    int i3 = this.in.firstVertex + 4 * qd + 3;
                    boolean bl = res = this.segmentIsAxisAligned(i0, i1) && this.segmentIsAxisAligned(i1, i2) && this.segmentIsAxisAligned(i2, i3);
                    if (!res) break;
                }
            }
            return res;
        }

        void tessellateQuadStrip() {
            this.beginTex();
            int quadCount = (this.in.lastVertex - this.in.firstVertex + 1) / 2 - 1;
            if (this.fill && 1 <= quadCount) {
                int nInInd = 6 * quadCount;
                this.setRawSize(nInInd);
                int idx = 0;
                boolean clamp = this.clampQuadStrip(quadCount);
                for (int qd = 1; qd < quadCount + 1; ++qd) {
                    int i0 = this.in.firstVertex + 2 * (qd - 1);
                    int i1 = this.in.firstVertex + 2 * (qd - 1) + 1;
                    int i2 = this.in.firstVertex + 2 * qd + 1;
                    int i3 = this.in.firstVertex + 2 * qd;
                    this.rawIndices[idx++] = i0;
                    this.rawIndices[idx++] = i1;
                    this.rawIndices[idx++] = i3;
                    this.rawIndices[idx++] = i1;
                    this.rawIndices[idx++] = i2;
                    this.rawIndices[idx++] = i3;
                }
                this.splitRawIndices(clamp);
            }
            this.endTex();
            this.tessellateEdges();
        }

        boolean clampQuadStrip(int quadCount) {
            boolean res = this.clamp2D();
            if (res) {
                for (int qd = 1; qd < quadCount + 1; ++qd) {
                    int i0 = this.in.firstVertex + 2 * (qd - 1);
                    int i1 = this.in.firstVertex + 2 * (qd - 1) + 1;
                    int i2 = this.in.firstVertex + 2 * qd + 1;
                    int i3 = this.in.firstVertex + 2 * qd;
                    boolean bl = res = this.segmentIsAxisAligned(i0, i1) && this.segmentIsAxisAligned(i1, i2) && this.segmentIsAxisAligned(i2, i3);
                    if (!res) break;
                }
            }
            return res;
        }

        void splitRawIndices(boolean clamp) {
            int index;
            this.tess.polyIndexCheck(this.rawSize);
            int offset = this.tess.firstPolyIndex;
            int inInd0 = 0;
            int inInd1 = 0;
            int inMaxVert0 = this.in.firstVertex;
            int inMaxVert1 = this.in.firstVertex;
            int inMaxVertRef = inMaxVert0;
            int inMaxVertRel = -1;
            this.dupCount = 0;
            IndexCache cache = this.tess.polyIndexCache;
            this.firstPolyIndexCache = index = this.in.renderMode == 1 ? cache.addNew() : cache.getLast();
            int trCount = this.rawSize / 3;
            for (int tr = 0; tr < trCount; ++tr) {
                int ri2;
                int ri1;
                int ri0;
                if (index == -1) {
                    index = cache.addNew();
                }
                int i0 = this.rawIndices[3 * tr + 0];
                int i1 = this.rawIndices[3 * tr + 1];
                int i2 = this.rawIndices[3 * tr + 2];
                int ii0 = i0 - inMaxVertRef;
                int ii1 = i1 - inMaxVertRef;
                int ii2 = i2 - inMaxVertRef;
                int count = cache.vertexCount[index];
                if (ii0 < 0) {
                    this.addDupIndex(ii0);
                    ri0 = ii0;
                } else {
                    ri0 = count + ii0;
                }
                if (ii1 < 0) {
                    this.addDupIndex(ii1);
                    ri1 = ii1;
                } else {
                    ri1 = count + ii1;
                }
                if (ii2 < 0) {
                    this.addDupIndex(ii2);
                    ri2 = ii2;
                } else {
                    ri2 = count + ii2;
                }
                this.tess.polyIndices[offset + 3 * tr + 0] = (short)ri0;
                this.tess.polyIndices[offset + 3 * tr + 1] = (short)ri1;
                this.tess.polyIndices[offset + 3 * tr + 2] = (short)ri2;
                inInd1 = 3 * tr + 2;
                inMaxVert1 = PApplet.max(inMaxVert1, PApplet.max(i0, i1, i2));
                inMaxVert0 = PApplet.min(inMaxVert0, PApplet.min(i0, i1, i2));
                inMaxVertRel = PApplet.max(inMaxVertRel, PApplet.max(ri0, ri1, ri2));
                if ((32765 > inMaxVertRel + this.dupCount || inMaxVertRel + this.dupCount >= 32768) && tr != trCount - 1) continue;
                int nondupCount = 0;
                if (0 < this.dupCount) {
                    int i;
                    for (i = inInd0; i <= inInd1; ++i) {
                        short ri = this.tess.polyIndices[offset + i];
                        if (ri >= 0) continue;
                        this.tess.polyIndices[offset + i] = (short)(inMaxVertRel + 1 + this.dupIndexPos(ri));
                    }
                    if (inMaxVertRef <= inMaxVert1) {
                        this.tess.addPolyVertices(this.in, inMaxVertRef, inMaxVert1, clamp);
                        nondupCount = inMaxVert1 - inMaxVertRef + 1;
                    }
                    for (i = 0; i < this.dupCount; ++i) {
                        this.tess.addPolyVertex(this.in, this.dupIndices[i] + inMaxVertRef, clamp);
                    }
                } else {
                    this.tess.addPolyVertices(this.in, inMaxVert0, inMaxVert1, clamp);
                    nondupCount = inMaxVert1 - inMaxVert0 + 1;
                }
                cache.incCounts(index, inInd1 - inInd0 + 1, nondupCount + this.dupCount);
                this.lastPolyIndexCache = index;
                index = -1;
                inMaxVertRel = -1;
                inMaxVert0 = inMaxVertRef = inMaxVert1 + 1;
                inInd0 = inInd1 + 1;
                if (this.dupIndices != null) {
                    Arrays.fill(this.dupIndices, 0, this.dupCount, 0);
                }
                this.dupCount = 0;
            }
        }

        void addDupIndex(int idx) {
            int i;
            if (this.dupIndices == null) {
                this.dupIndices = new int[16];
            }
            if (this.dupIndices.length == this.dupCount) {
                int n = this.dupCount << 1;
                int[] temp = new int[n];
                PApplet.arrayCopy(this.dupIndices, 0, temp, 0, this.dupCount);
                this.dupIndices = temp;
            }
            if (idx < this.dupIndices[0]) {
                for (i = this.dupCount; i > 0; --i) {
                    this.dupIndices[i] = this.dupIndices[i - 1];
                }
                this.dupIndices[0] = idx;
                ++this.dupCount;
            } else if (this.dupIndices[this.dupCount - 1] < idx) {
                this.dupIndices[this.dupCount] = idx;
                ++this.dupCount;
            } else {
                for (i = 0; i < this.dupCount - 1 && this.dupIndices[i] != idx; ++i) {
                    if (this.dupIndices[i] >= idx || idx >= this.dupIndices[i + 1]) continue;
                    for (int j = this.dupCount; j > i + 1; --j) {
                        this.dupIndices[j] = this.dupIndices[j - 1];
                    }
                    this.dupIndices[i + 1] = idx;
                    ++this.dupCount;
                    break;
                }
            }
        }

        int dupIndexPos(int idx) {
            for (int i = 0; i < this.dupCount; ++i) {
                if (this.dupIndices[i] != idx) continue;
                return i;
            }
            return 0;
        }

        void setRawSize(int size) {
            int size0 = this.rawIndices.length;
            if (size0 < size) {
                int size1 = PGraphicsOpenGL.expandArraySize(size0, size);
                this.expandRawIndices(size1);
            }
            this.rawSize = size;
        }

        void expandRawIndices(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.rawIndices, 0, temp, 0, this.rawSize);
            this.rawIndices = temp;
        }

        void beginTex() {
            this.setFirstTexIndex(this.tess.polyIndexCount, this.tess.polyIndexCache.size - 1);
        }

        void endTex() {
            this.setLastTexIndex(this.tess.lastPolyIndex, this.tess.polyIndexCache.size - 1);
        }

        void beginNoTex() {
            this.prevTexImage = this.newTexImage;
            this.newTexImage = null;
            this.setFirstTexIndex(this.tess.polyIndexCount, this.tess.polyIndexCache.size - 1);
        }

        void endNoTex() {
            this.setLastTexIndex(this.tess.lastPolyIndex, this.tess.polyIndexCache.size - 1);
        }

        void updateTex() {
            this.beginTex();
            this.endTex();
        }

        void setFirstTexIndex(int firstIndex, int firstCache) {
            if (this.texCache != null) {
                this.firstTexIndex = firstIndex;
                this.firstTexCache = PApplet.max(0, firstCache);
            }
        }

        void setLastTexIndex(int lastIndex, int lastCache) {
            if (this.texCache != null) {
                if (this.prevTexImage != this.newTexImage || this.texCache.size == 0) {
                    this.texCache.addTexture(this.newTexImage, this.firstTexIndex, this.firstTexCache, lastIndex, lastCache);
                } else {
                    this.texCache.setLastIndex(lastIndex, lastCache);
                }
            }
        }

        void tessellatePolygon(boolean solid, boolean closed, boolean calcNormals) {
            this.beginTex();
            int nInVert = this.in.lastVertex - this.in.firstVertex + 1;
            if (this.fill && 3 <= nInVert) {
                this.firstPolyIndexCache = -1;
                boolean clamp = this.clampPolygon();
                this.callback.init(this.in.renderMode == 1, false, calcNormals, clamp);
                this.gluTess.beginPolygon();
                if (solid) {
                    this.gluTess.setWindingRule(100131);
                } else {
                    this.gluTess.setWindingRule(100130);
                }
                this.gluTess.beginContour();
                for (int i = this.in.firstVertex; i <= this.in.lastVertex; ++i) {
                    boolean breakPt = this.in.breaks[i];
                    if (breakPt) {
                        this.gluTess.endContour();
                        this.gluTess.beginContour();
                    }
                    int fa = this.in.colors[i] >> 24 & 0xFF;
                    int fr = this.in.colors[i] >> 16 & 0xFF;
                    int fg = this.in.colors[i] >> 8 & 0xFF;
                    int fb = this.in.colors[i] >> 0 & 0xFF;
                    int aa = this.in.ambient[i] >> 24 & 0xFF;
                    int ar = this.in.ambient[i] >> 16 & 0xFF;
                    int ag = this.in.ambient[i] >> 8 & 0xFF;
                    int ab = this.in.ambient[i] >> 0 & 0xFF;
                    int sa = this.in.specular[i] >> 24 & 0xFF;
                    int sr = this.in.specular[i] >> 16 & 0xFF;
                    int sg = this.in.specular[i] >> 8 & 0xFF;
                    int sb = this.in.specular[i] >> 0 & 0xFF;
                    int ea = this.in.emissive[i] >> 24 & 0xFF;
                    int er = this.in.emissive[i] >> 16 & 0xFF;
                    int eg = this.in.emissive[i] >> 8 & 0xFF;
                    int eb = this.in.emissive[i] >> 0 & 0xFF;
                    double[] vertex = new double[]{this.in.vertices[3 * i + 0], this.in.vertices[3 * i + 1], this.in.vertices[3 * i + 2], fa, fr, fg, fb, this.in.normals[3 * i + 0], this.in.normals[3 * i + 1], this.in.normals[3 * i + 2], this.in.texcoords[2 * i + 0], this.in.texcoords[2 * i + 1], aa, ar, ag, ab, sa, sr, sg, sb, ea, er, eg, eb, this.in.shininess[i]};
                    this.gluTess.addVertex(vertex);
                }
                this.gluTess.endContour();
                this.gluTess.endPolygon();
            }
            this.endTex();
            this.tessellateEdges();
        }

        boolean clampPolygon() {
            return false;
        }

        public void tessellateLinePath(LinePath path) {
            int cap;
            boolean clamp = this.clampLinePath();
            this.callback.init(this.in.renderMode == 1, true, false, clamp);
            int n = this.strokeCap == 2 ? 1 : (cap = this.strokeCap == 4 ? 2 : 0);
            int join = this.strokeJoin == 2 ? 1 : (this.strokeJoin == 32 ? 2 : 0);
            LinePath strokedPath = LinePath.createStrokedPath(path, this.strokeWeight, cap, join);
            this.gluTess.beginPolygon();
            float[] coords = new float[6];
            LinePath.PathIterator iter = strokedPath.getPathIterator();
            int rule = iter.getWindingRule();
            switch (rule) {
                case 0: {
                    this.gluTess.setWindingRule(100130);
                    break;
                }
                case 1: {
                    this.gluTess.setWindingRule(100131);
                }
            }
            while (!iter.isDone()) {
                switch (iter.currentSegment(coords)) {
                    case 0: {
                        this.gluTess.beginContour();
                    }
                    case 1: {
                        double[] vertex = new double[]{coords[0], coords[1], 0.0, coords[2], coords[3], coords[4], coords[5], 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
                        this.gluTess.addVertex(vertex);
                        break;
                    }
                    case 2: {
                        this.gluTess.endContour();
                    }
                }
                iter.next();
            }
            this.gluTess.endPolygon();
        }

        boolean clampLinePath() {
            return this.clamp2D() && this.strokeCap == 4 && this.strokeJoin == 32 && !this.subPixelStroke(this.strokeWeight);
        }

        protected class TessellatorCallback
        implements PGL.TessellatorCallback {
            boolean calcNormals;
            boolean strokeTess;
            boolean clampXY;
            IndexCache cache;
            int cacheIndex;
            int vertFirst;
            int vertCount;
            int primitive;

            protected TessellatorCallback() {
            }

            public void init(boolean addCache, boolean strokeTess, boolean calcNorm, boolean clampXY) {
                this.strokeTess = strokeTess;
                this.calcNormals = calcNorm;
                this.clampXY = clampXY;
                this.cache = Tessellator.this.tess.polyIndexCache;
                if (addCache) {
                    this.cache.addNew();
                }
            }

            @Override
            public void begin(int type) {
                this.cacheIndex = this.cache.getLast();
                if (Tessellator.this.firstPolyIndexCache == -1) {
                    Tessellator.this.firstPolyIndexCache = this.cacheIndex;
                }
                if (this.strokeTess && Tessellator.this.firstLineIndexCache == -1) {
                    Tessellator.this.firstLineIndexCache = this.cacheIndex;
                }
                this.vertFirst = this.cache.vertexCount[this.cacheIndex];
                this.vertCount = 0;
                switch (type) {
                    case 6: {
                        this.primitive = 11;
                        break;
                    }
                    case 5: {
                        this.primitive = 10;
                        break;
                    }
                    case 4: {
                        this.primitive = 9;
                    }
                }
            }

            @Override
            public void end() {
                if (32768 <= this.vertFirst + this.vertCount) {
                    this.cacheIndex = this.cache.addNew();
                    this.vertFirst = 0;
                }
                int indCount = 0;
                switch (this.primitive) {
                    case 11: {
                        indCount = 3 * (this.vertCount - 2);
                        for (int i = 1; i < this.vertCount - 1; ++i) {
                            this.addIndex(0);
                            this.addIndex(i);
                            this.addIndex(i + 1);
                            if (!this.calcNormals) continue;
                            this.calcTriNormal(0, i, i + 1);
                        }
                        break;
                    }
                    case 10: {
                        indCount = 3 * (this.vertCount - 2);
                        for (int i = 1; i < this.vertCount - 1; ++i) {
                            if (i % 2 == 0) {
                                this.addIndex(i + 1);
                                this.addIndex(i);
                                this.addIndex(i - 1);
                                if (!this.calcNormals) continue;
                                this.calcTriNormal(i + 1, i, i - 1);
                                continue;
                            }
                            this.addIndex(i - 1);
                            this.addIndex(i);
                            this.addIndex(i + 1);
                            if (!this.calcNormals) continue;
                            this.calcTriNormal(i - 1, i, i + 1);
                        }
                        break;
                    }
                    case 9: {
                        indCount = this.vertCount;
                        for (int i = 0; i < this.vertCount; ++i) {
                            this.addIndex(i);
                        }
                        if (!this.calcNormals) break;
                        for (int tr = 0; tr < this.vertCount / 3; ++tr) {
                            int i0 = 3 * tr + 0;
                            int i1 = 3 * tr + 1;
                            int i2 = 3 * tr + 2;
                            this.calcTriNormal(i0, i1, i2);
                        }
                        break;
                    }
                }
                this.cache.incCounts(this.cacheIndex, indCount, this.vertCount);
                Tessellator.this.lastPolyIndexCache = this.cacheIndex;
                if (this.strokeTess) {
                    Tessellator.this.lastLineIndexCache = this.cacheIndex;
                }
            }

            protected void addIndex(int tessIdx) {
                Tessellator.this.tess.polyIndexCheck();
                Tessellator.this.tess.polyIndices[Tessellator.this.tess.polyIndexCount - 1] = (short)(this.vertFirst + tessIdx);
            }

            protected void calcTriNormal(int tessIdx0, int tessIdx1, int tessIdx2) {
                Tessellator.this.tess.calcPolyNormal(this.vertFirst + tessIdx0, this.vertFirst + tessIdx1, this.vertFirst + tessIdx2);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void vertex(Object data) {
                if (!(data instanceof double[])) throw new RuntimeException("TessCallback vertex() data not understood");
                double[] d = (double[])data;
                int l = d.length;
                if (l < 25) {
                    throw new RuntimeException("TessCallback vertex() data is not of length 25");
                }
                if (this.vertCount >= 32768) throw new RuntimeException("The tessellator is generating too many vertices, reduce complexity of shape.");
                int fcolor = (int)d[3] << 24 | (int)d[4] << 16 | (int)d[5] << 8 | (int)d[6];
                int acolor = (int)d[12] << 24 | (int)d[13] << 16 | (int)d[14] << 8 | (int)d[15];
                int scolor = (int)d[16] << 24 | (int)d[17] << 16 | (int)d[18] << 8 | (int)d[19];
                int ecolor = (int)d[20] << 24 | (int)d[21] << 16 | (int)d[22] << 8 | (int)d[23];
                Tessellator.this.tess.addPolyVertex((float)d[0], (float)d[1], (float)d[2], fcolor, (float)d[7], (float)d[8], (float)d[9], (float)d[10], (float)d[11], acolor, scolor, ecolor, (float)d[24], this.clampXY);
                ++this.vertCount;
            }

            @Override
            public void error(int errnum) {
                String estring = pgl.tessError(errnum);
                PGraphics.showWarning(PGraphicsOpenGL.TESSELLATION_ERROR, estring);
            }

            @Override
            public void combine(double[] coords, Object[] data, float[] weight, Object[] outData) {
                double[] vertex = new double[33];
                vertex[0] = coords[0];
                vertex[1] = coords[1];
                vertex[2] = coords[2];
                for (int i = 3; i < 25; ++i) {
                    vertex[i] = 0.0;
                    for (int j = 0; j < 4; ++j) {
                        double[] vertData = (double[])data[j];
                        if (vertData == null) continue;
                        int n = i;
                        vertex[n] = vertex[n] + (double)weight[j] * vertData[i];
                    }
                }
                double sum = vertex[7] * vertex[7] + vertex[8] * vertex[8] + vertex[9] * vertex[9];
                double len = Math.sqrt(sum);
                vertex[7] = vertex[7] / len;
                vertex[8] = vertex[8] / len;
                vertex[9] = vertex[9] / len;
                outData[0] = vertex;
            }
        }
    }

    protected class TessGeometry {
        int renderMode;
        int polyVertexCount;
        int firstPolyVertex;
        int lastPolyVertex;
        FloatBuffer polyVerticesBuffer;
        IntBuffer polyColorsBuffer;
        FloatBuffer polyNormalsBuffer;
        FloatBuffer polyTexCoordsBuffer;
        IntBuffer polyAmbientBuffer;
        IntBuffer polySpecularBuffer;
        IntBuffer polyEmissiveBuffer;
        FloatBuffer polyShininessBuffer;
        int polyIndexCount;
        int firstPolyIndex;
        int lastPolyIndex;
        ShortBuffer polyIndicesBuffer;
        IndexCache polyIndexCache;
        int lineVertexCount;
        int firstLineVertex;
        int lastLineVertex;
        FloatBuffer lineVerticesBuffer;
        IntBuffer lineColorsBuffer;
        FloatBuffer lineDirectionsBuffer;
        int lineIndexCount;
        int firstLineIndex;
        int lastLineIndex;
        ShortBuffer lineIndicesBuffer;
        IndexCache lineIndexCache;
        int pointVertexCount;
        int firstPointVertex;
        int lastPointVertex;
        FloatBuffer pointVerticesBuffer;
        IntBuffer pointColorsBuffer;
        FloatBuffer pointOffsetsBuffer;
        int pointIndexCount;
        int firstPointIndex;
        int lastPointIndex;
        ShortBuffer pointIndicesBuffer;
        IndexCache pointIndexCache;
        float[] polyVertices;
        int[] polyColors;
        float[] polyNormals;
        float[] polyTexCoords;
        int[] polyAmbient;
        int[] polySpecular;
        int[] polyEmissive;
        float[] polyShininess;
        short[] polyIndices;
        float[] lineVertices;
        int[] lineColors;
        float[] lineDirections;
        short[] lineIndices;
        float[] pointVertices;
        int[] pointColors;
        float[] pointOffsets;
        short[] pointIndices;

        TessGeometry(int mode) {
            this.polyIndexCache = new IndexCache();
            this.lineIndexCache = new IndexCache();
            this.pointIndexCache = new IndexCache();
            this.renderMode = mode;
            this.allocate();
        }

        void allocate() {
            this.polyVertices = new float[256];
            this.polyColors = new int[64];
            this.polyNormals = new float[192];
            this.polyTexCoords = new float[128];
            this.polyAmbient = new int[64];
            this.polySpecular = new int[64];
            this.polyEmissive = new int[64];
            this.polyShininess = new float[64];
            this.polyIndices = new short[64];
            this.lineVertices = new float[256];
            this.lineColors = new int[64];
            this.lineDirections = new float[256];
            this.lineIndices = new short[64];
            this.pointVertices = new float[256];
            this.pointColors = new int[64];
            this.pointOffsets = new float[128];
            this.pointIndices = new short[64];
            this.polyVerticesBuffer = PGL.allocateFloatBuffer(this.polyVertices);
            this.polyColorsBuffer = PGL.allocateIntBuffer(this.polyColors);
            this.polyNormalsBuffer = PGL.allocateFloatBuffer(this.polyNormals);
            this.polyTexCoordsBuffer = PGL.allocateFloatBuffer(this.polyTexCoords);
            this.polyAmbientBuffer = PGL.allocateIntBuffer(this.polyAmbient);
            this.polySpecularBuffer = PGL.allocateIntBuffer(this.polySpecular);
            this.polyEmissiveBuffer = PGL.allocateIntBuffer(this.polyEmissive);
            this.polyShininessBuffer = PGL.allocateFloatBuffer(this.polyShininess);
            this.polyIndicesBuffer = PGL.allocateShortBuffer(this.polyIndices);
            this.lineVerticesBuffer = PGL.allocateFloatBuffer(this.lineVertices);
            this.lineColorsBuffer = PGL.allocateIntBuffer(this.lineColors);
            this.lineDirectionsBuffer = PGL.allocateFloatBuffer(this.lineDirections);
            this.lineIndicesBuffer = PGL.allocateShortBuffer(this.lineIndices);
            this.pointVerticesBuffer = PGL.allocateFloatBuffer(this.pointVertices);
            this.pointColorsBuffer = PGL.allocateIntBuffer(this.pointColors);
            this.pointOffsetsBuffer = PGL.allocateFloatBuffer(this.pointOffsets);
            this.pointIndicesBuffer = PGL.allocateShortBuffer(this.pointIndices);
            this.clear();
        }

        void clear() {
            this.polyVertexCount = 0;
            this.lastPolyVertex = 0;
            this.firstPolyVertex = 0;
            this.polyIndexCount = 0;
            this.lastPolyIndex = 0;
            this.firstPolyIndex = 0;
            this.lineVertexCount = 0;
            this.lastLineVertex = 0;
            this.firstLineVertex = 0;
            this.lineIndexCount = 0;
            this.lastLineIndex = 0;
            this.firstLineIndex = 0;
            this.pointVertexCount = 0;
            this.lastPointVertex = 0;
            this.firstPointVertex = 0;
            this.pointIndexCount = 0;
            this.lastPointIndex = 0;
            this.firstPointIndex = 0;
            this.polyIndexCache.clear();
            this.lineIndexCache.clear();
            this.pointIndexCache.clear();
        }

        void polyVertexCheck() {
            if (this.polyVertexCount == this.polyVertices.length / 4) {
                int newSize = this.polyVertexCount << 1;
                this.expandPolyVertices(newSize);
                this.expandPolyColors(newSize);
                this.expandPolyNormals(newSize);
                this.expandPolyTexCoords(newSize);
                this.expandPolyAmbient(newSize);
                this.expandPolySpecular(newSize);
                this.expandPolyEmissive(newSize);
                this.expandPolyShininess(newSize);
            }
            this.firstPolyVertex = this.polyVertexCount++;
            this.lastPolyVertex = this.polyVertexCount - 1;
        }

        void polyVertexCheck(int count) {
            int oldSize = this.polyVertices.length / 4;
            if (this.polyVertexCount + count > oldSize) {
                int newSize = PGraphicsOpenGL.expandArraySize(oldSize, this.polyVertexCount + count);
                this.expandPolyVertices(newSize);
                this.expandPolyColors(newSize);
                this.expandPolyNormals(newSize);
                this.expandPolyTexCoords(newSize);
                this.expandPolyAmbient(newSize);
                this.expandPolySpecular(newSize);
                this.expandPolyEmissive(newSize);
                this.expandPolyShininess(newSize);
            }
            this.firstPolyVertex = this.polyVertexCount;
            this.polyVertexCount += count;
            this.lastPolyVertex = this.polyVertexCount - 1;
        }

        void polyIndexCheck(int count) {
            int oldSize = this.polyIndices.length;
            if (this.polyIndexCount + count > oldSize) {
                int newSize = PGraphicsOpenGL.expandArraySize(oldSize, this.polyIndexCount + count);
                this.expandPolyIndices(newSize);
            }
            this.firstPolyIndex = this.polyIndexCount;
            this.polyIndexCount += count;
            this.lastPolyIndex = this.polyIndexCount - 1;
        }

        void polyIndexCheck() {
            if (this.polyIndexCount == this.polyIndices.length) {
                int newSize = this.polyIndexCount << 1;
                this.expandPolyIndices(newSize);
            }
            this.firstPolyIndex = this.polyIndexCount++;
            this.lastPolyIndex = this.polyIndexCount - 1;
        }

        void lineVertexCheck(int count) {
            int oldSize = this.lineVertices.length / 4;
            if (this.lineVertexCount + count > oldSize) {
                int newSize = PGraphicsOpenGL.expandArraySize(oldSize, this.lineVertexCount + count);
                this.expandLineVertices(newSize);
                this.expandLineColors(newSize);
                this.expandLineDirections(newSize);
            }
            this.firstLineVertex = this.lineVertexCount;
            this.lineVertexCount += count;
            this.lastLineVertex = this.lineVertexCount - 1;
        }

        void lineIndexCheck(int count) {
            int oldSize = this.lineIndices.length;
            if (this.lineIndexCount + count > oldSize) {
                int newSize = PGraphicsOpenGL.expandArraySize(oldSize, this.lineIndexCount + count);
                this.expandLineIndices(newSize);
            }
            this.firstLineIndex = this.lineIndexCount;
            this.lineIndexCount += count;
            this.lastLineIndex = this.lineIndexCount - 1;
        }

        void pointVertexCheck(int count) {
            int oldSize = this.pointVertices.length / 4;
            if (this.pointVertexCount + count > oldSize) {
                int newSize = PGraphicsOpenGL.expandArraySize(oldSize, this.pointVertexCount + count);
                this.expandPointVertices(newSize);
                this.expandPointColors(newSize);
                this.expandPointOffsets(newSize);
            }
            this.firstPointVertex = this.pointVertexCount;
            this.pointVertexCount += count;
            this.lastPointVertex = this.pointVertexCount - 1;
        }

        void pointIndexCheck(int count) {
            int oldSize = this.pointIndices.length;
            if (this.pointIndexCount + count > oldSize) {
                int newSize = PGraphicsOpenGL.expandArraySize(oldSize, this.pointIndexCount + count);
                this.expandPointIndices(newSize);
            }
            this.firstPointIndex = this.pointIndexCount;
            this.pointIndexCount += count;
            this.lastPointIndex = this.pointIndexCount - 1;
        }

        boolean isFull() {
            return 32768 <= this.polyVertexCount || 32768 <= this.lineVertexCount || 32768 <= this.pointVertexCount;
        }

        void getPolyVertexMin(PVector v, int first, int last) {
            for (int i = first; i <= last; ++i) {
                int index = 4 * i;
                v.x = PApplet.min(v.x, this.polyVertices[index++]);
                v.y = PApplet.min(v.y, this.polyVertices[index++]);
                v.z = PApplet.min(v.z, this.polyVertices[index]);
            }
        }

        void getLineVertexMin(PVector v, int first, int last) {
            for (int i = first; i <= last; ++i) {
                int index = 4 * i;
                v.x = PApplet.min(v.x, this.lineVertices[index++]);
                v.y = PApplet.min(v.y, this.lineVertices[index++]);
                v.z = PApplet.min(v.z, this.lineVertices[index]);
            }
        }

        void getPointVertexMin(PVector v, int first, int last) {
            for (int i = first; i <= last; ++i) {
                int index = 4 * i;
                v.x = PApplet.min(v.x, this.pointVertices[index++]);
                v.y = PApplet.min(v.y, this.pointVertices[index++]);
                v.z = PApplet.min(v.z, this.pointVertices[index]);
            }
        }

        void getPolyVertexMax(PVector v, int first, int last) {
            for (int i = first; i <= last; ++i) {
                int index = 4 * i;
                v.x = PApplet.max(v.x, this.polyVertices[index++]);
                v.y = PApplet.max(v.y, this.polyVertices[index++]);
                v.z = PApplet.max(v.z, this.polyVertices[index]);
            }
        }

        void getLineVertexMax(PVector v, int first, int last) {
            for (int i = first; i <= last; ++i) {
                int index = 4 * i;
                v.x = PApplet.max(v.x, this.lineVertices[index++]);
                v.y = PApplet.max(v.y, this.lineVertices[index++]);
                v.z = PApplet.max(v.z, this.lineVertices[index]);
            }
        }

        void getPointVertexMax(PVector v, int first, int last) {
            for (int i = first; i <= last; ++i) {
                int index = 4 * i;
                v.x = PApplet.max(v.x, this.pointVertices[index++]);
                v.y = PApplet.max(v.y, this.pointVertices[index++]);
                v.z = PApplet.max(v.z, this.pointVertices[index]);
            }
        }

        int getPolyVertexSum(PVector v, int first, int last) {
            for (int i = first; i <= last; ++i) {
                int index = 4 * i;
                v.x += this.polyVertices[index++];
                v.y += this.polyVertices[index++];
                v.z += this.polyVertices[index];
            }
            return last - first + 1;
        }

        int getLineVertexSum(PVector v, int first, int last) {
            for (int i = first; i <= last; ++i) {
                int index = 4 * i;
                v.x += this.lineVertices[index++];
                v.y += this.lineVertices[index++];
                v.z += this.lineVertices[index];
            }
            return last - first + 1;
        }

        int getPointVertexSum(PVector v, int first, int last) {
            for (int i = first; i <= last; ++i) {
                int index = 4 * i;
                v.x += this.pointVertices[index++];
                v.y += this.pointVertices[index++];
                v.z += this.pointVertices[index];
            }
            return last - first + 1;
        }

        protected void updatePolyVerticesBuffer() {
            this.updatePolyVerticesBuffer(0, this.polyVertexCount);
        }

        protected void updatePolyVerticesBuffer(int offset, int size) {
            PGL.updateFloatBuffer(this.polyVerticesBuffer, this.polyVertices, 4 * offset, 4 * size);
        }

        protected void updatePolyColorsBuffer() {
            this.updatePolyColorsBuffer(0, this.polyVertexCount);
        }

        protected void updatePolyColorsBuffer(int offset, int size) {
            PGL.updateIntBuffer(this.polyColorsBuffer, this.polyColors, offset, size);
        }

        protected void updatePolyNormalsBuffer() {
            this.updatePolyNormalsBuffer(0, this.polyVertexCount);
        }

        protected void updatePolyNormalsBuffer(int offset, int size) {
            PGL.updateFloatBuffer(this.polyNormalsBuffer, this.polyNormals, 3 * offset, 3 * size);
        }

        protected void updatePolyTexCoordsBuffer() {
            this.updatePolyTexCoordsBuffer(0, this.polyVertexCount);
        }

        protected void updatePolyTexCoordsBuffer(int offset, int size) {
            PGL.updateFloatBuffer(this.polyTexCoordsBuffer, this.polyTexCoords, 2 * offset, 2 * size);
        }

        protected void updatePolyAmbientBuffer() {
            this.updatePolyAmbientBuffer(0, this.polyVertexCount);
        }

        protected void updatePolyAmbientBuffer(int offset, int size) {
            PGL.updateIntBuffer(this.polyAmbientBuffer, this.polyAmbient, offset, size);
        }

        protected void updatePolySpecularBuffer() {
            this.updatePolySpecularBuffer(0, this.polyVertexCount);
        }

        protected void updatePolySpecularBuffer(int offset, int size) {
            PGL.updateIntBuffer(this.polySpecularBuffer, this.polySpecular, offset, size);
        }

        protected void updatePolyEmissiveBuffer() {
            this.updatePolyEmissiveBuffer(0, this.polyVertexCount);
        }

        protected void updatePolyEmissiveBuffer(int offset, int size) {
            PGL.updateIntBuffer(this.polyEmissiveBuffer, this.polyEmissive, offset, size);
        }

        protected void updatePolyShininessBuffer() {
            this.updatePolyShininessBuffer(0, this.polyVertexCount);
        }

        protected void updatePolyShininessBuffer(int offset, int size) {
            PGL.updateFloatBuffer(this.polyShininessBuffer, this.polyShininess, offset, size);
        }

        protected void updatePolyIndicesBuffer() {
            this.updatePolyIndicesBuffer(0, this.polyIndexCount);
        }

        protected void updatePolyIndicesBuffer(int offset, int size) {
            PGL.updateShortBuffer(this.polyIndicesBuffer, this.polyIndices, offset, size);
        }

        protected void updateLineVerticesBuffer() {
            this.updateLineVerticesBuffer(0, this.lineVertexCount);
        }

        protected void updateLineVerticesBuffer(int offset, int size) {
            PGL.updateFloatBuffer(this.lineVerticesBuffer, this.lineVertices, 4 * offset, 4 * size);
        }

        protected void updateLineColorsBuffer() {
            this.updateLineColorsBuffer(0, this.lineVertexCount);
        }

        protected void updateLineColorsBuffer(int offset, int size) {
            PGL.updateIntBuffer(this.lineColorsBuffer, this.lineColors, offset, size);
        }

        protected void updateLineDirectionsBuffer() {
            this.updateLineDirectionsBuffer(0, this.lineVertexCount);
        }

        protected void updateLineDirectionsBuffer(int offset, int size) {
            PGL.updateFloatBuffer(this.lineDirectionsBuffer, this.lineDirections, 4 * offset, 4 * size);
        }

        protected void updateLineIndicesBuffer() {
            this.updateLineIndicesBuffer(0, this.lineIndexCount);
        }

        protected void updateLineIndicesBuffer(int offset, int size) {
            PGL.updateShortBuffer(this.lineIndicesBuffer, this.lineIndices, offset, size);
        }

        protected void updatePointVerticesBuffer() {
            this.updatePointVerticesBuffer(0, this.pointVertexCount);
        }

        protected void updatePointVerticesBuffer(int offset, int size) {
            PGL.updateFloatBuffer(this.pointVerticesBuffer, this.pointVertices, 4 * offset, 4 * size);
        }

        protected void updatePointColorsBuffer() {
            this.updatePointColorsBuffer(0, this.pointVertexCount);
        }

        protected void updatePointColorsBuffer(int offset, int size) {
            PGL.updateIntBuffer(this.pointColorsBuffer, this.pointColors, offset, size);
        }

        protected void updatePointOffsetsBuffer() {
            this.updatePointOffsetsBuffer(0, this.pointVertexCount);
        }

        protected void updatePointOffsetsBuffer(int offset, int size) {
            PGL.updateFloatBuffer(this.pointOffsetsBuffer, this.pointOffsets, 2 * offset, 2 * size);
        }

        protected void updatePointIndicesBuffer() {
            this.updatePointIndicesBuffer(0, this.pointIndexCount);
        }

        protected void updatePointIndicesBuffer(int offset, int size) {
            PGL.updateShortBuffer(this.pointIndicesBuffer, this.pointIndices, offset, size);
        }

        void expandPolyVertices(int n) {
            float[] temp = new float[4 * n];
            PApplet.arrayCopy(this.polyVertices, 0, temp, 0, 4 * this.polyVertexCount);
            this.polyVertices = temp;
            this.polyVerticesBuffer = PGL.allocateFloatBuffer(this.polyVertices);
        }

        void expandPolyColors(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.polyColors, 0, temp, 0, this.polyVertexCount);
            this.polyColors = temp;
            this.polyColorsBuffer = PGL.allocateIntBuffer(this.polyColors);
        }

        void expandPolyNormals(int n) {
            float[] temp = new float[3 * n];
            PApplet.arrayCopy(this.polyNormals, 0, temp, 0, 3 * this.polyVertexCount);
            this.polyNormals = temp;
            this.polyNormalsBuffer = PGL.allocateFloatBuffer(this.polyNormals);
        }

        void expandPolyTexCoords(int n) {
            float[] temp = new float[2 * n];
            PApplet.arrayCopy(this.polyTexCoords, 0, temp, 0, 2 * this.polyVertexCount);
            this.polyTexCoords = temp;
            this.polyTexCoordsBuffer = PGL.allocateFloatBuffer(this.polyTexCoords);
        }

        void expandPolyAmbient(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.polyAmbient, 0, temp, 0, this.polyVertexCount);
            this.polyAmbient = temp;
            this.polyAmbientBuffer = PGL.allocateIntBuffer(this.polyAmbient);
        }

        void expandPolySpecular(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.polySpecular, 0, temp, 0, this.polyVertexCount);
            this.polySpecular = temp;
            this.polySpecularBuffer = PGL.allocateIntBuffer(this.polySpecular);
        }

        void expandPolyEmissive(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.polyEmissive, 0, temp, 0, this.polyVertexCount);
            this.polyEmissive = temp;
            this.polyEmissiveBuffer = PGL.allocateIntBuffer(this.polyEmissive);
        }

        void expandPolyShininess(int n) {
            float[] temp = new float[n];
            PApplet.arrayCopy(this.polyShininess, 0, temp, 0, this.polyVertexCount);
            this.polyShininess = temp;
            this.polyShininessBuffer = PGL.allocateFloatBuffer(this.polyShininess);
        }

        void expandPolyIndices(int n) {
            short[] temp = new short[n];
            PApplet.arrayCopy(this.polyIndices, 0, temp, 0, this.polyIndexCount);
            this.polyIndices = temp;
            this.polyIndicesBuffer = PGL.allocateShortBuffer(this.polyIndices);
        }

        void expandLineVertices(int n) {
            float[] temp = new float[4 * n];
            PApplet.arrayCopy(this.lineVertices, 0, temp, 0, 4 * this.lineVertexCount);
            this.lineVertices = temp;
            this.lineVerticesBuffer = PGL.allocateFloatBuffer(this.lineVertices);
        }

        void expandLineColors(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.lineColors, 0, temp, 0, this.lineVertexCount);
            this.lineColors = temp;
            this.lineColorsBuffer = PGL.allocateIntBuffer(this.lineColors);
        }

        void expandLineDirections(int n) {
            float[] temp = new float[4 * n];
            PApplet.arrayCopy(this.lineDirections, 0, temp, 0, 4 * this.lineVertexCount);
            this.lineDirections = temp;
            this.lineDirectionsBuffer = PGL.allocateFloatBuffer(this.lineDirections);
        }

        void expandLineIndices(int n) {
            short[] temp = new short[n];
            PApplet.arrayCopy(this.lineIndices, 0, temp, 0, this.lineIndexCount);
            this.lineIndices = temp;
            this.lineIndicesBuffer = PGL.allocateShortBuffer(this.lineIndices);
        }

        void expandPointVertices(int n) {
            float[] temp = new float[4 * n];
            PApplet.arrayCopy(this.pointVertices, 0, temp, 0, 4 * this.pointVertexCount);
            this.pointVertices = temp;
            this.pointVerticesBuffer = PGL.allocateFloatBuffer(this.pointVertices);
        }

        void expandPointColors(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.pointColors, 0, temp, 0, this.pointVertexCount);
            this.pointColors = temp;
            this.pointColorsBuffer = PGL.allocateIntBuffer(this.pointColors);
        }

        void expandPointOffsets(int n) {
            float[] temp = new float[2 * n];
            PApplet.arrayCopy(this.pointOffsets, 0, temp, 0, 2 * this.pointVertexCount);
            this.pointOffsets = temp;
            this.pointOffsetsBuffer = PGL.allocateFloatBuffer(this.pointOffsets);
        }

        void expandPointIndices(int n) {
            short[] temp = new short[n];
            PApplet.arrayCopy(this.pointIndices, 0, temp, 0, this.pointIndexCount);
            this.pointIndices = temp;
            this.pointIndicesBuffer = PGL.allocateShortBuffer(this.pointIndices);
        }

        void trim() {
            if (0 < this.polyVertexCount && this.polyVertexCount < this.polyVertices.length / 4) {
                this.trimPolyVertices();
                this.trimPolyColors();
                this.trimPolyNormals();
                this.trimPolyTexCoords();
                this.trimPolyAmbient();
                this.trimPolySpecular();
                this.trimPolyEmissive();
                this.trimPolyShininess();
            }
            if (0 < this.polyIndexCount && this.polyIndexCount < this.polyIndices.length) {
                this.trimPolyIndices();
            }
            if (0 < this.lineVertexCount && this.lineVertexCount < this.lineVertices.length / 4) {
                this.trimLineVertices();
                this.trimLineColors();
                this.trimLineDirections();
            }
            if (0 < this.lineIndexCount && this.lineIndexCount < this.lineIndices.length) {
                this.trimLineIndices();
            }
            if (0 < this.pointVertexCount && this.pointVertexCount < this.pointVertices.length / 4) {
                this.trimPointVertices();
                this.trimPointColors();
                this.trimPointOffsets();
            }
            if (0 < this.pointIndexCount && this.pointIndexCount < this.pointIndices.length) {
                this.trimPointIndices();
            }
        }

        void trimPolyVertices() {
            float[] temp = new float[4 * this.polyVertexCount];
            PApplet.arrayCopy(this.polyVertices, 0, temp, 0, 4 * this.polyVertexCount);
            this.polyVertices = temp;
            this.polyVerticesBuffer = PGL.allocateFloatBuffer(this.polyVertices);
        }

        void trimPolyColors() {
            int[] temp = new int[this.polyVertexCount];
            PApplet.arrayCopy(this.polyColors, 0, temp, 0, this.polyVertexCount);
            this.polyColors = temp;
            this.polyColorsBuffer = PGL.allocateIntBuffer(this.polyColors);
        }

        void trimPolyNormals() {
            float[] temp = new float[3 * this.polyVertexCount];
            PApplet.arrayCopy(this.polyNormals, 0, temp, 0, 3 * this.polyVertexCount);
            this.polyNormals = temp;
            this.polyNormalsBuffer = PGL.allocateFloatBuffer(this.polyNormals);
        }

        void trimPolyTexCoords() {
            float[] temp = new float[2 * this.polyVertexCount];
            PApplet.arrayCopy(this.polyTexCoords, 0, temp, 0, 2 * this.polyVertexCount);
            this.polyTexCoords = temp;
            this.polyTexCoordsBuffer = PGL.allocateFloatBuffer(this.polyTexCoords);
        }

        void trimPolyAmbient() {
            int[] temp = new int[this.polyVertexCount];
            PApplet.arrayCopy(this.polyAmbient, 0, temp, 0, this.polyVertexCount);
            this.polyAmbient = temp;
            this.polyAmbientBuffer = PGL.allocateIntBuffer(this.polyAmbient);
        }

        void trimPolySpecular() {
            int[] temp = new int[this.polyVertexCount];
            PApplet.arrayCopy(this.polySpecular, 0, temp, 0, this.polyVertexCount);
            this.polySpecular = temp;
            this.polySpecularBuffer = PGL.allocateIntBuffer(this.polySpecular);
        }

        void trimPolyEmissive() {
            int[] temp = new int[this.polyVertexCount];
            PApplet.arrayCopy(this.polyEmissive, 0, temp, 0, this.polyVertexCount);
            this.polyEmissive = temp;
            this.polyEmissiveBuffer = PGL.allocateIntBuffer(this.polyEmissive);
        }

        void trimPolyShininess() {
            float[] temp = new float[this.polyVertexCount];
            PApplet.arrayCopy(this.polyShininess, 0, temp, 0, this.polyVertexCount);
            this.polyShininess = temp;
            this.polyShininessBuffer = PGL.allocateFloatBuffer(this.polyShininess);
        }

        void trimPolyIndices() {
            short[] temp = new short[this.polyIndexCount];
            PApplet.arrayCopy(this.polyIndices, 0, temp, 0, this.polyIndexCount);
            this.polyIndices = temp;
            this.polyIndicesBuffer = PGL.allocateShortBuffer(this.polyIndices);
        }

        void trimLineVertices() {
            float[] temp = new float[4 * this.lineVertexCount];
            PApplet.arrayCopy(this.lineVertices, 0, temp, 0, 4 * this.lineVertexCount);
            this.lineVertices = temp;
            this.lineVerticesBuffer = PGL.allocateFloatBuffer(this.lineVertices);
        }

        void trimLineColors() {
            int[] temp = new int[this.lineVertexCount];
            PApplet.arrayCopy(this.lineColors, 0, temp, 0, this.lineVertexCount);
            this.lineColors = temp;
            this.lineColorsBuffer = PGL.allocateIntBuffer(this.lineColors);
        }

        void trimLineDirections() {
            float[] temp = new float[4 * this.lineVertexCount];
            PApplet.arrayCopy(this.lineDirections, 0, temp, 0, 4 * this.lineVertexCount);
            this.lineDirections = temp;
            this.lineDirectionsBuffer = PGL.allocateFloatBuffer(this.lineDirections);
        }

        void trimLineIndices() {
            short[] temp = new short[this.lineIndexCount];
            PApplet.arrayCopy(this.lineIndices, 0, temp, 0, this.lineIndexCount);
            this.lineIndices = temp;
            this.lineIndicesBuffer = PGL.allocateShortBuffer(this.lineIndices);
        }

        void trimPointVertices() {
            float[] temp = new float[4 * this.pointVertexCount];
            PApplet.arrayCopy(this.pointVertices, 0, temp, 0, 4 * this.pointVertexCount);
            this.pointVertices = temp;
            this.pointVerticesBuffer = PGL.allocateFloatBuffer(this.pointVertices);
        }

        void trimPointColors() {
            int[] temp = new int[this.pointVertexCount];
            PApplet.arrayCopy(this.pointColors, 0, temp, 0, this.pointVertexCount);
            this.pointColors = temp;
            this.pointColorsBuffer = PGL.allocateIntBuffer(this.pointColors);
        }

        void trimPointOffsets() {
            float[] temp = new float[2 * this.pointVertexCount];
            PApplet.arrayCopy(this.pointOffsets, 0, temp, 0, 2 * this.pointVertexCount);
            this.pointOffsets = temp;
            this.pointOffsetsBuffer = PGL.allocateFloatBuffer(this.pointOffsets);
        }

        void trimPointIndices() {
            short[] temp = new short[this.pointIndexCount];
            PApplet.arrayCopy(this.pointIndices, 0, temp, 0, this.pointIndexCount);
            this.pointIndices = temp;
            this.pointIndicesBuffer = PGL.allocateShortBuffer(this.pointIndices);
        }

        void incPolyIndices(int first, int last, int inc) {
            int i = first;
            while (i <= last) {
                int n = i++;
                this.polyIndices[n] = (short)(this.polyIndices[n] + inc);
            }
        }

        void incLineIndices(int first, int last, int inc) {
            int i = first;
            while (i <= last) {
                int n = i++;
                this.lineIndices[n] = (short)(this.lineIndices[n] + inc);
            }
        }

        void incPointIndices(int first, int last, int inc) {
            int i = first;
            while (i <= last) {
                int n = i++;
                this.pointIndices[n] = (short)(this.pointIndices[n] + inc);
            }
        }

        void calcPolyNormal(int i0, int i1, int i2) {
            int index = 4 * i0;
            float x0 = this.polyVertices[index++];
            float y0 = this.polyVertices[index++];
            float z0 = this.polyVertices[index];
            index = 4 * i1;
            float x1 = this.polyVertices[index++];
            float y1 = this.polyVertices[index++];
            float z1 = this.polyVertices[index];
            index = 4 * i2;
            float x2 = this.polyVertices[index++];
            float y2 = this.polyVertices[index++];
            float z2 = this.polyVertices[index];
            float v12x = x2 - x1;
            float v12y = y2 - y1;
            float v12z = z2 - z1;
            float v10x = x0 - x1;
            float v10y = y0 - y1;
            float v10z = z0 - z1;
            float nx = v12y * v10z - v10y * v12z;
            float ny = v12z * v10x - v10z * v12x;
            float nz = v12x * v10y - v10x * v12y;
            float d = PApplet.sqrt(nx * nx + ny * ny + nz * nz);
            index = 3 * i0;
            this.polyNormals[index++] = nx /= d;
            this.polyNormals[index++] = ny /= d;
            this.polyNormals[index] = nz /= d;
            index = 3 * i1;
            this.polyNormals[index++] = nx;
            this.polyNormals[index++] = ny;
            this.polyNormals[index] = nz;
            index = 3 * i2;
            this.polyNormals[index++] = nx;
            this.polyNormals[index++] = ny;
            this.polyNormals[index] = nz;
        }

        void setPointVertex(int tessIdx, InGeometry in, int inIdx) {
            int index = 3 * inIdx;
            float x = in.vertices[index++];
            float y = in.vertices[index++];
            float z = in.vertices[index];
            if (this.renderMode == 0 && PGraphicsOpenGL.this.flushMode == 1) {
                PMatrix3D mm = PGraphicsOpenGL.this.modelview;
                index = 4 * tessIdx;
                this.pointVertices[index++] = x * mm.m00 + y * mm.m01 + z * mm.m02 + mm.m03;
                this.pointVertices[index++] = x * mm.m10 + y * mm.m11 + z * mm.m12 + mm.m13;
                this.pointVertices[index++] = x * mm.m20 + y * mm.m21 + z * mm.m22 + mm.m23;
                this.pointVertices[index] = x * mm.m30 + y * mm.m31 + z * mm.m32 + mm.m33;
            } else {
                index = 4 * tessIdx;
                this.pointVertices[index++] = x;
                this.pointVertices[index++] = y;
                this.pointVertices[index++] = z;
                this.pointVertices[index] = 1.0f;
            }
            this.pointColors[tessIdx] = in.strokeColors[inIdx];
        }

        void setLineVertex(int tessIdx, InGeometry in, int inIdx0, int rgba) {
            int index = 3 * inIdx0;
            float x0 = in.vertices[index++];
            float y0 = in.vertices[index++];
            float z0 = in.vertices[index];
            if (this.renderMode == 0 && PGraphicsOpenGL.this.flushMode == 1) {
                PMatrix3D mm = PGraphicsOpenGL.this.modelview;
                index = 4 * tessIdx;
                this.lineVertices[index++] = x0 * mm.m00 + y0 * mm.m01 + z0 * mm.m02 + mm.m03;
                this.lineVertices[index++] = x0 * mm.m10 + y0 * mm.m11 + z0 * mm.m12 + mm.m13;
                this.lineVertices[index++] = x0 * mm.m20 + y0 * mm.m21 + z0 * mm.m22 + mm.m23;
                this.lineVertices[index] = x0 * mm.m30 + y0 * mm.m31 + z0 * mm.m32 + mm.m33;
            } else {
                index = 4 * tessIdx;
                this.lineVertices[index++] = x0;
                this.lineVertices[index++] = y0;
                this.lineVertices[index++] = z0;
                this.lineVertices[index] = 1.0f;
            }
            this.lineColors[tessIdx] = rgba;
            index = 4 * tessIdx;
            this.lineDirections[index++] = 0.0f;
            this.lineDirections[index++] = 0.0f;
            this.lineDirections[index++] = 0.0f;
            this.lineDirections[index] = 0.0f;
        }

        void setLineVertex(int tessIdx, InGeometry in, int inIdx0, int inIdx1, int rgba, float weight) {
            int index = 3 * inIdx0;
            float x0 = in.vertices[index++];
            float y0 = in.vertices[index++];
            float z0 = in.vertices[index];
            index = 3 * inIdx1;
            float x1 = in.vertices[index++];
            float y1 = in.vertices[index++];
            float z1 = in.vertices[index];
            float dx = x1 - x0;
            float dy = y1 - y0;
            float dz = z1 - z0;
            if (this.renderMode == 0 && PGraphicsOpenGL.this.flushMode == 1) {
                PMatrix3D mm = PGraphicsOpenGL.this.modelview;
                index = 4 * tessIdx;
                this.lineVertices[index++] = x0 * mm.m00 + y0 * mm.m01 + z0 * mm.m02 + mm.m03;
                this.lineVertices[index++] = x0 * mm.m10 + y0 * mm.m11 + z0 * mm.m12 + mm.m13;
                this.lineVertices[index++] = x0 * mm.m20 + y0 * mm.m21 + z0 * mm.m22 + mm.m23;
                this.lineVertices[index] = x0 * mm.m30 + y0 * mm.m31 + z0 * mm.m32 + mm.m33;
                index = 4 * tessIdx;
                this.lineDirections[index++] = dx * mm.m00 + dy * mm.m01 + dz * mm.m02;
                this.lineDirections[index++] = dx * mm.m10 + dy * mm.m11 + dz * mm.m12;
                this.lineDirections[index] = dx * mm.m20 + dy * mm.m21 + dz * mm.m22;
            } else {
                index = 4 * tessIdx;
                this.lineVertices[index++] = x0;
                this.lineVertices[index++] = y0;
                this.lineVertices[index++] = z0;
                this.lineVertices[index] = 1.0f;
                index = 4 * tessIdx;
                this.lineDirections[index++] = dx;
                this.lineDirections[index++] = dy;
                this.lineDirections[index] = dz;
            }
            this.lineColors[tessIdx] = rgba;
            this.lineDirections[4 * tessIdx + 3] = weight;
        }

        void addPolyVertex(float x, float y, float z, int rgba, float nx, float ny, float nz, float u, float v, int am, int sp, int em, float shine, boolean clampXY) {
            this.polyVertexCheck();
            int tessIdx = this.polyVertexCount - 1;
            this.setPolyVertex(tessIdx, x, y, z, rgba, nx, ny, nz, u, v, am, sp, em, shine, clampXY);
        }

        void setPolyVertex(int tessIdx, float x, float y, float z, int rgba, boolean clampXY) {
            this.setPolyVertex(tessIdx, x, y, z, rgba, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0, 0, 0, 0.0f, clampXY);
        }

        void setPolyVertex(int tessIdx, float x, float y, float z, int rgba, float nx, float ny, float nz, float u, float v, int am, int sp, int em, float shine, boolean clampXY) {
            int index;
            if (this.renderMode == 0 && PGraphicsOpenGL.this.flushMode == 1) {
                PMatrix3D mm = PGraphicsOpenGL.this.modelview;
                PMatrix3D nm = PGraphicsOpenGL.this.modelviewInv;
                index = 4 * tessIdx;
                if (clampXY) {
                    this.polyVertices[index++] = PApplet.ceil(x * mm.m00 + y * mm.m01 + z * mm.m02 + mm.m03);
                    this.polyVertices[index++] = PApplet.ceil(x * mm.m10 + y * mm.m11 + z * mm.m12 + mm.m13);
                } else {
                    this.polyVertices[index++] = x * mm.m00 + y * mm.m01 + z * mm.m02 + mm.m03;
                    this.polyVertices[index++] = x * mm.m10 + y * mm.m11 + z * mm.m12 + mm.m13;
                }
                this.polyVertices[index++] = x * mm.m20 + y * mm.m21 + z * mm.m22 + mm.m23;
                this.polyVertices[index] = x * mm.m30 + y * mm.m31 + z * mm.m32 + mm.m33;
                index = 3 * tessIdx;
                this.polyNormals[index++] = nx * nm.m00 + ny * nm.m10 + nz * nm.m20;
                this.polyNormals[index++] = nx * nm.m01 + ny * nm.m11 + nz * nm.m21;
                this.polyNormals[index] = nx * nm.m02 + ny * nm.m12 + nz * nm.m22;
            } else {
                index = 4 * tessIdx;
                this.polyVertices[index++] = x;
                this.polyVertices[index++] = y;
                this.polyVertices[index++] = z;
                this.polyVertices[index] = 1.0f;
                index = 3 * tessIdx;
                this.polyNormals[index++] = nx;
                this.polyNormals[index++] = ny;
                this.polyNormals[index] = nz;
            }
            this.polyColors[tessIdx] = rgba;
            index = 2 * tessIdx;
            this.polyTexCoords[index++] = u;
            this.polyTexCoords[index] = v;
            this.polyAmbient[tessIdx] = am;
            this.polySpecular[tessIdx] = sp;
            this.polyEmissive[tessIdx] = em;
            this.polyShininess[tessIdx] = shine;
        }

        void addPolyVertices(InGeometry in, boolean clampXY) {
            this.addPolyVertices(in, in.firstVertex, in.lastVertex, clampXY);
        }

        void addPolyVertex(InGeometry in, int i, boolean clampXY) {
            this.addPolyVertices(in, i, i, clampXY);
        }

        void addPolyVertices(InGeometry in, int i0, int i1, boolean clampXY) {
            int tessIdx;
            int index;
            int nvert = i1 - i0 + 1;
            this.polyVertexCheck(nvert);
            if (this.renderMode == 0 && PGraphicsOpenGL.this.flushMode == 1) {
                PMatrix3D mm = PGraphicsOpenGL.this.modelview;
                PMatrix3D nm = PGraphicsOpenGL.this.modelviewInv;
                for (int i = 0; i < nvert; ++i) {
                    int inIdx = i0 + i;
                    int tessIdx2 = this.firstPolyVertex + i;
                    index = 3 * inIdx;
                    float x = in.vertices[index++];
                    float y = in.vertices[index++];
                    float z = in.vertices[index];
                    index = 3 * inIdx;
                    float nx = in.normals[index++];
                    float ny = in.normals[index++];
                    float nz = in.normals[index];
                    index = 4 * tessIdx2;
                    if (clampXY) {
                        this.polyVertices[index++] = PApplet.ceil(x * mm.m00 + y * mm.m01 + z * mm.m02 + mm.m03);
                        this.polyVertices[index++] = PApplet.ceil(x * mm.m10 + y * mm.m11 + z * mm.m12 + mm.m13);
                    } else {
                        this.polyVertices[index++] = x * mm.m00 + y * mm.m01 + z * mm.m02 + mm.m03;
                        this.polyVertices[index++] = x * mm.m10 + y * mm.m11 + z * mm.m12 + mm.m13;
                    }
                    this.polyVertices[index++] = x * mm.m20 + y * mm.m21 + z * mm.m22 + mm.m23;
                    this.polyVertices[index] = x * mm.m30 + y * mm.m31 + z * mm.m32 + mm.m33;
                    index = 3 * tessIdx2;
                    this.polyNormals[index++] = nx * nm.m00 + ny * nm.m10 + nz * nm.m20;
                    this.polyNormals[index++] = nx * nm.m01 + ny * nm.m11 + nz * nm.m21;
                    this.polyNormals[index] = nx * nm.m02 + ny * nm.m12 + nz * nm.m22;
                }
            } else if (nvert <= 2) {
                for (int i = 0; i < nvert; ++i) {
                    int inIdx = i0 + i;
                    tessIdx = this.firstPolyVertex + i;
                    index = 3 * inIdx;
                    float x = in.vertices[index++];
                    float y = in.vertices[index++];
                    float z = in.vertices[index];
                    index = 3 * inIdx;
                    float nx = in.normals[index++];
                    float ny = in.normals[index++];
                    float nz = in.normals[index];
                    index = 4 * tessIdx;
                    this.polyVertices[index++] = x;
                    this.polyVertices[index++] = y;
                    this.polyVertices[index++] = z;
                    this.polyVertices[index] = 1.0f;
                    index = 3 * tessIdx;
                    this.polyNormals[index++] = nx;
                    this.polyNormals[index++] = ny;
                    this.polyNormals[index] = nz;
                }
            } else {
                for (int i = 0; i < nvert; ++i) {
                    int inIdx = i0 + i;
                    tessIdx = this.firstPolyVertex + i;
                    PApplet.arrayCopy(in.vertices, 3 * inIdx, this.polyVertices, 4 * tessIdx, 3);
                    this.polyVertices[4 * tessIdx + 3] = 1.0f;
                }
                PApplet.arrayCopy(in.normals, 3 * i0, this.polyNormals, 3 * this.firstPolyVertex, 3 * nvert);
            }
            if (nvert <= 2) {
                for (int i = 0; i < nvert; ++i) {
                    int inIdx = i0 + i;
                    tessIdx = this.firstPolyVertex + i;
                    index = 2 * inIdx;
                    float u = in.texcoords[index++];
                    float v = in.texcoords[index];
                    this.polyColors[tessIdx] = in.colors[inIdx];
                    index = 2 * tessIdx;
                    this.polyTexCoords[index++] = u;
                    this.polyTexCoords[index] = v;
                    this.polyAmbient[tessIdx] = in.ambient[inIdx];
                    this.polySpecular[tessIdx] = in.specular[inIdx];
                    this.polyEmissive[tessIdx] = in.emissive[inIdx];
                    this.polyShininess[tessIdx] = in.shininess[inIdx];
                }
            } else {
                PApplet.arrayCopy(in.colors, i0, this.polyColors, this.firstPolyVertex, nvert);
                PApplet.arrayCopy(in.texcoords, 2 * i0, this.polyTexCoords, 2 * this.firstPolyVertex, 2 * nvert);
                PApplet.arrayCopy(in.ambient, i0, this.polyAmbient, this.firstPolyVertex, nvert);
                PApplet.arrayCopy(in.specular, i0, this.polySpecular, this.firstPolyVertex, nvert);
                PApplet.arrayCopy(in.emissive, i0, this.polyEmissive, this.firstPolyVertex, nvert);
                PApplet.arrayCopy(in.shininess, i0, this.polyShininess, this.firstPolyVertex, nvert);
            }
        }

        void applyMatrixOnPolyGeometry(PMatrix tr, int first, int last) {
            if (tr instanceof PMatrix2D) {
                this.applyMatrixOnPolyGeometry((PMatrix2D)tr, first, last);
            } else if (tr instanceof PMatrix3D) {
                this.applyMatrixOnPolyGeometry((PMatrix3D)tr, first, last);
            }
        }

        void applyMatrixOnLineGeometry(PMatrix tr, int first, int last) {
            if (tr instanceof PMatrix2D) {
                this.applyMatrixOnLineGeometry((PMatrix2D)tr, first, last);
            } else if (tr instanceof PMatrix3D) {
                this.applyMatrixOnLineGeometry((PMatrix3D)tr, first, last);
            }
        }

        void applyMatrixOnPointGeometry(PMatrix tr, int first, int last) {
            if (tr instanceof PMatrix2D) {
                this.applyMatrixOnPointGeometry((PMatrix2D)tr, first, last);
            } else if (tr instanceof PMatrix3D) {
                this.applyMatrixOnPointGeometry((PMatrix3D)tr, first, last);
            }
        }

        void applyMatrixOnPolyGeometry(PMatrix2D tr, int first, int last) {
            if (first < last) {
                for (int i = first; i <= last; ++i) {
                    int index = 4 * i;
                    float x = this.polyVertices[index++];
                    float y = this.polyVertices[index];
                    index = 3 * i;
                    float nx = this.polyNormals[index++];
                    float ny = this.polyNormals[index];
                    index = 4 * i;
                    this.polyVertices[index++] = x * tr.m00 + y * tr.m01 + tr.m02;
                    this.polyVertices[index] = x * tr.m10 + y * tr.m11 + tr.m12;
                    index = 3 * i;
                    this.polyNormals[index++] = nx * tr.m00 + ny * tr.m01;
                    this.polyNormals[index] = nx * tr.m10 + ny * tr.m11;
                }
            }
        }

        void applyMatrixOnLineGeometry(PMatrix2D tr, int first, int last) {
            if (first < last) {
                for (int i = first; i <= last; ++i) {
                    int index = 4 * i;
                    float x = this.lineVertices[index++];
                    float y = this.lineVertices[index];
                    index = 4 * i;
                    float xa = this.lineDirections[index++];
                    float ya = this.lineDirections[index];
                    float dx = xa - x;
                    float dy = ya - y;
                    index = 4 * i;
                    this.lineVertices[index++] = x * tr.m00 + y * tr.m01 + tr.m02;
                    this.lineVertices[index] = x * tr.m10 + y * tr.m11 + tr.m12;
                    index = 4 * i;
                    this.lineDirections[index++] = dx * tr.m00 + dy * tr.m01;
                    this.lineDirections[index] = dx * tr.m10 + dy * tr.m11;
                }
            }
        }

        void applyMatrixOnPointGeometry(PMatrix2D tr, int first, int last) {
            if (first < last) {
                for (int i = first; i <= last; ++i) {
                    int index = 4 * i;
                    float x = this.pointVertices[index++];
                    float y = this.pointVertices[index];
                    index = 4 * i;
                    this.pointVertices[index++] = x * tr.m00 + y * tr.m01 + tr.m02;
                    this.pointVertices[index] = x * tr.m10 + y * tr.m11 + tr.m12;
                }
            }
        }

        void applyMatrixOnPolyGeometry(PMatrix3D tr, int first, int last) {
            if (first < last) {
                for (int i = first; i <= last; ++i) {
                    int index = 4 * i;
                    float x = this.polyVertices[index++];
                    float y = this.polyVertices[index++];
                    float z = this.polyVertices[index++];
                    float w = this.polyVertices[index];
                    index = 3 * i;
                    float nx = this.polyNormals[index++];
                    float ny = this.polyNormals[index++];
                    float nz = this.polyNormals[index];
                    index = 4 * i;
                    this.polyVertices[index++] = x * tr.m00 + y * tr.m01 + z * tr.m02 + w * tr.m03;
                    this.polyVertices[index++] = x * tr.m10 + y * tr.m11 + z * tr.m12 + w * tr.m13;
                    this.polyVertices[index++] = x * tr.m20 + y * tr.m21 + z * tr.m22 + w * tr.m23;
                    this.polyVertices[index] = x * tr.m30 + y * tr.m31 + z * tr.m32 + w * tr.m33;
                    index = 3 * i;
                    this.polyNormals[index++] = nx * tr.m00 + ny * tr.m01 + nz * tr.m02;
                    this.polyNormals[index++] = nx * tr.m10 + ny * tr.m11 + nz * tr.m12;
                    this.polyNormals[index] = nx * tr.m20 + ny * tr.m21 + nz * tr.m22;
                }
            }
        }

        void applyMatrixOnLineGeometry(PMatrix3D tr, int first, int last) {
            if (first < last) {
                for (int i = first; i <= last; ++i) {
                    int index = 4 * i;
                    float x = this.lineVertices[index++];
                    float y = this.lineVertices[index++];
                    float z = this.lineVertices[index++];
                    float w = this.lineVertices[index];
                    index = 4 * i;
                    float xa = this.lineDirections[index++];
                    float ya = this.lineDirections[index++];
                    float za = this.lineDirections[index];
                    float dx = xa - x;
                    float dy = ya - y;
                    float dz = za - z;
                    index = 4 * i;
                    this.lineVertices[index++] = x * tr.m00 + y * tr.m01 + z * tr.m02 + w * tr.m03;
                    this.lineVertices[index++] = x * tr.m10 + y * tr.m11 + z * tr.m12 + w * tr.m13;
                    this.lineVertices[index++] = x * tr.m20 + y * tr.m21 + z * tr.m22 + w * tr.m23;
                    this.lineVertices[index] = x * tr.m30 + y * tr.m31 + z * tr.m32 + w * tr.m33;
                    index = 4 * i;
                    this.lineDirections[index++] = dx * tr.m00 + dy * tr.m01 + dz * tr.m02;
                    this.lineDirections[index++] = dx * tr.m10 + dy * tr.m11 + dz * tr.m12;
                    this.lineDirections[index] = dx * tr.m20 + dy * tr.m21 + dz * tr.m22;
                }
            }
        }

        void applyMatrixOnPointGeometry(PMatrix3D tr, int first, int last) {
            if (first < last) {
                for (int i = first; i <= last; ++i) {
                    int index = 4 * i;
                    float x = this.pointVertices[index++];
                    float y = this.pointVertices[index++];
                    float z = this.pointVertices[index++];
                    float w = this.pointVertices[index];
                    index = 4 * i;
                    this.pointVertices[index++] = x * tr.m00 + y * tr.m01 + z * tr.m02 + w * tr.m03;
                    this.pointVertices[index++] = x * tr.m10 + y * tr.m11 + z * tr.m12 + w * tr.m13;
                    this.pointVertices[index++] = x * tr.m20 + y * tr.m21 + z * tr.m22 + w * tr.m23;
                    this.pointVertices[index] = x * tr.m30 + y * tr.m31 + z * tr.m32 + w * tr.m33;
                }
            }
        }
    }

    protected class InGeometry {
        int renderMode;
        int vertexCount;
        int edgeCount;
        int firstVertex;
        int lastVertex;
        int firstEdge;
        int lastEdge;
        float[] vertices;
        int[] colors;
        float[] normals;
        float[] texcoords;
        int[] strokeColors;
        float[] strokeWeights;
        boolean[] breaks;
        int[][] edges;
        int[] ambient;
        int[] specular;
        int[] emissive;
        float[] shininess;
        int fillColor;
        int strokeColor;
        float strokeWeight;
        int ambientColor;
        int specularColor;
        int emissiveColor;
        float shininessFactor;
        float normalX;
        float normalY;
        float normalZ;

        InGeometry(int mode) {
            this.renderMode = mode;
            this.allocate();
        }

        void clear() {
            this.lastVertex = 0;
            this.firstVertex = 0;
            this.vertexCount = 0;
            this.lastEdge = 0;
            this.firstEdge = 0;
            this.edgeCount = 0;
        }

        void clearEdges() {
            this.lastEdge = 0;
            this.firstEdge = 0;
            this.edgeCount = 0;
        }

        void allocate() {
            this.vertices = new float[192];
            this.colors = new int[64];
            this.normals = new float[192];
            this.texcoords = new float[128];
            this.strokeColors = new int[64];
            this.strokeWeights = new float[64];
            this.ambient = new int[64];
            this.specular = new int[64];
            this.emissive = new int[64];
            this.shininess = new float[64];
            this.breaks = new boolean[64];
            this.edges = new int[128][3];
            this.clear();
        }

        void vertexCheck() {
            if (this.vertexCount == this.vertices.length / 3) {
                int newSize = this.vertexCount << 1;
                this.expandVertices(newSize);
                this.expandColors(newSize);
                this.expandNormals(newSize);
                this.expandTexCoords(newSize);
                this.expandStrokeColors(newSize);
                this.expandStrokeWeights(newSize);
                this.expandAmbient(newSize);
                this.expandSpecular(newSize);
                this.expandEmissive(newSize);
                this.expandShininess(newSize);
                this.expandBreaks(newSize);
            }
        }

        void edgeCheck() {
            if (this.edgeCount == this.edges.length) {
                int newLen = this.edgeCount << 1;
                this.expandEdges(newLen);
            }
        }

        float getVertexX(int idx) {
            return this.vertices[3 * idx + 0];
        }

        float getVertexY(int idx) {
            return this.vertices[3 * idx + 1];
        }

        float getVertexZ(int idx) {
            return this.vertices[3 * idx + 2];
        }

        float getLastVertexX() {
            return this.vertices[3 * (this.vertexCount - 1) + 0];
        }

        float getLastVertexY() {
            return this.vertices[3 * (this.vertexCount - 1) + 1];
        }

        float getLastVertexZ() {
            return this.vertices[3 * (this.vertexCount - 1) + 2];
        }

        int getNumEdgeClosures() {
            int count = 0;
            for (int i = this.firstEdge; i <= this.lastEdge; ++i) {
                if (this.edges[i][2] != -1) continue;
                ++count;
            }
            return count;
        }

        int getNumEdgeVertices(boolean bevel) {
            int segVert = this.lastEdge - this.firstEdge + 1;
            int bevVert = 0;
            if (bevel) {
                for (int i = this.firstEdge; i <= this.lastEdge; ++i) {
                    int[] edge = this.edges[i];
                    if (edge[2] == 0 || edge[2] == 1) {
                        ++bevVert;
                    }
                    if (edge[2] != -1) continue;
                    --segVert;
                }
            } else {
                segVert -= this.getNumEdgeClosures();
            }
            return 4 * segVert + bevVert;
        }

        int getNumEdgeIndices(boolean bevel) {
            int segInd = this.lastEdge - this.firstEdge + 1;
            int bevInd = 0;
            if (bevel) {
                for (int i = this.firstEdge; i <= this.lastEdge; ++i) {
                    int[] edge = this.edges[i];
                    if (edge[2] == 0 || edge[2] == 1) {
                        ++bevInd;
                    }
                    if (edge[2] != -1) continue;
                    --segInd;
                }
            } else {
                segInd -= this.getNumEdgeClosures();
            }
            return 6 * (segInd + bevInd);
        }

        void getVertexMin(PVector v) {
            for (int i = 0; i < this.vertexCount; ++i) {
                int index = 4 * i;
                v.x = PApplet.min(v.x, this.vertices[index++]);
                v.y = PApplet.min(v.y, this.vertices[index++]);
                v.z = PApplet.min(v.z, this.vertices[index]);
            }
        }

        void getVertexMax(PVector v) {
            for (int i = 0; i < this.vertexCount; ++i) {
                int index = 4 * i;
                v.x = PApplet.max(v.x, this.vertices[index++]);
                v.y = PApplet.max(v.y, this.vertices[index++]);
                v.z = PApplet.max(v.z, this.vertices[index]);
            }
        }

        int getVertexSum(PVector v) {
            for (int i = 0; i < this.vertexCount; ++i) {
                int index = 4 * i;
                v.x += this.vertices[index++];
                v.y += this.vertices[index++];
                v.z += this.vertices[index];
            }
            return this.vertexCount;
        }

        void expandVertices(int n) {
            float[] temp = new float[3 * n];
            PApplet.arrayCopy(this.vertices, 0, temp, 0, 3 * this.vertexCount);
            this.vertices = temp;
        }

        void expandColors(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.colors, 0, temp, 0, this.vertexCount);
            this.colors = temp;
        }

        void expandNormals(int n) {
            float[] temp = new float[3 * n];
            PApplet.arrayCopy(this.normals, 0, temp, 0, 3 * this.vertexCount);
            this.normals = temp;
        }

        void expandTexCoords(int n) {
            float[] temp = new float[2 * n];
            PApplet.arrayCopy(this.texcoords, 0, temp, 0, 2 * this.vertexCount);
            this.texcoords = temp;
        }

        void expandStrokeColors(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.strokeColors, 0, temp, 0, this.vertexCount);
            this.strokeColors = temp;
        }

        void expandStrokeWeights(int n) {
            float[] temp = new float[n];
            PApplet.arrayCopy(this.strokeWeights, 0, temp, 0, this.vertexCount);
            this.strokeWeights = temp;
        }

        void expandAmbient(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.ambient, 0, temp, 0, this.vertexCount);
            this.ambient = temp;
        }

        void expandSpecular(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.specular, 0, temp, 0, this.vertexCount);
            this.specular = temp;
        }

        void expandEmissive(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.emissive, 0, temp, 0, this.vertexCount);
            this.emissive = temp;
        }

        void expandShininess(int n) {
            float[] temp = new float[n];
            PApplet.arrayCopy(this.shininess, 0, temp, 0, this.vertexCount);
            this.shininess = temp;
        }

        void expandBreaks(int n) {
            boolean[] temp = new boolean[n];
            PApplet.arrayCopy(this.breaks, 0, temp, 0, this.vertexCount);
            this.breaks = temp;
        }

        void expandEdges(int n) {
            int[][] temp = new int[n][3];
            PApplet.arrayCopy(this.edges, 0, temp, 0, this.edgeCount);
            this.edges = temp;
        }

        void trim() {
            if (0 < this.vertexCount && this.vertexCount < this.vertices.length / 3) {
                this.trimVertices();
                this.trimColors();
                this.trimNormals();
                this.trimTexCoords();
                this.trimStrokeColors();
                this.trimStrokeWeights();
                this.trimAmbient();
                this.trimSpecular();
                this.trimEmissive();
                this.trimShininess();
                this.trimBreaks();
            }
            if (0 < this.edgeCount && this.edgeCount < this.edges.length) {
                this.trimEdges();
            }
        }

        void trimVertices() {
            float[] temp = new float[3 * this.vertexCount];
            PApplet.arrayCopy(this.vertices, 0, temp, 0, 3 * this.vertexCount);
            this.vertices = temp;
        }

        void trimColors() {
            int[] temp = new int[this.vertexCount];
            PApplet.arrayCopy(this.colors, 0, temp, 0, this.vertexCount);
            this.colors = temp;
        }

        void trimNormals() {
            float[] temp = new float[3 * this.vertexCount];
            PApplet.arrayCopy(this.normals, 0, temp, 0, 3 * this.vertexCount);
            this.normals = temp;
        }

        void trimTexCoords() {
            float[] temp = new float[2 * this.vertexCount];
            PApplet.arrayCopy(this.texcoords, 0, temp, 0, 2 * this.vertexCount);
            this.texcoords = temp;
        }

        void trimStrokeColors() {
            int[] temp = new int[this.vertexCount];
            PApplet.arrayCopy(this.strokeColors, 0, temp, 0, this.vertexCount);
            this.strokeColors = temp;
        }

        void trimStrokeWeights() {
            float[] temp = new float[this.vertexCount];
            PApplet.arrayCopy(this.strokeWeights, 0, temp, 0, this.vertexCount);
            this.strokeWeights = temp;
        }

        void trimAmbient() {
            int[] temp = new int[this.vertexCount];
            PApplet.arrayCopy(this.ambient, 0, temp, 0, this.vertexCount);
            this.ambient = temp;
        }

        void trimSpecular() {
            int[] temp = new int[this.vertexCount];
            PApplet.arrayCopy(this.specular, 0, temp, 0, this.vertexCount);
            this.specular = temp;
        }

        void trimEmissive() {
            int[] temp = new int[this.vertexCount];
            PApplet.arrayCopy(this.emissive, 0, temp, 0, this.vertexCount);
            this.emissive = temp;
        }

        void trimShininess() {
            float[] temp = new float[this.vertexCount];
            PApplet.arrayCopy(this.shininess, 0, temp, 0, this.vertexCount);
            this.shininess = temp;
        }

        void trimBreaks() {
            boolean[] temp = new boolean[this.vertexCount];
            PApplet.arrayCopy(this.breaks, 0, temp, 0, this.vertexCount);
            this.breaks = temp;
        }

        void trimEdges() {
            int[][] temp = new int[this.edgeCount][3];
            PApplet.arrayCopy(this.edges, 0, temp, 0, this.edgeCount);
            this.edges = temp;
        }

        int addVertex(float x, float y, int code) {
            return this.addVertex(x, y, 0.0f, this.fillColor, this.normalX, this.normalY, this.normalZ, 0.0f, 0.0f, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininessFactor, code);
        }

        int addVertex(float x, float y, float u, float v, int code) {
            return this.addVertex(x, y, 0.0f, this.fillColor, this.normalX, this.normalY, this.normalZ, u, v, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininessFactor, code);
        }

        int addVertex(float x, float y, float z, int code) {
            return this.addVertex(x, y, z, this.fillColor, this.normalX, this.normalY, this.normalZ, 0.0f, 0.0f, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininessFactor, code);
        }

        int addVertex(float x, float y, float z, float u, float v, int code) {
            return this.addVertex(x, y, z, this.fillColor, this.normalX, this.normalY, this.normalZ, u, v, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininessFactor, code);
        }

        int addVertex(float x, float y, float z, int fcolor, float nx, float ny, float nz, float u, float v, int scolor, float sweight, int am, int sp, int em, float shine, int code) {
            this.vertexCheck();
            PGraphicsOpenGL.this.curveVertexCount = 0;
            int index = 3 * this.vertexCount;
            this.vertices[index++] = x;
            this.vertices[index++] = y;
            this.vertices[index] = z;
            this.colors[this.vertexCount] = PGL.javaToNativeARGB(fcolor);
            index = 3 * this.vertexCount;
            this.normals[index++] = nx;
            this.normals[index++] = ny;
            this.normals[index] = nz;
            index = 2 * this.vertexCount;
            this.texcoords[index++] = u;
            this.texcoords[index] = v;
            this.strokeColors[this.vertexCount] = PGL.javaToNativeARGB(scolor);
            this.strokeWeights[this.vertexCount] = sweight;
            this.ambient[this.vertexCount] = PGL.javaToNativeARGB(am);
            this.specular[this.vertexCount] = PGL.javaToNativeARGB(sp);
            this.emissive[this.vertexCount] = PGL.javaToNativeARGB(em);
            this.shininess[this.vertexCount] = shine;
            this.breaks[this.vertexCount] = code == 4;
            this.lastVertex = this.vertexCount++;
            return this.lastVertex;
        }

        void addBezierVertex(float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, boolean fill, boolean stroke, int detail, int code) {
            this.addBezierVertex(x2, y2, z2, x3, y3, z3, x4, y4, z4, fill, stroke, detail, code, 20);
        }

        void addBezierVertex(float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, boolean fill, boolean stroke, int detail, int code, int shape) {
            PGraphicsOpenGL.this.bezierInitCheck();
            PGraphicsOpenGL.this.bezierVertexCheck(shape, this.vertexCount);
            PMatrix3D draw = PGraphicsOpenGL.this.bezierDrawMatrix;
            float x1 = this.getLastVertexX();
            float y1 = this.getLastVertexY();
            float z1 = this.getLastVertexZ();
            float xplot1 = draw.m10 * x1 + draw.m11 * x2 + draw.m12 * x3 + draw.m13 * x4;
            float xplot2 = draw.m20 * x1 + draw.m21 * x2 + draw.m22 * x3 + draw.m23 * x4;
            float xplot3 = draw.m30 * x1 + draw.m31 * x2 + draw.m32 * x3 + draw.m33 * x4;
            float yplot1 = draw.m10 * y1 + draw.m11 * y2 + draw.m12 * y3 + draw.m13 * y4;
            float yplot2 = draw.m20 * y1 + draw.m21 * y2 + draw.m22 * y3 + draw.m23 * y4;
            float yplot3 = draw.m30 * y1 + draw.m31 * y2 + draw.m32 * y3 + draw.m33 * y4;
            float zplot1 = draw.m10 * z1 + draw.m11 * z2 + draw.m12 * z3 + draw.m13 * z4;
            float zplot2 = draw.m20 * z1 + draw.m21 * z2 + draw.m22 * z3 + draw.m23 * z4;
            float zplot3 = draw.m30 * z1 + draw.m31 * z2 + draw.m32 * z3 + draw.m33 * z4;
            for (int j = 0; j < detail; ++j) {
                x1 += xplot1;
                xplot1 += xplot2;
                xplot2 += xplot3;
                yplot1 += yplot2;
                yplot2 += yplot3;
                zplot2 += zplot3;
                this.addVertex(x1, y1 += yplot1, z1 += (zplot1 += zplot2), j == 0 && code == 4 ? 4 : 0);
            }
        }

        public void addQuadraticVertex(float cx, float cy, float cz, float x3, float y3, float z3, boolean fill, boolean stroke, int detail, int code) {
            this.addQuadraticVertex(cx, cy, cz, x3, y3, z3, fill, stroke, detail, code, 20);
        }

        public void addQuadraticVertex(float cx, float cy, float cz, float x3, float y3, float z3, boolean fill, boolean stroke, int detail, int code, int shape) {
            float x1 = this.getLastVertexX();
            float y1 = this.getLastVertexY();
            float z1 = this.getLastVertexZ();
            this.addBezierVertex(x1 + (cx - x1) * 2.0f / 3.0f, y1 + (cy - y1) * 2.0f / 3.0f, z1 + (cz - z1) * 2.0f / 3.0f, x3 + (cx - x3) * 2.0f / 3.0f, y3 + (cy - y3) * 2.0f / 3.0f, z3 + (cz - z3) * 2.0f / 3.0f, x3, y3, z3, fill, stroke, detail, code, shape);
        }

        void addCurveVertex(float x, float y, float z, boolean fill, boolean stroke, int detail, int code) {
            this.addCurveVertex(x, y, z, fill, stroke, detail, code, 20);
        }

        void addCurveVertex(float x, float y, float z, boolean fill, boolean stroke, int detail, int code, int shape) {
            PGraphicsOpenGL.this.curveVertexCheck(shape);
            float[] vertex = PGraphicsOpenGL.this.curveVertices[PGraphicsOpenGL.this.curveVertexCount];
            vertex[0] = x;
            vertex[1] = y;
            vertex[2] = z;
            PGraphicsOpenGL.this.curveVertexCount++;
            if (PGraphicsOpenGL.this.curveVertexCount > 3) {
                float[] v1 = PGraphicsOpenGL.this.curveVertices[PGraphicsOpenGL.this.curveVertexCount - 4];
                float[] v2 = PGraphicsOpenGL.this.curveVertices[PGraphicsOpenGL.this.curveVertexCount - 3];
                float[] v3 = PGraphicsOpenGL.this.curveVertices[PGraphicsOpenGL.this.curveVertexCount - 2];
                float[] v4 = PGraphicsOpenGL.this.curveVertices[PGraphicsOpenGL.this.curveVertexCount - 1];
                this.addCurveVertexSegment(v1[0], v1[1], v1[2], v2[0], v2[1], v2[2], v3[0], v3[1], v3[2], v4[0], v4[1], v4[2], detail, code);
            }
        }

        void addCurveVertexSegment(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, int detail, int code) {
            float x0 = x2;
            float y0 = y2;
            float z0 = z2;
            PMatrix3D draw = PGraphicsOpenGL.this.curveDrawMatrix;
            float xplot1 = draw.m10 * x1 + draw.m11 * x2 + draw.m12 * x3 + draw.m13 * x4;
            float xplot2 = draw.m20 * x1 + draw.m21 * x2 + draw.m22 * x3 + draw.m23 * x4;
            float xplot3 = draw.m30 * x1 + draw.m31 * x2 + draw.m32 * x3 + draw.m33 * x4;
            float yplot1 = draw.m10 * y1 + draw.m11 * y2 + draw.m12 * y3 + draw.m13 * y4;
            float yplot2 = draw.m20 * y1 + draw.m21 * y2 + draw.m22 * y3 + draw.m23 * y4;
            float yplot3 = draw.m30 * y1 + draw.m31 * y2 + draw.m32 * y3 + draw.m33 * y4;
            float zplot1 = draw.m10 * z1 + draw.m11 * z2 + draw.m12 * z3 + draw.m13 * z4;
            float zplot2 = draw.m20 * z1 + draw.m21 * z2 + draw.m22 * z3 + draw.m23 * z4;
            float zplot3 = draw.m30 * z1 + draw.m31 * z2 + draw.m32 * z3 + draw.m33 * z4;
            int savedCount = PGraphicsOpenGL.this.curveVertexCount;
            this.addVertex(x0, y0, z0, code == 4 ? 4 : 0);
            for (int j = 0; j < detail; ++j) {
                x0 += xplot1;
                xplot1 += xplot2;
                xplot2 += xplot3;
                yplot2 += yplot3;
                this.addVertex(x0, y0 += (yplot1 += yplot2), z0 += (zplot1 += (zplot2 += zplot3)), 0);
            }
            PGraphicsOpenGL.this.curveVertexCount = savedCount;
        }

        float[][] getVertexData() {
            float[][] data = new float[this.vertexCount][37];
            for (int i = 0; i < this.vertexCount; ++i) {
                float[] vert = data[i];
                vert[0] = this.vertices[3 * i + 0];
                vert[1] = this.vertices[3 * i + 1];
                vert[2] = this.vertices[3 * i + 2];
                vert[3] = (float)(this.colors[i] >> 16 & 0xFF) / 255.0f;
                vert[4] = (float)(this.colors[i] >> 8 & 0xFF) / 255.0f;
                vert[5] = (float)(this.colors[i] >> 0 & 0xFF) / 255.0f;
                vert[6] = (float)(this.colors[i] >> 24 & 0xFF) / 255.0f;
                vert[7] = this.texcoords[2 * i + 0];
                vert[8] = this.texcoords[2 * i + 1];
                vert[9] = this.normals[3 * i + 0];
                vert[10] = this.normals[3 * i + 1];
                vert[11] = this.normals[3 * i + 2];
                vert[13] = (float)(this.strokeColors[i] >> 16 & 0xFF) / 255.0f;
                vert[14] = (float)(this.strokeColors[i] >> 8 & 0xFF) / 255.0f;
                vert[15] = (float)(this.strokeColors[i] >> 0 & 0xFF) / 255.0f;
                vert[16] = (float)(this.strokeColors[i] >> 24 & 0xFF) / 255.0f;
                vert[17] = this.strokeWeights[i];
            }
            return data;
        }

        int addEdge(int i, int j, boolean start, boolean end) {
            this.edgeCheck();
            int[] edge = this.edges[this.edgeCount];
            edge[0] = i;
            edge[1] = j;
            edge[2] = (start ? 1 : 0) + 2 * (end ? 1 : 0);
            this.lastEdge = this.edgeCount++;
            return this.lastEdge;
        }

        int closeEdge(int i, int j) {
            this.edgeCheck();
            int[] edge = this.edges[this.edgeCount];
            edge[0] = i;
            edge[1] = j;
            edge[2] = -1;
            this.lastEdge = this.edgeCount++;
            return this.lastEdge;
        }

        void addTrianglesEdges() {
            for (int i = 0; i < (this.lastVertex - this.firstVertex + 1) / 3; ++i) {
                int i0 = 3 * i + 0;
                int i1 = 3 * i + 1;
                int i2 = 3 * i + 2;
                this.addEdge(i0, i1, true, false);
                this.addEdge(i1, i2, false, false);
                this.addEdge(i2, i0, false, false);
                this.closeEdge(i2, i0);
            }
        }

        void addTriangleFanEdges() {
            for (int i = this.firstVertex + 1; i < this.lastVertex; ++i) {
                int i0 = this.firstVertex;
                int i1 = i;
                int i2 = i + 1;
                this.addEdge(i0, i1, true, false);
                this.addEdge(i1, i2, false, false);
                this.addEdge(i2, i0, false, false);
                this.closeEdge(i2, i0);
            }
        }

        void addTriangleStripEdges() {
            for (int i = this.firstVertex + 1; i < this.lastVertex; ++i) {
                int i2;
                int i1;
                int i0 = i;
                if (i % 2 == 0) {
                    i1 = i - 1;
                    i2 = i + 1;
                } else {
                    i1 = i + 1;
                    i2 = i - 1;
                }
                this.addEdge(i0, i1, true, false);
                this.addEdge(i1, i2, false, false);
                this.addEdge(i2, i0, false, false);
                this.closeEdge(i2, i0);
            }
        }

        void addQuadsEdges() {
            for (int i = 0; i < (this.lastVertex - this.firstVertex + 1) / 4; ++i) {
                int i0 = 4 * i + 0;
                int i1 = 4 * i + 1;
                int i2 = 4 * i + 2;
                int i3 = 4 * i + 3;
                this.addEdge(i0, i1, true, false);
                this.addEdge(i1, i2, false, false);
                this.addEdge(i2, i3, false, false);
                this.addEdge(i3, i0, false, false);
                this.closeEdge(i3, i0);
            }
        }

        void addQuadStripEdges() {
            for (int qd = 1; qd < (this.lastVertex - this.firstVertex + 1) / 2; ++qd) {
                int i0 = this.firstVertex + 2 * (qd - 1);
                int i1 = this.firstVertex + 2 * (qd - 1) + 1;
                int i2 = this.firstVertex + 2 * qd + 1;
                int i3 = this.firstVertex + 2 * qd;
                this.addEdge(i0, i1, true, false);
                this.addEdge(i1, i2, false, false);
                this.addEdge(i2, i3, false, false);
                this.addEdge(i3, i0, false, true);
                this.closeEdge(i3, i0);
            }
        }

        void addPolygonEdges(boolean closed) {
            int start = this.firstVertex;
            boolean begin = true;
            for (int i = this.firstVertex + 1; i <= this.lastVertex; ++i) {
                if (this.breaks[i]) {
                    if (closed) {
                        this.addEdge(i - 1, start, begin, false);
                        this.closeEdge(i - 1, start);
                    }
                    start = i;
                    begin = true;
                    continue;
                }
                if (i == this.lastVertex) {
                    if (closed && start + 1 < i) {
                        this.addEdge(i - 1, i, begin, false);
                        this.addEdge(i, start, false, false);
                        this.closeEdge(i, start);
                    } else {
                        this.addEdge(i - 1, i, begin, true);
                    }
                } else if (i < this.lastVertex && this.breaks[i + 1] && !closed) {
                    this.addEdge(i - 1, i, begin, true);
                } else {
                    this.addEdge(i - 1, i, begin, false);
                }
                begin = false;
            }
        }

        void calcTriangleNormal(int i0, int i1, int i2) {
            int index = 3 * i0;
            float x0 = this.vertices[index++];
            float y0 = this.vertices[index++];
            float z0 = this.vertices[index];
            index = 3 * i1;
            float x1 = this.vertices[index++];
            float y1 = this.vertices[index++];
            float z1 = this.vertices[index];
            index = 3 * i2;
            float x2 = this.vertices[index++];
            float y2 = this.vertices[index++];
            float z2 = this.vertices[index];
            float v12x = x2 - x1;
            float v12y = y2 - y1;
            float v12z = z2 - z1;
            float v10x = x0 - x1;
            float v10y = y0 - y1;
            float v10z = z0 - z1;
            float nx = v12y * v10z - v10y * v12z;
            float ny = v12z * v10x - v10z * v12x;
            float nz = v12x * v10y - v10x * v12y;
            float d = PApplet.sqrt(nx * nx + ny * ny + nz * nz);
            index = 3 * i0;
            this.normals[index++] = nx /= d;
            this.normals[index++] = ny /= d;
            this.normals[index] = nz /= d;
            index = 3 * i1;
            this.normals[index++] = nx;
            this.normals[index++] = ny;
            this.normals[index] = nz;
            index = 3 * i2;
            this.normals[index++] = nx;
            this.normals[index++] = ny;
            this.normals[index] = nz;
        }

        void calcTrianglesNormals() {
            for (int i = 0; i < (this.lastVertex - this.firstVertex + 1) / 3; ++i) {
                int i0 = 3 * i + 0;
                int i1 = 3 * i + 1;
                int i2 = 3 * i + 2;
                this.calcTriangleNormal(i0, i1, i2);
            }
        }

        void calcTriangleFanNormals() {
            for (int i = this.firstVertex + 1; i < this.lastVertex; ++i) {
                int i0 = this.firstVertex;
                int i1 = i;
                int i2 = i + 1;
                this.calcTriangleNormal(i0, i1, i2);
            }
        }

        void calcTriangleStripNormals() {
            for (int i = this.firstVertex + 1; i < this.lastVertex; ++i) {
                int i2;
                int i0;
                int i1 = i;
                if (i % 2 == 0) {
                    i0 = i + 1;
                    i2 = i - 1;
                } else {
                    i0 = i - 1;
                    i2 = i + 1;
                }
                this.calcTriangleNormal(i0, i1, i2);
            }
        }

        void calcQuadsNormals() {
            for (int i = 0; i < (this.lastVertex - this.firstVertex + 1) / 4; ++i) {
                int i0 = 4 * i + 0;
                int i1 = 4 * i + 1;
                int i2 = 4 * i + 2;
                int i3 = 4 * i + 3;
                this.calcTriangleNormal(i0, i1, i2);
                this.calcTriangleNormal(i2, i3, i0);
            }
        }

        void calcQuadStripNormals() {
            for (int qd = 1; qd < (this.lastVertex - this.firstVertex + 1) / 2; ++qd) {
                int i0 = this.firstVertex + 2 * (qd - 1);
                int i1 = this.firstVertex + 2 * (qd - 1) + 1;
                int i2 = this.firstVertex + 2 * qd;
                int i3 = this.firstVertex + 2 * qd + 1;
                this.calcTriangleNormal(i0, i3, i1);
                this.calcTriangleNormal(i0, i2, i3);
            }
        }

        void setMaterial(int fillColor, int strokeColor, float strokeWeight, int ambientColor, int specularColor, int emissiveColor, float shininessFactor) {
            this.fillColor = fillColor;
            this.strokeColor = strokeColor;
            this.strokeWeight = strokeWeight;
            this.ambientColor = ambientColor;
            this.specularColor = specularColor;
            this.emissiveColor = emissiveColor;
            this.shininessFactor = shininessFactor;
        }

        void setNormal(float normalX, float normalY, float normalZ) {
            this.normalX = normalX;
            this.normalY = normalY;
            this.normalZ = normalZ;
        }

        void addPoint(float x, float y, float z, boolean fill, boolean stroke) {
            this.addVertex(x, y, z, 0);
        }

        void addLine(float x1, float y1, float z1, float x2, float y2, float z2, boolean fill, boolean stroke) {
            int idx1 = this.addVertex(x1, y1, z1, 0);
            int idx2 = this.addVertex(x2, y2, z2, 0);
            if (stroke) {
                this.addEdge(idx1, idx2, true, true);
            }
        }

        void addTriangle(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, boolean fill, boolean stroke) {
            int idx1 = this.addVertex(x1, y1, z1, 0);
            int idx2 = this.addVertex(x2, y2, z2, 0);
            int idx3 = this.addVertex(x3, y3, z3, 0);
            if (stroke) {
                this.addEdge(idx1, idx2, true, false);
                this.addEdge(idx2, idx3, false, false);
                this.addEdge(idx3, idx1, false, false);
                this.closeEdge(idx3, idx1);
            }
        }

        void addQuad(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, boolean fill, boolean stroke) {
            int idx1 = this.addVertex(x1, y1, z1, 0.0f, 0.0f, 0);
            int idx2 = this.addVertex(x2, y2, z2, 1.0f, 0.0f, 0);
            int idx3 = this.addVertex(x3, y3, z3, 1.0f, 1.0f, 0);
            int idx4 = this.addVertex(x4, y4, z4, 0.0f, 1.0f, 0);
            if (stroke) {
                this.addEdge(idx1, idx2, true, false);
                this.addEdge(idx2, idx3, false, false);
                this.addEdge(idx3, idx4, false, false);
                this.addEdge(idx4, idx1, false, false);
                this.closeEdge(idx4, idx1);
            }
        }

        void addRect(float a, float b, float c, float d, boolean fill, boolean stroke, int rectMode) {
            float temp;
            switch (rectMode) {
                case 1: {
                    break;
                }
                case 0: {
                    c += a;
                    d += b;
                    break;
                }
                case 2: {
                    float hradius = c;
                    float vradius = d;
                    c = a + hradius;
                    d = b + vradius;
                    a -= hradius;
                    b -= vradius;
                    break;
                }
                case 3: {
                    float hradius = c / 2.0f;
                    float vradius = d / 2.0f;
                    c = a + hradius;
                    d = b + vradius;
                    a -= hradius;
                    b -= vradius;
                }
            }
            if (a > c) {
                temp = a;
                a = c;
                c = temp;
            }
            if (b > d) {
                temp = b;
                b = d;
                d = temp;
            }
            this.addQuad(a, b, 0.0f, c, b, 0.0f, c, d, 0.0f, a, d, 0.0f, fill, stroke);
        }

        void addRect(float a, float b, float c, float d, float tl, float tr, float br, float bl, boolean fill, boolean stroke, int detail, int rectMode) {
            float maxRounding;
            float temp;
            switch (rectMode) {
                case 1: {
                    break;
                }
                case 0: {
                    c += a;
                    d += b;
                    break;
                }
                case 2: {
                    float hradius = c;
                    float vradius = d;
                    c = a + hradius;
                    d = b + vradius;
                    a -= hradius;
                    b -= vradius;
                    break;
                }
                case 3: {
                    float hradius = c / 2.0f;
                    float vradius = d / 2.0f;
                    c = a + hradius;
                    d = b + vradius;
                    a -= hradius;
                    b -= vradius;
                }
            }
            if (a > c) {
                temp = a;
                a = c;
                c = temp;
            }
            if (b > d) {
                temp = b;
                b = d;
                d = temp;
            }
            if (tl > (maxRounding = PApplet.min((c - a) / 2.0f, (d - b) / 2.0f))) {
                tl = maxRounding;
            }
            if (tr > maxRounding) {
                tr = maxRounding;
            }
            if (br > maxRounding) {
                br = maxRounding;
            }
            if (bl > maxRounding) {
                bl = maxRounding;
            }
            if (PGraphicsOpenGL.nonZero(tr)) {
                this.addVertex(c - tr, b, 0);
                this.addQuadraticVertex(c, b, 0.0f, c, b + tr, 0.0f, fill, stroke, detail, 0);
            } else {
                this.addVertex(c, b, 0);
            }
            if (PGraphicsOpenGL.nonZero(br)) {
                this.addVertex(c, d - br, 0);
                this.addQuadraticVertex(c, d, 0.0f, c - br, d, 0.0f, fill, stroke, detail, 0);
            } else {
                this.addVertex(c, d, 0);
            }
            if (PGraphicsOpenGL.nonZero(bl)) {
                this.addVertex(a + bl, d, 0);
                this.addQuadraticVertex(a, d, 0.0f, a, d - bl, 0.0f, fill, stroke, detail, 0);
            } else {
                this.addVertex(a, d, 0);
            }
            if (PGraphicsOpenGL.nonZero(tl)) {
                this.addVertex(a, b + tl, 0);
                this.addQuadraticVertex(a, b, 0.0f, a + tl, b, 0.0f, fill, stroke, detail, 0);
            } else {
                this.addVertex(a, b, 0);
            }
            if (stroke) {
                this.addPolygonEdges(true);
            }
        }

        void addEllipse(float a, float b, float c, float d, boolean fill, boolean stroke, int ellipseMode) {
            float x = a;
            float y = b;
            float w = c;
            float h = d;
            if (ellipseMode == 1) {
                w = c - a;
                h = d - b;
            } else if (ellipseMode == 2) {
                x = a - c;
                y = b - d;
                w = c * 2.0f;
                h = d * 2.0f;
            } else if (ellipseMode == 3) {
                x = a - c / 2.0f;
                y = b - d / 2.0f;
            }
            if (w < 0.0f) {
                x += w;
                w = -w;
            }
            if (h < 0.0f) {
                y += h;
                h = -h;
            }
            float radiusH = w / 2.0f;
            float radiusV = h / 2.0f;
            float centerX = x + radiusH;
            float centerY = y + radiusV;
            float sx1 = pgCurrent.screenX(x, y);
            float sy1 = pgCurrent.screenY(x, y);
            float sx2 = pgCurrent.screenX(x + w, y + h);
            float sy2 = pgCurrent.screenY(x + w, y + h);
            int accuracy = PApplet.max(20, (int)((float)Math.PI * 2 * PApplet.dist(sx1, sy1, sx2, sy2) / 10.0f));
            float inc = 720.0f / (float)accuracy;
            if (fill) {
                this.addVertex(centerX, centerY, 0);
            }
            int idx = 0;
            int pidx = 0;
            int idx0 = 0;
            float val = 0.0f;
            for (int i = 0; i < accuracy; ++i) {
                idx = this.addVertex(centerX + cosLUT[(int)val] * radiusH, centerY + sinLUT[(int)val] * radiusV, 0);
                val = (val + inc) % 720.0f;
                if (0 < i) {
                    if (stroke) {
                        this.addEdge(pidx, idx, i == 1, false);
                    }
                } else {
                    idx0 = idx;
                }
                pidx = idx;
            }
            this.addVertex(centerX + cosLUT[0] * radiusH, centerY + sinLUT[0] * radiusV, 0);
            if (stroke) {
                this.addEdge(idx, idx0, false, false);
                this.closeEdge(idx, idx0);
            }
        }

        void addArc(float x, float y, float w, float h, float start, float stop, boolean fill, boolean stroke, int arcMode) {
            int ii;
            int i;
            float hr = w / 2.0f;
            float vr = h / 2.0f;
            float centerX = x + hr;
            float centerY = y + vr;
            int startLUT = (int)(0.5f + start / ((float)Math.PI * 2) * 720.0f);
            int stopLUT = (int)(0.5f + stop / ((float)Math.PI * 2) * 720.0f);
            if (fill) {
                this.addVertex(centerX, centerY, 0);
            }
            int increment = 1;
            int idx = 0;
            int pidx = 0;
            int idx0 = 0;
            for (i = startLUT; i < stopLUT; i += increment) {
                ii = i % 720;
                if (ii < 0) {
                    ii += 720;
                }
                idx = this.addVertex(centerX + cosLUT[ii] * hr, centerY + sinLUT[ii] * vr, 0);
                if (stroke) {
                    if (arcMode == 3) {
                        this.addEdge(pidx, idx, i == startLUT, false);
                    } else if (startLUT < i) {
                        this.addEdge(pidx, idx, i == startLUT + 1, arcMode == 0 && i == stopLUT - 1);
                    }
                }
                if (startLUT == i) {
                    idx0 = idx;
                }
                pidx = idx;
            }
            idx = this.addVertex(centerX + cosLUT[stopLUT % 720] * hr, centerY + sinLUT[stopLUT % 720] * vr, 0);
            if (stroke && arcMode == 3) {
                this.addEdge(idx, idx0, false, false);
                this.closeEdge(idx, idx0);
            }
            if (arcMode == 2 || arcMode == 1) {
                pidx = idx;
                i = startLUT;
                ii = i % 720;
                if (ii < 0) {
                    ii += 720;
                }
                idx = this.addVertex(centerX + cosLUT[ii] * hr, centerY + sinLUT[ii] * vr, 0);
                if (stroke && arcMode == 2) {
                    this.addEdge(pidx, idx, false, true);
                }
            }
        }

        void addBox(float w, float h, float d, boolean fill, boolean stroke) {
            float x1 = -w / 2.0f;
            float x2 = w / 2.0f;
            float y1 = -h / 2.0f;
            float y2 = h / 2.0f;
            float z1 = -d / 2.0f;
            float z2 = d / 2.0f;
            int idx1 = 0;
            int idx2 = 0;
            int idx3 = 0;
            int idx4 = 0;
            if (fill || stroke) {
                this.setNormal(0.0f, 0.0f, 1.0f);
                idx1 = this.addVertex(x1, y1, z1, 0.0f, 0.0f, 0);
                idx2 = this.addVertex(x2, y1, z1, 1.0f, 0.0f, 0);
                idx3 = this.addVertex(x2, y2, z1, 1.0f, 1.0f, 0);
                idx4 = this.addVertex(x1, y2, z1, 0.0f, 1.0f, 0);
                if (stroke) {
                    this.addEdge(idx1, idx2, true, false);
                    this.addEdge(idx2, idx3, false, false);
                    this.addEdge(idx3, idx4, false, false);
                    this.addEdge(idx4, idx1, false, false);
                    this.closeEdge(idx4, idx1);
                }
                this.setNormal(0.0f, 0.0f, -1.0f);
                idx1 = this.addVertex(x2, y1, z2, 0.0f, 0.0f, 0);
                idx2 = this.addVertex(x1, y1, z2, 1.0f, 0.0f, 0);
                idx3 = this.addVertex(x1, y2, z2, 1.0f, 1.0f, 0);
                idx4 = this.addVertex(x2, y2, z2, 0.0f, 1.0f, 0);
                if (stroke) {
                    this.addEdge(idx1, idx2, true, false);
                    this.addEdge(idx2, idx3, false, false);
                    this.addEdge(idx3, idx4, false, false);
                    this.addEdge(idx4, idx1, false, false);
                    this.closeEdge(idx4, idx1);
                }
                this.setNormal(1.0f, 0.0f, 0.0f);
                idx1 = this.addVertex(x2, y1, z1, 0.0f, 0.0f, 0);
                idx2 = this.addVertex(x2, y1, z2, 1.0f, 0.0f, 0);
                idx3 = this.addVertex(x2, y2, z2, 1.0f, 1.0f, 0);
                idx4 = this.addVertex(x2, y2, z1, 0.0f, 1.0f, 0);
                if (stroke) {
                    this.addEdge(idx1, idx2, true, false);
                    this.addEdge(idx2, idx3, false, false);
                    this.addEdge(idx3, idx4, false, false);
                    this.addEdge(idx4, idx1, false, false);
                    this.closeEdge(idx4, idx1);
                }
                this.setNormal(-1.0f, 0.0f, 0.0f);
                idx1 = this.addVertex(x1, y1, z2, 0.0f, 0.0f, 0);
                idx2 = this.addVertex(x1, y1, z1, 1.0f, 0.0f, 0);
                idx3 = this.addVertex(x1, y2, z1, 1.0f, 1.0f, 0);
                idx4 = this.addVertex(x1, y2, z2, 0.0f, 1.0f, 0);
                if (stroke) {
                    this.addEdge(idx1, idx2, true, false);
                    this.addEdge(idx2, idx3, false, false);
                    this.addEdge(idx3, idx4, false, false);
                    this.addEdge(idx4, idx1, false, false);
                    this.closeEdge(idx4, idx1);
                }
                this.setNormal(0.0f, 1.0f, 0.0f);
                idx1 = this.addVertex(x1, y1, z2, 0.0f, 0.0f, 0);
                idx2 = this.addVertex(x2, y1, z2, 1.0f, 0.0f, 0);
                idx3 = this.addVertex(x2, y1, z1, 1.0f, 1.0f, 0);
                idx4 = this.addVertex(x1, y1, z1, 0.0f, 1.0f, 0);
                if (stroke) {
                    this.addEdge(idx1, idx2, true, false);
                    this.addEdge(idx2, idx3, false, false);
                    this.addEdge(idx3, idx4, false, false);
                    this.addEdge(idx4, idx1, false, false);
                    this.closeEdge(idx4, idx1);
                }
                this.setNormal(0.0f, -1.0f, 0.0f);
                idx1 = this.addVertex(x1, y2, z1, 0.0f, 0.0f, 0);
                idx2 = this.addVertex(x2, y2, z1, 1.0f, 0.0f, 0);
                idx3 = this.addVertex(x2, y2, z2, 1.0f, 1.0f, 0);
                idx4 = this.addVertex(x1, y2, z2, 0.0f, 1.0f, 0);
                if (stroke) {
                    this.addEdge(idx1, idx2, true, false);
                    this.addEdge(idx2, idx3, false, false);
                    this.addEdge(idx3, idx4, false, false);
                    this.addEdge(idx4, idx1, false, false);
                    this.closeEdge(idx4, idx1);
                }
            }
        }

        int[] addSphere(float r, int detailU, int detailV, boolean fill, boolean stroke) {
            int i;
            int i1;
            int i0;
            int i2;
            if (detailU < 3 || detailV < 2) {
                PGraphicsOpenGL.this.sphereDetail(30);
                detailV = 30;
                detailU = 30;
            } else {
                PGraphicsOpenGL.this.sphereDetail(detailU, detailV);
            }
            int nind = 3 * detailU + (6 * detailU + 3) * (detailV - 2) + 3 * detailU;
            int[] indices = new int[nind];
            int vertCount = 0;
            int indCount = 0;
            float du = 1.0f / (float)detailU;
            float dv = 1.0f / (float)detailV;
            float u = 1.0f;
            float v = 1.0f;
            for (i2 = 0; i2 < detailU; ++i2) {
                this.setNormal(0.0f, 1.0f, 0.0f);
                this.addVertex(0.0f, r, 0.0f, u, v, 0);
                u -= du;
            }
            int vert0 = vertCount = detailU;
            u = 1.0f;
            v -= dv;
            for (i2 = 0; i2 < detailU; ++i2) {
                this.setNormal(PGraphicsOpenGL.this.sphereX[i2], PGraphicsOpenGL.this.sphereY[i2], PGraphicsOpenGL.this.sphereZ[i2]);
                this.addVertex(r * PGraphicsOpenGL.this.sphereX[i2], r * PGraphicsOpenGL.this.sphereY[i2], r * PGraphicsOpenGL.this.sphereZ[i2], u, v, 0);
                u -= du;
            }
            vertCount += detailU;
            int vert1 = vertCount++;
            this.setNormal(PGraphicsOpenGL.this.sphereX[0], PGraphicsOpenGL.this.sphereY[0], PGraphicsOpenGL.this.sphereZ[0]);
            this.addVertex(r * PGraphicsOpenGL.this.sphereX[0], r * PGraphicsOpenGL.this.sphereY[0], r * PGraphicsOpenGL.this.sphereZ[0], u, v, 0);
            for (i2 = 0; i2 < detailU; ++i2) {
                int i12 = vert0 + i2;
                i0 = vert0 + i2 - detailU;
                indices[3 * i2 + 0] = i12;
                indices[3 * i2 + 1] = i0;
                indices[3 * i2 + 2] = i12 + 1;
                this.addEdge(i0, i12, true, true);
                this.addEdge(i12, i12 + 1, true, true);
            }
            indCount += 3 * detailU;
            int offset = 0;
            for (int j = 2; j < detailV; ++j) {
                int i3;
                offset += detailU;
                vert0 = vertCount;
                u = 1.0f;
                v -= dv;
                for (i3 = 0; i3 < detailU; ++i3) {
                    int ioff = offset + i3;
                    this.setNormal(PGraphicsOpenGL.this.sphereX[ioff], PGraphicsOpenGL.this.sphereY[ioff], PGraphicsOpenGL.this.sphereZ[ioff]);
                    this.addVertex(r * PGraphicsOpenGL.this.sphereX[ioff], r * PGraphicsOpenGL.this.sphereY[ioff], r * PGraphicsOpenGL.this.sphereZ[ioff], u, v, 0);
                    u -= du;
                }
                vertCount += detailU;
                vert1 = vertCount++;
                this.setNormal(PGraphicsOpenGL.this.sphereX[offset], PGraphicsOpenGL.this.sphereY[offset], PGraphicsOpenGL.this.sphereZ[offset]);
                this.addVertex(r * PGraphicsOpenGL.this.sphereX[offset], r * PGraphicsOpenGL.this.sphereY[offset], r * PGraphicsOpenGL.this.sphereZ[offset], u, v, 0);
                for (i3 = 0; i3 < detailU; ++i3) {
                    i1 = vert0 + i3;
                    int i02 = vert0 + i3 - detailU - 1;
                    indices[indCount + 6 * i3 + 0] = i1;
                    indices[indCount + 6 * i3 + 1] = i02;
                    indices[indCount + 6 * i3 + 2] = i02 + 1;
                    indices[indCount + 6 * i3 + 3] = i1;
                    indices[indCount + 6 * i3 + 4] = i02 + 1;
                    indices[indCount + 6 * i3 + 5] = i1 + 1;
                    this.addEdge(i02, i1, true, true);
                    this.addEdge(i1, i1 + 1, true, true);
                    this.addEdge(i02 + 1, i1, true, true);
                }
                indices[(indCount += 6 * detailU) + 0] = vert1;
                indices[indCount + 1] = vert1 - detailU;
                indices[indCount + 2] = vert1 - 1;
                indCount += 3;
                this.addEdge(vert1 - detailU, vert1 - 1, true, true);
                this.addEdge(vert1 - 1, vert1, true, true);
            }
            u = 1.0f;
            v = 0.0f;
            for (i = 0; i < detailU; ++i) {
                this.setNormal(0.0f, -1.0f, 0.0f);
                this.addVertex(0.0f, -r, 0.0f, u, v, 0);
                u -= du;
            }
            vertCount += detailU;
            for (i = 0; i < detailU; ++i) {
                i0 = vert0 + i;
                i1 = vert0 + i + detailU + 1;
                indices[indCount + 3 * i + 0] = i0;
                indices[indCount + 3 * i + 1] = i1;
                indices[indCount + 3 * i + 2] = i0 + 1;
                this.addEdge(i0, i0 + 1, true, true);
                this.addEdge(i0, i1, true, true);
            }
            indCount += 3 * detailU;
            return indices;
        }
    }

    protected class IndexCache {
        int size;
        int[] indexCount;
        int[] indexOffset;
        int[] vertexCount;
        int[] vertexOffset;

        IndexCache() {
            this.allocate();
        }

        void allocate() {
            this.indexCount = new int[2];
            this.indexOffset = new int[2];
            this.vertexCount = new int[2];
            this.vertexOffset = new int[2];
            this.size = 0;
        }

        void clear() {
            this.size = 0;
        }

        int addNew() {
            this.arrayCheck();
            this.init(this.size);
            ++this.size;
            return this.size - 1;
        }

        int addNew(int index) {
            this.arrayCheck();
            this.indexCount[this.size] = this.indexCount[index];
            this.indexOffset[this.size] = this.indexOffset[index];
            this.vertexCount[this.size] = this.vertexCount[index];
            this.vertexOffset[this.size] = this.vertexOffset[index];
            ++this.size;
            return this.size - 1;
        }

        int getLast() {
            if (this.size == 0) {
                this.arrayCheck();
                this.init(0);
                this.size = 1;
            }
            return this.size - 1;
        }

        void incCounts(int index, int icount, int vcount) {
            int n = index;
            this.indexCount[n] = this.indexCount[n] + icount;
            int n2 = index;
            this.vertexCount[n2] = this.vertexCount[n2] + vcount;
        }

        void init(int n) {
            if (0 < n) {
                this.indexOffset[n] = this.indexOffset[n - 1] + this.indexCount[n - 1];
                this.vertexOffset[n] = this.vertexOffset[n - 1] + this.vertexCount[n - 1];
            } else {
                this.indexOffset[n] = 0;
                this.vertexOffset[n] = 0;
            }
            this.indexCount[n] = 0;
            this.vertexCount[n] = 0;
        }

        void arrayCheck() {
            if (this.size == this.indexCount.length) {
                int newSize = this.size << 1;
                this.expandIndexCount(newSize);
                this.expandIndexOffset(newSize);
                this.expandVertexCount(newSize);
                this.expandVertexOffset(newSize);
            }
        }

        void expandIndexCount(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.indexCount, 0, temp, 0, this.size);
            this.indexCount = temp;
        }

        void expandIndexOffset(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.indexOffset, 0, temp, 0, this.size);
            this.indexOffset = temp;
        }

        void expandVertexCount(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.vertexCount, 0, temp, 0, this.size);
            this.vertexCount = temp;
        }

        void expandVertexOffset(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.vertexOffset, 0, temp, 0, this.size);
            this.vertexOffset = temp;
        }
    }

    protected class TexCache {
        int size;
        PImage[] textures;
        int[] firstIndex;
        int[] lastIndex;
        int[] firstCache;
        int[] lastCache;
        boolean hasTextures;

        TexCache() {
            this.allocate();
        }

        void allocate() {
            this.textures = new PImage[64];
            this.firstIndex = new int[64];
            this.lastIndex = new int[64];
            this.firstCache = new int[64];
            this.lastCache = new int[64];
            this.size = 0;
            this.hasTextures = false;
        }

        void clear() {
            Arrays.fill(this.textures, 0, this.size, null);
            this.size = 0;
            this.hasTextures = false;
        }

        boolean containsTexture(PImage img) {
            for (int i = 0; i < this.size; ++i) {
                if (this.textures[i] != img) continue;
                return true;
            }
            return false;
        }

        PImage getTextureImage(int i) {
            return this.textures[i];
        }

        Texture getTexture(int i) {
            PImage img = this.textures[i];
            Texture tex = null;
            if (img != null) {
                tex = pgPrimary.getTexture(img);
            }
            return tex;
        }

        void addTexture(PImage img, int firsti, int firstb, int lasti, int lastb) {
            this.arrayCheck();
            this.textures[this.size] = img;
            this.firstIndex[this.size] = firsti;
            this.lastIndex[this.size] = lasti;
            this.firstCache[this.size] = firstb;
            this.lastCache[this.size] = lastb;
            this.hasTextures |= img != null;
            ++this.size;
        }

        void setLastIndex(int lasti, int lastb) {
            this.lastIndex[this.size - 1] = lasti;
            this.lastCache[this.size - 1] = lastb;
        }

        void arrayCheck() {
            if (this.size == this.textures.length) {
                int newSize = this.size << 1;
                this.expandTextures(newSize);
                this.expandFirstIndex(newSize);
                this.expandLastIndex(newSize);
                this.expandFirstCache(newSize);
                this.expandLastCache(newSize);
            }
        }

        void expandTextures(int n) {
            PImage[] temp = new PImage[n];
            PApplet.arrayCopy(this.textures, 0, temp, 0, this.size);
            this.textures = temp;
        }

        void expandFirstIndex(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.firstIndex, 0, temp, 0, this.size);
            this.firstIndex = temp;
        }

        void expandLastIndex(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.lastIndex, 0, temp, 0, this.size);
            this.lastIndex = temp;
        }

        void expandFirstCache(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.firstCache, 0, temp, 0, this.size);
            this.firstCache = temp;
        }

        void expandLastCache(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.lastCache, 0, temp, 0, this.size);
            this.lastCache = temp;
        }
    }

    protected class PointShader
    extends BaseShader {
        protected int perspectiveLoc;
        protected int vertexLoc;
        protected int colorLoc;
        protected int offsetLoc;

        public PointShader(PApplet parent) {
            super(parent);
        }

        public PointShader(PApplet parent, String vertFilename, String fragFilename) {
            super(parent, vertFilename, fragFilename);
        }

        public PointShader(PApplet parent, URL vertURL, URL fragURL) {
            super(parent, vertURL, fragURL);
        }

        @Override
        public void loadAttributes() {
            this.vertexLoc = this.getAttributeLoc("vertex");
            this.colorLoc = this.getAttributeLoc("color");
            this.offsetLoc = this.getAttributeLoc("offset");
        }

        @Override
        public void loadUniforms() {
            super.loadUniforms();
            this.perspectiveLoc = this.getUniformLoc("perspective");
        }

        @Override
        public void setVertexAttribute(int vboId, int size, int type, int stride, int offset) {
            this.setAttributeVBO(this.vertexLoc, vboId, size, type, false, stride, offset);
        }

        @Override
        public void setColorAttribute(int vboId, int size, int type, int stride, int offset) {
            this.setAttributeVBO(this.colorLoc, vboId, size, type, true, stride, offset);
        }

        public void setPointAttribute(int vboId, int size, int type, int stride, int offset) {
            this.setAttributeVBO(this.offsetLoc, vboId, size, type, false, stride, offset);
        }

        @Override
        public void bind() {
            super.bind();
            if (this.pgCurrent == null) {
                this.setRenderer(pgCurrent);
                this.loadAttributes();
                this.loadUniforms();
            }
            if (-1 < this.vertexLoc) {
                this.pgl.enableVertexAttribArray(this.vertexLoc);
            }
            if (-1 < this.colorLoc) {
                this.pgl.enableVertexAttribArray(this.colorLoc);
            }
            if (-1 < this.offsetLoc) {
                this.pgl.enableVertexAttribArray(this.offsetLoc);
            }
            if (this.pgCurrent.getHint(7) && this.pgCurrent.nonOrthoProjection()) {
                this.setUniformValue(this.perspectiveLoc, 1);
            } else {
                this.setUniformValue(this.perspectiveLoc, 0);
            }
            super.setCommonUniforms();
        }

        @Override
        public void unbind() {
            if (-1 < this.vertexLoc) {
                this.pgl.disableVertexAttribArray(this.vertexLoc);
            }
            if (-1 < this.colorLoc) {
                this.pgl.disableVertexAttribArray(this.colorLoc);
            }
            if (-1 < this.offsetLoc) {
                this.pgl.disableVertexAttribArray(this.offsetLoc);
            }
            super.unbind();
        }
    }

    protected class LineShader
    extends BaseShader {
        protected int perspectiveLoc;
        protected int scaleLoc;
        protected int vertexLoc;
        protected int colorLoc;
        protected int directionLoc;

        public LineShader(PApplet parent) {
            super(parent);
        }

        public LineShader(PApplet parent, String vertFilename, String fragFilename) {
            super(parent, vertFilename, fragFilename);
        }

        public LineShader(PApplet parent, URL vertURL, URL fragURL) {
            super(parent, vertURL, fragURL);
        }

        @Override
        public void loadAttributes() {
            this.vertexLoc = this.getAttributeLoc("vertex");
            this.colorLoc = this.getAttributeLoc("color");
            this.directionLoc = this.getAttributeLoc("direction");
        }

        @Override
        public void loadUniforms() {
            super.loadUniforms();
            this.viewportLoc = this.getUniformLoc("viewport");
            this.perspectiveLoc = this.getUniformLoc("perspective");
            this.scaleLoc = this.getUniformLoc("scale");
        }

        @Override
        public void setVertexAttribute(int vboId, int size, int type, int stride, int offset) {
            this.setAttributeVBO(this.vertexLoc, vboId, size, type, false, stride, offset);
        }

        @Override
        public void setColorAttribute(int vboId, int size, int type, int stride, int offset) {
            this.setAttributeVBO(this.colorLoc, vboId, size, type, true, stride, offset);
        }

        public void setLineAttribute(int vboId, int size, int type, int stride, int offset) {
            this.setAttributeVBO(this.directionLoc, vboId, size, type, false, stride, offset);
        }

        @Override
        public void bind() {
            super.bind();
            if (this.pgCurrent == null) {
                this.setRenderer(pgCurrent);
                this.loadAttributes();
                this.loadUniforms();
            }
            if (-1 < this.vertexLoc) {
                this.pgl.enableVertexAttribArray(this.vertexLoc);
            }
            if (-1 < this.colorLoc) {
                this.pgl.enableVertexAttribArray(this.colorLoc);
            }
            if (-1 < this.directionLoc) {
                this.pgl.enableVertexAttribArray(this.directionLoc);
            }
            if (this.pgCurrent.getHint(7) && this.pgCurrent.nonOrthoProjection()) {
                this.setUniformValue(this.perspectiveLoc, 1);
            } else {
                this.setUniformValue(this.perspectiveLoc, 0);
            }
            if (this.pgCurrent.getHint(6)) {
                this.setUniformValue(this.scaleLoc, 1.0f, 1.0f, 1.0f);
            } else {
                float f = 0.999f;
                if (PGraphicsOpenGL.this.orthoProjection()) {
                    this.setUniformValue(this.scaleLoc, 1.0f, 1.0f, f);
                } else {
                    this.setUniformValue(this.scaleLoc, f, f, f);
                }
            }
            this.setCommonUniforms();
        }

        @Override
        public void unbind() {
            if (-1 < this.vertexLoc) {
                this.pgl.disableVertexAttribArray(this.vertexLoc);
            }
            if (-1 < this.colorLoc) {
                this.pgl.disableVertexAttribArray(this.colorLoc);
            }
            if (-1 < this.directionLoc) {
                this.pgl.disableVertexAttribArray(this.directionLoc);
            }
            super.unbind();
        }
    }

    protected class TexlightShader
    extends LightShader {
        protected Texture texture;
        protected int texUnit;
        protected int texCoordLoc;
        protected int textureLoc;
        protected int texMatrixLoc;
        protected int texOffsetLoc;
        protected float[] tcmat;

        public TexlightShader(PApplet parent) {
            super(parent);
        }

        public TexlightShader(PApplet parent, String vertFilename, String fragFilename) {
            super(parent, vertFilename, fragFilename);
        }

        public TexlightShader(PApplet parent, URL vertURL, URL fragURL) {
            super(parent, vertURL, fragURL);
        }

        @Override
        public void loadUniforms() {
            super.loadUniforms();
            this.textureLoc = this.getUniformLoc("texture");
            this.texMatrixLoc = this.getUniformLoc("texMatrix");
            this.texOffsetLoc = this.getUniformLoc("texOffset");
        }

        @Override
        public void loadAttributes() {
            super.loadAttributes();
            this.texCoordLoc = this.getAttributeLoc("texCoord");
        }

        @Override
        public void setTexcoordAttribute(int vboId, int size, int type, int stride, int offset) {
            this.setAttributeVBO(this.texCoordLoc, vboId, size, type, false, stride, offset);
        }

        @Override
        public int getLastTexUnit() {
            return -1 < this.bufferUnit ? this.bufferUnit : super.getLastTexUnit();
        }

        @Override
        public void setTexture(Texture tex) {
            float scaleu = 1.0f;
            float scalev = 1.0f;
            float dispu = 0.0f;
            float dispv = 0.0f;
            if (tex.invertedX()) {
                scaleu = -1.0f;
                dispu = 1.0f;
            }
            if (tex.invertedY()) {
                scalev = -1.0f;
                dispv = 1.0f;
            }
            scaleu *= tex.maxTexcoordU;
            dispu *= tex.maxTexcoordU;
            scalev *= tex.maxTexcoordV;
            dispv *= tex.maxTexcoordV;
            if (-1 < this.texMatrixLoc) {
                if (this.tcmat == null) {
                    this.tcmat = new float[16];
                }
                this.tcmat[0] = scaleu;
                this.tcmat[4] = 0.0f;
                this.tcmat[8] = 0.0f;
                this.tcmat[12] = dispu;
                this.tcmat[1] = 0.0f;
                this.tcmat[5] = scalev;
                this.tcmat[9] = 0.0f;
                this.tcmat[13] = dispv;
                this.tcmat[2] = 0.0f;
                this.tcmat[6] = 0.0f;
                this.tcmat[10] = 0.0f;
                this.tcmat[14] = 0.0f;
                this.tcmat[3] = 0.0f;
                this.tcmat[7] = 0.0f;
                this.tcmat[11] = 0.0f;
                this.tcmat[15] = 0.0f;
                this.setUniformMatrix(this.texMatrixLoc, this.tcmat);
            }
            this.setUniformValue(this.texOffsetLoc, 1.0f / (float)tex.width, 1.0f / (float)tex.height);
            if (-1 < this.textureLoc) {
                this.texUnit = this.getLastTexUnit() + 1;
                this.setUniformValue(this.textureLoc, this.texUnit);
                this.pgl.activeTexture(33984 + this.texUnit);
                tex.bind();
                this.texture = tex;
            }
        }

        @Override
        public void bind() {
            super.bind();
            if (-1 < this.texCoordLoc) {
                this.pgl.enableVertexAttribArray(this.texCoordLoc);
            }
        }

        @Override
        public void unbind() {
            if (-1 < this.texCoordLoc) {
                this.pgl.disableVertexAttribArray(this.texCoordLoc);
            }
            if (-1 < this.textureLoc && this.texture != null) {
                this.pgl.activeTexture(33984 + this.texUnit);
                this.texture.unbind();
                this.pgl.activeTexture(33984);
                this.texture = null;
            }
            super.unbind();
        }
    }

    protected class TextureShader
    extends ColorShader {
        protected Texture texture;
        protected int texUnit;
        protected int texCoordLoc;
        protected int textureLoc;
        protected int texMatrixLoc;
        protected int texOffsetLoc;
        protected int normalMatrixLoc;
        protected int normalLoc;
        protected float[] tcmat;

        public TextureShader(PApplet parent) {
            super(parent);
        }

        public TextureShader(PApplet parent, String vertFilename, String fragFilename) {
            super(parent, vertFilename, fragFilename);
        }

        public TextureShader(PApplet parent, URL vertURL, URL fragURL) {
            super(parent, vertURL, fragURL);
        }

        @Override
        public void loadUniforms() {
            super.loadUniforms();
            this.textureLoc = this.getUniformLoc("texture");
            this.texMatrixLoc = this.getUniformLoc("texMatrix");
            this.texOffsetLoc = this.getUniformLoc("texOffset");
            this.normalMatrixLoc = this.getUniformLoc("normalMatrix");
        }

        @Override
        public void loadAttributes() {
            super.loadAttributes();
            this.texCoordLoc = this.getAttributeLoc("texCoord");
            this.normalLoc = this.getAttributeLoc("normal");
        }

        @Override
        public void setNormalAttribute(int vboId, int size, int type, int stride, int offset) {
            this.setAttributeVBO(this.normalLoc, vboId, size, type, false, stride, offset);
        }

        @Override
        public void setTexcoordAttribute(int vboId, int size, int type, int stride, int offset) {
            this.setAttributeVBO(this.texCoordLoc, vboId, size, type, false, stride, offset);
        }

        @Override
        public int getLastTexUnit() {
            return -1 < this.bufferUnit ? this.bufferUnit : super.getLastTexUnit();
        }

        @Override
        public void setTexture(Texture tex) {
            float scaleu = 1.0f;
            float scalev = 1.0f;
            float dispu = 0.0f;
            float dispv = 0.0f;
            if (tex.invertedX()) {
                scaleu = -1.0f;
                dispu = 1.0f;
            }
            if (tex.invertedY()) {
                scalev = -1.0f;
                dispv = 1.0f;
            }
            scaleu *= tex.maxTexcoordU();
            dispu *= tex.maxTexcoordU();
            scalev *= tex.maxTexcoordV();
            dispv *= tex.maxTexcoordV();
            if (-1 < this.texMatrixLoc) {
                if (this.tcmat == null) {
                    this.tcmat = new float[16];
                }
                this.tcmat[0] = scaleu;
                this.tcmat[4] = 0.0f;
                this.tcmat[8] = 0.0f;
                this.tcmat[12] = dispu;
                this.tcmat[1] = 0.0f;
                this.tcmat[5] = scalev;
                this.tcmat[9] = 0.0f;
                this.tcmat[13] = dispv;
                this.tcmat[2] = 0.0f;
                this.tcmat[6] = 0.0f;
                this.tcmat[10] = 0.0f;
                this.tcmat[14] = 0.0f;
                this.tcmat[3] = 0.0f;
                this.tcmat[7] = 0.0f;
                this.tcmat[11] = 0.0f;
                this.tcmat[15] = 0.0f;
                this.setUniformMatrix(this.texMatrixLoc, this.tcmat);
            }
            this.setUniformValue(this.texOffsetLoc, 1.0f / (float)tex.width, 1.0f / (float)tex.height);
            if (-1 < this.textureLoc) {
                this.texUnit = this.getLastTexUnit() + 1;
                this.setUniformValue(this.textureLoc, this.texUnit);
                this.pgl.activeTexture(33984 + this.texUnit);
                tex.bind();
                this.texture = tex;
            }
        }

        @Override
        public void bind() {
            super.bind();
            if (-1 < this.texCoordLoc) {
                this.pgl.enableVertexAttribArray(this.texCoordLoc);
            }
            if (-1 < this.normalLoc) {
                this.pgl.enableVertexAttribArray(this.normalLoc);
            }
            if (-1 < this.normalMatrixLoc) {
                this.pgCurrent.updateGLNormal();
                this.setUniformMatrix(this.normalMatrixLoc, this.pgCurrent.glNormal);
            }
        }

        @Override
        public void unbind() {
            if (-1 < this.texCoordLoc) {
                this.pgl.disableVertexAttribArray(this.texCoordLoc);
            }
            if (-1 < this.normalLoc) {
                this.pgl.disableVertexAttribArray(this.normalLoc);
            }
            if (-1 < this.textureLoc && this.texture != null) {
                this.pgl.activeTexture(33984 + this.texUnit);
                this.texture.unbind();
                this.pgl.activeTexture(33984);
                this.texture = null;
            }
            super.unbind();
        }
    }

    protected class LightShader
    extends BaseShader {
        protected int normalMatrixLoc;
        protected int lightCountLoc;
        protected int lightPositionLoc;
        protected int lightNormalLoc;
        protected int lightAmbientLoc;
        protected int lightDiffuseLoc;
        protected int lightSpecularLoc;
        protected int lightFalloffLoc;
        protected int lightSpotLoc;
        protected int vertexLoc;
        protected int colorLoc;
        protected int normalLoc;
        protected int ambientLoc;
        protected int specularLoc;
        protected int emissiveLoc;
        protected int shininessLoc;

        public LightShader(PApplet parent) {
            super(parent);
        }

        public LightShader(PApplet parent, String vertFilename, String fragFilename) {
            super(parent, vertFilename, fragFilename);
        }

        public LightShader(PApplet parent, URL vertURL, URL fragURL) {
            super(parent, vertURL, fragURL);
        }

        @Override
        public void loadAttributes() {
            this.vertexLoc = this.getAttributeLoc("vertex");
            this.colorLoc = this.getAttributeLoc("color");
            this.normalLoc = this.getAttributeLoc("normal");
            this.ambientLoc = this.getAttributeLoc("ambient");
            this.specularLoc = this.getAttributeLoc("specular");
            this.emissiveLoc = this.getAttributeLoc("emissive");
            this.shininessLoc = this.getAttributeLoc("shininess");
        }

        @Override
        public void loadUniforms() {
            super.loadUniforms();
            this.normalMatrixLoc = this.getUniformLoc("normalMatrix");
            this.lightCountLoc = this.getUniformLoc("lightCount");
            this.lightPositionLoc = this.getUniformLoc("lightPosition");
            this.lightNormalLoc = this.getUniformLoc("lightNormal");
            this.lightAmbientLoc = this.getUniformLoc("lightAmbient");
            this.lightDiffuseLoc = this.getUniformLoc("lightDiffuse");
            this.lightSpecularLoc = this.getUniformLoc("lightSpecular");
            this.lightFalloffLoc = this.getUniformLoc("lightFalloff");
            this.lightSpotLoc = this.getUniformLoc("lightSpot");
        }

        @Override
        public void setVertexAttribute(int vboId, int size, int type, int stride, int offset) {
            this.setAttributeVBO(this.vertexLoc, vboId, size, type, false, stride, offset);
        }

        @Override
        public void setColorAttribute(int vboId, int size, int type, int stride, int offset) {
            this.setAttributeVBO(this.colorLoc, vboId, size, type, true, stride, offset);
        }

        @Override
        public void setNormalAttribute(int vboId, int size, int type, int stride, int offset) {
            this.setAttributeVBO(this.normalLoc, vboId, size, type, false, stride, offset);
        }

        @Override
        public void setAmbientAttribute(int vboId, int size, int type, int stride, int offset) {
            this.setAttributeVBO(this.ambientLoc, vboId, size, type, true, stride, offset);
        }

        @Override
        public void setSpecularAttribute(int vboId, int size, int type, int stride, int offset) {
            this.setAttributeVBO(this.specularLoc, vboId, size, type, true, stride, offset);
        }

        @Override
        public void setEmissiveAttribute(int vboId, int size, int type, int stride, int offset) {
            this.setAttributeVBO(this.emissiveLoc, vboId, size, type, true, stride, offset);
        }

        @Override
        public void setShininessAttribute(int vboId, int size, int type, int stride, int offset) {
            this.setAttributeVBO(this.shininessLoc, vboId, size, type, false, stride, offset);
        }

        @Override
        public void bind() {
            super.bind();
            if (this.pgCurrent == null) {
                this.setRenderer(pgCurrent);
                this.loadAttributes();
                this.loadUniforms();
            }
            if (-1 < this.vertexLoc) {
                this.pgl.enableVertexAttribArray(this.vertexLoc);
            }
            if (-1 < this.colorLoc) {
                this.pgl.enableVertexAttribArray(this.colorLoc);
            }
            if (-1 < this.normalLoc) {
                this.pgl.enableVertexAttribArray(this.normalLoc);
            }
            if (-1 < this.ambientLoc) {
                this.pgl.enableVertexAttribArray(this.ambientLoc);
            }
            if (-1 < this.specularLoc) {
                this.pgl.enableVertexAttribArray(this.specularLoc);
            }
            if (-1 < this.emissiveLoc) {
                this.pgl.enableVertexAttribArray(this.emissiveLoc);
            }
            if (-1 < this.shininessLoc) {
                this.pgl.enableVertexAttribArray(this.shininessLoc);
            }
            if (-1 < this.normalMatrixLoc) {
                this.pgCurrent.updateGLNormal();
                this.setUniformMatrix(this.normalMatrixLoc, this.pgCurrent.glNormal);
            }
            int count = this.pgCurrent.lightCount;
            this.setUniformValue(this.lightCountLoc, count);
            this.setUniformVector(this.lightPositionLoc, this.pgCurrent.lightPosition, 4, count);
            this.setUniformVector(this.lightNormalLoc, this.pgCurrent.lightNormal, 3, count);
            this.setUniformVector(this.lightAmbientLoc, this.pgCurrent.lightAmbient, 3, count);
            this.setUniformVector(this.lightDiffuseLoc, this.pgCurrent.lightDiffuse, 3, count);
            this.setUniformVector(this.lightSpecularLoc, this.pgCurrent.lightSpecular, 3, count);
            this.setUniformVector(this.lightFalloffLoc, this.pgCurrent.lightFalloffCoefficients, 3, count);
            this.setUniformVector(this.lightSpotLoc, this.pgCurrent.lightSpotParameters, 2, count);
            this.setCommonUniforms();
        }

        @Override
        public void unbind() {
            if (-1 < this.vertexLoc) {
                this.pgl.disableVertexAttribArray(this.vertexLoc);
            }
            if (-1 < this.colorLoc) {
                this.pgl.disableVertexAttribArray(this.colorLoc);
            }
            if (-1 < this.normalLoc) {
                this.pgl.disableVertexAttribArray(this.normalLoc);
            }
            if (-1 < this.ambientLoc) {
                this.pgl.disableVertexAttribArray(this.ambientLoc);
            }
            if (-1 < this.specularLoc) {
                this.pgl.disableVertexAttribArray(this.specularLoc);
            }
            if (-1 < this.emissiveLoc) {
                this.pgl.disableVertexAttribArray(this.emissiveLoc);
            }
            if (-1 < this.shininessLoc) {
                this.pgl.disableVertexAttribArray(this.shininessLoc);
            }
            super.unbind();
        }
    }

    protected class ColorShader
    extends BaseShader {
        protected int vertexLoc;
        protected int colorLoc;

        public ColorShader(PApplet parent) {
            super(parent);
        }

        public ColorShader(PApplet parent, String vertFilename, String fragFilename) {
            super(parent, vertFilename, fragFilename);
        }

        public ColorShader(PApplet parent, URL vertURL, URL fragURL) {
            super(parent, vertURL, fragURL);
        }

        @Override
        public void loadAttributes() {
            this.vertexLoc = this.getAttributeLoc("vertex");
            this.colorLoc = this.getAttributeLoc("color");
        }

        @Override
        public void loadUniforms() {
            super.loadUniforms();
        }

        @Override
        public void setVertexAttribute(int vboId, int size, int type, int stride, int offset) {
            this.setAttributeVBO(this.vertexLoc, vboId, size, type, false, stride, offset);
        }

        @Override
        public void setColorAttribute(int vboId, int size, int type, int stride, int offset) {
            this.setAttributeVBO(this.colorLoc, vboId, size, type, true, stride, offset);
        }

        @Override
        public void bind() {
            super.bind();
            if (this.pgCurrent == null) {
                this.setRenderer(pgCurrent);
                this.loadAttributes();
                this.loadUniforms();
            }
            if (-1 < this.vertexLoc) {
                this.pgl.enableVertexAttribArray(this.vertexLoc);
            }
            if (-1 < this.colorLoc) {
                this.pgl.enableVertexAttribArray(this.colorLoc);
            }
            this.setCommonUniforms();
        }

        @Override
        public void unbind() {
            if (-1 < this.vertexLoc) {
                this.pgl.disableVertexAttribArray(this.vertexLoc);
            }
            if (-1 < this.colorLoc) {
                this.pgl.disableVertexAttribArray(this.colorLoc);
            }
            super.unbind();
        }
    }

    protected class BaseShader
    extends PShader {
        protected int transformLoc;
        protected int modelviewLoc;
        protected int projectionLoc;
        protected int bufferLoc;
        protected int bufferUnit;
        protected int viewportLoc;

        public BaseShader(PApplet parent) {
            super(parent);
        }

        public BaseShader(PApplet parent, String vertFilename, String fragFilename) {
            super(parent, vertFilename, fragFilename);
        }

        public BaseShader(PApplet parent, URL vertURL, URL fragURL) {
            super(parent, vertURL, fragURL);
        }

        @Override
        public void loadUniforms() {
            this.transformLoc = this.getUniformLoc("transform");
            this.modelviewLoc = this.getUniformLoc("modelview");
            this.projectionLoc = this.getUniformLoc("projection");
            this.viewportLoc = this.getUniformLoc("viewport");
            this.bufferLoc = this.getUniformLoc("buffer");
        }

        @Override
        public void unbind() {
            if (-1 < this.bufferLoc) {
                this.pgl.requestFBOLayer();
                this.pgl.activeTexture(33984 + this.bufferUnit);
                this.pgCurrent.unbindFrontTexture();
                this.pgl.activeTexture(33984);
            }
            this.pgl.bindBuffer(34962, 0);
            super.unbind();
        }

        protected void setCommonUniforms() {
            if (-1 < this.transformLoc) {
                this.pgCurrent.updateGLProjmodelview();
                this.setUniformMatrix(this.transformLoc, this.pgCurrent.glProjmodelview);
            }
            if (-1 < this.modelviewLoc) {
                this.pgCurrent.updateGLModelview();
                this.setUniformMatrix(this.modelviewLoc, this.pgCurrent.glModelview);
            }
            if (-1 < this.projectionLoc) {
                this.pgCurrent.updateGLProjection();
                this.setUniformMatrix(this.projectionLoc, this.pgCurrent.glProjection);
            }
            if (-1 < this.viewportLoc) {
                float x = this.pgCurrent.viewport.get(0);
                float y = this.pgCurrent.viewport.get(1);
                float w = this.pgCurrent.viewport.get(2);
                float h = this.pgCurrent.viewport.get(3);
                this.setUniformValue(this.viewportLoc, x, y, w, h);
            }
            if (-1 < this.bufferLoc) {
                this.bufferUnit = this.getLastTexUnit() + 1;
                this.setUniformValue(this.bufferLoc, this.bufferUnit);
                this.pgl.activeTexture(33984 + this.bufferUnit);
                this.pgCurrent.bindFrontTexture();
            } else {
                this.bufferUnit = -1;
            }
        }

        public void setVertexAttribute(int vboId, int size, int type, int stride, int offset) {
        }

        public void setColorAttribute(int vboId, int size, int type, int stride, int offset) {
        }

        public void setNormalAttribute(int vboId, int size, int type, int stride, int offset) {
        }

        public void setAmbientAttribute(int vboId, int size, int type, int stride, int offset) {
        }

        public void setSpecularAttribute(int vboId, int size, int type, int stride, int offset) {
        }

        public void setEmissiveAttribute(int vboId, int size, int type, int stride, int offset) {
        }

        public void setShininessAttribute(int vboId, int size, int type, int stride, int offset) {
        }

        public void setTexcoordAttribute(int vboId, int size, int type, int stride, int offset) {
        }

        public void setTexture(Texture tex) {
        }
    }

    protected static class GLResource {
        int id;
        int context;

        GLResource(int id, int context) {
            this.id = id;
            this.context = context;
        }

        public boolean equals(Object obj) {
            GLResource other = (GLResource)obj;
            return other.id == this.id && other.context == this.context;
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.id;
            result = 31 * result + this.context;
            return result;
        }
    }
}

