package lec12loops;

import processing.core.PApplet;


public class Lec12Loops extends PApplet {

	public final int MINSIZE = 10;
	
	public int tileWidth = MINSIZE; // width of tiling shape
	public int tileHeight = MINSIZE; // height of tiling shape
	
	// fill color for tiling shape
	public int fillR = 255;
	public int fillG = 255;
	public int fillB = 0;
	
	public boolean drawArcs = false; // whether to draw rectangles or ellipses
	
	public void setup() {
		size(800, 450);
		smooth();
		
		fill(fillR, fillG, fillB);
		noStroke();
		
		ellipseMode(CORNER); // should simplify drawing 
	}
	
	public void drawARow(int y) {
		int x = 0; // start at the left edge of the screen

		while (x < width) { // keep drawing until we hit the right edge of the screen

			ellipse(x, y, tileWidth, tileHeight);

			if (drawArcs) {
				fill(fillG, fillB, fillR); // change colors
				arc(x, y, tileWidth, tileHeight, 0, PI/2);
				arc(x, y, tileWidth, tileHeight, PI, 3*PI/2);
				fill(fillR, fillG, fillB); // put the original color back
			}
			
			x = x + tileWidth; // move to the right and get ready to draw again
		}

	}
	
	public void draw() {
		background(255-fillR, 255-fillG, 255-fillB);
		
		int y = 0; // start at the top of the screen
		while (y < height) { // keep drawing until we hit the bottom edge of the screen
			drawARow(y);
			y = y + tileHeight; // move down and get ready to draw again
		}
	}
	
	public void mouseMoved() {
		tileWidth = Math.max(mouseX / 10, MINSIZE);
		tileHeight = Math.max(mouseY / 10, MINSIZE);
	}
	
	public void mouseClicked() {
		drawArcs = !drawArcs;
	}
}
