/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.nio;

import com.jogamp.common.nio.AbstractBuffer;
import com.jogamp.common.nio.Buffers;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.LongObjectHashMap;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;

public class PointerBuffer
extends AbstractBuffer<PointerBuffer> {
    public static final int ELEMENT_SIZE = Platform.is32Bit() ? 4 : 8;
    protected LongObjectHashMap dataMap = null;

    static PointerBuffer create(ByteBuffer byteBuffer) {
        return Platform.is32Bit() ? new PointerBuffer(byteBuffer.asIntBuffer()) : new PointerBuffer(byteBuffer.asLongBuffer());
    }

    PointerBuffer(IntBuffer intBuffer) {
        super(intBuffer, ELEMENT_SIZE, intBuffer.capacity());
    }

    PointerBuffer(LongBuffer longBuffer) {
        super(longBuffer, ELEMENT_SIZE, longBuffer.capacity());
    }

    private final void validateDataMap() {
        if (null == this.dataMap) {
            this.dataMap = new LongObjectHashMap();
            this.dataMap.setKeyNotFoundValue(null);
        }
    }

    public static PointerBuffer allocate(int n) {
        if (Platform.is32Bit()) {
            return new PointerBuffer(IntBuffer.wrap(new int[n]));
        }
        return new PointerBuffer(LongBuffer.wrap(new long[n]));
    }

    public static PointerBuffer allocateDirect(int n) {
        return PointerBuffer.create(Buffers.newDirectByteBuffer(ELEMENT_SIZE * n));
    }

    public static PointerBuffer wrap(ByteBuffer byteBuffer) {
        return PointerBuffer.create(byteBuffer);
    }

    public final PointerBuffer duplicate() {
        PointerBuffer pointerBuffer = Platform.is32Bit() ? new PointerBuffer((IntBuffer)this.buffer) : new PointerBuffer((LongBuffer)this.buffer);
        if (null != this.dataMap) {
            pointerBuffer.dataMap = (LongObjectHashMap)this.dataMap.clone();
        }
        pointerBuffer.position = this.position;
        return pointerBuffer;
    }

    @Override
    public final PointerBuffer put(PointerBuffer pointerBuffer) {
        if (this.remaining() < pointerBuffer.remaining()) {
            throw new IndexOutOfBoundsException();
        }
        if (null == pointerBuffer.dataMap && null == this.dataMap) {
            while (pointerBuffer.hasRemaining()) {
                this.put(pointerBuffer.get());
            }
        } else {
            while (pointerBuffer.hasRemaining()) {
                long l = pointerBuffer.get();
                this.put(l);
                if (null != pointerBuffer.dataMap) {
                    Buffer buffer = (Buffer)pointerBuffer.dataMap.get(l);
                    if (null != buffer) {
                        this.validateDataMap();
                        this.dataMap.put(l, buffer);
                        continue;
                    }
                    if (null == this.dataMap) continue;
                    this.dataMap.remove(l);
                    continue;
                }
                if (null == this.dataMap) continue;
                this.dataMap.remove(l);
            }
        }
        return this;
    }

    @Override
    public final long get() {
        long l = this.get(this.position);
        ++this.position;
        return l;
    }

    @Override
    public final long get(int n) {
        if (0 > n || n >= this.capacity) {
            throw new IndexOutOfBoundsException();
        }
        if (Platform.is32Bit()) {
            return (long)((IntBuffer)this.buffer).get(n) & 0xFFFFFFFFL;
        }
        return ((LongBuffer)this.buffer).get(n);
    }

    public final PointerBuffer get(long[] lArray, int n, int n2) {
        if (lArray.length < n + n2) {
            throw new IndexOutOfBoundsException();
        }
        if (this.remaining() < n2) {
            throw new IndexOutOfBoundsException();
        }
        while (n2 > 0) {
            lArray[n++] = this.get(this.position++);
            --n2;
        }
        return this;
    }

    @Override
    public final PointerBuffer put(int n, long l) {
        if (0 > n || n >= this.capacity) {
            throw new IndexOutOfBoundsException();
        }
        if (Platform.is32Bit()) {
            ((IntBuffer)this.buffer).put(n, (int)l);
        } else {
            ((LongBuffer)this.buffer).put(n, l);
        }
        return this;
    }

    @Override
    public final PointerBuffer put(long l) {
        this.put(this.position, l);
        ++this.position;
        return this;
    }

    public final PointerBuffer put(long[] lArray, int n, int n2) {
        if (lArray.length < n + n2) {
            throw new IndexOutOfBoundsException();
        }
        if (this.remaining() < n2) {
            throw new IndexOutOfBoundsException();
        }
        while (n2 > 0) {
            this.put(this.position++, lArray[n++]);
            --n2;
        }
        return this;
    }

    public final PointerBuffer referenceBuffer(int n, Buffer buffer) {
        if (null == buffer) {
            throw new IllegalArgumentException("Buffer is null");
        }
        if (!Buffers.isDirect(buffer)) {
            throw new IllegalArgumentException("Buffer is not direct");
        }
        long l = Platform.is32Bit() ? 0xFFFFFFFFL : -1L;
        long l2 = this.getDirectBufferAddressImpl(buffer) & l;
        if (0L == l2) {
            throw new RuntimeException("Couldn't determine native address of given Buffer: " + buffer);
        }
        this.validateDataMap();
        this.put(n, l2);
        this.dataMap.put(l2, buffer);
        return this;
    }

    public final PointerBuffer referenceBuffer(Buffer buffer) {
        this.referenceBuffer(this.position, buffer);
        ++this.position;
        return this;
    }

    public final Buffer getReferencedBuffer(int n) {
        if (null != this.dataMap) {
            long l = this.get(n);
            return (Buffer)this.dataMap.get(l);
        }
        return null;
    }

    public final Buffer getReferencedBuffer() {
        Buffer buffer = this.getReferencedBuffer(this.position);
        ++this.position;
        return buffer;
    }

    private native long getDirectBufferAddressImpl(Object var1);

    @Override
    public String toString() {
        return "PointerBuffer:" + super.toString();
    }

    static {
        Platform.initSingleton();
    }
}

