/*
 * Decompiled with CFR 0.152.
 */
package processing.data;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import processing.core.PApplet;
import processing.data.FloatDict;
import processing.data.Sort;

public class IntDict {
    protected int count;
    protected String[] keys;
    protected int[] values;
    private HashMap<String, Integer> indices = new HashMap();

    public IntDict() {
        this.count = 0;
        this.keys = new String[10];
        this.values = new int[10];
    }

    public IntDict(int length) {
        this.count = 0;
        this.keys = new String[length];
        this.values = new int[length];
    }

    public IntDict(BufferedReader reader) {
        String[] lines = PApplet.loadStrings(reader);
        this.keys = new String[lines.length];
        this.values = new int[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            String[] pieces = PApplet.split(lines[i], '\t');
            if (pieces.length != 2) continue;
            this.keys[this.count] = pieces[0];
            this.values[this.count] = PApplet.parseInt(pieces[1]);
            ++this.count;
        }
    }

    public IntDict(String[] keys, int[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("key and value arrays must be the same length");
        }
        this.keys = keys;
        this.values = values;
        this.count = keys.length;
        for (int i = 0; i < this.count; ++i) {
            this.indices.put(keys[i], i);
        }
    }

    public int size() {
        return this.count;
    }

    public void clear() {
        this.count = 0;
        this.indices = new HashMap();
    }

    public String key(int index) {
        return this.keys[index];
    }

    public Iterable<String> keys() {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return IntDict.this.keyIterator();
            }
        };
    }

    public Iterator<String> keyIterator() {
        return new Iterator<String>(){
            int index = -1;

            @Override
            public void remove() {
                IntDict.this.removeIndex(this.index);
            }

            @Override
            public String next() {
                return IntDict.this.key(++this.index);
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < IntDict.this.size();
            }
        };
    }

    public String[] keyArray() {
        return this.keyArray(null);
    }

    public String[] keyArray(String[] outgoing) {
        if (outgoing == null || outgoing.length != this.count) {
            outgoing = new String[this.count];
        }
        System.arraycopy(this.keys, 0, outgoing, 0, this.count);
        return outgoing;
    }

    public int value(int index) {
        return this.values[index];
    }

    public Iterable<Integer> values() {
        return new Iterable<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                return IntDict.this.valueIterator();
            }
        };
    }

    public Iterator<Integer> valueIterator() {
        return new Iterator<Integer>(){
            int index = -1;

            @Override
            public void remove() {
                IntDict.this.removeIndex(this.index);
            }

            @Override
            public Integer next() {
                return IntDict.this.value(++this.index);
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < IntDict.this.size();
            }
        };
    }

    public int[] valueArray() {
        return this.valueArray(null);
    }

    public int[] valueArray(int[] array) {
        if (array == null || array.length != this.size()) {
            array = new int[this.count];
        }
        System.arraycopy(this.values, 0, array, 0, this.count);
        return array;
    }

    public int get(String key) {
        int index = this.index(key);
        if (index == -1) {
            return 0;
        }
        return this.values[index];
    }

    public void set(String key, int amount) {
        int index = this.index(key);
        if (index == -1) {
            this.create(key, amount);
        } else {
            this.values[index] = amount;
        }
    }

    public boolean hasKey(String key) {
        return this.index(key) != -1;
    }

    public void increment(String key) {
        this.add(key, 1);
    }

    public void add(String key, int amount) {
        int index = this.index(key);
        if (index == -1) {
            this.create(key, amount);
        } else {
            int n = index;
            this.values[n] = this.values[n] + amount;
        }
    }

    public void sub(String key, int amount) {
        this.add(key, -amount);
    }

    public void mult(String key, int amount) {
        int index = this.index(key);
        if (index != -1) {
            int n = index;
            this.values[n] = this.values[n] * amount;
        }
    }

    public void div(String key, int amount) {
        int index = this.index(key);
        if (index != -1) {
            int n = index;
            this.values[n] = this.values[n] / amount;
        }
    }

    private void checkMinMax(String functionName) {
        if (this.count == 0) {
            String msg = String.format("Cannot use %s() on an empty %s.", functionName, this.getClass().getSimpleName());
            throw new RuntimeException(msg);
        }
    }

    public int minIndex() {
        this.checkMinMax("minIndex");
        int index = 0;
        int value = this.values[0];
        for (int i = 1; i < this.count; ++i) {
            if (this.values[i] >= value) continue;
            index = i;
            value = this.values[i];
        }
        return index;
    }

    public int minValue() {
        this.checkMinMax("minValue");
        return this.values[this.minIndex()];
    }

    public String minKey() {
        this.checkMinMax("minKey");
        return this.keys[this.minIndex()];
    }

    public int maxIndex() {
        this.checkMinMax("maxIndex");
        int index = 0;
        int value = this.values[0];
        for (int i = 1; i < this.count; ++i) {
            if (this.values[i] <= value) continue;
            index = i;
            value = this.values[i];
        }
        return index;
    }

    public int maxValue() {
        this.checkMinMax("maxValue");
        return this.values[this.maxIndex()];
    }

    public String maxKey() {
        this.checkMinMax("maxKey");
        return this.keys[this.maxIndex()];
    }

    public int index(String what) {
        Integer found = this.indices.get(what);
        return found == null ? -1 : found;
    }

    protected void create(String what, int much) {
        if (this.count == this.keys.length) {
            this.keys = PApplet.expand(this.keys);
            this.values = PApplet.expand(this.values);
        }
        this.indices.put(what, new Integer(this.count));
        this.keys[this.count] = what;
        this.values[this.count] = much;
        ++this.count;
    }

    public int remove(String key) {
        int index = this.index(key);
        if (index != -1) {
            this.removeIndex(index);
        }
        return index;
    }

    public String removeIndex(int index) {
        if (index < 0 || index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        String key = this.keys[index];
        this.indices.remove(this.keys[index]);
        for (int i = index; i < this.count - 1; ++i) {
            this.keys[i] = this.keys[i + 1];
            this.values[i] = this.values[i + 1];
            this.indices.put(this.keys[i], i);
        }
        --this.count;
        this.keys[this.count] = null;
        this.values[this.count] = 0;
        return key;
    }

    protected void swap(int a, int b) {
        String tkey = this.keys[a];
        int tvalue = this.values[a];
        this.keys[a] = this.keys[b];
        this.values[a] = this.values[b];
        this.keys[b] = tkey;
        this.values[b] = tvalue;
        this.indices.put(this.keys[a], new Integer(a));
        this.indices.put(this.keys[b], new Integer(b));
    }

    public void sortKeys() {
        this.sortImpl(true, false);
    }

    public void sortKeysReverse() {
        this.sortImpl(true, true);
    }

    public void sortValues() {
        this.sortImpl(false, false);
    }

    public void sortValuesReverse() {
        this.sortImpl(false, true);
    }

    protected void sortImpl(final boolean useKeys, final boolean reverse) {
        Sort s = new Sort(){

            @Override
            public int size() {
                return IntDict.this.count;
            }

            @Override
            public float compare(int a, int b) {
                int diff = 0;
                if (useKeys) {
                    diff = IntDict.this.keys[a].compareToIgnoreCase(IntDict.this.keys[b]);
                    if (diff == 0) {
                        return IntDict.this.values[a] - IntDict.this.values[b];
                    }
                } else {
                    diff = IntDict.this.values[a] - IntDict.this.values[b];
                    if (diff == 0) {
                        diff = IntDict.this.keys[a].compareToIgnoreCase(IntDict.this.keys[b]);
                    }
                }
                return reverse ? (float)(-diff) : (float)diff;
            }

            @Override
            public void swap(int a, int b) {
                IntDict.this.swap(a, b);
            }
        };
        s.run();
    }

    public FloatDict getPercent() {
        double sum = 0.0;
        for (int value : this.valueArray()) {
            sum += (double)value;
        }
        FloatDict outgoing = new FloatDict();
        for (int i = 0; i < this.size(); ++i) {
            double percent = (double)this.value(i) / sum;
            outgoing.set(this.key(i), (float)percent);
        }
        return outgoing;
    }

    public IntDict copy() {
        IntDict outgoing = new IntDict(this.count);
        System.arraycopy(this.keys, 0, outgoing.keys, 0, this.count);
        System.arraycopy(this.values, 0, outgoing.values, 0, this.count);
        for (int i = 0; i < this.count; ++i) {
            outgoing.indices.put(this.keys[i], i);
        }
        outgoing.count = this.count;
        return outgoing;
    }

    public void write(PrintWriter writer) {
        for (int i = 0; i < this.count; ++i) {
            writer.println(this.keys[i] + "\t" + this.values[i]);
        }
        writer.flush();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName() + " size=" + this.size() + " { ");
        for (int i = 0; i < this.size(); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append("\"" + this.keys[i] + "\": " + this.values[i]);
        }
        sb.append(" }");
        return sb.toString();
    }
}

