package lec08arrow;

import processing.core.PApplet;


public class Lec08Arrow extends PApplet {

	int triX = 0; // arrow lead point x
	int triY = 0; // arrow lead point y
	int triW = 0; // arrow width (lead point to base)
	int triH = 0; // arrow height
	int triD = 0; // amount to move arrow
	
	int barX = 0;
	int barY = 0;
	int barW = 0; // bar width
	int barH = 0; // bar height

	public void setup() {
		smooth();
		fill(191, 191, 0);
		noStroke();
		size(800, 450);
		resetTriangle();
		resetBar();
		rectMode(CENTER); // center the paddle on the mouse cursor
	}

	public void draw() {
		background(127, 0, 0);

		// \1 Make the paddle move with the mouse cursor

		// \2 Implement moveTraingle
		// moveTriangle();

		drawTriangle();

		rect(barX, barY, barW, barH); // draw paddle
	}
	
	public void moveTriangle() {
		// \2a move the arrow as follows
		//     arrow moves by the amount in triD variable
		//     x coordinate always moves right
		//     y coordinate can move up or down
		//     arrow bounces only off top or bottom of screen
		
		// \2b see if the paddle "caught" the arrow:
		//     - check if triangle's (x, y) is inside the bar
		//     - if so, call resetTriangle() method

		// \2c in addition to restTriangle(), make the bar smaller
		
	}
	
	// isosceles triangle with lead point at right
	// vertical line on left-hand size
	// kind of looks like this: |>
	public void drawTriangle() { 
		int leftX = triX - triW;
		int h = triH / 2;
		int topY = triY - h;
		int botY = triY + h;
		triangle(triX, triY, leftX, topY, leftX, botY);
	}

	public void resetTriangle() {
		triW = width/20;
		triH = height/20;
		triD = Math.max((width/100), 1); // make sure it moves commensurate with screen width
		triX = triW; // always start at left edge
		triY = (int)(Math.random() * height); // randomly place top-to-bottom
	}

	public void resetBar() {
		barW = width/20;     // 5% of screen width
		barH = height/2;     // start at half-size
		barX = width - barW; // right-hand side, just off edge
		barY = height/2;     // centered top-to-bottom
	}
	
}
