package lec05obj;

public class Point {
	private int px; // the x coordinate of the point
	private int py; // the y coordinate of the point
	
	public Point() {
		reset(0, 0);
	}
	
	public Point(Point p) {
		int x = p.getX();
		int y = p.getY();
		reset(x, y);
	}
	
	public Point(int x, int y) {
		reset(x, y);
	}
	
	public void reset(int x, int y) {
		setX(x);
		setY(y);
	}
	
	public void setX(int x) {
		px = x;
	}
	
	public void setY(int y) {
		py = y;
	}

	public int getX() {
		return px;
	}

	public int getY() {
		return py;
	}
	
	public int getLength(Point p) {
		int xlen = Math.abs(px - p.getX());
		int ylen = Math.abs(py - p.getY());
		return (int)(Math.sqrt(xlen*xlen + ylen*ylen));
	}
	
	public void bump(int amt) {

		if (Math.random() > 0.5) amt = -amt;
		px = px + amt;

		if (Math.random() > 0.5) amt = -amt;
		py = py + amt;
	}
}