/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.windows;

import java.util.ArrayList;
import javax.media.nativewindow.NativeWindowException;
import jogamp.nativewindow.Debug;
import jogamp.nativewindow.windows.GDI;
import jogamp.nativewindow.windows.GDIUtil;
import jogamp.nativewindow.windows.RegisteredClass;

public class RegisteredClassFactory {
    private static final boolean DEBUG = Debug.debug("RegisteredClass");
    private static final ArrayList<RegisteredClassFactory> registeredFactories;
    private static final long hInstance;
    private String classBaseName;
    private long wndProc;
    private RegisteredClass sharedClass = null;
    private int classIter = 0;
    private int sharedRefCount = 0;
    private final Object sync = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownSharedClasses() {
        ArrayList<RegisteredClassFactory> arrayList = registeredFactories;
        synchronized (arrayList) {
            for (int i = 0; i < registeredFactories.size(); ++i) {
                RegisteredClassFactory registeredClassFactory = registeredFactories.get(i);
                Object object = registeredClassFactory.sync;
                synchronized (object) {
                    if (null != registeredClassFactory.sharedClass) {
                        GDIUtil.DestroyWindowClass(registeredClassFactory.sharedClass.getHInstance(), registeredClassFactory.sharedClass.getName());
                        registeredClassFactory.sharedClass = null;
                        registeredClassFactory.sharedRefCount = 0;
                        registeredClassFactory.classIter = 0;
                        if (DEBUG) {
                            System.err.println("RegisteredClassFactory #" + i + "/" + registeredFactories.size() + " shutdownSharedClasses : " + registeredClassFactory.sharedClass);
                        }
                    }
                    continue;
                }
            }
        }
    }

    public static long getHInstance() {
        return hInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisteredClassFactory(String string, long l) {
        this.classBaseName = string;
        this.wndProc = l;
        ArrayList<RegisteredClassFactory> arrayList = registeredFactories;
        synchronized (arrayList) {
            registeredFactories.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisteredClass getSharedClass() throws NativeWindowException {
        Object object = this.sync;
        synchronized (object) {
            if (0 == this.sharedRefCount) {
                if (null != this.sharedClass) {
                    throw new InternalError("Error (" + this.sharedRefCount + "): SharedClass not null: " + this.sharedClass);
                }
                String string = null;
                boolean bl = false;
                int n = this.classIter - 1;
                while (!bl && n != this.classIter) {
                    string = this.classBaseName + this.classIter;
                    ++this.classIter;
                    bl = GDIUtil.CreateWindowClass(hInstance, string, this.wndProc);
                }
                if (!bl) {
                    throw new NativeWindowException("Error: Could not create WindowClass: " + string);
                }
                this.sharedClass = new RegisteredClass(hInstance, string);
                if (DEBUG) {
                    System.err.println("RegisteredClassFactory getSharedClass (" + this.sharedRefCount + ") initialized: " + this.sharedClass);
                }
            } else if (null == this.sharedClass) {
                throw new InternalError("Error (" + this.sharedRefCount + "): SharedClass is null");
            }
            ++this.sharedRefCount;
        }
        return this.sharedClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSharedClass() {
        Object object = this.sync;
        synchronized (object) {
            if (0 == this.sharedRefCount) {
                if (null != this.sharedClass) {
                    throw new InternalError("Error (" + this.sharedRefCount + "): SharedClass not null: " + this.sharedClass);
                }
                return;
            }
            --this.sharedRefCount;
            if (null == this.sharedClass) {
                throw new InternalError("Error (" + this.sharedRefCount + "): SharedClass is null");
            }
            if (0 == this.sharedRefCount) {
                GDIUtil.DestroyWindowClass(this.sharedClass.getHInstance(), this.sharedClass.getName());
                if (DEBUG) {
                    System.err.println("RegisteredClassFactory releaseSharedClass (" + this.sharedRefCount + ") released: " + this.sharedClass);
                }
                this.sharedClass = null;
                this.sharedRefCount = 0;
                this.classIter = 0;
            }
        }
    }

    public int getSharedRefCount() {
        return this.sharedRefCount;
    }

    static {
        hInstance = GDI.GetApplicationHandle();
        if (0L == hInstance) {
            throw new NativeWindowException("Error: Null ModuleHandle for Application");
        }
        registeredFactories = new ArrayList();
    }
}

