package lec03anim;

import processing.core.PApplet;

public class Lec03Anim extends PApplet {

	int diam = 10; // diameter of a face
	
	public void setup() {
		// drawing setup
		size(940, 360);
		smooth();
		strokeWeight(2); // use thicker lines
	}

	public void draw() {
		// make the face bigger by 5 pixels,
		// but wrap around at screen height
		diam = (diam + 5) % height; 

		// position faces using left-hand area of drawing space
		int quarterW = width / 4;
		int halfH = height / 2;

		// draw some faces
		drawFace(quarterW, halfH, diam);        // middle face
		drawFace(quarterW - diam, halfH, diam); // left face
		drawFace(quarterW + diam, halfH, diam); // right face
	}
	
	public void drawFace(int x, int y, int size) {
		ellipseMode(CENTER);
		ellipse(x, y, size, size); // head

		int eyeSize = size / 4; // eye is smaller than head

		ellipse(x - eyeSize, y - eyeSize, eyeSize, eyeSize); // left eye
		ellipse(x + eyeSize, y - eyeSize, eyeSize, eyeSize); // right eye
		
		line(x - eyeSize, y + eyeSize, x + eyeSize, y + eyeSize); // mouth	
	}
	
	public void mouseClicked() {
		// invert the colors
		fill(0);     // black interior
		stroke(255); // white lines

		// draw a small face at the click point
		drawFace(mouseX, mouseY, 40);
		
		// try this line by uncommenting... what happens?
		// drawFace(mouseX, mouseY, diam);

		// go back to default colors
		fill(255); // white interior
		stroke(0); // black lines
	}
}
