/*
 * Decompiled with CFR 0.152.
 */
package processing.data;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import processing.core.PApplet;
import processing.data.FloatDict;
import processing.data.FloatList;
import processing.data.IntDict;
import processing.data.IntList;
import processing.data.Sort;
import processing.data.StringDict;
import processing.data.StringList;
import processing.data.TableRow;
import processing.data.XML;

public class Table {
    protected int rowCount;
    protected String missingString = null;
    protected int missingInt = 0;
    protected long missingLong = 0L;
    protected float missingFloat = Float.NaN;
    protected double missingDouble = Double.NaN;
    protected int missingCategory = -1;
    String[] columnTitles;
    HashMapBlows[] columnCategories;
    HashMap<String, Integer> columnIndices;
    protected Object[] columns;
    public static final int STRING = 0;
    public static final int INT = 1;
    public static final int LONG = 2;
    public static final int FLOAT = 3;
    public static final int DOUBLE = 4;
    public static final int CATEGORY = 5;
    int[] columnTypes;
    protected RowIterator rowIterator;
    protected int expandIncrement;
    static final String[] loadExtensions = new String[]{"csv", "tsv", "ods", "bin"};
    static final String[] saveExtensions = new String[]{"csv", "tsv", "html", "bin"};

    public Table() {
        this.init();
    }

    public Table(File file) throws IOException {
        this(file, null);
    }

    public Table(File file, String options) throws IOException {
        this.init();
        this.parse(PApplet.createInput(file), Table.extensionOptions(true, file.getName(), options));
    }

    public Table(InputStream input) throws IOException {
        this(input, null);
    }

    public Table(InputStream input, String options) throws IOException {
        this.init();
        this.parse(input, options);
    }

    public Table(Iterable<TableRow> rows) {
        boolean typed = false;
        for (TableRow row : rows) {
            if (!typed) {
                this.setColumnTypes(row.getColumnTypes());
            }
            this.addRow(row);
        }
    }

    public Table(ResultSet rs) {
        this.init();
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            this.setColumnCount(columnCount);
            block15: for (int col = 0; col < columnCount; ++col) {
                this.setColumnTitle(col, rsmd.getColumnName(col + 1));
                int type = rsmd.getColumnType(col + 1);
                switch (type) {
                    case -6: 
                    case 4: 
                    case 5: {
                        this.setColumnType(col, 1);
                        continue block15;
                    }
                    case -5: {
                        this.setColumnType(col, 2);
                        continue block15;
                    }
                    case 6: {
                        this.setColumnType(col, 3);
                        continue block15;
                    }
                    case 3: 
                    case 7: 
                    case 8: {
                        this.setColumnType(col, 4);
                    }
                }
            }
            int row = 0;
            while (rs.next()) {
                block17: for (int col = 0; col < columnCount; ++col) {
                    switch (this.columnTypes[col]) {
                        case 0: {
                            this.setString(row, col, rs.getString(col + 1));
                            continue block17;
                        }
                        case 1: {
                            this.setInt(row, col, rs.getInt(col + 1));
                            continue block17;
                        }
                        case 2: {
                            this.setLong(row, col, rs.getLong(col + 1));
                            continue block17;
                        }
                        case 3: {
                            this.setFloat(row, col, rs.getFloat(col + 1));
                            continue block17;
                        }
                        case 4: {
                            this.setDouble(row, col, rs.getDouble(col + 1));
                            continue block17;
                        }
                        default: {
                            throw new IllegalArgumentException("column type " + this.columnTypes[col] + " not supported.");
                        }
                    }
                }
                ++row;
            }
        }
        catch (SQLException s) {
            throw new RuntimeException(s);
        }
    }

    public Table typedParse(InputStream input, String options) throws IOException {
        Table table = new Table();
        table.setColumnTypes(this);
        table.parse(input, options);
        return table;
    }

    protected void init() {
        this.columns = new Object[0];
        this.columnTypes = new int[0];
        this.columnCategories = new HashMapBlows[0];
    }

    public static String extensionOptions(boolean loading, String filename, String options) {
        String extension = PApplet.checkExtension(filename);
        if (extension != null) {
            for (String possible : loading ? loadExtensions : saveExtensions) {
                if (!extension.equals(possible)) continue;
                if (options == null) {
                    return extension;
                }
                return extension + "," + options;
            }
        }
        return options;
    }

    protected void parse(InputStream input, String options) throws IOException {
        boolean awfulCSV = false;
        boolean header = false;
        String extension = null;
        boolean binary = false;
        String worksheet = null;
        String sheetParam = "worksheet=";
        String[] opts = null;
        if (options != null) {
            for (String opt : opts = PApplet.splitTokens(options, " ,")) {
                if (opt.equals("tsv")) {
                    extension = "tsv";
                    continue;
                }
                if (opt.equals("csv")) {
                    extension = "csv";
                    continue;
                }
                if (opt.equals("ods")) {
                    extension = "ods";
                    continue;
                }
                if (opt.equals("newlines")) {
                    awfulCSV = true;
                    extension = "csv";
                    continue;
                }
                if (opt.equals("bin")) {
                    binary = true;
                    extension = "bin";
                    continue;
                }
                if (opt.equals("header")) {
                    header = true;
                    continue;
                }
                if (opt.startsWith("worksheet=")) {
                    worksheet = opt.substring("worksheet=".length());
                    continue;
                }
                if (opt.startsWith("dictionary=")) continue;
                throw new IllegalArgumentException("'" + opt + "' is not a valid option for loading a Table");
            }
        }
        if (extension == null) {
            throw new IllegalArgumentException("No extension specified for this Table");
        }
        if (binary) {
            this.loadBinary(input);
        } else if (extension.equals("ods")) {
            this.odsParse(input, worksheet);
        } else {
            BufferedReader reader = PApplet.createReader(input);
            if (awfulCSV) {
                this.parseAwfulCSV(reader, header);
            } else if ("tsv".equals(extension)) {
                this.parseBasic(reader, header, true);
            } else if ("csv".equals(extension)) {
                this.parseBasic(reader, header, false);
            }
        }
    }

    protected void parseBasic(BufferedReader reader, boolean header, boolean tsv) throws IOException {
        String line = null;
        int row = 0;
        if (this.rowCount == 0) {
            this.setRowCount(10);
        }
        try {
            while ((line = reader.readLine()) != null) {
                if (row == this.getRowCount()) {
                    this.setRowCount(row << 1);
                }
                if (row == 0 && header) {
                    this.setColumnTitles(tsv ? PApplet.split(line, '\t') : Table.splitLineCSV(line));
                    header = false;
                } else {
                    this.setRow(row, tsv ? PApplet.split(line, '\t') : Table.splitLineCSV(line));
                    ++row;
                }
                if (row % 10000 != 0) continue;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading table on line " + row, e);
        }
        if (row != this.getRowCount()) {
            this.setRowCount(row);
        }
    }

    protected void parseAwfulCSV(BufferedReader reader, boolean header) throws IOException {
        int ch;
        char[] c = new char[100];
        int count = 0;
        boolean insideQuote = false;
        int row = 0;
        int col = 0;
        while ((ch = reader.read()) != -1) {
            if (insideQuote) {
                if (ch == 34) {
                    reader.mark(1);
                    if (reader.read() == 34) {
                        if (count == c.length) {
                            c = PApplet.expand(c);
                        }
                        c[count++] = 34;
                        continue;
                    }
                    reader.reset();
                    insideQuote = false;
                    continue;
                }
                if (count == c.length) {
                    c = PApplet.expand(c);
                }
                c[count++] = (char)ch;
                continue;
            }
            if (ch == 34) {
                insideQuote = true;
                continue;
            }
            if (ch == 13 || ch == 10) {
                if (ch == 13) {
                    reader.mark(1);
                    if (reader.read() != 10) {
                        reader.reset();
                    }
                }
                this.setString(row, col, new String(c, 0, count));
                count = 0;
                if (row == 0 && header) {
                    this.removeTitleRow();
                    header = false;
                }
                ++row;
                col = 0;
                continue;
            }
            if (ch == 44) {
                this.setString(row, col, new String(c, 0, count));
                count = 0;
                this.ensureColumn(++col);
                continue;
            }
            if (count == c.length) {
                c = PApplet.expand(c);
            }
            c[count++] = (char)ch;
        }
        if (count > 0) {
            this.setString(row, col, new String(c, 0, count));
        }
    }

    protected static String[] splitLineCSV(String line) {
        char[] c = line.toCharArray();
        int rough = 1;
        boolean quote = false;
        for (int i = 0; i < c.length; ++i) {
            if (!quote && c[i] == ',') {
                ++rough;
                continue;
            }
            if (c[i] != '\"') continue;
            quote = !quote;
        }
        String[] pieces = new String[rough];
        int pieceCount = 0;
        int offset = 0;
        while (offset < c.length) {
            int start = offset;
            int stop = Table.nextComma(c, offset);
            offset = stop + 1;
            if (c[start] == '\"' && c[stop - 1] == '\"') {
                --stop;
            }
            int i = ++start;
            int ii = start;
            while (i < stop) {
                if (c[i] == '\"') {
                    ++i;
                }
                if (i != ii) {
                    c[ii] = c[i];
                }
                ++i;
                ++ii;
            }
            String s = new String(c, start, ii - start);
            pieces[pieceCount++] = s;
        }
        for (int i = pieceCount; i < pieces.length; ++i) {
            pieces[i] = "";
        }
        return pieces;
    }

    protected static int nextComma(char[] c, int index) {
        boolean quote = false;
        for (int i = index; i < c.length; ++i) {
            if (!quote && c[i] == ',') {
                return i;
            }
            if (c[i] != '\"') continue;
            quote = !quote;
        }
        return c.length;
    }

    private InputStream odsFindContentXML(InputStream input) {
        ZipInputStream zis = new ZipInputStream(input);
        ZipEntry entry = null;
        try {
            while ((entry = zis.getNextEntry()) != null) {
                if (!entry.getName().equals("content.xml")) continue;
                return zis;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected void odsParse(InputStream input, String worksheet) {
        try {
            InputStream contentStream = this.odsFindContentXML(input);
            XML xml = new XML(contentStream);
            XML[] sheets = xml.getChildren("office:body/office:spreadsheet/table:table");
            boolean found = false;
            for (XML sheet : sheets) {
                if (worksheet != null && !worksheet.equals(sheet.getString("table:name"))) continue;
                this.odsParseSheet(sheet);
                found = true;
                if (worksheet == null) break;
            }
            if (!found) {
                if (worksheet == null) {
                    throw new RuntimeException("No worksheets found in the ODS file.");
                }
                throw new RuntimeException("No worksheet named " + worksheet + " found in the ODS file.");
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    private void odsParseSheet(XML sheet) {
        boolean ignoreTags = true;
        XML[] rows = sheet.getChildren("table:table-row");
        int rowIndex = 0;
        for (XML row : rows) {
            int rowRepeat = row.getInt("table:number-rows-repeated", 1);
            boolean rowNotNull = false;
            XML[] cells = row.getChildren();
            int columnIndex = 0;
            for (XML cell : cells) {
                int cellKids;
                int cellRepeat = cell.getInt("table:number-columns-repeated", 1);
                String cellData = cell.getString("office:value");
                if (cellData == null && (cellKids = cell.getChildCount()) != 0) {
                    XML[] paragraphElements = cell.getChildren("text:p");
                    if (paragraphElements.length != 1) {
                        for (XML el : paragraphElements) {
                            System.err.println(el.toString());
                        }
                        throw new RuntimeException("found more than one text:p element");
                    }
                    XML textp = paragraphElements[0];
                    String textpContent = textp.getContent();
                    if (textpContent != null) {
                        cellData = textpContent;
                    } else {
                        XML[] textpKids = textp.getChildren();
                        StringBuffer cellBuffer = new StringBuffer();
                        for (XML kid : textpKids) {
                            String kidName = kid.getName();
                            if (kidName == null) {
                                this.odsAppendNotNull(kid, cellBuffer);
                                continue;
                            }
                            if (kidName.equals("text:s")) {
                                int spaceCount = kid.getInt("text:c", 1);
                                for (int space = 0; space < spaceCount; ++space) {
                                    cellBuffer.append(' ');
                                }
                                continue;
                            }
                            if (kidName.equals("text:span")) {
                                this.odsAppendNotNull(kid, cellBuffer);
                                continue;
                            }
                            if (kidName.equals("text:a")) {
                                cellBuffer.append(kid.getString("xlink:href"));
                                continue;
                            }
                            this.odsAppendNotNull(kid, cellBuffer);
                            System.err.println(this.getClass().getName() + ": don't understand: " + kid);
                        }
                        cellData = cellBuffer.toString();
                    }
                }
                for (int r = 0; r < cellRepeat; ++r) {
                    if (cellData != null) {
                        this.setString(rowIndex, columnIndex, cellData);
                    }
                    ++columnIndex;
                    if (cellData == null) continue;
                    rowNotNull = true;
                }
            }
            if (rowNotNull && rowRepeat > 1) {
                Object[] rowStrings = this.getStringRow(rowIndex);
                for (int r = 1; r < rowRepeat; ++r) {
                    this.addRow(rowStrings);
                }
            }
            rowIndex += rowRepeat;
        }
    }

    private void odsAppendNotNull(XML kid, StringBuffer buffer) {
        String content = kid.getContent();
        if (content != null) {
            buffer.append(content);
        }
    }

    public void parseInto(Object enclosingObject, String fieldName) {
        Class<?> target = null;
        Object outgoing = null;
        Field targetField = null;
        try {
            Class<?> sketchClass = enclosingObject.getClass();
            targetField = sketchClass.getDeclaredField(fieldName);
            Class<?> targetArray = targetField.getType();
            if (targetArray.isArray()) {
                target = targetArray.getComponentType();
                outgoing = Array.newInstance(target, this.getRowCount());
            }
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        Class<?> enclosingClass = target.getEnclosingClass();
        Constructor<?> con = null;
        try {
            con = enclosingClass == null ? target.getDeclaredConstructor(new Class[0]) : target.getDeclaredConstructor(enclosingClass);
            if (!con.isAccessible()) {
                con.setAccessible(true);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        Field[] fields = target.getDeclaredFields();
        ArrayList<Field> inuse = new ArrayList<Field>();
        for (Field field : fields) {
            String name = field.getName();
            if (this.getColumnIndex(name, false) == -1) continue;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            inuse.add(field);
        }
        int index = 0;
        try {
            for (TableRow row : this.rows()) {
                Object item = null;
                item = enclosingClass == null ? con.newInstance(new Object[0]) : con.newInstance(enclosingObject);
                for (Field field : inuse) {
                    String content;
                    String name = field.getName();
                    if (field.getType() == String.class) {
                        field.set(item, row.getString(name));
                        continue;
                    }
                    if (field.getType() == Integer.TYPE) {
                        field.setInt(item, row.getInt(name));
                        continue;
                    }
                    if (field.getType() == Long.TYPE) {
                        field.setLong(item, row.getLong(name));
                        continue;
                    }
                    if (field.getType() == Float.TYPE) {
                        field.setFloat(item, row.getFloat(name));
                        continue;
                    }
                    if (field.getType() == Double.TYPE) {
                        field.setDouble(item, row.getDouble(name));
                        continue;
                    }
                    if (field.getType() == Boolean.TYPE) {
                        content = row.getString(name);
                        if (content == null || !content.toLowerCase().equals("true") && !content.equals("1")) continue;
                        field.setBoolean(item, true);
                        continue;
                    }
                    if (field.getType() != Character.TYPE || (content = row.getString(name)) == null || content.length() <= 0) continue;
                    field.setChar(item, content.charAt(0));
                }
                Array.set(outgoing, index++, item);
            }
            if (!targetField.isAccessible()) {
                targetField.setAccessible(true);
            }
            targetField.set(enclosingObject, outgoing);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public boolean save(File file, String options) throws IOException {
        return this.save(PApplet.createOutput(file), Table.extensionOptions(false, file.getName(), options));
    }

    public boolean save(OutputStream output, String options) {
        PrintWriter writer = PApplet.createWriter(output);
        String extension = null;
        if (options == null) {
            throw new IllegalArgumentException("No extension specified for saving this Table");
        }
        String[] opts = PApplet.splitTokens(options, ", ");
        extension = opts[opts.length - 1];
        boolean found = false;
        for (String ext : saveExtensions) {
            if (!extension.equals(ext)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalArgumentException("'" + extension + "' not available for Table");
        }
        if (extension.equals("csv")) {
            this.writeCSV(writer);
        } else if (extension.equals("tsv")) {
            this.writeTSV(writer);
        } else if (extension.equals("html")) {
            this.writeHTML(writer);
        } else if (extension.equals("bin")) {
            try {
                this.saveBinary(output);
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        writer.flush();
        writer.close();
        return true;
    }

    protected void writeTSV(PrintWriter writer) {
        if (this.columnTitles != null) {
            for (int col = 0; col < this.columns.length; ++col) {
                if (col != 0) {
                    writer.print('\t');
                }
                if (this.columnTitles[col] == null) continue;
                writer.print(this.columnTitles[col]);
            }
            writer.println();
        }
        for (int row = 0; row < this.rowCount; ++row) {
            for (int col = 0; col < this.getColumnCount(); ++col) {
                String entry;
                if (col != 0) {
                    writer.print('\t');
                }
                if ((entry = this.getString(row, col)) == null) continue;
                writer.print(entry);
            }
            writer.println();
        }
        writer.flush();
    }

    protected void writeCSV(PrintWriter writer) {
        if (this.columnTitles != null) {
            for (int col = 0; col < this.columns.length; ++col) {
                if (col != 0) {
                    writer.print(',');
                }
                if (this.columnTitles[col] == null) continue;
                this.writeEntryCSV(writer, this.columnTitles[col]);
            }
            writer.println();
        }
        for (int row = 0; row < this.rowCount; ++row) {
            for (int col = 0; col < this.getColumnCount(); ++col) {
                String entry;
                if (col != 0) {
                    writer.print(',');
                }
                if ((entry = this.getString(row, col)) == null) continue;
                this.writeEntryCSV(writer, entry);
            }
            writer.println();
        }
        writer.flush();
    }

    protected void writeEntryCSV(PrintWriter writer, String entry) {
        if (entry != null) {
            if (entry.indexOf(34) != -1) {
                char[] c = entry.toCharArray();
                writer.print('\"');
                for (int i = 0; i < c.length; ++i) {
                    if (c[i] == '\"') {
                        writer.print("\"\"");
                        continue;
                    }
                    writer.print(c[i]);
                }
                writer.print('\"');
            } else if (entry.indexOf(44) != -1 || entry.indexOf(10) != -1 || entry.indexOf(13) != -1) {
                writer.print('\"');
                writer.print(entry);
                writer.print('\"');
            } else if (entry.length() > 0 && (entry.charAt(0) == ' ' || entry.charAt(entry.length() - 1) == ' ')) {
                writer.print('\"');
                writer.print(entry);
                writer.print('\"');
            } else {
                writer.print(entry);
            }
        }
    }

    protected void writeHTML(PrintWriter writer) {
        writer.println("<html>");
        writer.println("<head>");
        writer.println("  <meta http-equiv=\"content-type\" content=\"text/html;charset=utf-8\" />");
        writer.println("</head>");
        writer.println("<body>");
        writer.println("  <table>");
        for (int row = 0; row < this.getRowCount(); ++row) {
            writer.println("    <tr>");
            for (int col = 0; col < this.getColumnCount(); ++col) {
                String entry = this.getString(row, col);
                writer.print("      <td>");
                this.writeEntryHTML(writer, entry);
                writer.println("      </td>");
            }
            writer.println("    </tr>");
        }
        writer.println("  </table>");
        writer.println("</body>");
        writer.println("</hmtl>");
        writer.flush();
    }

    protected void writeEntryHTML(PrintWriter writer, String entry) {
        for (char c : entry.toCharArray()) {
            if (c == '<') {
                writer.print("&lt;");
                continue;
            }
            if (c == '>') {
                writer.print("&gt;");
                continue;
            }
            if (c == '&') {
                writer.print("&amp;");
                continue;
            }
            if (c == '\'') {
                writer.print("&apos;");
                continue;
            }
            if (c == '\"') {
                writer.print("&quot;");
                continue;
            }
            writer.print(c);
        }
    }

    protected void saveBinary(OutputStream os) throws IOException {
        int i;
        DataOutputStream output = new DataOutputStream(new BufferedOutputStream(os));
        output.writeInt(-1878545634);
        output.writeInt(this.getRowCount());
        output.writeInt(this.getColumnCount());
        if (this.columnTitles != null) {
            output.writeBoolean(true);
            for (String title : this.columnTitles) {
                output.writeUTF(title);
            }
        } else {
            output.writeBoolean(false);
        }
        for (i = 0; i < this.getColumnCount(); ++i) {
            output.writeInt(this.columnTypes[i]);
        }
        for (i = 0; i < this.getColumnCount(); ++i) {
            if (this.columnTypes[i] != 5) continue;
            this.columnCategories[i].write(output);
        }
        if (this.missingString == null) {
            output.writeBoolean(false);
        } else {
            output.writeBoolean(true);
            output.writeUTF(this.missingString);
        }
        output.writeInt(this.missingInt);
        output.writeLong(this.missingLong);
        output.writeFloat(this.missingFloat);
        output.writeDouble(this.missingDouble);
        output.writeInt(this.missingCategory);
        for (TableRow row : this.rows()) {
            block12: for (int col = 0; col < this.getColumnCount(); ++col) {
                switch (this.columnTypes[col]) {
                    case 0: {
                        String str = row.getString(col);
                        if (str == null) {
                            output.writeBoolean(false);
                            continue block12;
                        }
                        output.writeBoolean(true);
                        output.writeUTF(str);
                        continue block12;
                    }
                    case 1: {
                        output.writeInt(row.getInt(col));
                        continue block12;
                    }
                    case 2: {
                        output.writeLong(row.getLong(col));
                        continue block12;
                    }
                    case 3: {
                        output.writeFloat(row.getFloat(col));
                        continue block12;
                    }
                    case 4: {
                        output.writeDouble(row.getDouble(col));
                        continue block12;
                    }
                    case 5: {
                        output.writeInt(this.columnCategories[col].index(row.getString(col)));
                    }
                }
            }
        }
        output.flush();
        output.close();
    }

    protected void loadBinary(InputStream is) throws IOException {
        int i;
        DataInputStream input = new DataInputStream(new BufferedInputStream(is));
        int magic = input.readInt();
        if (magic != -1878545634) {
            throw new IOException("Not a compatible binary table (magic was " + PApplet.hex(magic) + ")");
        }
        int rowCount = input.readInt();
        this.setRowCount(rowCount);
        int columnCount = input.readInt();
        this.setColumnCount(columnCount);
        boolean hasTitles = input.readBoolean();
        if (hasTitles) {
            this.columnTitles = new String[this.getColumnCount()];
            for (i = 0; i < columnCount; ++i) {
                this.setColumnTitle(i, input.readUTF());
            }
        }
        block17: for (int column = 0; column < columnCount; ++column) {
            int newType;
            this.columnTypes[column] = newType = input.readInt();
            switch (newType) {
                case 1: {
                    this.columns[column] = new int[rowCount];
                    continue block17;
                }
                case 2: {
                    this.columns[column] = new long[rowCount];
                    continue block17;
                }
                case 3: {
                    this.columns[column] = new float[rowCount];
                    continue block17;
                }
                case 4: {
                    this.columns[column] = new double[rowCount];
                    continue block17;
                }
                case 0: {
                    this.columns[column] = new String[rowCount];
                    continue block17;
                }
                case 5: {
                    this.columns[column] = new int[rowCount];
                    continue block17;
                }
                default: {
                    throw new IllegalArgumentException(newType + " is not a valid column type.");
                }
            }
        }
        for (i = 0; i < columnCount; ++i) {
            if (this.columnTypes[i] != 5) continue;
            this.columnCategories[i] = new HashMapBlows(input);
        }
        this.missingString = input.readBoolean() ? input.readUTF() : null;
        this.missingInt = input.readInt();
        this.missingLong = input.readLong();
        this.missingFloat = input.readFloat();
        this.missingDouble = input.readDouble();
        this.missingCategory = input.readInt();
        for (int row = 0; row < rowCount; ++row) {
            block20: for (int col = 0; col < columnCount; ++col) {
                switch (this.columnTypes[col]) {
                    case 0: {
                        String str = null;
                        if (input.readBoolean()) {
                            str = input.readUTF();
                        }
                        this.setString(row, col, str);
                        continue block20;
                    }
                    case 1: {
                        this.setInt(row, col, input.readInt());
                        continue block20;
                    }
                    case 2: {
                        this.setLong(row, col, input.readLong());
                        continue block20;
                    }
                    case 3: {
                        this.setFloat(row, col, input.readFloat());
                        continue block20;
                    }
                    case 4: {
                        this.setDouble(row, col, input.readDouble());
                        continue block20;
                    }
                    case 5: {
                        int index = input.readInt();
                        this.setInt(row, col, index);
                    }
                }
            }
        }
        input.close();
    }

    public void addColumn() {
        this.addColumn(null, 0);
    }

    public void addColumn(String title) {
        this.addColumn(title, 0);
    }

    public void addColumn(String title, int type) {
        this.insertColumn(this.columns.length, title, type);
    }

    public void insertColumn(int index) {
        this.insertColumn(index, null, 0);
    }

    public void insertColumn(int index, String title) {
        this.insertColumn(index, title, 0);
    }

    public void insertColumn(int index, String title, int type) {
        int i;
        if (title != null && this.columnTitles == null) {
            this.columnTitles = new String[this.columns.length];
        }
        if (this.columnTitles != null) {
            this.columnTitles = PApplet.splice(this.columnTitles, title, index);
            this.columnIndices = null;
        }
        this.columnTypes = PApplet.splice(this.columnTypes, type, index);
        HashMapBlows[] catTemp = new HashMapBlows[this.columns.length + 1];
        for (i = 0; i < index; ++i) {
            catTemp[i] = this.columnCategories[i];
        }
        catTemp[index] = new HashMapBlows();
        for (i = index; i < this.columns.length; ++i) {
            catTemp[i + 1] = this.columnCategories[i];
        }
        this.columnCategories = catTemp;
        Object[] temp = new Object[this.columns.length + 1];
        System.arraycopy(this.columns, 0, temp, 0, index);
        System.arraycopy(this.columns, index, temp, index + 1, this.columns.length - index);
        this.columns = temp;
        switch (type) {
            case 1: {
                this.columns[index] = new int[this.rowCount];
                break;
            }
            case 2: {
                this.columns[index] = new long[this.rowCount];
                break;
            }
            case 3: {
                this.columns[index] = new float[this.rowCount];
                break;
            }
            case 4: {
                this.columns[index] = new double[this.rowCount];
                break;
            }
            case 0: {
                this.columns[index] = new String[this.rowCount];
                break;
            }
            case 5: {
                this.columns[index] = new int[this.rowCount];
            }
        }
    }

    public void removeColumn(String columnName) {
        this.removeColumn(this.getColumnIndex(columnName));
    }

    public void removeColumn(int column) {
        int i;
        int newCount = this.columns.length - 1;
        Object[] columnsTemp = new Object[newCount];
        HashMapBlows[] catTemp = new HashMapBlows[newCount];
        for (i = 0; i < column; ++i) {
            columnsTemp[i] = this.columns[i];
            catTemp[i] = this.columnCategories[i];
        }
        for (i = column; i < newCount; ++i) {
            columnsTemp[i] = this.columns[i + 1];
            catTemp[i] = this.columnCategories[i + 1];
        }
        this.columns = columnsTemp;
        this.columnCategories = catTemp;
        if (this.columnTitles != null) {
            int i2;
            String[] titlesTemp = new String[newCount];
            for (i2 = 0; i2 < column; ++i2) {
                titlesTemp[i2] = this.columnTitles[i2];
            }
            for (i2 = column; i2 < newCount; ++i2) {
                titlesTemp[i2] = this.columnTitles[i2 + 1];
            }
            this.columnTitles = titlesTemp;
            this.columnIndices = null;
        }
    }

    public int getColumnCount() {
        return this.columns.length;
    }

    public void setColumnCount(int newCount) {
        int oldCount = this.columns.length;
        if (oldCount != newCount) {
            this.columns = (Object[])PApplet.expand(this.columns, newCount);
            for (int c = oldCount; c < newCount; ++c) {
                this.columns[c] = new String[this.rowCount];
            }
            if (this.columnTitles != null) {
                this.columnTitles = PApplet.expand(this.columnTitles, newCount);
            }
            this.columnTypes = PApplet.expand(this.columnTypes, newCount);
            this.columnCategories = (HashMapBlows[])PApplet.expand(this.columnCategories, newCount);
        }
    }

    public void setColumnType(String columnName, String columnType) {
        this.setColumnType(this.checkColumnIndex(columnName), columnType);
    }

    public void setColumnType(int column, String columnType) {
        int type = -1;
        if (columnType.equals("String")) {
            type = 0;
        } else if (columnType.equals("int")) {
            type = 1;
        } else if (columnType.equals("long")) {
            type = 2;
        } else if (columnType.equals("float")) {
            type = 3;
        } else if (columnType.equals("double")) {
            type = 4;
        } else if (columnType.equals("category")) {
            type = 5;
        } else {
            throw new IllegalArgumentException("'" + columnType + "' is not a valid column type.");
        }
        this.setColumnType(column, type);
    }

    public void setColumnType(String columnName, int newType) {
        this.setColumnType(this.checkColumnIndex(columnName), newType);
    }

    public void setColumnType(int column, int newType) {
        switch (newType) {
            case 1: {
                int[] intData = new int[this.rowCount];
                for (int row = 0; row < this.rowCount; ++row) {
                    String s = this.getString(row, column);
                    intData[row] = PApplet.parseInt(s, this.missingInt);
                }
                this.columns[column] = intData;
                break;
            }
            case 2: {
                long[] longData = new long[this.rowCount];
                for (int row = 0; row < this.rowCount; ++row) {
                    String s = this.getString(row, column);
                    try {
                        longData[row] = Long.parseLong(s);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        longData[row] = this.missingLong;
                    }
                }
                this.columns[column] = longData;
                break;
            }
            case 3: {
                float[] floatData = new float[this.rowCount];
                for (int row = 0; row < this.rowCount; ++row) {
                    String s = this.getString(row, column);
                    floatData[row] = PApplet.parseFloat(s, this.missingFloat);
                }
                this.columns[column] = floatData;
                break;
            }
            case 4: {
                double[] doubleData = new double[this.rowCount];
                for (int row = 0; row < this.rowCount; ++row) {
                    String s = this.getString(row, column);
                    try {
                        doubleData[row] = Double.parseDouble(s);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        doubleData[row] = this.missingDouble;
                    }
                }
                this.columns[column] = doubleData;
                break;
            }
            case 0: {
                if (this.columnTypes[column] == 0) break;
                String[] stringData = new String[this.rowCount];
                for (int row = 0; row < this.rowCount; ++row) {
                    stringData[row] = this.getString(row, column);
                }
                this.columns[column] = stringData;
                break;
            }
            case 5: {
                int[] indexData = new int[this.rowCount];
                HashMapBlows categories = new HashMapBlows();
                for (int row = 0; row < this.rowCount; ++row) {
                    String s = this.getString(row, column);
                    indexData[row] = categories.index(s);
                }
                this.columnCategories[column] = categories;
                this.columns[column] = indexData;
                break;
            }
            default: {
                throw new IllegalArgumentException("That's not a valid column type.");
            }
        }
        this.columnTypes[column] = newType;
    }

    public void setTableType(String type) {
        for (int col = 0; col < this.getColumnCount(); ++col) {
            this.setColumnType(col, type);
        }
    }

    public void setColumnTypes(int[] types) {
        for (int col = 0; col < types.length; ++col) {
            this.setColumnType(col, types[col]);
        }
    }

    public void setColumnTypes(Table dictionary) {
        block6: {
            int titleCol = 0;
            int typeCol = 1;
            if (dictionary.hasColumnTitles()) {
                titleCol = dictionary.getColumnIndex("title", true);
                typeCol = dictionary.getColumnIndex("type", true);
            }
            this.setColumnTitles(dictionary.getStringColumn(titleCol));
            final String[] typeNames = dictionary.getStringColumn(typeCol);
            if (dictionary.getColumnCount() <= 1) break block6;
            if (this.getRowCount() > 1000) {
                int proc = Runtime.getRuntime().availableProcessors();
                ExecutorService pool = Executors.newFixedThreadPool(proc / 2);
                int i = 0;
                while (i < dictionary.getRowCount()) {
                    final int col = i++;
                    pool.execute(new Runnable(){

                        @Override
                        public void run() {
                            Table.this.setColumnType(col, typeNames[col]);
                        }
                    });
                }
                pool.shutdown();
                while (!pool.isTerminated()) {
                    Thread.yield();
                }
            } else {
                for (int col = 0; col < dictionary.getRowCount(); ++col) {
                    this.setColumnType(col, typeNames[col]);
                }
            }
        }
    }

    public int getColumnType(String columnName) {
        return this.getColumnType(this.getColumnIndex(columnName));
    }

    public int getColumnType(int column) {
        return this.columnTypes[column];
    }

    public int[] getColumnTypes() {
        return this.columnTypes;
    }

    @Deprecated
    public String[] removeTitleRow() {
        String[] titles = this.getStringRow(0);
        this.removeRow(0);
        this.setColumnTitles(titles);
        return titles;
    }

    public void setColumnTitles(String[] titles) {
        if (titles != null) {
            this.ensureColumn(titles.length - 1);
        }
        this.columnTitles = titles;
        this.columnIndices = null;
    }

    public void setColumnTitle(int column, String title) {
        this.ensureColumn(column);
        if (this.columnTitles == null) {
            this.columnTitles = new String[this.getColumnCount()];
        }
        this.columnTitles[column] = title;
        this.columnIndices = null;
    }

    public boolean hasColumnTitles() {
        return this.columnTitles != null;
    }

    public String[] getColumnTitles() {
        return this.columnTitles;
    }

    public String getColumnTitle(int col) {
        return this.columnTitles == null ? null : this.columnTitles[col];
    }

    public int getColumnIndex(String columnName) {
        return this.getColumnIndex(columnName, true);
    }

    protected int getColumnIndex(String name, boolean report) {
        Integer index;
        if (this.columnTitles == null) {
            if (report) {
                throw new IllegalArgumentException("This table has no header, so no column titles are set.");
            }
            return -1;
        }
        if (this.columnIndices == null) {
            this.columnIndices = new HashMap();
            for (int col = 0; col < this.columns.length; ++col) {
                this.columnIndices.put(this.columnTitles[col], col);
            }
        }
        if ((index = this.columnIndices.get(name)) == null) {
            if (report) {
                throw new IllegalArgumentException("This table has no column named '" + name + "'");
            }
            return -1;
        }
        return index;
    }

    public int checkColumnIndex(String title) {
        int index = this.getColumnIndex(title, false);
        if (index != -1) {
            return index;
        }
        this.addColumn(title);
        return this.getColumnCount() - 1;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int lastRowIndex() {
        return this.getRowCount() - 1;
    }

    public void clearRows() {
        this.setRowCount(0);
    }

    public void setRowCount(int newCount) {
        if (newCount != this.rowCount) {
            if (newCount > 1000000) {
                System.out.print("Note: setting maximum row count to " + PApplet.nfc(newCount));
            }
            long t = System.currentTimeMillis();
            for (int col = 0; col < this.columns.length; ++col) {
                switch (this.columnTypes[col]) {
                    case 1: {
                        this.columns[col] = PApplet.expand((int[])this.columns[col], newCount);
                        break;
                    }
                    case 2: {
                        this.columns[col] = PApplet.expand((long[])this.columns[col], newCount);
                        break;
                    }
                    case 3: {
                        this.columns[col] = PApplet.expand((float[])this.columns[col], newCount);
                        break;
                    }
                    case 4: {
                        this.columns[col] = PApplet.expand((double[])this.columns[col], newCount);
                        break;
                    }
                    case 0: {
                        this.columns[col] = PApplet.expand((String[])this.columns[col], newCount);
                        break;
                    }
                    case 5: {
                        this.columns[col] = PApplet.expand((int[])this.columns[col], newCount);
                    }
                }
                if (newCount <= 1000000) continue;
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (newCount > 1000000) {
                int ms = (int)(System.currentTimeMillis() - t);
                System.out.println(" (resize took " + PApplet.nfc(ms) + " ms)");
            }
        }
        this.rowCount = newCount;
    }

    public TableRow addRow() {
        this.setRowCount(this.rowCount + 1);
        return new RowPointer(this, this.rowCount - 1);
    }

    public TableRow addRow(TableRow source) {
        int row = this.rowCount;
        this.ensureBounds(row, source.getColumnCount() - 1);
        block7: for (int col = 0; col < this.columns.length; ++col) {
            switch (this.columnTypes[col]) {
                case 1: 
                case 5: {
                    this.setInt(row, col, source.getInt(col));
                    continue block7;
                }
                case 2: {
                    this.setLong(row, col, source.getLong(col));
                    continue block7;
                }
                case 3: {
                    this.setFloat(row, col, source.getFloat(col));
                    continue block7;
                }
                case 4: {
                    this.setDouble(row, col, source.getDouble(col));
                    continue block7;
                }
                case 0: {
                    this.setString(row, col, source.getString(col));
                    continue block7;
                }
                default: {
                    throw new RuntimeException("no types");
                }
            }
        }
        return new RowPointer(this, row);
    }

    public TableRow addRow(Object[] columnData) {
        this.setRow(this.getRowCount(), columnData);
        return new RowPointer(this, this.rowCount - 1);
    }

    public void insertRow(int insert, Object[] columnData) {
        block7: for (int col = 0; col < this.columns.length; ++col) {
            switch (this.columnTypes[col]) {
                case 1: 
                case 5: {
                    int[] intTemp = new int[this.rowCount + 1];
                    System.arraycopy(this.columns[col], 0, intTemp, 0, insert);
                    System.arraycopy(this.columns[col], insert, intTemp, insert + 1, this.rowCount - insert + 1);
                    this.columns[col] = intTemp;
                    continue block7;
                }
                case 2: {
                    long[] longTemp = new long[this.rowCount + 1];
                    System.arraycopy(this.columns[col], 0, longTemp, 0, insert);
                    System.arraycopy(this.columns[col], insert, longTemp, insert + 1, this.rowCount - insert + 1);
                    this.columns[col] = longTemp;
                    continue block7;
                }
                case 3: {
                    float[] floatTemp = new float[this.rowCount + 1];
                    System.arraycopy(this.columns[col], 0, floatTemp, 0, insert);
                    System.arraycopy(this.columns[col], insert, floatTemp, insert + 1, this.rowCount - insert + 1);
                    this.columns[col] = floatTemp;
                    continue block7;
                }
                case 4: {
                    double[] doubleTemp = new double[this.rowCount + 1];
                    System.arraycopy(this.columns[col], 0, doubleTemp, 0, insert);
                    System.arraycopy(this.columns[col], insert, doubleTemp, insert + 1, this.rowCount - insert + 1);
                    this.columns[col] = doubleTemp;
                    continue block7;
                }
                case 0: {
                    String[] stringTemp = new String[this.rowCount + 1];
                    System.arraycopy(this.columns[col], 0, stringTemp, 0, insert);
                    System.arraycopy(this.columns[col], insert, stringTemp, insert + 1, this.rowCount - insert + 1);
                    this.columns[col] = stringTemp;
                    continue block7;
                }
            }
        }
        this.setRow(insert, columnData);
        ++this.rowCount;
    }

    public void removeRow(int row) {
        block7: for (int col = 0; col < this.columns.length; ++col) {
            switch (this.columnTypes[col]) {
                case 1: 
                case 5: {
                    int[] intTemp = new int[this.rowCount - 1];
                    System.arraycopy(this.columns[col], 0, intTemp, 0, row);
                    System.arraycopy(this.columns[col], row + 1, intTemp, row, this.rowCount - row - 1);
                    this.columns[col] = intTemp;
                    continue block7;
                }
                case 2: {
                    long[] longTemp = new long[this.rowCount - 1];
                    System.arraycopy(this.columns[col], 0, longTemp, 0, row);
                    System.arraycopy(this.columns[col], row + 1, longTemp, row, this.rowCount - row - 1);
                    this.columns[col] = longTemp;
                    continue block7;
                }
                case 3: {
                    float[] floatTemp = new float[this.rowCount - 1];
                    System.arraycopy(this.columns[col], 0, floatTemp, 0, row);
                    System.arraycopy(this.columns[col], row + 1, floatTemp, row, this.rowCount - row - 1);
                    this.columns[col] = floatTemp;
                    continue block7;
                }
                case 4: {
                    double[] doubleTemp = new double[this.rowCount - 1];
                    System.arraycopy(this.columns[col], 0, doubleTemp, 0, row);
                    System.arraycopy(this.columns[col], row + 1, doubleTemp, row, this.rowCount - row - 1);
                    this.columns[col] = doubleTemp;
                    continue block7;
                }
                case 0: {
                    String[] stringTemp = new String[this.rowCount - 1];
                    System.arraycopy(this.columns[col], 0, stringTemp, 0, row);
                    System.arraycopy(this.columns[col], row + 1, stringTemp, row, this.rowCount - row - 1);
                    this.columns[col] = stringTemp;
                }
            }
        }
        --this.rowCount;
    }

    public void setRow(int row, Object[] pieces) {
        this.ensureBounds(row, pieces.length - 1);
        for (int col = 0; col < pieces.length; ++col) {
            this.setRowCol(row, col, pieces[col]);
        }
    }

    protected void setRowCol(int row, int col, Object piece) {
        switch (this.columnTypes[col]) {
            case 0: {
                String[] stringData = (String[])this.columns[col];
                if (piece == null) {
                    stringData[row] = null;
                    break;
                }
                stringData[row] = String.valueOf(piece);
                break;
            }
            case 1: {
                int[] intData = (int[])this.columns[col];
                if (piece == null) {
                    intData[row] = this.missingInt;
                    break;
                }
                if (piece instanceof Integer) {
                    intData[row] = (Integer)piece;
                    break;
                }
                intData[row] = PApplet.parseInt(String.valueOf(piece), this.missingInt);
                break;
            }
            case 2: {
                long[] longData = (long[])this.columns[col];
                if (piece == null) {
                    longData[row] = this.missingLong;
                    break;
                }
                if (piece instanceof Long) {
                    longData[row] = (Long)piece;
                    break;
                }
                try {
                    longData[row] = Long.parseLong(String.valueOf(piece));
                }
                catch (NumberFormatException nfe) {
                    longData[row] = this.missingLong;
                }
                break;
            }
            case 3: {
                float[] floatData = (float[])this.columns[col];
                if (piece == null) {
                    floatData[row] = this.missingFloat;
                    break;
                }
                if (piece instanceof Float) {
                    floatData[row] = ((Float)piece).floatValue();
                    break;
                }
                floatData[row] = PApplet.parseFloat(String.valueOf(piece), this.missingFloat);
                break;
            }
            case 4: {
                double[] doubleData = (double[])this.columns[col];
                if (piece == null) {
                    doubleData[row] = this.missingDouble;
                    break;
                }
                if (piece instanceof Double) {
                    doubleData[row] = (Double)piece;
                    break;
                }
                try {
                    doubleData[row] = Double.parseDouble(String.valueOf(piece));
                }
                catch (NumberFormatException nfe) {
                    doubleData[row] = this.missingDouble;
                }
                break;
            }
            case 5: {
                int[] indexData = (int[])this.columns[col];
                if (piece == null) {
                    indexData[row] = this.missingCategory;
                    break;
                }
                indexData[row] = this.columnCategories[col].index(String.valueOf(piece));
                break;
            }
            default: {
                throw new IllegalArgumentException("That's not a valid column type.");
            }
        }
    }

    public TableRow getRow(int row) {
        return new RowPointer(this, row);
    }

    public Iterable<TableRow> rows() {
        return new Iterable<TableRow>(){

            @Override
            public Iterator<TableRow> iterator() {
                if (Table.this.rowIterator == null) {
                    Table.this.rowIterator = new RowIterator(Table.this);
                } else {
                    Table.this.rowIterator.reset();
                }
                return Table.this.rowIterator;
            }
        };
    }

    public Iterable<TableRow> rows(final int[] indices) {
        return new Iterable<TableRow>(){

            @Override
            public Iterator<TableRow> iterator() {
                return new RowIndexIterator(Table.this, indices);
            }
        };
    }

    public int getInt(int row, int column) {
        this.checkBounds(row, column);
        if (this.columnTypes[column] == 1 || this.columnTypes[column] == 5) {
            int[] intData = (int[])this.columns[column];
            return intData[row];
        }
        String str = this.getString(row, column);
        return str == null || str.equals(this.missingString) ? this.missingInt : PApplet.parseInt(str, this.missingInt);
    }

    public int getInt(int row, String columnName) {
        return this.getInt(row, this.getColumnIndex(columnName));
    }

    public void setMissingInt(int value) {
        this.missingInt = value;
    }

    public void setInt(int row, int column, int value) {
        if (this.columnTypes[column] == 0) {
            this.setString(row, column, String.valueOf(value));
        } else {
            this.ensureBounds(row, column);
            if (this.columnTypes[column] != 1 && this.columnTypes[column] != 5) {
                throw new IllegalArgumentException("Column " + column + " is not an int column.");
            }
            int[] intData = (int[])this.columns[column];
            intData[row] = value;
        }
    }

    public void setInt(int row, String columnName, int value) {
        this.setInt(row, this.getColumnIndex(columnName), value);
    }

    public int[] getIntColumn(String name) {
        int col = this.getColumnIndex(name);
        return col == -1 ? null : this.getIntColumn(col);
    }

    public int[] getIntColumn(int col) {
        int[] outgoing = new int[this.rowCount];
        for (int row = 0; row < this.rowCount; ++row) {
            outgoing[row] = this.getInt(row, col);
        }
        return outgoing;
    }

    public int[] getIntRow(int row) {
        int[] outgoing = new int[this.columns.length];
        for (int col = 0; col < this.columns.length; ++col) {
            outgoing[col] = this.getInt(row, col);
        }
        return outgoing;
    }

    public long getLong(int row, int column) {
        this.checkBounds(row, column);
        if (this.columnTypes[column] == 2) {
            long[] longData = (long[])this.columns[column];
            return longData[row];
        }
        String str = this.getString(row, column);
        if (str == null || str.equals(this.missingString)) {
            return this.missingLong;
        }
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException nfe) {
            return this.missingLong;
        }
    }

    public long getLong(int row, String columnName) {
        return this.getLong(row, this.getColumnIndex(columnName));
    }

    public void setMissingLong(long value) {
        this.missingLong = value;
    }

    public void setLong(int row, int column, long value) {
        if (this.columnTypes[column] == 0) {
            this.setString(row, column, String.valueOf(value));
        } else {
            this.ensureBounds(row, column);
            if (this.columnTypes[column] != 2) {
                throw new IllegalArgumentException("Column " + column + " is not a 'long' column.");
            }
            long[] longData = (long[])this.columns[column];
            longData[row] = value;
        }
    }

    public void setLong(int row, String columnName, long value) {
        this.setLong(row, this.getColumnIndex(columnName), value);
    }

    public long[] getLongColumn(String name) {
        int col = this.getColumnIndex(name);
        return col == -1 ? null : this.getLongColumn(col);
    }

    public long[] getLongColumn(int col) {
        long[] outgoing = new long[this.rowCount];
        for (int row = 0; row < this.rowCount; ++row) {
            outgoing[row] = this.getLong(row, col);
        }
        return outgoing;
    }

    public long[] getLongRow(int row) {
        long[] outgoing = new long[this.columns.length];
        for (int col = 0; col < this.columns.length; ++col) {
            outgoing[col] = this.getLong(row, col);
        }
        return outgoing;
    }

    public float getFloat(int row, int column) {
        this.checkBounds(row, column);
        if (this.columnTypes[column] == 3) {
            float[] floatData = (float[])this.columns[column];
            return floatData[row];
        }
        String str = this.getString(row, column);
        if (str == null || str.equals(this.missingString)) {
            return this.missingFloat;
        }
        return PApplet.parseFloat(str, this.missingFloat);
    }

    public float getFloat(int row, String columnName) {
        return this.getFloat(row, this.getColumnIndex(columnName));
    }

    public void setMissingFloat(float value) {
        this.missingFloat = value;
    }

    public void setFloat(int row, int column, float value) {
        if (this.columnTypes[column] == 0) {
            this.setString(row, column, String.valueOf(value));
        } else {
            this.ensureBounds(row, column);
            if (this.columnTypes[column] != 3) {
                throw new IllegalArgumentException("Column " + column + " is not a float column.");
            }
            float[] longData = (float[])this.columns[column];
            longData[row] = value;
        }
    }

    public void setFloat(int row, String columnName, float value) {
        this.setFloat(row, this.getColumnIndex(columnName), value);
    }

    public float[] getFloatColumn(String name) {
        int col = this.getColumnIndex(name);
        return col == -1 ? null : this.getFloatColumn(col);
    }

    public float[] getFloatColumn(int col) {
        float[] outgoing = new float[this.rowCount];
        for (int row = 0; row < this.rowCount; ++row) {
            outgoing[row] = this.getFloat(row, col);
        }
        return outgoing;
    }

    public float[] getFloatRow(int row) {
        float[] outgoing = new float[this.columns.length];
        for (int col = 0; col < this.columns.length; ++col) {
            outgoing[col] = this.getFloat(row, col);
        }
        return outgoing;
    }

    public double getDouble(int row, int column) {
        this.checkBounds(row, column);
        if (this.columnTypes[column] == 4) {
            double[] doubleData = (double[])this.columns[column];
            return doubleData[row];
        }
        String str = this.getString(row, column);
        if (str == null || str.equals(this.missingString)) {
            return this.missingDouble;
        }
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException nfe) {
            return this.missingDouble;
        }
    }

    public double getDouble(int row, String columnName) {
        return this.getDouble(row, this.getColumnIndex(columnName));
    }

    public void setMissingDouble(double value) {
        this.missingDouble = value;
    }

    public void setDouble(int row, int column, double value) {
        if (this.columnTypes[column] == 0) {
            this.setString(row, column, String.valueOf(value));
        } else {
            this.ensureBounds(row, column);
            if (this.columnTypes[column] != 4) {
                throw new IllegalArgumentException("Column " + column + " is not a 'double' column.");
            }
            double[] doubleData = (double[])this.columns[column];
            doubleData[row] = value;
        }
    }

    public void setDouble(int row, String columnName, double value) {
        this.setDouble(row, this.getColumnIndex(columnName), value);
    }

    public double[] getDoubleColumn(String name) {
        int col = this.getColumnIndex(name);
        return col == -1 ? null : this.getDoubleColumn(col);
    }

    public double[] getDoubleColumn(int col) {
        double[] outgoing = new double[this.rowCount];
        for (int row = 0; row < this.rowCount; ++row) {
            outgoing[row] = this.getDouble(row, col);
        }
        return outgoing;
    }

    public double[] getDoubleRow(int row) {
        double[] outgoing = new double[this.columns.length];
        for (int col = 0; col < this.columns.length; ++col) {
            outgoing[col] = this.getDouble(row, col);
        }
        return outgoing;
    }

    public String getString(int row, int column) {
        this.checkBounds(row, column);
        if (this.columnTypes[column] == 0) {
            String[] stringData = (String[])this.columns[column];
            return stringData[row];
        }
        if (this.columnTypes[column] == 5) {
            int cat = this.getInt(row, column);
            if (cat == this.missingCategory) {
                return this.missingString;
            }
            return this.columnCategories[column].key(cat);
        }
        return String.valueOf(Array.get(this.columns[column], row));
    }

    public String getString(int row, String columnName) {
        return this.getString(row, this.getColumnIndex(columnName));
    }

    public void setMissingString(String value) {
        this.missingString = value;
    }

    public void setString(int row, int column, String value) {
        this.ensureBounds(row, column);
        if (this.columnTypes[column] != 0) {
            throw new IllegalArgumentException("Column " + column + " is not a String column.");
        }
        String[] stringData = (String[])this.columns[column];
        stringData[row] = value;
    }

    public void setString(int row, String columnName, String value) {
        int column = this.checkColumnIndex(columnName);
        this.setString(row, column, value);
    }

    public String[] getStringColumn(String columnName) {
        int col = this.getColumnIndex(columnName);
        return col == -1 ? null : this.getStringColumn(col);
    }

    public String[] getStringColumn(int column) {
        String[] outgoing = new String[this.rowCount];
        for (int i = 0; i < this.rowCount; ++i) {
            outgoing[i] = this.getString(i, column);
        }
        return outgoing;
    }

    public String[] getStringRow(int row) {
        String[] outgoing = new String[this.columns.length];
        for (int col = 0; col < this.columns.length; ++col) {
            outgoing[col] = this.getString(row, col);
        }
        return outgoing;
    }

    public int findRowIndex(String value, int column) {
        this.checkColumn(column);
        if (this.columnTypes[column] == 0) {
            String[] stringData = (String[])this.columns[column];
            if (value == null) {
                for (int row = 0; row < this.rowCount; ++row) {
                    if (stringData[row] != null) continue;
                    return row;
                }
            } else {
                for (int row = 0; row < this.rowCount; ++row) {
                    if (stringData[row] == null || !stringData[row].equals(value)) continue;
                    return row;
                }
            }
        } else {
            for (int row = 0; row < this.rowCount; ++row) {
                String str = this.getString(row, column);
                if (!(str == null ? value == null : str.equals(value))) continue;
                return row;
            }
        }
        return -1;
    }

    public int findRowIndex(String value, String columnName) {
        return this.findRowIndex(value, this.getColumnIndex(columnName));
    }

    public int[] findRowIndices(String value, int column) {
        int[] outgoing = new int[this.rowCount];
        int count = 0;
        this.checkColumn(column);
        if (this.columnTypes[column] == 0) {
            String[] stringData = (String[])this.columns[column];
            if (value == null) {
                for (int row = 0; row < this.rowCount; ++row) {
                    if (stringData[row] != null) continue;
                    outgoing[count++] = row;
                }
            } else {
                for (int row = 0; row < this.rowCount; ++row) {
                    if (stringData[row] == null || !stringData[row].equals(value)) continue;
                    outgoing[count++] = row;
                }
            }
        } else {
            for (int row = 0; row < this.rowCount; ++row) {
                String str = this.getString(row, column);
                if (str == null) {
                    if (value != null) continue;
                    outgoing[count++] = row;
                    continue;
                }
                if (!str.equals(value)) continue;
                outgoing[count++] = row;
            }
        }
        return PApplet.subset(outgoing, 0, count);
    }

    public int[] findRowIndices(String value, String columnName) {
        return this.findRowIndices(value, this.getColumnIndex(columnName));
    }

    public TableRow findRow(String value, int column) {
        int row = this.findRowIndex(value, column);
        return row == -1 ? null : new RowPointer(this, row);
    }

    public TableRow findRow(String value, String columnName) {
        return this.findRow(value, this.getColumnIndex(columnName));
    }

    public Iterable<TableRow> findRows(final String value, final int column) {
        return new Iterable<TableRow>(){

            @Override
            public Iterator<TableRow> iterator() {
                return Table.this.findRowIterator(value, column);
            }
        };
    }

    public Iterable<TableRow> findRows(String value, String columnName) {
        return this.findRows(value, this.getColumnIndex(columnName));
    }

    public Iterator<TableRow> findRowIterator(String value, int column) {
        return new RowIndexIterator(this, this.findRowIndices(value, column));
    }

    public Iterator<TableRow> findRowIterator(String value, String columnName) {
        return this.findRowIterator(value, this.getColumnIndex(columnName));
    }

    public int matchRowIndex(String regexp, int column) {
        this.checkColumn(column);
        if (this.columnTypes[column] == 0) {
            String[] stringData = (String[])this.columns[column];
            for (int row = 0; row < this.rowCount; ++row) {
                if (stringData[row] == null || PApplet.match(stringData[row], regexp) == null) continue;
                return row;
            }
        } else {
            for (int row = 0; row < this.rowCount; ++row) {
                String str = this.getString(row, column);
                if (str == null || PApplet.match(str, regexp) == null) continue;
                return row;
            }
        }
        return -1;
    }

    public int matchRowIndex(String what, String columnName) {
        return this.matchRowIndex(what, this.getColumnIndex(columnName));
    }

    public int[] matchRowIndices(String regexp, int column) {
        int[] outgoing = new int[this.rowCount];
        int count = 0;
        this.checkColumn(column);
        if (this.columnTypes[column] == 0) {
            String[] stringData = (String[])this.columns[column];
            for (int row = 0; row < this.rowCount; ++row) {
                if (stringData[row] == null || PApplet.match(stringData[row], regexp) == null) continue;
                outgoing[count++] = row;
            }
        } else {
            for (int row = 0; row < this.rowCount; ++row) {
                String str = this.getString(row, column);
                if (str == null || PApplet.match(str, regexp) == null) continue;
                outgoing[count++] = row;
            }
        }
        return PApplet.subset(outgoing, 0, count);
    }

    public int[] matchRowIndices(String what, String columnName) {
        return this.matchRowIndices(what, this.getColumnIndex(columnName));
    }

    public TableRow matchRow(String regexp, int column) {
        int row = this.matchRowIndex(regexp, column);
        return row == -1 ? null : new RowPointer(this, row);
    }

    public TableRow matchRow(String regexp, String columnName) {
        return this.matchRow(regexp, this.getColumnIndex(columnName));
    }

    public Iterable<TableRow> matchRows(final String regexp, final int column) {
        return new Iterable<TableRow>(){

            @Override
            public Iterator<TableRow> iterator() {
                return Table.this.matchRowIterator(regexp, column);
            }
        };
    }

    public Iterable<TableRow> matchRows(String regexp, String columnName) {
        return this.matchRows(regexp, this.getColumnIndex(columnName));
    }

    public Iterator<TableRow> matchRowIterator(String value, int column) {
        return new RowIndexIterator(this, this.matchRowIndices(value, column));
    }

    public Iterator<TableRow> matchRowIterator(String value, String columnName) {
        return this.matchRowIterator(value, this.getColumnIndex(columnName));
    }

    public void replace(String orig, String replacement) {
        for (int col = 0; col < this.columns.length; ++col) {
            this.replace(orig, replacement, col);
        }
    }

    public void replace(String orig, String replacement, int col) {
        if (this.columnTypes[col] == 0) {
            String[] stringData = (String[])this.columns[col];
            for (int row = 0; row < this.rowCount; ++row) {
                if (!stringData[row].equals(orig)) continue;
                stringData[row] = replacement;
            }
        }
    }

    public void replace(String orig, String replacement, String colName) {
        this.replace(orig, replacement, this.getColumnIndex(colName));
    }

    public void replaceAll(String orig, String replacement) {
        for (int col = 0; col < this.columns.length; ++col) {
            this.replaceAll(orig, replacement, col);
        }
    }

    public void replaceAll(String regex, String replacement, int column) {
        this.checkColumn(column);
        if (this.columnTypes[column] == 0) {
            String[] stringData = (String[])this.columns[column];
            for (int row = 0; row < this.rowCount; ++row) {
                if (stringData[row] == null) continue;
                stringData[row] = stringData[row].replaceAll(regex, replacement);
            }
        } else {
            throw new IllegalArgumentException("replaceAll() can only be used on String columns");
        }
    }

    public void replaceAll(String regex, String replacement, String columnName) {
        this.replaceAll(regex, replacement, this.getColumnIndex(columnName));
    }

    public void removeTokens(String tokens) {
        for (int col = 0; col < this.getColumnCount(); ++col) {
            this.removeTokens(tokens, col);
        }
    }

    public void removeTokens(String tokens, int column) {
        for (int row = 0; row < this.rowCount; ++row) {
            String s = this.getString(row, column);
            if (s == null) continue;
            char[] c = s.toCharArray();
            int index = 0;
            for (int j = 0; j < c.length; ++j) {
                if (tokens.indexOf(c[j]) != -1) continue;
                if (index != j) {
                    c[index] = c[j];
                }
                ++index;
            }
            if (index == c.length) continue;
            this.setString(row, column, new String(c, 0, index));
        }
    }

    public void removeTokens(String tokens, String columnName) {
        this.removeTokens(tokens, this.getColumnIndex(columnName));
    }

    public void trim() {
        for (int col = 0; col < this.getColumnCount(); ++col) {
            this.trim(col);
        }
    }

    public void trim(int column) {
        if (this.columnTypes[column] == 0) {
            String[] stringData = (String[])this.columns[column];
            for (int row = 0; row < this.rowCount; ++row) {
                if (stringData[row] == null) continue;
                stringData[row] = PApplet.trim(stringData[row]);
            }
        }
    }

    public void trim(String columnName) {
        this.trim(this.getColumnIndex(columnName));
    }

    protected void ensureColumn(int col) {
        if (col >= this.columns.length) {
            this.setColumnCount(col + 1);
        }
    }

    protected void ensureRow(int row) {
        if (row >= this.rowCount) {
            this.setRowCount(row + 1);
        }
    }

    protected void ensureBounds(int row, int col) {
        this.ensureRow(row);
        this.ensureColumn(col);
    }

    protected void checkRow(int row) {
        if (row < 0 || row >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException("Row " + row + " does not exist.");
        }
    }

    protected void checkColumn(int column) {
        if (column < 0 || column >= this.columns.length) {
            throw new ArrayIndexOutOfBoundsException("Column " + column + " does not exist.");
        }
    }

    protected void checkBounds(int row, int column) {
        this.checkRow(row);
        this.checkColumn(column);
    }

    public void sort(String columnName) {
        this.sort(this.getColumnIndex(columnName), false);
    }

    public void sort(int column) {
        this.sort(column, false);
    }

    public void sortReverse(String columnName) {
        this.sort(this.getColumnIndex(columnName), true);
    }

    public void sortReverse(int column) {
        this.sort(column, true);
    }

    protected void sort(final int column, final boolean reverse) {
        final int[] order = IntList.fromRange(this.getRowCount()).array();
        Sort s = new Sort(){

            @Override
            public int size() {
                return Table.this.getRowCount();
            }

            @Override
            public float compare(int index1, int index2) {
                int a = reverse ? order[index2] : order[index1];
                int b = reverse ? order[index1] : order[index2];
                switch (Table.this.getColumnType(column)) {
                    case 1: {
                        return Table.this.getInt(a, column) - Table.this.getInt(b, column);
                    }
                    case 2: {
                        return Table.this.getLong(a, column) - Table.this.getLong(b, column);
                    }
                    case 3: {
                        return Table.this.getFloat(a, column) - Table.this.getFloat(b, column);
                    }
                    case 4: {
                        return (float)(Table.this.getDouble(a, column) - Table.this.getDouble(b, column));
                    }
                    case 0: {
                        return Table.this.getString(a, column).compareToIgnoreCase(Table.this.getString(b, column));
                    }
                    case 5: {
                        return Table.this.getInt(a, column) - Table.this.getInt(b, column);
                    }
                }
                throw new IllegalArgumentException("Invalid column type: " + Table.this.getColumnType(column));
            }

            @Override
            public void swap(int a, int b) {
                int temp = order[a];
                order[a] = order[b];
                order[b] = temp;
            }
        };
        s.run();
        block7: for (int col = 0; col < this.getColumnCount(); ++col) {
            switch (this.getColumnType(col)) {
                case 1: 
                case 5: {
                    int[] oldInt = (int[])this.columns[col];
                    int[] newInt = new int[this.rowCount];
                    for (int row = 0; row < this.getRowCount(); ++row) {
                        newInt[row] = oldInt[order[row]];
                    }
                    this.columns[col] = newInt;
                    continue block7;
                }
                case 2: {
                    long[] oldLong = (long[])this.columns[col];
                    long[] newLong = new long[this.rowCount];
                    for (int row = 0; row < this.getRowCount(); ++row) {
                        newLong[row] = oldLong[order[row]];
                    }
                    this.columns[col] = newLong;
                    continue block7;
                }
                case 3: {
                    float[] oldFloat = (float[])this.columns[col];
                    float[] newFloat = new float[this.rowCount];
                    for (int row = 0; row < this.getRowCount(); ++row) {
                        newFloat[row] = oldFloat[order[row]];
                    }
                    this.columns[col] = newFloat;
                    continue block7;
                }
                case 4: {
                    double[] oldDouble = (double[])this.columns[col];
                    double[] newDouble = new double[this.rowCount];
                    for (int row = 0; row < this.getRowCount(); ++row) {
                        newDouble[row] = oldDouble[order[row]];
                    }
                    this.columns[col] = newDouble;
                    continue block7;
                }
                case 0: {
                    String[] oldString = (String[])this.columns[col];
                    String[] newString = new String[this.rowCount];
                    for (int row = 0; row < this.getRowCount(); ++row) {
                        newString[row] = oldString[order[row]];
                    }
                    this.columns[col] = newString;
                }
            }
        }
    }

    public String[] getUnique(String columnName) {
        return this.getUnique(this.getColumnIndex(columnName));
    }

    public String[] getUnique(int column) {
        StringList list = new StringList(this.getStringColumn(column));
        return list.getUnique();
    }

    public IntDict getTally(String columnName) {
        return this.getTally(this.getColumnIndex(columnName));
    }

    public IntDict getTally(int column) {
        StringList list = new StringList(this.getStringColumn(column));
        return list.getTally();
    }

    public IntDict getOrder(String columnName) {
        return this.getOrder(this.getColumnIndex(columnName));
    }

    public IntDict getOrder(int column) {
        StringList list = new StringList(this.getStringColumn(column));
        return list.getOrder();
    }

    public IntList getIntList(String columnName) {
        return new IntList(this.getIntColumn(columnName));
    }

    public IntList getIntList(int column) {
        return new IntList(this.getIntColumn(column));
    }

    public FloatList getFloatList(String columnName) {
        return new FloatList(this.getFloatColumn(columnName));
    }

    public FloatList getFloatList(int column) {
        return new FloatList(this.getFloatColumn(column));
    }

    public StringList getStringList(String columnName) {
        return new StringList(this.getStringColumn(columnName));
    }

    public StringList getStringList(int column) {
        return new StringList(this.getStringColumn(column));
    }

    public IntDict getIntDict(String keyColumnName, String valueColumnName) {
        return new IntDict(this.getStringColumn(keyColumnName), this.getIntColumn(valueColumnName));
    }

    public IntDict getIntDict(int keyColumn, int valueColumn) {
        return new IntDict(this.getStringColumn(keyColumn), this.getIntColumn(valueColumn));
    }

    public FloatDict getFloatDict(String keyColumnName, String valueColumnName) {
        return new FloatDict(this.getStringColumn(keyColumnName), this.getFloatColumn(valueColumnName));
    }

    public FloatDict getFloatDict(int keyColumn, int valueColumn) {
        return new FloatDict(this.getStringColumn(keyColumn), this.getFloatColumn(valueColumn));
    }

    public StringDict getStringDict(String keyColumnName, String valueColumnName) {
        return new StringDict(this.getStringColumn(keyColumnName), this.getStringColumn(valueColumnName));
    }

    public StringDict getStringDict(int keyColumn, int valueColumn) {
        return new StringDict(this.getStringColumn(keyColumn), this.getStringColumn(valueColumn));
    }

    protected Table createSubset(int[] rowSubset) {
        Table newbie = new Table();
        newbie.setColumnTitles(this.columnTitles);
        newbie.columnTypes = this.columnTypes;
        newbie.setRowCount(rowSubset.length);
        for (int i = 0; i < rowSubset.length; ++i) {
            int row = rowSubset[i];
            block8: for (int col = 0; col < this.columns.length; ++col) {
                switch (this.columnTypes[col]) {
                    case 0: {
                        newbie.setString(i, col, this.getString(row, col));
                        continue block8;
                    }
                    case 1: {
                        newbie.setInt(i, col, this.getInt(row, col));
                        continue block8;
                    }
                    case 2: {
                        newbie.setLong(i, col, this.getLong(row, col));
                        continue block8;
                    }
                    case 3: {
                        newbie.setFloat(i, col, this.getFloat(row, col));
                        continue block8;
                    }
                    case 4: {
                        newbie.setDouble(i, col, this.getDouble(row, col));
                    }
                }
            }
        }
        return newbie;
    }

    protected float getMaxFloat() {
        boolean found = false;
        float max = -3.4028235E38f;
        for (int row = 0; row < this.getRowCount(); ++row) {
            for (int col = 0; col < this.getColumnCount(); ++col) {
                float value = this.getFloat(row, col);
                if (Float.isNaN(value)) continue;
                if (!found) {
                    max = value;
                    found = true;
                    continue;
                }
                if (!(value > max)) continue;
                max = value;
            }
        }
        return found ? max : this.missingFloat;
    }

    protected void convertBasic(BufferedReader reader, boolean tsv, File outputFile) throws IOException {
        String string;
        FileOutputStream fos = new FileOutputStream(outputFile);
        BufferedOutputStream bos = new BufferedOutputStream(fos, 16384);
        DataOutputStream output = new DataOutputStream(bos);
        output.writeInt(0);
        output.writeInt(this.getColumnCount());
        if (this.columnTitles != null) {
            output.writeBoolean(true);
            for (String title : this.columnTitles) {
                output.writeUTF(title);
            }
        } else {
            output.writeBoolean(false);
        }
        for (int type : this.columnTypes) {
            output.writeInt(type);
        }
        Object var7_9 = null;
        int prev = -1;
        int row = 0;
        while ((string = reader.readLine()) != null) {
            int pct;
            this.convertRow(output, tsv ? PApplet.split(string, '\t') : Table.splitLineCSV(string));
            if (++row % 10000 != 0 || row >= this.rowCount || (pct = 100 * row / this.rowCount) == prev) continue;
            System.out.println(pct + "%");
            prev = pct;
        }
        int col = 0;
        for (HashMapBlows hmb : this.columnCategories) {
            if (hmb == null) {
                output.writeInt(0);
            } else {
                hmb.write(output);
                hmb.writeln(PApplet.createWriter(new File(this.columnTitles[col] + ".categories")));
            }
            ++col;
        }
        output.flush();
        output.close();
        RandomAccessFile raf = new RandomAccessFile(outputFile, "rw");
        raf.writeInt(this.rowCount);
        raf.close();
    }

    protected void convertRow(DataOutputStream output, String[] pieces) throws IOException {
        int col;
        if (pieces.length > this.getColumnCount()) {
            throw new IllegalArgumentException("Row with too many columns: " + PApplet.join(pieces, ","));
        }
        block20: for (col = 0; col < pieces.length; ++col) {
            switch (this.columnTypes[col]) {
                case 0: {
                    output.writeUTF(pieces[col]);
                    continue block20;
                }
                case 1: {
                    output.writeInt(PApplet.parseInt(pieces[col], this.missingInt));
                    continue block20;
                }
                case 2: {
                    try {
                        output.writeLong(Long.parseLong(pieces[col]));
                    }
                    catch (NumberFormatException nfe) {
                        output.writeLong(this.missingLong);
                    }
                    continue block20;
                }
                case 3: {
                    output.writeFloat(PApplet.parseFloat(pieces[col], this.missingFloat));
                    continue block20;
                }
                case 4: {
                    try {
                        output.writeDouble(Double.parseDouble(pieces[col]));
                    }
                    catch (NumberFormatException nfe) {
                        output.writeDouble(this.missingDouble);
                    }
                    continue block20;
                }
                case 5: {
                    output.writeInt(this.columnCategories[col].index(pieces[col]));
                }
            }
        }
        block21: for (col = pieces.length; col < this.getColumnCount(); ++col) {
            switch (this.columnTypes[col]) {
                case 0: {
                    output.writeUTF("");
                    continue block21;
                }
                case 1: {
                    output.writeInt(this.missingInt);
                    continue block21;
                }
                case 2: {
                    output.writeLong(this.missingLong);
                    continue block21;
                }
                case 3: {
                    output.writeFloat(this.missingFloat);
                    continue block21;
                }
                case 4: {
                    output.writeDouble(this.missingDouble);
                    continue block21;
                }
                case 5: {
                    output.writeInt(this.missingCategory);
                }
            }
        }
    }

    class HashMapBlows {
        HashMap<String, Integer> dataToIndex = new HashMap();
        ArrayList<String> indexToData = new ArrayList();

        HashMapBlows() {
        }

        HashMapBlows(DataInputStream input) throws IOException {
            this.read(input);
        }

        int index(String key) {
            Integer value = this.dataToIndex.get(key);
            if (value != null) {
                return value;
            }
            int v = this.dataToIndex.size();
            this.dataToIndex.put(key, v);
            this.indexToData.add(key);
            return v;
        }

        String key(int index) {
            return this.indexToData.get(index);
        }

        int size() {
            return this.dataToIndex.size();
        }

        void write(DataOutputStream output) throws IOException {
            output.writeInt(this.size());
            for (String str : this.indexToData) {
                output.writeUTF(str);
            }
        }

        private void writeln(PrintWriter writer) throws IOException {
            for (String str : this.indexToData) {
                writer.println(str);
            }
            writer.flush();
            writer.close();
        }

        void read(DataInputStream input) throws IOException {
            int count = input.readInt();
            this.dataToIndex = new HashMap(count);
            for (int i = 0; i < count; ++i) {
                String str = input.readUTF();
                this.dataToIndex.put(str, i);
                this.indexToData.add(str);
            }
        }
    }

    static class RowIndexIterator
    implements Iterator<TableRow> {
        Table table;
        RowPointer rp;
        int[] indices;
        int index;

        public RowIndexIterator(Table table, int[] indices) {
            this.table = table;
            this.indices = indices;
            this.index = -1;
            this.rp = new RowPointer(table, -1);
        }

        @Override
        public void remove() {
            this.table.removeRow(this.indices[this.index]);
        }

        @Override
        public TableRow next() {
            this.rp.setRow(this.indices[++this.index]);
            return this.rp;
        }

        @Override
        public boolean hasNext() {
            return this.index + 1 < this.indices.length;
        }

        public void reset() {
            this.index = -1;
        }
    }

    static class RowIterator
    implements Iterator<TableRow> {
        Table table;
        RowPointer rp;
        int row;

        public RowIterator(Table table) {
            this.table = table;
            this.row = -1;
            this.rp = new RowPointer(table, this.row);
        }

        @Override
        public void remove() {
            this.table.removeRow(this.row);
        }

        @Override
        public TableRow next() {
            this.rp.setRow(++this.row);
            return this.rp;
        }

        @Override
        public boolean hasNext() {
            return this.row + 1 < this.table.getRowCount();
        }

        public void reset() {
            this.row = -1;
        }
    }

    static class RowPointer
    implements TableRow {
        Table table;
        int row;

        public RowPointer(Table table, int row) {
            this.table = table;
            this.row = row;
        }

        public void setRow(int row) {
            this.row = row;
        }

        @Override
        public String getString(int column) {
            return this.table.getString(this.row, column);
        }

        @Override
        public String getString(String columnName) {
            return this.table.getString(this.row, columnName);
        }

        @Override
        public int getInt(int column) {
            return this.table.getInt(this.row, column);
        }

        @Override
        public int getInt(String columnName) {
            return this.table.getInt(this.row, columnName);
        }

        @Override
        public long getLong(int column) {
            return this.table.getLong(this.row, column);
        }

        @Override
        public long getLong(String columnName) {
            return this.table.getLong(this.row, columnName);
        }

        @Override
        public float getFloat(int column) {
            return this.table.getFloat(this.row, column);
        }

        @Override
        public float getFloat(String columnName) {
            return this.table.getFloat(this.row, columnName);
        }

        @Override
        public double getDouble(int column) {
            return this.table.getDouble(this.row, column);
        }

        @Override
        public double getDouble(String columnName) {
            return this.table.getDouble(this.row, columnName);
        }

        @Override
        public void setString(int column, String value) {
            this.table.setString(this.row, column, value);
        }

        @Override
        public void setString(String columnName, String value) {
            this.table.setString(this.row, columnName, value);
        }

        @Override
        public void setInt(int column, int value) {
            this.table.setInt(this.row, column, value);
        }

        @Override
        public void setInt(String columnName, int value) {
            this.table.setInt(this.row, columnName, value);
        }

        @Override
        public void setLong(int column, long value) {
            this.table.setLong(this.row, column, value);
        }

        @Override
        public void setLong(String columnName, long value) {
            this.table.setLong(this.row, columnName, value);
        }

        @Override
        public void setFloat(int column, float value) {
            this.table.setFloat(this.row, column, value);
        }

        @Override
        public void setFloat(String columnName, float value) {
            this.table.setFloat(this.row, columnName, value);
        }

        @Override
        public void setDouble(int column, double value) {
            this.table.setDouble(this.row, column, value);
        }

        @Override
        public void setDouble(String columnName, double value) {
            this.table.setDouble(this.row, columnName, value);
        }

        @Override
        public int getColumnCount() {
            return this.table.getColumnCount();
        }

        @Override
        public int getColumnType(String columnName) {
            return this.table.getColumnType(columnName);
        }

        @Override
        public int getColumnType(int column) {
            return this.table.getColumnType(column);
        }

        @Override
        public int[] getColumnTypes() {
            return this.table.getColumnTypes();
        }
    }
}

