package lec01play;

import processing.core.PApplet;

public class Lec01Play extends PApplet {

	public void setup() {
		// always draw smooth-looking lines and curves
		smooth();

		// initial drawing space
		// 640 pixels wide
		// 360 pixels high
		size(640, 360);
	}

	public void draw() {
		// reset the drawing space to a dark blue color
		background(0, 0, 63);

		// prepare to draw a red triangle with a thick green border
		fill(255, 0, 0);
		stroke(0, 255, 0);
		strokeWeight(7);
		
		// put the triangle halfway down on the left-hand side
		triangle(0, height/2, 64, (height/2)-18, 64, (height/2)+18);
		
		// prepare to draw a yellow triangle with a thin purple border
		fill(255, 255, 0);
		stroke(255, 0, 255);
		strokeWeight(2);
		
		// put the triangle halfway across at the top
		triangle(width/2, 0, (width/2)-32, 36, (width/2)+32, 36);
		
		// draw 2 rectangles using corner points, widths, and heights
		rectMode(CORNER);
		strokeWeight(1);        // rect 1 has a thin border
		stroke(255);            // rect 1 has a white border
		noFill();               // rect 1 has no interior color
		rect(40, 20, 50, 10);   // rect 1 is wide but not tall
		strokeWeight(10);       // rect 2 has a thick border
		stroke(255, 191, 191);  // rect 2 has a pinkish border
		fill(255);              // rect 2 has a white interior
		rect(120, 20, 80, 240); // rect 2 is much taller than wide

		// draw 2 ellipses using corner points, widths, and heights
		ellipseMode(CORNER);
		strokeWeight(1);           // ellipse 1 has a thin border
		stroke(255);               // ellipse 1 has a white border
		noFill();                  // ellipse 1 has no interior color
		ellipse(220, 99, 80, 20);  // ellipse 1 is wide but not tall
		strokeWeight(10);          // ellipse 2 has a thick border
		stroke(255, 191, 191);     // ellipse 2 has a pinkish border
		fill(255);                 // ellipse 2 has a white interior
		ellipse(300, 99, 80, 240); // ellipse 2 is much taller than wide

		// draw some orange lines
		stroke(255, 191, 15);    // an orange-ish color
		strokeWeight(2);         // a thin line
		line(500, 20, 500, 210); // a vertical, tall line
		strokeWeight(4);         // double-thickness
		line(510, 20, 620, 110); // a diagonal, medium-length line
		strokeWeight(8);         // quadruple-thickness
		line(510, 10, 540, 10);  // a horizontal, short line
		
		// draw some circular arcs
		strokeWeight(2);
		stroke(255,255,0);
		fill(0,127,0);
		arc(600, 180, 30, 30, 0, PI);        // U-shaped semi-circle
		arc(600, 220, 30, 30, PI, TWO_PI);   // upside-down U shape
		arc(599, 259, 30, 30, PI, 3*PI/2);   // upper-left quarter of a circle
		arc(601, 261, 30, 30, 0, PI/2);      // lower-right quarter of a circle
		
		// draw a rectangle around the mouse
		rectMode(CENTER);     // center box on the mouse cursor
		noStroke();           // don't draw an outline to the box
		fill(255, 0, 0, 127); // make the box reddish but semi-transparent
		rect(mouseX, mouseY, 64, 36); // draw it		
	}
}
