/*
 * Your CS1 Professors
 * TestMyLoops.java
 * Tests the methods in IfMethods.java
 * using junit testing.
 * 
 * Do not change anything in this file.
 */
import junit.framework.*;

public class TestMyStrings extends TestCase{
	private IW5Strings myMethods;
	
	public TestMyStrings(){
		super();
		myMethods = new IW5Strings();
	}
	
	public void testBarChart() {
		assertEquals("\nbarChart(1)", "- 1", myMethods.barChart(1));
		assertEquals("\nbarChart(2)", "-- 2", myMethods.barChart(2));
		assertEquals("\nbarChart(3)", "--- 3", myMethods.barChart(3));
		assertEquals("\nbarChart(4)", "---- 4", myMethods.barChart(4));
		assertEquals("\nbarChart(5)", "----- 5", myMethods.barChart(5));
		assertEquals("\nbarChart(6)", "------ 6", myMethods.barChart(6));
		assertEquals("\nbarChart(7)", "------- 7", myMethods.barChart(7));
		assertEquals("\nbarChart(8)", "-------- 8", myMethods.barChart(8));
		assertEquals("\nbarChart(9)", "--------- 9", myMethods.barChart(9));
		assertEquals("\nbarChart(10)", "---------- 10", myMethods.barChart(10));
	}
	
	public void testYUsage() {
		assertEquals("\nyUsage(\"Yawn\")", "cnst", myMethods.yUsage("Yawn"));
		assertEquals("\nyUsage(\"yawn\")", "cnst", myMethods.yUsage("yawn"));
		assertEquals("\nyUsage(\"Yellowy\")", "both", myMethods.yUsage("Yellowy"));
		assertEquals("\nyUsage(\"FRYGUY\")", "vowl", myMethods.yUsage("FRYGUY"));
		assertEquals("\nyUsage(\"Lie\")", "none", myMethods.yUsage("Lie"));

		assertEquals("\nyUsage(\"YO\")", "cnst", myMethods.yUsage("YO"));
		assertEquals("\nyUsage(\"yo\")", "cnst", myMethods.yUsage("yo"));
		assertEquals("\nyUsage(\"yuppY\")", "both", myMethods.yUsage("yuppY"));
		assertEquals("\nyUsage(\"shyguy\")", "vowl", myMethods.yUsage("shyguy"));
		assertEquals("\nyUsage(\"shy\")", "vowl", myMethods.yUsage("shy"));
		assertEquals("\nyUsage(\"guy\")", "vowl", myMethods.yUsage("guy"));
		assertEquals("\nyUsage(\"TRIE\")", "none", myMethods.yUsage("TRIE"));

		assertEquals("\nyUsage(\"oyyyyy\")", "vowl", myMethods.yUsage("oyyyyy"));
	}
	
	public void testPigLatin() {
		assertEquals("\npigLatin(\"duke\")", "ukeday", myMethods.pigLatin("duke"));
		assertEquals("\npigLatin(\"luke\")", "ukelay", myMethods.pigLatin("luke"));
		assertEquals("\npigLatin(\"spooky\")", "ookyspay", myMethods.pigLatin("spooky"));
		assertEquals("\npigLatin(\"trowel\")", "oweltray", myMethods.pigLatin("trowel"));
		assertEquals("\npigLatin(\"stray\")", "aystray", myMethods.pigLatin("stray"));
		assertEquals("\npigLatin(\"stratos\")", "atosstray", myMethods.pigLatin("stratos"));
		assertEquals("\npigLatin(\"schtick\")", "ickschtay", myMethods.pigLatin("schtick"));
		assertEquals("\npigLatin(\"methods\")", "ethodsmay", myMethods.pigLatin("methods"));
		assertEquals("\npigLatin(\"apple\")", "appleway", myMethods.pigLatin("apple"));
		assertEquals("\npigLatin(\"emit\")", "emitway", myMethods.pigLatin("emit"));
		assertEquals("\npigLatin(\"ipad\")", "ipadway", myMethods.pigLatin("ipad"));
		assertEquals("\npigLatin(\"owl\")", "owlway", myMethods.pigLatin("owl"));
		assertEquals("\npigLatin(\"under\")", "underway", myMethods.pigLatin("under"));
		assertEquals("\npigLatin(\"underway\")", "underwayway", myMethods.pigLatin("underway"));

		assertEquals("\npigLatin(\"to\")", "otay", myMethods.pigLatin("to"));
		assertEquals("\npigLatin(\"stu\")", "ustay", myMethods.pigLatin("stu"));
	}
	
	public void testYahtzee() {
		 assertEquals("\nyahtzee(\"11234\")", 2, myMethods.yahtzee("11234"));
		 assertEquals("\nyahtzee(\"12234\")", 2, myMethods.yahtzee("12234"));
		 assertEquals("\nyahtzee(\"12334\")", 2, myMethods.yahtzee("11234"));
		 assertEquals("\nyahtzee(\"12344\")", 2, myMethods.yahtzee("12344"));
		 assertEquals("\nyahtzee(\"11134\")", 3, myMethods.yahtzee("11134"));
		 assertEquals("\nyahtzee(\"12224\")", 3, myMethods.yahtzee("12224"));
		 assertEquals("\nyahtzee(\"12444\")", 3, myMethods.yahtzee("12444"));
		 assertEquals("\nyahtzee(\"14444\")", 4, myMethods.yahtzee("14444"));
		 assertEquals("\nyahtzee(\"44445\")", 4, myMethods.yahtzee("44445"));
		 assertEquals("\nyahtzee(\"66666\")", 5, myMethods.yahtzee("66666"));

		 assertEquals("\nyahtzee(\"22345\")", 2, myMethods.yahtzee("22345"));
		 assertEquals("\nyahtzee(\"23345\")", 2, myMethods.yahtzee("23345"));
		 assertEquals("\nyahtzee(\"23445\")", 2, myMethods.yahtzee("23445"));
		 assertEquals("\nyahtzee(\"23455\")", 2, myMethods.yahtzee("23455"));
		 assertEquals("\nyahtzee(\"22234\")", 3, myMethods.yahtzee("22234"));
		 assertEquals("\nyahtzee(\"13334\")", 3, myMethods.yahtzee("13334"));
		 assertEquals("\nyahtzee(\"12555\")", 3, myMethods.yahtzee("12555"));
		 assertEquals("\nyahtzee(\"16666\")", 4, myMethods.yahtzee("16666"));
		 assertEquals("\nyahtzee(\"55556\")", 4, myMethods.yahtzee("55556"));
		 assertEquals("\nyahtzee(\"11111\")", 5, myMethods.yahtzee("11111"));

		 assertEquals("\nyahtzee(\"12346\")", 0, myMethods.yahtzee("12346"));
		 assertEquals("\nyahtzee(\"12356\")", 0, myMethods.yahtzee("12356"));
		 assertEquals("\nyahtzee(\"12456\")", 0, myMethods.yahtzee("12456"));
		 assertEquals("\nyahtzee(\"13456\")", 0, myMethods.yahtzee("13456"));
	}
	
	public void testBalancedParen() {
		assertTrue("\nbalancedParen(\"a(bc)(d(ef))\")", myMethods.balancedParen("a(bc)(d(ef))"));
		assertTrue("\nbalancedParen(\"(abc)\")", myMethods.balancedParen("(abc)"));
		assertTrue("\nbalancedParen(\"abc()\")", myMethods.balancedParen("abc()"));
		assertTrue("\nbalancedParen(\"ab()c\")", myMethods.balancedParen("ab()c"));
		assertTrue("\nbalancedParen(\"a()bc\")", myMethods.balancedParen("a()bc"));
		assertTrue("\nbalancedParen(\"()abc\")", myMethods.balancedParen("()abc"));
		assertTrue("\nbalancedParen(\"a(bc)\")", myMethods.balancedParen("a(bc)"));
		assertTrue("\nbalancedParen(\"(ab)c\")", myMethods.balancedParen("(ab)c"));
		assertTrue("\nbalancedParen(\"ab(c)\")", myMethods.balancedParen("ab(c)"));
		assertTrue("\nbalancedParen(\"a(b)c\")", myMethods.balancedParen("a(b)c"));
		assertTrue("\nbalancedParen(\"(a)bc\")", myMethods.balancedParen("(a)bc"));
		assertTrue("\nbalancedParen(\"()()\")", myMethods.balancedParen("()()"));
		assertTrue("\nbalancedParen(\"()\")", myMethods.balancedParen("()"));
		assertTrue("\nbalancedParen(\"(())\")", myMethods.balancedParen("(())"));
		assertTrue("\nbalancedParen(\"(()())\")", myMethods.balancedParen("(()())"));
		assertTrue("\nbalancedParen(\"((()())(()()))\")", myMethods.balancedParen("((()())(()()))"));
		assertTrue("\nbalancedParen(\"]} vacuous truth: no parentheses are balanced parentheses {[\")", myMethods.balancedParen("]} vacuous truth: no parentheses are balanced parentheses {["));

		assertFalse("\nbalancedParen(\"((bca(de))\")", myMethods.balancedParen("((bca(de))"));
		assertFalse("\nbalancedParen(\"(((bca(de))\")", myMethods.balancedParen("(((bca(de))"));
		assertFalse("\nbalancedParen(\"a(b))\")", myMethods.balancedParen("a(b))"));
		assertFalse("\nbalancedParen(\"a(b)))\")", myMethods.balancedParen("a(b)))"));
		assertFalse("\nbalancedParen(\")a(\"))", myMethods.balancedParen(")a("));	
		assertFalse("\nbalancedParen(\"())a(\")", myMethods.balancedParen("())a("));
		assertFalse("\nbalancedParen(\"()()()(\")", myMethods.balancedParen("()()()("));
		assertFalse("\nbalancedParen(\"()()()(()\")", myMethods.balancedParen("()()()(()"));
		assertFalse("\nbalancedParen(\"()()()())\")", myMethods.balancedParen("()()()())"));
		assertFalse("\nbalancedParen(\"()()())(\")", myMethods.balancedParen("()()())("));
	}

	private static TestSuite suite() {
		TestSuite suite = new TestSuite("Test for IW4.java");
		suite.addTestSuite(TestMyStrings.class);
		return suite;
	}
}
