/*
 * Your CS1 Professors
 * TestMyLoops.java
 * Tests the methods in IfMethods.java
 * using junit testing.
 * 
 * Do not change anything in this file.
 */
import junit.framework.*;
import java.util.ArrayList;
import java.util.Arrays;

public class TestMyLoops extends TestCase{
	private IW4 myMethods;
	
	public TestMyLoops(){
		super();
		myMethods = new IW4();
	}
	
	public int threeInARow(String flips){
		int index1 = flips.indexOf("HHH");
		int index2 = flips.indexOf("TTT");
		if(index1 == -1 && index2 == -1){
			return -1;
		}
		if (index1 == -1 || index2 == -1){
			return Math.max(index1, index2)+3;
		}
		return Math.min(index1, index2)+3;
	}
	
	public void testThreeInARow(){
		Coin penny = new Coin();
		for(int i = 1; i<=50; i++){
			int answer = myMethods.threeInARow(penny);
			int realAnswer = threeInARow(penny.getFlips());
			//System.out.println(answer+" "+realAnswer);
			assertEquals("\nthreeInARow()", answer, realAnswer);
			
		}
	}
	
	public int betGame(String flips, int bets){
		if(bets > flips.length()){
			return Integer.MAX_VALUE;
		}
		flips = flips.substring(0,bets);
		String noHeads = flips.replaceAll("H","");
		return (noHeads.length()*-1 + (flips.length()-noHeads.length()));
	}
	
	public void testBetGame(){
		Coin penny = new Coin();
		for(int i =1; i<= 50; i++){
			int answer = myMethods.betGame(penny, i);
			int realAnswer = betGame(penny.getFlips(), i);
			assertEquals("\nbetGame(penny," + i +")", realAnswer, answer);
		}
	}
	
	public void testPennies(){
		for(int i = 1; i<= 100; i++){
			int desired = (int)(Math.random()*(30)+1);
			int answer = myMethods.pennies(desired);
			int highBound = (int)(Math.pow(2, desired)) -1;
			//System.out.println(answer+", "+highBound);
			assertEquals("\npennies(" + desired +")", highBound, answer);
			
		}
	}
	
	public void testGetAnA(){
		
		assertEquals("\ngetAnA(90)", 0, myMethods.getAnA(90));
		assertEquals("\ngetAnA(50)", 40, myMethods.getAnA(50));
		assertEquals("\ngetAnA(70)", 20, myMethods.getAnA(70));
		assertEquals("\ngetAnA(73)", 17, myMethods.getAnA(73));
		assertEquals("\ngetAnA(79)", 11, myMethods.getAnA(79));
		assertEquals("\ngetAnA(81)", 9, myMethods.getAnA(81));
		assertEquals("\ngetAnA(83)", 7, myMethods.getAnA(83));
		assertEquals("\ngetAnA(85)", 5, myMethods.getAnA(85));
		assertEquals("\ngetAnA(88)", 2, myMethods.getAnA(88));
	}
	
	public void testFindDigit() {
		assertEquals("\nmyMethods.findDigit(12468, 8)", 1, myMethods.findDigit(12468, 8));
		assertEquals("\nmyMethods.findDigit(12468, 6)", 10, myMethods.findDigit(12468, 6));
		assertEquals("\nmyMethods.findDigit(12468, 4)", 100, myMethods.findDigit(12468, 4));
		assertEquals("\nmyMethods.findDigit(12468, 2)", 1000, myMethods.findDigit(12468, 2));
		assertEquals("\nmyMethods.findDigit(12468, 1)", 10000, myMethods.findDigit(12468, 1));
		assertEquals("\nmyMethods.findDigit(2468, 8)", 1, myMethods.findDigit(2468, 8));
		assertEquals("\nmyMethods.findDigit(2468, 6)", 10, myMethods.findDigit(2468, 6));
		assertEquals("\nmyMethods.findDigit(2468, 4)", 100, myMethods.findDigit(2468, 4));
		assertEquals("\nmyMethods.findDigit(2468, 2)", 1000, myMethods.findDigit(2468, 2));
		assertEquals("\nmyMethods.findDigit(2468, 1)", -1, myMethods.findDigit(2468, 1));
		assertEquals("\nmyMethods.findDigit(468, 8)", 1, myMethods.findDigit(468, 8));
		assertEquals("\nmyMethods.findDigit(468, 6)", 10, myMethods.findDigit(468, 6));
		assertEquals("\nmyMethods.findDigit(468, 4)", 100, myMethods.findDigit(468, 4));
		assertEquals("\nmyMethods.findDigit(468, 2)", -1, myMethods.findDigit(468, 2));
		assertEquals("\nmyMethods.findDigit(468, 1)", -1, myMethods.findDigit(468, 1));
		assertEquals("\nmyMethods.findDigit(68, 8)", 1, myMethods.findDigit(68, 8));
		assertEquals("\nmyMethods.findDigit(68, 6)", 10, myMethods.findDigit(68, 6));
		assertEquals("\nmyMethods.findDigit(68, 4)", -1, myMethods.findDigit(68, 4));
		assertEquals("\nmyMethods.findDigit(68, 2)", -1, myMethods.findDigit(68, 2));
		assertEquals("\nmyMethods.findDigit(68, 1)", -1, myMethods.findDigit(68, 1));
		assertEquals("\nmyMethods.findDigit(8, 8)", 1, myMethods.findDigit(8, 8));
		assertEquals("\nmyMethods.findDigit(8, 6)", -1, myMethods.findDigit(8, 6));
		assertEquals("\nmyMethods.findDigit(8, 4)", -1, myMethods.findDigit(8, 4));
		assertEquals("\nmyMethods.findDigit(8, 2)", -1, myMethods.findDigit(8, 2));
		assertEquals("\nmyMethods.findDigit(8, 1)", -1, myMethods.findDigit(8, 1));

		assertEquals("\nmyMethods.findDigit(5577, 7)", 1, myMethods.findDigit(5577, 7));
		assertEquals("\nmyMethods.findDigit(5577, 5)", 100, myMethods.findDigit(5577, 5));
		assertEquals("\nmyMethods.findDigit(5577, 9)", -1, myMethods.findDigit(5577, 9));

		assertEquals("\nmyMethods.findDigit(3939339, 3)", 10, myMethods.findDigit(3939339, 3));
		assertEquals("\nmyMethods.findDigit(3939339, 9)", 1, myMethods.findDigit(3939339, 9));

		assertEquals("\nmyMethods.findDigit(10101, 0)", 10, myMethods.findDigit(10101, 0));
		assertEquals("\nmyMethods.findDigit(10101, 1)", 1, myMethods.findDigit(10101, 1));
		assertEquals("\nmyMethods.findDigit(10101, 2)", -1, myMethods.findDigit(10101, 2));

		assertEquals("\nmyMethods.findDigit(1010, 0)", 1, myMethods.findDigit(1010, 0));
		assertEquals("\nmyMethods.findDigit(1010, 1)", 10, myMethods.findDigit(1010, 1));
		assertEquals("\nmyMethods.findDigit(1010, 2)", -1, myMethods.findDigit(1010, 2));

		assertEquals("\nmyMethods.findDigit(123456789, 0)", -1, myMethods.findDigit(123456789, 0));
		assertEquals("\nmyMethods.findDigit(123456789, 1)", 100000000, myMethods.findDigit(123456789, 1));
		assertEquals("\nmyMethods.findDigit(123456789, 2)", 10000000, myMethods.findDigit(123456789, 2));
		assertEquals("\nmyMethods.findDigit(123456789, 3)", 1000000, myMethods.findDigit(123456789, 3));
		assertEquals("\nmyMethods.findDigit(123456789, 4)", 100000, myMethods.findDigit(123456789, 4));
		assertEquals("\nmyMethods.findDigit(123456789, 5)", 10000, myMethods.findDigit(123456789, 5));
		assertEquals("\nmyMethods.findDigit(123456789, 6)", 1000, myMethods.findDigit(123456789, 6));
		assertEquals("\nmyMethods.findDigit(123456789, 7)", 100, myMethods.findDigit(123456789, 7));
		assertEquals("\nmyMethods.findDigit(123456789, 8)", 10, myMethods.findDigit(123456789, 8));
		assertEquals("\nmyMethods.findDigit(123456789, 9)", 1, myMethods.findDigit(123456789, 9));
	}

	private static TestSuite suite() {
		TestSuite suite = new TestSuite("Test for IW4.java");
		suite.addTestSuite(TestMyLoops.class);
		return suite;
	}
}
