/*
 * Shannon Duvall
 * IfMethodsTest.java
 * Tests the methods in IfMethods.java
 * using junit testing.
 * 
 * Do not change anything in this file.
 */
import junit.framework.*;

public class IfMethodsTest extends TestCase{
	private IfMethods myMethods;
	
	public IfMethodsTest(){
		super();
		myMethods = new IfMethods();
	}
	
	public void testAmtInOrder(){
		int sm = 10 + (int)(Math.random()*9);
		int md = 20 + (int)(Math.random()*9);
		int lg = 30 + (int)(Math.random()*9);
		
		assertEquals("\namtInOrder(" + sm + ", " + md + ", " + lg + ")", 2, myMethods.amtInOrder(sm, md, lg));
		assertEquals("\namtInOrder(" + sm + ", " + lg + ", " + md + ")", 1, myMethods.amtInOrder(sm, lg, md));
		assertEquals("\namtInOrder(" + md + ", " + sm + ", " + lg + ")", 1, myMethods.amtInOrder(md, sm, lg));
		assertEquals("\namtInOrder(" + md + ", " + lg + ", " + sm + ")", 1, myMethods.amtInOrder(md, lg, sm));
		assertEquals("\namtInOrder(" + lg + ", " + sm + ", " + md + ")", 1, myMethods.amtInOrder(lg, sm, md));
		assertEquals("\namtInOrder(" + lg + ", " + md + ", " + sm + ")", 0, myMethods.amtInOrder(lg, md, sm));
		assertEquals("\namtInOrder(" + sm + ", " + sm + ", " + lg + ")", 1, myMethods.amtInOrder(sm, sm, lg));
		assertEquals("\namtInOrder(" + md + ", " + sm + ", " + sm + ")", 0, myMethods.amtInOrder(md, sm, sm));
		assertEquals("\namtInOrder(" + lg + ", " + md + ", " + lg + ")", 1, myMethods.amtInOrder(lg, md, lg));
		assertEquals("\namtInOrder(" + md + ", " + md + ", " + md + ")", 0, myMethods.amtInOrder(md, md, md));
	}
	
	public void testBlackJack(){
		// player wins - no blackjack
		for (int p = 5; p < 21; p++) {
			for (int d = 4; d < p; d++) {
				for (int w = 5; w < 100; w += 5) {
					assertEquals("\nblackJack(" + p + ", " + d + ", " + w + ")", w*2, myMethods.blackJack(p, d, w));
				}
			}
		}
		// player wins - blackjack
		for (int d = 4; d < 21; d++) {
			for (int w = 5; w < 100; w += 5) {
				assertEquals("\nblackJack(21, " + d + ", " + w + ")", w*3, myMethods.blackJack(21, d, w));
			}
		}
		// dealer wins
		for (int d = 5; d < 21; d++) {
			for (int p = 4; p < d; p++) {
				for (int w = 5; w < 100; w += 5) {
					assertEquals("\nblackJack(" + p + ", " + d + ", " + w + ")", 0, myMethods.blackJack(p, d, w));
				}
			}
		}
		// tie
		for (int d = 5; d < 21; d++) {
			int p = d;
			for (int w = 5; w < 100; w += 5) {
				assertEquals("\nblackJack(" + p + ", " + d + ", " + w + ")", w, myMethods.blackJack(p, d, w));
			}
		}
	}
	
	public void testCanTake(){
		 assertTrue("\ncanTake('O', '+', 'O', '+')", myMethods.canTake('O', '+', 'O', '+'));
		assertFalse("\ncanTake('O', '+', 'O', '-')", myMethods.canTake('O', '+', 'O', '-'));
		 assertTrue("\ncanTake('O', '+', 'A', '+')", myMethods.canTake('O', '+', 'A', '+'));
		assertFalse("\ncanTake('O', '+', 'A', '-')", myMethods.canTake('O', '+', 'A', '-'));
		 assertTrue("\ncanTake('O', '+', 'B', '+')", myMethods.canTake('O', '+', 'B', '+'));
		assertFalse("\ncanTake('O', '+', 'B', '-')", myMethods.canTake('O', '+', 'B', '-'));

		 assertTrue("\ncanTake('O', '-', 'O', '+')", myMethods.canTake('O', '-', 'O', '+'));
		 assertTrue("\ncanTake('O', '-', 'O', '-')", myMethods.canTake('O', '-', 'O', '-'));
		 assertTrue("\ncanTake('O', '-', 'A', '+')", myMethods.canTake('O', '-', 'A', '+'));
		 assertTrue("\ncanTake('O', '-', 'A', '-')", myMethods.canTake('O', '-', 'A', '-'));
		 assertTrue("\ncanTake('O', '-', 'B', '+')", myMethods.canTake('O', '-', 'B', '+'));
		 assertTrue("\ncanTake('O', '-', 'B', '-')", myMethods.canTake('O', '-', 'B', '-'));

		assertFalse("\ncanTake('A', '+', 'O', '+')", myMethods.canTake('A', '+', 'O', '+'));
		assertFalse("\ncanTake('A', '+', 'O', '-')", myMethods.canTake('A', '+', 'O', '-'));
		 assertTrue("\ncanTake('A', '+', 'A', '+')", myMethods.canTake('A', '+', 'A', '+'));
		assertFalse("\ncanTake('A', '+', 'A', '-')", myMethods.canTake('A', '+', 'A', '-'));
		assertFalse("\ncanTake('A', '+', 'B', '+')", myMethods.canTake('A', '+', 'B', '+'));
		assertFalse("\ncanTake('A', '+', 'B', '-')", myMethods.canTake('A', '+', 'B', '-'));

		assertFalse("\ncanTake('A', '-', 'O', '+')", myMethods.canTake('A', '-', 'O', '+'));
		assertFalse("\ncanTake('A', '-', 'O', '-')", myMethods.canTake('A', '-', 'O', '-'));
		 assertTrue("\ncanTake('A', '-', 'A', '+')", myMethods.canTake('A', '-', 'A', '+'));
		 assertTrue("\ncanTake('A', '-', 'A', '-')", myMethods.canTake('A', '-', 'A', '-'));
		assertFalse("\ncanTake('A', '-', 'B', '+')", myMethods.canTake('A', '-', 'B', '+'));
		assertFalse("\ncanTake('A', '-', 'B', '-')", myMethods.canTake('A', '-', 'B', '-'));

		assertFalse("\ncanTake('B', '+', 'O', '+')", myMethods.canTake('B', '+', 'O', '+'));
		assertFalse("\ncanTake('B', '+', 'O', '-')", myMethods.canTake('B', '+', 'O', '-'));
		assertFalse("\ncanTake('B', '+', 'A', '+')", myMethods.canTake('B', '+', 'A', '+'));
		assertFalse("\ncanTake('B', '+', 'A', '-')", myMethods.canTake('B', '+', 'A', '-'));
		 assertTrue("\ncanTake('B', '+', 'B', '+')", myMethods.canTake('B', '+', 'B', '+'));
		assertFalse("\ncanTake('B', '+', 'B', '-')", myMethods.canTake('B', '+', 'B', '-'));

		assertFalse("\ncanTake('B', '-', 'O', '+')", myMethods.canTake('B', '-', 'O', '+'));
		assertFalse("\ncanTake('B', '-', 'O', '-')", myMethods.canTake('B', '-', 'O', '-'));
		assertFalse("\ncanTake('B', '-', 'A', '+')", myMethods.canTake('B', '-', 'A', '+'));
		assertFalse("\ncanTake('B', '-', 'A', '-')", myMethods.canTake('B', '-', 'A', '-'));
		 assertTrue("\ncanTake('B', '-', 'B', '+')", myMethods.canTake('B', '-', 'B', '+'));
		 assertTrue("\ncanTake('B', '-', 'B', '-')", myMethods.canTake('B', '-', 'B', '-'));
	}
	
	public void testHowClose(){
		assertEquals("\nhowClose(813, 814)", "invalid", myMethods.howClose(813, 814));
		assertEquals("\nhowClose(522, 532)", "invalid", myMethods.howClose(522, 532));
		assertEquals("\nhowClose(666, 766)", "invalid", myMethods.howClose(666, 766));
		assertEquals("\nhowClose(2183, 2184)", "invalid", myMethods.howClose(2183, 2184));
		assertEquals("\nhowClose(4147, 4157)", "invalid", myMethods.howClose(4147, 4157));
		assertEquals("\nhowClose(2151, 2251)", "invalid", myMethods.howClose(2151, 2251));
		assertEquals("\nhowClose(8965, 9965)", "invalid", myMethods.howClose(8965, 9965));

		assertEquals("\nhowClose(813, 14)", "invalid", myMethods.howClose(813, 14));
		assertEquals("\nhowClose(522, 53)", "invalid", myMethods.howClose(522, 53));
		assertEquals("\nhowClose(666, 76)", "invalid", myMethods.howClose(666, 76));
		assertEquals("\nhowClose(2183, 84)", "invalid", myMethods.howClose(2183, 84));
		assertEquals("\nhowClose(4147, 47)", "invalid", myMethods.howClose(4147, 47));
		assertEquals("\nhowClose(2151, 22)", "invalid", myMethods.howClose(2151, 22));

		assertEquals("\nhowClose(814, 814)", "pretty close", myMethods.howClose(814, 814));
		assertEquals("\nhowClose(822, 814)", "pretty close", myMethods.howClose(822, 814));
		assertEquals("\nhowClose(854, 814)", "pretty close", myMethods.howClose(854, 814));
		assertEquals("\nhowClose(855, 814)", "close enough", myMethods.howClose(855, 814));
		assertEquals("\nhowClose(895, 814)", "close enough", myMethods.howClose(895, 814));
		assertEquals("\nhowClose(896, 814)", "different", myMethods.howClose(896, 814));
		assertEquals("\nhowClose(936, 814)", "different", myMethods.howClose(936, 814));
		assertEquals("\nhowClose(103, 103)", "pretty close", myMethods.howClose(103, 103));
		assertEquals("\nhowClose(104, 103)", "pretty close", myMethods.howClose(104, 103));
		assertEquals("\nhowClose(108, 103)", "pretty close", myMethods.howClose(108, 103));
		assertEquals("\nhowClose(109, 103)", "close enough", myMethods.howClose(109, 103));
		assertEquals("\nhowClose(113, 103)", "close enough", myMethods.howClose(113, 103));
		assertEquals("\nhowClose(114, 103)", "different", myMethods.howClose(114, 103));
		assertEquals("\nhowClose(118, 103)", "different", myMethods.howClose(118, 103));
		assertEquals("\nhowClose(532, 532)", "pretty close", myMethods.howClose(532, 532));
		assertEquals("\nhowClose(537, 532)", "pretty close", myMethods.howClose(537, 532));
		assertEquals("\nhowClose(558, 532)", "pretty close", myMethods.howClose(558, 532));
		assertEquals("\nhowClose(559, 532)", "close enough", myMethods.howClose(559, 532));
		assertEquals("\nhowClose(585, 532)", "close enough", myMethods.howClose(585, 532));
		assertEquals("\nhowClose(586, 532)", "different", myMethods.howClose(586, 532));
		assertEquals("\nhowClose(611, 532)", "different", myMethods.howClose(611, 532));
		assertEquals("\nhowClose(766, 766)", "pretty close", myMethods.howClose(766, 766));
		assertEquals("\nhowClose(773, 766)", "pretty close", myMethods.howClose(773, 766));
		assertEquals("\nhowClose(804, 766)", "pretty close", myMethods.howClose(804, 766));
		assertEquals("\nhowClose(805, 766)", "close enough", myMethods.howClose(805, 766));
		assertEquals("\nhowClose(842, 766)", "close enough", myMethods.howClose(842, 766));
		assertEquals("\nhowClose(843, 766)", "different", myMethods.howClose(843, 766));
		assertEquals("\nhowClose(880, 766)", "different", myMethods.howClose(880, 766));
		assertEquals("\nhowClose(907, 907)", "pretty close", myMethods.howClose(907, 907));
		assertEquals("\nhowClose(916, 907)", "pretty close", myMethods.howClose(916, 907));
		assertEquals("\nhowClose(952, 907)", "pretty close", myMethods.howClose(952, 907));
		assertEquals("\nhowClose(953, 907)", "close enough", myMethods.howClose(953, 907));
		assertEquals("\nhowClose(997, 907)", "close enough", myMethods.howClose(997, 907));
		assertEquals("\nhowClose(998, 907)", "different", myMethods.howClose(998, 907));
		assertEquals("\nhowClose(1043, 907)", "different", myMethods.howClose(1043, 907));
		assertEquals("\nhowClose(2184, 2184)", "pretty close", myMethods.howClose(2184, 2184));
		assertEquals("\nhowClose(2205, 2184)", "pretty close", myMethods.howClose(2205, 2184));
		assertEquals("\nhowClose(2293, 2184)", "pretty close", myMethods.howClose(2293, 2184));
		assertEquals("\nhowClose(2294, 2184)", "close enough", myMethods.howClose(2294, 2184));
		assertEquals("\nhowClose(2402, 2184)", "close enough", myMethods.howClose(2402, 2184));
		assertEquals("\nhowClose(2403, 2184)", "different", myMethods.howClose(2403, 2184));
		assertEquals("\nhowClose(2511, 2184)", "different", myMethods.howClose(2511, 2184));
		assertEquals("\nhowClose(4157, 4157)", "pretty close", myMethods.howClose(4157, 4157));
		assertEquals("\nhowClose(4198, 4157)", "pretty close", myMethods.howClose(4198, 4157));
		assertEquals("\nhowClose(4364, 4157)", "pretty close", myMethods.howClose(4364, 4157));
		assertEquals("\nhowClose(4365, 4157)", "close enough", myMethods.howClose(4365, 4157));
		assertEquals("\nhowClose(4572, 4157)", "close enough", myMethods.howClose(4572, 4157));
		assertEquals("\nhowClose(4573, 4157)", "different", myMethods.howClose(4573, 4157));
		assertEquals("\nhowClose(4780, 4157)", "different", myMethods.howClose(4780, 4157));
		assertEquals("\nhowClose(2251, 2251)", "pretty close", myMethods.howClose(2251, 2251));
		assertEquals("\nhowClose(2273, 2251)", "pretty close", myMethods.howClose(2273, 2251));
		assertEquals("\nhowClose(2363, 2251)", "pretty close", myMethods.howClose(2363, 2251));
		assertEquals("\nhowClose(2364, 2251)", "close enough", myMethods.howClose(2364, 2251));
		assertEquals("\nhowClose(2476, 2251)", "close enough", myMethods.howClose(2476, 2251));
		assertEquals("\nhowClose(2477, 2251)", "different", myMethods.howClose(2477, 2251));
		assertEquals("\nhowClose(2588, 2251)", "different", myMethods.howClose(2588, 2251));
		assertEquals("\nhowClose(9965, 9965)", "pretty close", myMethods.howClose(9965, 9965));
		assertEquals("\nhowClose(10064, 9965)", "pretty close", myMethods.howClose(10064, 9965));
		assertEquals("\nhowClose(10463, 9965)", "pretty close", myMethods.howClose(10463, 9965));
		assertEquals("\nhowClose(10464, 9965)", "close enough", myMethods.howClose(10464, 9965));
		assertEquals("\nhowClose(10961, 9965)", "close enough", myMethods.howClose(10961, 9965));
		assertEquals("\nhowClose(10962, 9965)", "different", myMethods.howClose(10962, 9965));
		assertEquals("\nhowClose(11459, 9965)", "different", myMethods.howClose(11459, 9965));
		assertEquals("\nhowClose(4717, 4717)", "pretty close", myMethods.howClose(4717, 4717));
		assertEquals("\nhowClose(4764, 4717)", "pretty close", myMethods.howClose(4764, 4717));
		assertEquals("\nhowClose(4952, 4717)", "pretty close", myMethods.howClose(4952, 4717));
		assertEquals("\nhowClose(4953, 4717)", "close enough", myMethods.howClose(4953, 4717));
		assertEquals("\nhowClose(5188, 4717)", "close enough", myMethods.howClose(5188, 4717));
		assertEquals("\nhowClose(5189, 4717)", "different", myMethods.howClose(5189, 4717));
		assertEquals("\nhowClose(5424, 4717)", "different", myMethods.howClose(5424, 4717));
	}
	
	public void testWhichOrder(){
		int sm = 10 + (int)(Math.random()*9);
		int md = 20 + (int)(Math.random()*9);
		int lg = 30 + (int)(Math.random()*9);
		
		assertEquals("\nwhichOrder(" + sm + ", " + md + ", " + lg + ")", "cba", myMethods.whichOrder(sm, md, lg));
		assertEquals("\nwhichOrder(" + sm + ", " + lg + ", " + md + ")", "bca", myMethods.whichOrder(sm, lg, md));
		assertEquals("\nwhichOrder(" + md + ", " + sm + ", " + lg + ")", "cab", myMethods.whichOrder(md, sm, lg));
		assertEquals("\nwhichOrder(" + md + ", " + lg + ", " + sm + ")", "bac", myMethods.whichOrder(md, lg, sm));
		assertEquals("\nwhichOrder(" + lg + ", " + sm + ", " + md + ")", "acb", myMethods.whichOrder(lg, sm, md));
		assertEquals("\nwhichOrder(" + lg + ", " + md + ", " + sm + ")", "abc", myMethods.whichOrder(lg, md, sm));
		assertEquals("\nwhichOrder(" + sm + ", " + sm + ", " + lg + ")", "xxx", myMethods.whichOrder(sm, sm, lg));
		assertEquals("\nwhichOrder(" + md + ", " + sm + ", " + sm + ")", "xxx", myMethods.whichOrder(md, sm, sm));
		assertEquals("\nwhichOrder(" + lg + ", " + md + ", " + lg + ")", "xxx", myMethods.whichOrder(lg, md, lg));
		assertEquals("\nwhichOrder(" + md + ", " + md + ", " + md + ")", "xxx", myMethods.whichOrder(md, md, md));
	}
	
	private static TestSuite suite() {
		TestSuite suite = new TestSuite("Test for IfMethods.java");
		suite.addTestSuite(IfMethodsTest.class);
		return suite;
	}
}
