/*
 * Authors: Your CS1 Professors
 * 
 * Tester.java
 * Used to test the code in the Arithmetic object.
 * 
 * To run it, choose Run -> Run As -> JUnit Test.
 * 
 * DO NOT EDIT THIS FILE.
 */
import junit.framework.*;
import java.awt.Point;


public class Tester extends TestCase{

	private Arithmetic myMethods;

	public Tester(){
		super();
		myMethods = new Arithmetic();
	}

	public void testComputeGrade()
	{
		assertEquals("\ncomputeGrade(97, 85, 75)", 86, myMethods.computeGrade(97, 85, 75));
		assertEquals("\ncomputeGrade(100, 100, 100)", 100, myMethods.computeGrade(100, 100, 100));
		assertEquals("\ncomputeGrade(0, 0, 0)", 0, myMethods.computeGrade(0, 0, 0));
		assertEquals("\ncomputeGrade(85, 75, 97)", 82, myMethods.computeGrade(85, 75, 97));
		assertEquals("\ncomputeGrade(75, 97, 85)", 88, myMethods.computeGrade(75, 97, 85));
		assertEquals("\ncomputeGrade(96, 84, 75)", 85, myMethods.computeGrade(96, 84, 75));
		assertEquals("\ncomputeGrade(70, 71, 72)", 70, myMethods.computeGrade(70, 71, 72));
		assertEquals("\ncomputeGrade(72, 71, 70)", 71, myMethods.computeGrade(72, 71, 70));
		assertEquals("\ncomputeGrade(22.2, 55.5, 33.3)", 41, myMethods.computeGrade(22.2, 55.5, 33.3));
		assertEquals("\ncomputeGrade(22.2, 33.3, 55.5)", 34, myMethods.computeGrade(22.2, 33.3, 55.5));
		assertEquals("\ncomputeGrade(33.3, 55.5, 22.2)", 42, myMethods.computeGrade(33.3, 55.5, 22.2));
		assertEquals("\ncomputeGrade(33.3, 22.2, 55.5)", 32, myMethods.computeGrade(33.3, 22.2, 55.5));
		assertEquals("\ncomputeGrade(55.5, 22.2, 33.3)", 34, myMethods.computeGrade(55.5, 22.2, 33.3));
		assertEquals("\ncomputeGrade(55.5, 33.3, 22.2)", 37, myMethods.computeGrade(55.5, 33.3, 22.2));
	}
	
	public void testComputeDistance(){
		double d;
		d = myMethods.computeDistance(10);
		assertTrue("\ncomputeDistance(10) should be about 490 but was " + d, d > 489.99999 && d < 490.00001);
		d = myMethods.computeDistance(0);
		assertTrue("\ncomputeDistance(0) should be about 0 but was " + d, d > -0.00001 && d < 0.00001);
		d = myMethods.computeDistance(0.5);
		assertTrue("\ncomputeDistance(0.5) should be about 1.22 but was " + d, d > 1.22499 && d < 1.22501);
		d = myMethods.computeDistance(1);
		assertTrue("\ncomputeDistance(1) should be about 4.9 but was " + d, d > 4.89999 && d < 4.90001);
		d = myMethods.computeDistance(2.2);
		assertTrue("\ncomputeDistance(2.2) should be about 23.716 but was " + d, d > 23.71599 && d < 23.71601);
		d = myMethods.computeDistance(3.99);
		assertTrue("\ncomputeDistance(3.99) should be about 78.00849 but was " + d, d > 78.00848 && d < 78.0085);
		d = myMethods.computeDistance(4.01);
		assertTrue("\ncomputeDistance(4.01) should be about 78.79249 but was " + d, d > 78.79248 && d < 78.7925);
		d = myMethods.computeDistance(1000);
		assertTrue("\ncomputeDistance(1000) should be about 4900000 but was " + d, d > 4899999.99999 && d < 4900000.00001);
		d = myMethods.computeDistance(55.55);
		assertTrue("\ncomputeDistance(55.55) should be about 15120.43225 but was " + d, d > 15120.43224 && d < 15120.43226);
	}
	
	public void testGetDigit(){
		assertEquals("\ngetDigit(1234, 1)", 4, myMethods.getDigit(1234, 1));
		assertEquals("\ngetDigit(1234, 10)", 3, myMethods.getDigit(1234, 10));
		assertEquals("\ngetDigit(1234, 100)", 2, myMethods.getDigit(1234, 100));
		assertEquals("\ngetDigit(1234, 1000)", 1, myMethods.getDigit(1234, 1000));
		assertEquals("\ngetDigit(9999, 1)", 9, myMethods.getDigit(9999, 1));
		assertEquals("\ngetDigit(9999, 10)", 9, myMethods.getDigit(9999, 10));
		assertEquals("\ngetDigit(9999, 100)", 9, myMethods.getDigit(9999, 100));
		assertEquals("\ngetDigit(9999, 1000)", 9, myMethods.getDigit(9999, 1000));
		assertEquals("\ngetDigit(1000, 1)", 0, myMethods.getDigit(1000, 1));
		assertEquals("\ngetDigit(1000, 10)", 0, myMethods.getDigit(1000, 10));
		assertEquals("\ngetDigit(1000, 100)", 0, myMethods.getDigit(1000, 100));
		assertEquals("\ngetDigit(1000, 1000)", 1, myMethods.getDigit(1000, 1000));
		assertEquals("\ngetDigit(9999, 1)", 9, myMethods.getDigit(9999, 1));
		assertEquals("\ngetDigit(9998, 1)", 8, myMethods.getDigit(9998, 1));
		assertEquals("\ngetDigit(9997, 1)", 7, myMethods.getDigit(9997, 1));
		assertEquals("\ngetDigit(9996, 1)", 6, myMethods.getDigit(9996, 1));
		assertEquals("\ngetDigit(9995, 1)", 5, myMethods.getDigit(9995, 1));
		assertEquals("\ngetDigit(9994, 1)", 4, myMethods.getDigit(9994, 1));
		assertEquals("\ngetDigit(9993, 1)", 3, myMethods.getDigit(9993, 1));
		assertEquals("\ngetDigit(9992, 1)", 2, myMethods.getDigit(9992, 1));
		assertEquals("\ngetDigit(9991, 1)", 1, myMethods.getDigit(9991, 1));
		assertEquals("\ngetDigit(9990, 1)", 0, myMethods.getDigit(9990, 1));
		assertEquals("\ngetDigit(9989, 10)", 8, myMethods.getDigit(9989, 10));
		assertEquals("\ngetDigit(9979, 10)", 7, myMethods.getDigit(9979, 10));
		assertEquals("\ngetDigit(9969, 10)", 6, myMethods.getDigit(9969, 10));
		assertEquals("\ngetDigit(9959, 10)", 5, myMethods.getDigit(9959, 10));
		assertEquals("\ngetDigit(9949, 10)", 4, myMethods.getDigit(9949, 10));
		assertEquals("\ngetDigit(9939, 10)", 3, myMethods.getDigit(9939, 10));
		assertEquals("\ngetDigit(9929, 10)", 2, myMethods.getDigit(9929, 10));
		assertEquals("\ngetDigit(9919, 10)", 1, myMethods.getDigit(9919, 10));
		assertEquals("\ngetDigit(9909, 10)", 0, myMethods.getDigit(9909, 10));
		assertEquals("\ngetDigit(9899, 100)", 8, myMethods.getDigit(9899, 100));
		assertEquals("\ngetDigit(9799, 100)", 7, myMethods.getDigit(9799, 100));
		assertEquals("\ngetDigit(9699, 100)", 6, myMethods.getDigit(9699, 100));
		assertEquals("\ngetDigit(9599, 100)", 5, myMethods.getDigit(9599, 100));
		assertEquals("\ngetDigit(9499, 100)", 4, myMethods.getDigit(9499, 100));
		assertEquals("\ngetDigit(9399, 100)", 3, myMethods.getDigit(9399, 100));
		assertEquals("\ngetDigit(9299, 100)", 2, myMethods.getDigit(9299, 100));
		assertEquals("\ngetDigit(9199, 100)", 1, myMethods.getDigit(9199, 100));
		assertEquals("\ngetDigit(9099, 100)", 0, myMethods.getDigit(9099, 100));
		assertEquals("\ngetDigit(8999, 1000)", 8, myMethods.getDigit(8999, 1000));
		assertEquals("\ngetDigit(7999, 1000)", 7, myMethods.getDigit(7999, 1000));
		assertEquals("\ngetDigit(6999, 1000)", 6, myMethods.getDigit(6999, 1000));
		assertEquals("\ngetDigit(5999, 1000)", 5, myMethods.getDigit(5999, 1000));
		assertEquals("\ngetDigit(4999, 1000)", 4, myMethods.getDigit(4999, 1000));
		assertEquals("\ngetDigit(3999, 1000)", 3, myMethods.getDigit(3999, 1000));
		assertEquals("\ngetDigit(2999, 1000)", 2, myMethods.getDigit(2999, 1000));
		assertEquals("\ngetDigit(1999, 1000)", 1, myMethods.getDigit(1999, 1000));
	}
	
	public void testTicketCounter(){
		Prizes p;
		int b = 0;
		int g = 0;
		int s = 0;
		p = myMethods.ticketCounter(1);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(1)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n0 bears, 0 gumballs, and 1 stickers.",b == 0 && g == 0 && s == 1);
		p = myMethods.ticketCounter(2);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(2)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n0 bears, 0 gumballs, and 2 stickers.",b == 0 && g == 0 && s == 2);
		p = myMethods.ticketCounter(3);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(3)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n0 bears, 1 gumballs, and 0 stickers.",b == 0 && g == 1 && s == 0);
		p = myMethods.ticketCounter(4);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(4)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n0 bears, 1 gumballs, and 1 stickers.",b == 0 && g == 1 && s == 1);
		p = myMethods.ticketCounter(5);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(5)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n0 bears, 1 gumballs, and 2 stickers.",b == 0 && g == 1 && s == 2);
		p = myMethods.ticketCounter(6);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(6)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n0 bears, 2 gumballs, and 0 stickers.",b == 0 && g == 2 && s == 0);
		p = myMethods.ticketCounter(7);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(7)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n0 bears, 2 gumballs, and 1 stickers.",b == 0 && g == 2 && s == 1);
		p = myMethods.ticketCounter(8);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(8)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n0 bears, 2 gumballs, and 2 stickers.",b == 0 && g == 2 && s == 2);
		p = myMethods.ticketCounter(9);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(9)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n0 bears, 3 gumballs, and 0 stickers.",b == 0 && g == 3 && s == 0);
		p = myMethods.ticketCounter(10);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(10)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n1 bears, 0 gumballs, and 0 stickers.",b == 1 && g == 0 && s == 0);
		p = myMethods.ticketCounter(11);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(11)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n1 bears, 0 gumballs, and 1 stickers.",b == 1 && g == 0 && s == 1);
		p = myMethods.ticketCounter(12);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(12)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n1 bears, 0 gumballs, and 2 stickers.",b == 1 && g == 0 && s == 2);
		p = myMethods.ticketCounter(13);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(13)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n1 bears, 1 gumballs, and 0 stickers.",b == 1 && g == 1 && s == 0);
		p = myMethods.ticketCounter(14);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(14)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n1 bears, 1 gumballs, and 1 stickers.",b == 1 && g == 1 && s == 1);
		p = myMethods.ticketCounter(15);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(15)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n1 bears, 1 gumballs, and 2 stickers.",b == 1 && g == 1 && s == 2);
		p = myMethods.ticketCounter(16);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(16)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n1 bears, 2 gumballs, and 0 stickers.",b == 1 && g == 2 && s == 0);
		p = myMethods.ticketCounter(17);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(17)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n1 bears, 2 gumballs, and 1 stickers.",b == 1 && g == 2 && s == 1);
		p = myMethods.ticketCounter(18);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(18)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n1 bears, 2 gumballs, and 2 stickers.",b == 1 && g == 2 && s == 2);
		p = myMethods.ticketCounter(19);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(19)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n1 bears, 3 gumballs, and 0 stickers.",b == 1 && g == 3 && s == 0);
		p = myMethods.ticketCounter(20);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(20)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n2 bears, 0 gumballs, and 0 stickers.",b == 2 && g == 0 && s == 0);
		p = myMethods.ticketCounter(21);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(21)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n2 bears, 0 gumballs, and 1 stickers.",b == 2 && g == 0 && s == 1);
		p = myMethods.ticketCounter(22);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(22)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n2 bears, 0 gumballs, and 2 stickers.",b == 2 && g == 0 && s == 2);
		p = myMethods.ticketCounter(23);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(23)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n2 bears, 1 gumballs, and 0 stickers.",b == 2 && g == 1 && s == 0);
		p = myMethods.ticketCounter(24);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(24)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n2 bears, 1 gumballs, and 1 stickers.",b == 2 && g == 1 && s == 1);
		p = myMethods.ticketCounter(25);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(25)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n2 bears, 1 gumballs, and 2 stickers.",b == 2 && g == 1 && s == 2);
		p = myMethods.ticketCounter(26);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(26)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n2 bears, 2 gumballs, and 0 stickers.",b == 2 && g == 2 && s == 0);
		p = myMethods.ticketCounter(27);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(27)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n2 bears, 2 gumballs, and 1 stickers.",b == 2 && g == 2 && s == 1);
		p = myMethods.ticketCounter(28);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(28)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n2 bears, 2 gumballs, and 2 stickers.",b == 2 && g == 2 && s == 2);
		p = myMethods.ticketCounter(29);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(29)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n2 bears, 3 gumballs, and 0 stickers.",b == 2 && g == 3 && s == 0);
		p = myMethods.ticketCounter(30);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(30)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n3 bears, 0 gumballs, and 0 stickers.",b == 3 && g == 0 && s == 0);
		p = myMethods.ticketCounter(31);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(31)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n3 bears, 0 gumballs, and 1 stickers.",b == 3 && g == 0 && s == 1);
		p = myMethods.ticketCounter(32);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(32)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n3 bears, 0 gumballs, and 2 stickers.",b == 3 && g == 0 && s == 2);
		p = myMethods.ticketCounter(33);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(33)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n3 bears, 1 gumballs, and 0 stickers.",b == 3 && g == 1 && s == 0);
		p = myMethods.ticketCounter(34);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(34)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n3 bears, 1 gumballs, and 1 stickers.",b == 3 && g == 1 && s == 1);
		p = myMethods.ticketCounter(35);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(35)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n3 bears, 1 gumballs, and 2 stickers.",b == 3 && g == 1 && s == 2);
		p = myMethods.ticketCounter(36);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(36)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n3 bears, 2 gumballs, and 0 stickers.",b == 3 && g == 2 && s == 0);
		p = myMethods.ticketCounter(37);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(37)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n3 bears, 2 gumballs, and 1 stickers.",b == 3 && g == 2 && s == 1);
		p = myMethods.ticketCounter(38);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(38)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n3 bears, 2 gumballs, and 2 stickers.",b == 3 && g == 2 && s == 2);
		p = myMethods.ticketCounter(39);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(39)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n3 bears, 3 gumballs, and 0 stickers.",b == 3 && g == 3 && s == 0);
		p = myMethods.ticketCounter(40);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(40)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n4 bears, 0 gumballs, and 0 stickers.",b == 4 && g == 0 && s == 0);
		p = myMethods.ticketCounter(41);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(41)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n4 bears, 0 gumballs, and 1 stickers.",b == 4 && g == 0 && s == 1);
		p = myMethods.ticketCounter(42);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(42)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n4 bears, 0 gumballs, and 2 stickers.",b == 4 && g == 0 && s == 2);
		p = myMethods.ticketCounter(43);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(43)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n4 bears, 1 gumballs, and 0 stickers.",b == 4 && g == 1 && s == 0);
		p = myMethods.ticketCounter(44);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(44)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n4 bears, 1 gumballs, and 1 stickers.",b == 4 && g == 1 && s == 1);
		p = myMethods.ticketCounter(45);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(45)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n4 bears, 1 gumballs, and 2 stickers.",b == 4 && g == 1 && s == 2);
		p = myMethods.ticketCounter(46);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(46)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n4 bears, 2 gumballs, and 0 stickers.",b == 4 && g == 2 && s == 0);
		p = myMethods.ticketCounter(47);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(47)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n4 bears, 2 gumballs, and 1 stickers.",b == 4 && g == 2 && s == 1);
		p = myMethods.ticketCounter(48);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(48)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n4 bears, 2 gumballs, and 2 stickers.",b == 4 && g == 2 && s == 2);
		p = myMethods.ticketCounter(49);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(49)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n4 bears, 3 gumballs, and 0 stickers.",b == 4 && g == 3 && s == 0);
		p = myMethods.ticketCounter(50);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(50)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n5 bears, 0 gumballs, and 0 stickers.",b == 5 && g == 0 && s == 0);
		p = myMethods.ticketCounter(51);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(51)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n5 bears, 0 gumballs, and 1 stickers.",b == 5 && g == 0 && s == 1);
		p = myMethods.ticketCounter(52);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(52)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n5 bears, 0 gumballs, and 2 stickers.",b == 5 && g == 0 && s == 2);
		p = myMethods.ticketCounter(53);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(53)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n5 bears, 1 gumballs, and 0 stickers.",b == 5 && g == 1 && s == 0);
		p = myMethods.ticketCounter(54);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(54)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n5 bears, 1 gumballs, and 1 stickers.",b == 5 && g == 1 && s == 1);
		p = myMethods.ticketCounter(55);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(55)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n5 bears, 1 gumballs, and 2 stickers.",b == 5 && g == 1 && s == 2);
		p = myMethods.ticketCounter(56);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(56)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n5 bears, 2 gumballs, and 0 stickers.",b == 5 && g == 2 && s == 0);
		p = myMethods.ticketCounter(57);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(57)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n5 bears, 2 gumballs, and 1 stickers.",b == 5 && g == 2 && s == 1);
		p = myMethods.ticketCounter(58);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(58)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n5 bears, 2 gumballs, and 2 stickers.",b == 5 && g == 2 && s == 2);
		p = myMethods.ticketCounter(59);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(59)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n5 bears, 3 gumballs, and 0 stickers.",b == 5 && g == 3 && s == 0);
		p = myMethods.ticketCounter(60);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(60)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n6 bears, 0 gumballs, and 0 stickers.",b == 6 && g == 0 && s == 0);
		p = myMethods.ticketCounter(61);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(61)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n6 bears, 0 gumballs, and 1 stickers.",b == 6 && g == 0 && s == 1);
		p = myMethods.ticketCounter(62);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(62)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n6 bears, 0 gumballs, and 2 stickers.",b == 6 && g == 0 && s == 2);
		p = myMethods.ticketCounter(63);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(63)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n6 bears, 1 gumballs, and 0 stickers.",b == 6 && g == 1 && s == 0);
		p = myMethods.ticketCounter(64);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(64)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n6 bears, 1 gumballs, and 1 stickers.",b == 6 && g == 1 && s == 1);
		p = myMethods.ticketCounter(65);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(65)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n6 bears, 1 gumballs, and 2 stickers.",b == 6 && g == 1 && s == 2);
		p = myMethods.ticketCounter(66);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(66)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n6 bears, 2 gumballs, and 0 stickers.",b == 6 && g == 2 && s == 0);
		p = myMethods.ticketCounter(67);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(67)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n6 bears, 2 gumballs, and 1 stickers.",b == 6 && g == 2 && s == 1);
		p = myMethods.ticketCounter(68);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(68)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n6 bears, 2 gumballs, and 2 stickers.",b == 6 && g == 2 && s == 2);
		p = myMethods.ticketCounter(69);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(69)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n6 bears, 3 gumballs, and 0 stickers.",b == 6 && g == 3 && s == 0);
		p = myMethods.ticketCounter(70);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(70)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n7 bears, 0 gumballs, and 0 stickers.",b == 7 && g == 0 && s == 0);
		p = myMethods.ticketCounter(71);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(71)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n7 bears, 0 gumballs, and 1 stickers.",b == 7 && g == 0 && s == 1);
		p = myMethods.ticketCounter(72);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(72)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n7 bears, 0 gumballs, and 2 stickers.",b == 7 && g == 0 && s == 2);
		p = myMethods.ticketCounter(73);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(73)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n7 bears, 1 gumballs, and 0 stickers.",b == 7 && g == 1 && s == 0);
		p = myMethods.ticketCounter(74);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(74)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n7 bears, 1 gumballs, and 1 stickers.",b == 7 && g == 1 && s == 1);
		p = myMethods.ticketCounter(75);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(75)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n7 bears, 1 gumballs, and 2 stickers.",b == 7 && g == 1 && s == 2);
		p = myMethods.ticketCounter(76);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(76)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n7 bears, 2 gumballs, and 0 stickers.",b == 7 && g == 2 && s == 0);
		p = myMethods.ticketCounter(77);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(77)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n7 bears, 2 gumballs, and 1 stickers.",b == 7 && g == 2 && s == 1);
		p = myMethods.ticketCounter(78);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(78)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n7 bears, 2 gumballs, and 2 stickers.",b == 7 && g == 2 && s == 2);
		p = myMethods.ticketCounter(79);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(79)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n7 bears, 3 gumballs, and 0 stickers.",b == 7 && g == 3 && s == 0);
		p = myMethods.ticketCounter(80);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(80)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n8 bears, 0 gumballs, and 0 stickers.",b == 8 && g == 0 && s == 0);
		p = myMethods.ticketCounter(81);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(81)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n8 bears, 0 gumballs, and 1 stickers.",b == 8 && g == 0 && s == 1);
		p = myMethods.ticketCounter(82);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(82)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n8 bears, 0 gumballs, and 2 stickers.",b == 8 && g == 0 && s == 2);
		p = myMethods.ticketCounter(83);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(83)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n8 bears, 1 gumballs, and 0 stickers.",b == 8 && g == 1 && s == 0);
		p = myMethods.ticketCounter(84);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(84)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n8 bears, 1 gumballs, and 1 stickers.",b == 8 && g == 1 && s == 1);
		p = myMethods.ticketCounter(85);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(85)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n8 bears, 1 gumballs, and 2 stickers.",b == 8 && g == 1 && s == 2);
		p = myMethods.ticketCounter(86);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(86)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n8 bears, 2 gumballs, and 0 stickers.",b == 8 && g == 2 && s == 0);
		p = myMethods.ticketCounter(87);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(87)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n8 bears, 2 gumballs, and 1 stickers.",b == 8 && g == 2 && s == 1);
		p = myMethods.ticketCounter(88);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(88)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n8 bears, 2 gumballs, and 2 stickers.",b == 8 && g == 2 && s == 2);
		p = myMethods.ticketCounter(89);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(89)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n8 bears, 3 gumballs, and 0 stickers.",b == 8 && g == 3 && s == 0);
		p = myMethods.ticketCounter(90);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(90)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n9 bears, 0 gumballs, and 0 stickers.",b == 9 && g == 0 && s == 0);
		p = myMethods.ticketCounter(91);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(91)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n9 bears, 0 gumballs, and 1 stickers.",b == 9 && g == 0 && s == 1);
		p = myMethods.ticketCounter(92);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(92)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n9 bears, 0 gumballs, and 2 stickers.",b == 9 && g == 0 && s == 2);
		p = myMethods.ticketCounter(93);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(93)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n9 bears, 1 gumballs, and 0 stickers.",b == 9 && g == 1 && s == 0);
		p = myMethods.ticketCounter(94);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(94)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n9 bears, 1 gumballs, and 1 stickers.",b == 9 && g == 1 && s == 1);
		p = myMethods.ticketCounter(95);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(95)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n9 bears, 1 gumballs, and 2 stickers.",b == 9 && g == 1 && s == 2);
		p = myMethods.ticketCounter(96);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(96)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n9 bears, 2 gumballs, and 0 stickers.",b == 9 && g == 2 && s == 0);
		p = myMethods.ticketCounter(97);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(97)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n9 bears, 2 gumballs, and 1 stickers.",b == 9 && g == 2 && s == 1);
		p = myMethods.ticketCounter(98);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(98)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n9 bears, 2 gumballs, and 2 stickers.",b == 9 && g == 2 && s == 2);
		p = myMethods.ticketCounter(99);
		b = p.getBears();
		g = p.getGumBalls();
		s = p.getStickers();
		assertTrue("\nOn ticketCounter(99)\n" + b + " bears, " + g + " gumballs, and " + s + " stickers were returned but should have been\n9 bears, 3 gumballs, and 0 stickers.",b == 9 && g == 3 && s == 0);
	}
	
	public void testScaleMAR(){
		Point size;
		size = myMethods.scaleMAR(400, 300, 300, 224);
		assertTrue("\nOn scaleMAR(400, 300, 300, 224)\n(" + size.x + "," + size.y + ") was returned but it should have been\n(298,224)",size.x == 298 && size.y == 224);
		size = myMethods.scaleMAR(400, 300, 300, 225);
		assertTrue("\nOn scaleMAR(400, 300, 300, 225)\n(" + size.x + "," + size.y + ") was returned but it should have been\n(300,225)",size.x == 300 && size.y == 225);
		size = myMethods.scaleMAR(400, 300, 300, 226);
		assertTrue("\nOn scaleMAR(400, 300, 300, 226)\n(" + size.x + "," + size.y + ") was returned but it should have been\n(300,225)",size.x == 300 && size.y == 225);
		size = myMethods.scaleMAR(300, 400, 224, 300);
		assertTrue("\nOn scaleMAR(300, 400, 224, 300)\n(" + size.x + "," + size.y + ") was returned but it should have been\n(224,298)",size.x == 224 && size.y == 298);
		size = myMethods.scaleMAR(300, 400, 225, 300);
		assertTrue("\nOn scaleMAR(300, 400, 225, 300)\n(" + size.x + "," + size.y + ") was returned but it should have been\n(225,300)",size.x == 225 && size.y == 300);
		size = myMethods.scaleMAR(300, 400, 226, 300);
		assertTrue("\nOn scaleMAR(300, 400, 226, 300)\n(" + size.x + "," + size.y + ") was returned but it should have been\n(225,300)",size.x == 225 && size.y == 300);
		size = myMethods.scaleMAR(400, 400, 226, 300);
		assertTrue("\nOn scaleMAR(400, 400, 226, 300)\n(" + size.x + "," + size.y + ") was returned but it should have been\n(226,226)",size.x == 226 && size.y == 226);
		size = myMethods.scaleMAR(400, 400, 300, 226);
		assertTrue("\nOn scaleMAR(400, 400, 300, 226)\n(" + size.x + "," + size.y + ") was returned but it should have been\n(226,226)",size.x == 226 && size.y == 226);
	}
	
	private static TestSuite suite() {
		TestSuite suite = new TestSuite("Test for Arithmetic.java");
		suite.addTestSuite(Tester.class);
		return suite;
	}
}
