package connectfour2013;

/*
 * GameBoard.java
 *
 * @author  J. Hollingsworth
 * revised by Shannon Duvall
 * revised by Duke Hutchings
 *
 * A two-dimensional gameboard for Connect-Four.
 */

public class GameBoard
{
	public static final int OPEN = 0;
	public static final int RED = 1;
	public static final int BLACK = 2;

	private int [][] board;
	
	private int lastColumnPlayed;
	private int lastColorPlayed;

	GameBoard(int numRows, int numCols) {
		board = new int[numRows][numCols];
		reset();
	}
	
	/*
	 * PARTNER WORK:  Complete the hasWinner method.
	 * Use the board variable declared above.  Return whether
	 * or not there are four elements in the table in a 
	 * row that are all RED or BLACK.  
	 * 
	 * Hint: Most likely, this code has several double-for loops:
	 * one for each direction you check.  Be sure you don't try to
	 * rows or columns that don't exist.
	 * 
	 * When the code works, the game will correctly detect when there are 
	 * four in a row in any direction.  Be sure to test it thoroughly.
	 */
	public boolean hasWinner() {
		return false;		
	}

	public void reset() {
		lastColumnPlayed = -1;
		lastColorPlayed = OPEN;
		for(int row=0; row<board.length; row++) {
			for(int col=0; col<board[0].length; col++) {
				board[row][col]= OPEN;
			}
		}
	}

	public int[][] getBoard2D() {
		return board;
	}
	
	public int getRowAmt() {
		return board.length;
	}

	public int getColAmt() {
		return board[0].length;
	}

	public GameBoard getCopy() {
		GameBoard clone = new GameBoard(board.length, board[0].length);
		for(int i=0; i<board.length; i++) {
			for(int j=0; j<board[0].length; j++) {
				clone.board[i][j] = this.board[i][j];
			}
		}
		clone.lastColumnPlayed = this.lastColumnPlayed;
		clone.lastColorPlayed = this.lastColorPlayed;
		return clone;
	}

	public boolean play(int col, int mark) {
		if(!canPlay(col)) {
			return false;
		}
		for (int row=board.length-1; row>=0; row--) {
			if (board[row][col] == OPEN) {
				board[row][col] = mark;
				lastColumnPlayed = col;
				lastColorPlayed = mark;
				return true;
			}
		}
		return false;
	}

	public boolean canPlay(int col) {
		if (col < 0 || col >= board[0].length) {
			return false;
		}
		for (int row=board.length-1; row>=0; row--) {
			if (board[row][col] == OPEN) {
				return true;
			}
		}
		return false;
	}
	
	public int prevColumn() {
		return lastColumnPlayed;
	}

	public int prevColor() {
		return lastColorPlayed;
	}

	public void dumpBoard(){
		for(int i=0;i<board.length;i++) {
			for(int j=0; j<board[i].length; j++) {
				System.out.print(board[i][j]);
			}
			System.out.println();
		}
	}
}
