// * Duke Hutchings
// * TestCasesFile.java
// * Tests the methods in YourWork.java
// * using junit testing.
// * 
// * Do not change anything in this file.

import junit.framework.*;

public class TestCasesFile extends TestCase {

	private YourWork yourMethods;
	
	public TestCasesFile(){
		super();
		yourMethods = new YourWork();
	}
	
	private boolean[] boolArr(String s) {
		boolean [] arr = new boolean[s.length()];
		for (int i = 0; i < arr.length; i++) {
			if (s.substring(i,i+1).equals("T")) {
				arr[i] = true;
			}
		}
		return arr;
	}
	
	private int[] intArr(String s) {
		int [] arr = new int[s.length()];
		for (int i = 0; i < arr.length; i++) {
			arr[i] = Integer.parseInt(s.substring(i, i+1));
		}
		return arr;
	}
	
	private String[] strArr(String s) {
		return s.split(",");
	}
	
	private boolean test_check_8(String[] a, String[] b) {
		if (a.length != b.length) return false;
		for (int i = 0; i < a.length; i++) {
			if (a[i] != null && b[i] != null) {
				if (!a[i].equals(b[i])) {
					return false;
				}
			}
			else if (!(a[i] == null && b[i] == null)) {
				return false;
			}
		}
		return true;
	}
	
	private String convert_8(String[] a) {
		String conv = "|";
		for (int i = 0; i < a.length; i++) {
			if (a[i] == null) a[i] = "null";
			conv = conv + a[i] + "|";
		}
		return conv;
	}
	
	public void test_p1() {
		for (int i = 1; i < 10; i++) {
			for (int j = 0; j < i; j++) {
				for (int k = 0; k < 10; k++) {
					String sout = k + "R" + j;
					int n = i*k+j;
					int d = i;
					String sin = "(" + n + "," + d + ")";
					assertEquals("\np1" + sin, sout, yourMethods.p1(n,d));
				}
			}
		}
	}

	public void test_p2() {
		assertEquals("\np2(0,0,0)", "black", yourMethods.p2(0,0,0));

		assertEquals("\np2(127,127,127)", "dark", yourMethods.p2(127,127,127));
		assertEquals("\np2(127,0,0)", "dark", yourMethods.p2(127,0,0));
		assertEquals("\np2(0,127,0)", "dark", yourMethods.p2(0,127,0));
		assertEquals("\np2(0,0,127)", "dark", yourMethods.p2(0,0,127));
		assertEquals("\np2(127,127,0)", "dark", yourMethods.p2(127,127,0));
		assertEquals("\np2(0,127,127)", "dark", yourMethods.p2(0,127,127));
		assertEquals("\np2(127,0,127)", "dark", yourMethods.p2(127,0,127));

		assertEquals("\np2(128,0,0)", "bright", yourMethods.p2(128,0,0));
		assertEquals("\np2(0,128,0)", "bright", yourMethods.p2(0,128,0));
		assertEquals("\np2(0,0,128)", "bright", yourMethods.p2(0,0,128));
		assertEquals("\np2(128,128,0)", "bright", yourMethods.p2(128,128,0));
		assertEquals("\np2(0,128,128)", "bright", yourMethods.p2(0,128,128));
		assertEquals("\np2(128,0,128)", "bright", yourMethods.p2(128,0,128));

		for (int i = 128; i < 256; i+=5) {
			for (int j = 0; j < 256; j+=5) {
				String sin = "(" + i + "," + j + "," + j + ")";
				assertEquals("\np2" + sin, "bright", yourMethods.p2(i,i,j));
				sin = "(" + j + "," + i + "," + j + ")";
				assertEquals("\np2" + sin, "bright", yourMethods.p2(j,i,j));
				sin = "(" + j + "," + j + "," + i + ")";
				assertEquals("\np2" + sin, "bright", yourMethods.p2(j,j,i));
				sin = "(" + i + "," + i + "," + j + ")";
				assertEquals("\np2" + sin, "bright", yourMethods.p2(i,i,j));
				sin = "(" + i + "," + j + "," + i + ")";
				assertEquals("\np2" + sin, "bright", yourMethods.p2(i,j,i));
				sin = "(" + i + "," + i + "," + j + ")";
				assertEquals("\np2" + sin, "bright", yourMethods.p2(i,i,j));
				sin = "(" + i + "," + i + "," + i + ")";
				assertEquals("\np2" + sin, "bright", yourMethods.p2(i,i,i));
			}
		}
		for (int r = 1; r < 128; r++) {
			for (int g = 1; g < 128; g+=2) {
				for (int b = 1; b < 128; b+=2) {
					String sin = "(" + r + "," + g + "," + b + ")";
					assertEquals("\np2" + sin, "dark", yourMethods.p2(r,g,b));
				}
			}
		}
	}
	
	public void test_p3() {
		assertEquals("\np3(0.0)", 0, yourMethods.p3(0.0));
		assertEquals("\np3(1.9)", 0, yourMethods.p3(1.9));
		assertEquals("\np3(2.0)", 0, yourMethods.p3(2.0));
		assertEquals("\np3(2.1)", 1, yourMethods.p3(2.1));
		assertEquals("\np3(3.9)", 1, yourMethods.p3(3.9));
		assertEquals("\np3(4.0)", 1, yourMethods.p3(4.0));
		assertEquals("\np3(4.1)", 2, yourMethods.p3(4.1));
		assertEquals("\np3(7.9)", 2, yourMethods.p3(7.9));
		assertEquals("\np3(8.0)", 2, yourMethods.p3(8.0));
		assertEquals("\np3(8.1)", 3, yourMethods.p3(8.1));
		assertEquals("\np3(15.9)", 3, yourMethods.p3(15.9));
		assertEquals("\np3(16.0)", 3, yourMethods.p3(16.0));
		assertEquals("\np3(16.1)", 4, yourMethods.p3(16.1));
		assertEquals("\np3(31.0)", 4, yourMethods.p3(31.0));
		assertEquals("\np3(32.0)", 4, yourMethods.p3(32.0));
		assertEquals("\np3(33.0)", 5, yourMethods.p3(33.0));
	}
	
	public void test_p4() {
		assertEquals("\np4(\"OliveBreadSwissPastramiBread\")", "SwissPastrami", yourMethods.p4("OliveBreadSwissPastramiBread"));
		assertEquals("\np4(\"BreadBurgerBreadGrease\")", "Burger", yourMethods.p4("BreadBurgerBreadGrease"));
		assertEquals("\np4(\"ButterBreadCheeseBreadButter\")", "Cheese", yourMethods.p4("ButterBreadCheeseBreadButter"));
		assertEquals("\np4(\"ButterBreadButterBreadButter\")", "Butter", yourMethods.p4("ButterBreadButterBreadButter"));
		assertEquals("\np4(\"BreadPB&JBread\")", "PB&J", yourMethods.p4("BreadPB&JBread"));
		assertEquals("\np4(\"BreadBread\")", "", yourMethods.p4("BreadBread"));
		assertEquals("\np4(\"OliveBreadMushroomMushroomMushroomBread\")", "MushroomMushroomMushroom", yourMethods.p4("OliveBreadMushroomMushroomMushroomBread"));
		assertEquals("\np4(\"BreadBaconBurgerDogBreadGrease\")", "BaconBurgerDog", yourMethods.p4("BreadBaconBurgerDogBreadGrease"));
		assertEquals("\np4(\"SeedsBreadSprinklesBreadCrumbs\")", "Sprinkles", yourMethods.p4("SeedsBreadSprinklesBreadCrumbs"));
		assertEquals("\np4(\"BreadMeatballBread\")", "Meatball", yourMethods.p4("BreadMeatballBread"));
		assertEquals("\np4(\"BreadBBread\")", "B", yourMethods.p4("BreadBBread"));
	}
	
	public void test_p5() {
		assertEquals("\np5 input: |1|2|3|4| and |1|2|3|4|", "T", yourMethods.p5(intArr("1234"), intArr("1234")));
		assertEquals("\np5 input: |1|2|3|4| and |1|3|5|3|", "T", yourMethods.p5(intArr("1234"), intArr("1353")));
		assertEquals("\np5 input: |1|2|3|5| and |1|2|3|4|", "F", yourMethods.p5(intArr("1235"), intArr("1234")));
		assertEquals("\np5 input: |1|2|3|4| and |1|2|3|5|", "S", yourMethods.p5(intArr("1234"), intArr("1235")));
		assertEquals("\np5 input: |1|8|3|4| and |1|2|3|4|", "F", yourMethods.p5(intArr("1834"), intArr("1234")));
		assertEquals("\np5 input: |1|2|3|4| and |1|2|6|4|", "S", yourMethods.p5(intArr("1234"), intArr("1264")));
		assertEquals("\np5 input: |0|1|0|0| and |5|0|0|0|", "T", yourMethods.p5(intArr("0100"), intArr("5000")));
		assertEquals("\np5 input: |0|0|1|0| and |0|2|0|0|", "T", yourMethods.p5(intArr("0010"), intArr("0200")));
		assertEquals("\np5 input: |0|0|0|2| and |0|0|5|0|", "T", yourMethods.p5(intArr("0002"), intArr("0050")));
		assertEquals("\np5 input: |1|1|0|0| and |5|0|0|0|", "F", yourMethods.p5(intArr("1100"), intArr("5000")));
		assertEquals("\np5 input: |0|1|1|0| and |0|2|0|0|", "F", yourMethods.p5(intArr("0110"), intArr("0200")));
		assertEquals("\np5 input: |0|0|1|2| and |0|0|5|0|", "F", yourMethods.p5(intArr("0012"), intArr("0050")));
		assertEquals("\np5 input: |0|1|0|0| and |5|1|0|0|", "S", yourMethods.p5(intArr("0100"), intArr("5100")));
		assertEquals("\np5 input: |0|0|1|0| and |0|2|1|0|", "S", yourMethods.p5(intArr("0010"), intArr("0210")));
		assertEquals("\np5 input: |0|0|0|2| and |0|0|5|1|", "S", yourMethods.p5(intArr("0002"), intArr("0051")));
		assertEquals("\np5 input: |0|0|0|2| and |1|1|1|0|", "F", yourMethods.p5(intArr("0002"), intArr("1110")));
		assertEquals("\np5 input: |0|0|9|0| and |5|5|0|1|", "F", yourMethods.p5(intArr("0090"), intArr("5501")));
		assertEquals("\np5 input: |2|2|2|0| and |0|0|0|8|", "S", yourMethods.p5(intArr("2220"), intArr("0008")));
		assertEquals("\np5 input: |1|1|5|0| and |1|1|0|3|", "S", yourMethods.p5(intArr("1150"), intArr("1103")));
	}
	
	public void test_p6() {
		assertTrue("\np6 input: |3|4|5|", yourMethods.p6(intArr("345")));
		assertTrue("\np6 input: |1|3|4|5|", yourMethods.p6(intArr("1345")));
		assertTrue("\np6 input: |3|4|5|1|", yourMethods.p6(intArr("3451")));
		assertTrue("\np6 input: |9|0|0|1|2|", yourMethods.p6(intArr("90012")));
		assertTrue("\np6 input: |1|2|3|3|2|1|", yourMethods.p6(intArr("123321")));
		assertTrue("\np6 input: |1|1|2|3|3|2|", yourMethods.p6(intArr("112332")));
		assertTrue("\np6 input: |1|1|1|2|3|3|", yourMethods.p6(intArr("111233")));
		assertTrue("\np6 input: |1|1|1|1|2|3|", yourMethods.p6(intArr("111123")));
		assertTrue("\np6 input: |1|2|3|0|3|2|1|", yourMethods.p6(intArr("123321")));

		assertFalse("\np6 input: |3|4|6|", yourMethods.p6(intArr("346")));
		assertFalse("\np6 input: |3|1|4|5|", yourMethods.p6(intArr("3145")));
		assertFalse("\np6 input: |3|4|1|5|", yourMethods.p6(intArr("3415")));
		assertFalse("\np6 input: |2|3|4|5|", yourMethods.p6(intArr("3415")));
		assertFalse("\np6 input: |3|4|5|6|", yourMethods.p6(intArr("3415")));
		assertFalse("\np6 input: |9|0|2|1|0|", yourMethods.p6(intArr("90210")));
		assertFalse("\np6 input: |9|0|1|2|3|", yourMethods.p6(intArr("90123")));
		assertFalse("\np6 input: |0|1|2|3|9|", yourMethods.p6(intArr("90123")));
		assertFalse("\np6 input: |1|2|3|1|2|3|", yourMethods.p6(intArr("123123")));
		assertFalse("\np6 input: |1|2|3|7|8|9|", yourMethods.p6(intArr("123789")));
		assertFalse("\np6 input: |1|2|3|0|7|8|9|", yourMethods.p6(intArr("123789")));
	}	

	public void test_p7() {
		assertTrue("\np7(1)", yourMethods.p7(1));
		assertTrue("\np7(2)", yourMethods.p7(2));
		assertTrue("\np7(3)", yourMethods.p7(3));
		assertTrue("\np7(4)", yourMethods.p7(4));
		assertTrue("\np7(5)", yourMethods.p7(5));
		assertTrue("\np7(6)", yourMethods.p7(6));
		assertTrue("\np7(7)", yourMethods.p7(7));
		assertTrue("\np7(8)", yourMethods.p7(8));
		assertTrue("\np7(9)", yourMethods.p7(9));
		assertFalse("\np7(10)", yourMethods.p7(10));
		assertTrue("\np7(11)", yourMethods.p7(11));
		assertTrue("\np7(12)", yourMethods.p7(12));
		assertFalse("\np7(13)", yourMethods.p7(13));
		assertFalse("\np7(14)", yourMethods.p7(14));
		assertTrue("\np7(15)", yourMethods.p7(15));
		assertFalse("\np7(16)", yourMethods.p7(16));
		assertFalse("\np7(17)", yourMethods.p7(17));
		assertFalse("\np7(18)", yourMethods.p7(18));
		assertFalse("\np7(19)", yourMethods.p7(19));
		assertFalse("\np7(20)", yourMethods.p7(20));
		assertFalse("\np7(21)", yourMethods.p7(21));
		assertTrue("\np7(22)", yourMethods.p7(22));
		assertFalse("\np7(23)", yourMethods.p7(23));
		assertTrue("\np7(24)", yourMethods.p7(24));
		assertFalse("\np7(25)", yourMethods.p7(25));
		assertFalse("\np7(26)", yourMethods.p7(26));
		assertFalse("\np7(27)", yourMethods.p7(27));
		assertFalse("\np7(28)", yourMethods.p7(28));
		assertFalse("\np7(29)", yourMethods.p7(29));
		assertFalse("\np7(30)", yourMethods.p7(30));
		assertFalse("\np7(31)", yourMethods.p7(31));
		assertFalse("\np7(32)", yourMethods.p7(32));
		assertTrue("\np7(33)", yourMethods.p7(33));
		assertFalse("\np7(34)", yourMethods.p7(34));
		assertFalse("\np7(35)", yourMethods.p7(35));
		assertTrue("\np7(36)", yourMethods.p7(36));
		assertFalse("\np7(37)", yourMethods.p7(37));
		assertFalse("\np7(38)", yourMethods.p7(38));
		assertFalse("\np7(39)", yourMethods.p7(39));
		assertFalse("\np7(40)", yourMethods.p7(40));
		assertFalse("\np7(41)", yourMethods.p7(41));
		assertFalse("\np7(42)", yourMethods.p7(42));
		assertFalse("\np7(43)", yourMethods.p7(43));
		assertTrue("\np7(44)", yourMethods.p7(44));
		assertFalse("\np7(45)", yourMethods.p7(45));
		assertFalse("\np7(46)", yourMethods.p7(46));
		assertFalse("\np7(47)", yourMethods.p7(47));
		assertTrue("\np7(48)", yourMethods.p7(48));
		assertFalse("\np7(49)", yourMethods.p7(49));
		assertFalse("\np7(50)", yourMethods.p7(50));
		assertFalse("\np7(51)", yourMethods.p7(51));
		assertFalse("\np7(52)", yourMethods.p7(52));
		assertFalse("\np7(53)", yourMethods.p7(53));
		assertFalse("\np7(54)", yourMethods.p7(54));
		assertTrue("\np7(55)", yourMethods.p7(55));
		assertFalse("\np7(56)", yourMethods.p7(56));
		assertFalse("\np7(57)", yourMethods.p7(57));
		assertFalse("\np7(58)", yourMethods.p7(58));
		assertFalse("\np7(59)", yourMethods.p7(59));
		assertFalse("\np7(60)", yourMethods.p7(60));
		assertFalse("\np7(61)", yourMethods.p7(61));
		assertFalse("\np7(62)", yourMethods.p7(62));
		assertFalse("\np7(63)", yourMethods.p7(63));
		assertFalse("\np7(64)", yourMethods.p7(64));
		assertFalse("\np7(65)", yourMethods.p7(65));
		assertTrue("\np7(66)", yourMethods.p7(66));
		assertFalse("\np7(67)", yourMethods.p7(67));
		assertFalse("\np7(68)", yourMethods.p7(68));
		assertFalse("\np7(69)", yourMethods.p7(69));
		assertFalse("\np7(70)", yourMethods.p7(70));
		assertFalse("\np7(71)", yourMethods.p7(71));
		assertFalse("\np7(72)", yourMethods.p7(72));
		assertFalse("\np7(73)", yourMethods.p7(73));
		assertFalse("\np7(74)", yourMethods.p7(74));
		assertFalse("\np7(75)", yourMethods.p7(75));
		assertFalse("\np7(76)", yourMethods.p7(76));
		assertTrue("\np7(77)", yourMethods.p7(77));
		assertFalse("\np7(78)", yourMethods.p7(78));
		assertFalse("\np7(79)", yourMethods.p7(79));
		assertFalse("\np7(80)", yourMethods.p7(80));
		assertFalse("\np7(81)", yourMethods.p7(81));
		assertFalse("\np7(82)", yourMethods.p7(82));
		assertFalse("\np7(83)", yourMethods.p7(83));
		assertFalse("\np7(84)", yourMethods.p7(84));
		assertFalse("\np7(85)", yourMethods.p7(85));
		assertFalse("\np7(86)", yourMethods.p7(86));
		assertFalse("\np7(87)", yourMethods.p7(87));
		assertTrue("\np7(88)", yourMethods.p7(88));
		assertFalse("\np7(89)", yourMethods.p7(89));
		assertFalse("\np7(90)", yourMethods.p7(90));
		assertFalse("\np7(91)", yourMethods.p7(91));
		assertFalse("\np7(92)", yourMethods.p7(92));
		assertFalse("\np7(93)", yourMethods.p7(93));
		assertFalse("\np7(94)", yourMethods.p7(94));
		assertFalse("\np7(95)", yourMethods.p7(95));
		assertFalse("\np7(96)", yourMethods.p7(96));
		assertFalse("\np7(97)", yourMethods.p7(97));
		assertFalse("\np7(98)", yourMethods.p7(98));
		assertTrue("\np7(99)", yourMethods.p7(99));
		assertFalse("\np7(100)", yourMethods.p7(100));
		assertFalse("\np7(101)", yourMethods.p7(101));
		assertFalse("\np7(102)", yourMethods.p7(102));
		assertFalse("\np7(103)", yourMethods.p7(103));
		assertFalse("\np7(104)", yourMethods.p7(104));
		assertFalse("\np7(105)", yourMethods.p7(105));
		assertFalse("\np7(106)", yourMethods.p7(106));
		assertFalse("\np7(107)", yourMethods.p7(107));
		assertFalse("\np7(108)", yourMethods.p7(108));
		assertFalse("\np7(109)", yourMethods.p7(109));
		assertFalse("\np7(110)", yourMethods.p7(110));
		assertTrue("\np7(111)", yourMethods.p7(111));
		assertTrue("\np7(112)", yourMethods.p7(112));
		assertFalse("\np7(113)", yourMethods.p7(113));
		assertFalse("\np7(114)", yourMethods.p7(114));
		assertTrue("\np7(115)", yourMethods.p7(115));
		assertFalse("\np7(116)", yourMethods.p7(116));
		assertFalse("\np7(117)", yourMethods.p7(117));
		assertFalse("\np7(118)", yourMethods.p7(118));
		assertFalse("\np7(119)", yourMethods.p7(119));
		assertFalse("\np7(120)", yourMethods.p7(120));
		assertFalse("\np7(121)", yourMethods.p7(121));
		assertTrue("\np7(122)", yourMethods.p7(122));
		assertFalse("\np7(123)", yourMethods.p7(123));
		assertTrue("\np7(124)", yourMethods.p7(124));
		assertFalse("\np7(125)", yourMethods.p7(125));
		assertTrue("\np7(126)", yourMethods.p7(126));
		assertFalse("\np7(127)", yourMethods.p7(127));
		assertTrue("\np7(128)", yourMethods.p7(128));
		assertFalse("\np7(129)", yourMethods.p7(129));
		assertFalse("\np7(130)", yourMethods.p7(130));
		assertFalse("\np7(131)", yourMethods.p7(131));
		assertTrue("\np7(132)", yourMethods.p7(132));
		assertFalse("\np7(133)", yourMethods.p7(133));
		assertFalse("\np7(134)", yourMethods.p7(134));
		assertTrue("\np7(135)", yourMethods.p7(135));
		assertFalse("\np7(136)", yourMethods.p7(136));
		assertFalse("\np7(137)", yourMethods.p7(137));
		assertFalse("\np7(138)", yourMethods.p7(138));
		assertFalse("\np7(139)", yourMethods.p7(139));
		assertFalse("\np7(140)", yourMethods.p7(140));
		assertFalse("\np7(141)", yourMethods.p7(141));
		assertFalse("\np7(142)", yourMethods.p7(142));
		assertFalse("\np7(143)", yourMethods.p7(143));
		assertTrue("\np7(144)", yourMethods.p7(144));
		assertFalse("\np7(145)", yourMethods.p7(145));
		assertFalse("\np7(146)", yourMethods.p7(146));
		assertFalse("\np7(147)", yourMethods.p7(147));
		assertFalse("\np7(148)", yourMethods.p7(148));
		assertFalse("\np7(149)", yourMethods.p7(149));
		assertFalse("\np7(150)", yourMethods.p7(150));
		assertFalse("\np7(151)", yourMethods.p7(151));
		assertFalse("\np7(152)", yourMethods.p7(152));
		assertFalse("\np7(153)", yourMethods.p7(153));
		assertFalse("\np7(154)", yourMethods.p7(154));
		assertTrue("\np7(155)", yourMethods.p7(155));
		assertFalse("\np7(156)", yourMethods.p7(156));
		assertFalse("\np7(157)", yourMethods.p7(157));
		assertFalse("\np7(158)", yourMethods.p7(158));
		assertFalse("\np7(159)", yourMethods.p7(159));
		assertFalse("\np7(160)", yourMethods.p7(160));
		assertFalse("\np7(161)", yourMethods.p7(161));
		assertTrue("\np7(162)", yourMethods.p7(162));
		assertFalse("\np7(163)", yourMethods.p7(163));
		assertFalse("\np7(164)", yourMethods.p7(164));
		assertFalse("\np7(165)", yourMethods.p7(165));
		assertFalse("\np7(166)", yourMethods.p7(166));
		assertFalse("\np7(167)", yourMethods.p7(167));
		assertTrue("\np7(168)", yourMethods.p7(168));
		assertFalse("\np7(169)", yourMethods.p7(169));
		assertFalse("\np7(170)", yourMethods.p7(170));
		assertFalse("\np7(171)", yourMethods.p7(171));
		assertFalse("\np7(172)", yourMethods.p7(172));
		assertFalse("\np7(173)", yourMethods.p7(173));
		assertFalse("\np7(174)", yourMethods.p7(174));
		assertTrue("\np7(175)", yourMethods.p7(175));
		assertFalse("\np7(176)", yourMethods.p7(176));
		assertFalse("\np7(177)", yourMethods.p7(177));
		assertFalse("\np7(178)", yourMethods.p7(178));
		assertFalse("\np7(179)", yourMethods.p7(179));
		assertFalse("\np7(180)", yourMethods.p7(180));
		assertFalse("\np7(181)", yourMethods.p7(181));
		assertFalse("\np7(182)", yourMethods.p7(182));
		assertFalse("\np7(183)", yourMethods.p7(183));
		assertTrue("\np7(184)", yourMethods.p7(184));
		assertFalse("\np7(185)", yourMethods.p7(185));
		assertFalse("\np7(186)", yourMethods.p7(186));
		assertFalse("\np7(187)", yourMethods.p7(187));
		assertFalse("\np7(188)", yourMethods.p7(188));
		assertFalse("\np7(189)", yourMethods.p7(189));
		assertFalse("\np7(190)", yourMethods.p7(190));
		assertFalse("\np7(191)", yourMethods.p7(191));
		assertFalse("\np7(192)", yourMethods.p7(192));
		assertFalse("\np7(193)", yourMethods.p7(193));
		assertFalse("\np7(194)", yourMethods.p7(194));
		assertFalse("\np7(195)", yourMethods.p7(195));
		assertFalse("\np7(196)", yourMethods.p7(196));
		assertFalse("\np7(197)", yourMethods.p7(197));
		assertFalse("\np7(198)", yourMethods.p7(198));
		assertFalse("\np7(199)", yourMethods.p7(199));
		assertFalse("\np7(200)", yourMethods.p7(200));
		assertFalse("\np7(201)", yourMethods.p7(201));
		assertFalse("\np7(202)", yourMethods.p7(202));
		assertFalse("\np7(203)", yourMethods.p7(203));
		assertFalse("\np7(204)", yourMethods.p7(204));
		assertFalse("\np7(205)", yourMethods.p7(205));
		assertFalse("\np7(206)", yourMethods.p7(206));
		assertFalse("\np7(207)", yourMethods.p7(207));
		assertFalse("\np7(208)", yourMethods.p7(208));
		assertFalse("\np7(209)", yourMethods.p7(209));
		assertFalse("\np7(210)", yourMethods.p7(210));
		assertFalse("\np7(211)", yourMethods.p7(211));
		assertTrue("\np7(212)", yourMethods.p7(212));
		assertFalse("\np7(213)", yourMethods.p7(213));
		assertFalse("\np7(214)", yourMethods.p7(214));
		assertFalse("\np7(215)", yourMethods.p7(215));
		assertTrue("\np7(216)", yourMethods.p7(216));
		assertFalse("\np7(217)", yourMethods.p7(217));
		assertFalse("\np7(218)", yourMethods.p7(218));
		assertFalse("\np7(219)", yourMethods.p7(219));
		assertFalse("\np7(220)", yourMethods.p7(220));
		assertFalse("\np7(221)", yourMethods.p7(221));
		assertTrue("\np7(222)", yourMethods.p7(222));
		assertFalse("\np7(223)", yourMethods.p7(223));
		assertTrue("\np7(224)", yourMethods.p7(224));
		assertFalse("\np7(225)", yourMethods.p7(225));
		assertFalse("\np7(226)", yourMethods.p7(226));
		assertFalse("\np7(227)", yourMethods.p7(227));
		assertFalse("\np7(228)", yourMethods.p7(228));
		assertFalse("\np7(229)", yourMethods.p7(229));
		assertFalse("\np7(230)", yourMethods.p7(230));
		assertFalse("\np7(231)", yourMethods.p7(231));
		assertFalse("\np7(232)", yourMethods.p7(232));
		assertFalse("\np7(233)", yourMethods.p7(233));
		assertFalse("\np7(234)", yourMethods.p7(234));
		assertFalse("\np7(235)", yourMethods.p7(235));
		assertFalse("\np7(236)", yourMethods.p7(236));
		assertFalse("\np7(237)", yourMethods.p7(237));
		assertFalse("\np7(238)", yourMethods.p7(238));
		assertFalse("\np7(239)", yourMethods.p7(239));
		assertFalse("\np7(240)", yourMethods.p7(240));
		assertFalse("\np7(241)", yourMethods.p7(241));
		assertFalse("\np7(242)", yourMethods.p7(242));
		assertFalse("\np7(243)", yourMethods.p7(243));
		assertTrue("\np7(244)", yourMethods.p7(244));
		assertFalse("\np7(245)", yourMethods.p7(245));
		assertFalse("\np7(246)", yourMethods.p7(246));
		assertFalse("\np7(247)", yourMethods.p7(247));
		assertTrue("\np7(248)", yourMethods.p7(248));
		assertFalse("\np7(249)", yourMethods.p7(249));
		assertFalse("\np7(250)", yourMethods.p7(250));
		assertFalse("\np7(251)", yourMethods.p7(251));
		assertFalse("\np7(252)", yourMethods.p7(252));
		assertFalse("\np7(253)", yourMethods.p7(253));
		assertFalse("\np7(254)", yourMethods.p7(254));
		assertFalse("\np7(255)", yourMethods.p7(255));
		assertFalse("\np7(256)", yourMethods.p7(256));
		assertFalse("\np7(257)", yourMethods.p7(257));
		assertFalse("\np7(258)", yourMethods.p7(258));
		assertFalse("\np7(259)", yourMethods.p7(259));
		assertFalse("\np7(260)", yourMethods.p7(260));
		assertFalse("\np7(261)", yourMethods.p7(261));
		assertFalse("\np7(262)", yourMethods.p7(262));
		assertFalse("\np7(263)", yourMethods.p7(263));
		assertTrue("\np7(264)", yourMethods.p7(264));
		assertFalse("\np7(265)", yourMethods.p7(265));
		assertFalse("\np7(266)", yourMethods.p7(266));
		assertFalse("\np7(267)", yourMethods.p7(267));
		assertFalse("\np7(268)", yourMethods.p7(268));
		assertFalse("\np7(269)", yourMethods.p7(269));
		assertFalse("\np7(270)", yourMethods.p7(270));
		assertFalse("\np7(271)", yourMethods.p7(271));
		assertFalse("\np7(272)", yourMethods.p7(272));
		assertFalse("\np7(273)", yourMethods.p7(273));
		assertFalse("\np7(274)", yourMethods.p7(274));
		assertFalse("\np7(275)", yourMethods.p7(275));
		assertFalse("\np7(276)", yourMethods.p7(276));
		assertFalse("\np7(277)", yourMethods.p7(277));
		assertFalse("\np7(278)", yourMethods.p7(278));
		assertFalse("\np7(279)", yourMethods.p7(279));
		assertFalse("\np7(280)", yourMethods.p7(280));
		assertFalse("\np7(281)", yourMethods.p7(281));
		assertFalse("\np7(282)", yourMethods.p7(282));
		assertFalse("\np7(283)", yourMethods.p7(283));
		assertFalse("\np7(284)", yourMethods.p7(284));
		assertFalse("\np7(285)", yourMethods.p7(285));
		assertFalse("\np7(286)", yourMethods.p7(286));
		assertFalse("\np7(287)", yourMethods.p7(287));
		assertTrue("\np7(288)", yourMethods.p7(288));
		assertFalse("\np7(289)", yourMethods.p7(289));
		assertFalse("\np7(290)", yourMethods.p7(290));
		assertFalse("\np7(291)", yourMethods.p7(291));
		assertFalse("\np7(292)", yourMethods.p7(292));
		assertFalse("\np7(293)", yourMethods.p7(293));
		assertFalse("\np7(294)", yourMethods.p7(294));
		assertFalse("\np7(295)", yourMethods.p7(295));
		assertFalse("\np7(296)", yourMethods.p7(296));
		assertFalse("\np7(297)", yourMethods.p7(297));
		assertFalse("\np7(298)", yourMethods.p7(298));
		assertFalse("\np7(299)", yourMethods.p7(299));
		assertFalse("\np7(300)", yourMethods.p7(300));
		assertFalse("\np7(301)", yourMethods.p7(301));
		assertFalse("\np7(302)", yourMethods.p7(302));
		assertFalse("\np7(303)", yourMethods.p7(303));
		assertFalse("\np7(304)", yourMethods.p7(304));
		assertFalse("\np7(305)", yourMethods.p7(305));
		assertFalse("\np7(306)", yourMethods.p7(306));
		assertFalse("\np7(307)", yourMethods.p7(307));
		assertFalse("\np7(308)", yourMethods.p7(308));
		assertFalse("\np7(309)", yourMethods.p7(309));
		assertFalse("\np7(310)", yourMethods.p7(310));
		assertFalse("\np7(311)", yourMethods.p7(311));
		assertTrue("\np7(312)", yourMethods.p7(312));
		assertFalse("\np7(313)", yourMethods.p7(313));
		assertFalse("\np7(314)", yourMethods.p7(314));
		assertTrue("\np7(315)", yourMethods.p7(315));
		assertFalse("\np7(316)", yourMethods.p7(316));
		assertFalse("\np7(317)", yourMethods.p7(317));
		assertFalse("\np7(318)", yourMethods.p7(318));
		assertFalse("\np7(319)", yourMethods.p7(319));
		assertFalse("\np7(320)", yourMethods.p7(320));
		assertFalse("\np7(321)", yourMethods.p7(321));
		assertFalse("\np7(322)", yourMethods.p7(322));
		assertFalse("\np7(323)", yourMethods.p7(323));
		assertTrue("\np7(324)", yourMethods.p7(324));
		assertFalse("\np7(325)", yourMethods.p7(325));
		assertFalse("\np7(326)", yourMethods.p7(326));
		assertFalse("\np7(327)", yourMethods.p7(327));
		assertFalse("\np7(328)", yourMethods.p7(328));
		assertFalse("\np7(329)", yourMethods.p7(329));
		assertFalse("\np7(330)", yourMethods.p7(330));
		assertFalse("\np7(331)", yourMethods.p7(331));
		assertFalse("\np7(332)", yourMethods.p7(332));
		assertTrue("\np7(333)", yourMethods.p7(333));
		assertFalse("\np7(334)", yourMethods.p7(334));
		assertFalse("\np7(335)", yourMethods.p7(335));
		assertTrue("\np7(336)", yourMethods.p7(336));
		assertFalse("\np7(337)", yourMethods.p7(337));
		assertFalse("\np7(338)", yourMethods.p7(338));
		assertFalse("\np7(339)", yourMethods.p7(339));
		assertFalse("\np7(340)", yourMethods.p7(340));
		assertFalse("\np7(341)", yourMethods.p7(341));
		assertFalse("\np7(342)", yourMethods.p7(342));
		assertFalse("\np7(343)", yourMethods.p7(343));
		assertFalse("\np7(344)", yourMethods.p7(344));
		assertFalse("\np7(345)", yourMethods.p7(345));
		assertFalse("\np7(346)", yourMethods.p7(346));
		assertFalse("\np7(347)", yourMethods.p7(347));
		assertFalse("\np7(348)", yourMethods.p7(348));
		assertFalse("\np7(349)", yourMethods.p7(349));
		assertFalse("\np7(350)", yourMethods.p7(350));
		assertFalse("\np7(351)", yourMethods.p7(351));
		assertFalse("\np7(352)", yourMethods.p7(352));
		assertFalse("\np7(353)", yourMethods.p7(353));
		assertFalse("\np7(354)", yourMethods.p7(354));
		assertFalse("\np7(355)", yourMethods.p7(355));
		assertFalse("\np7(356)", yourMethods.p7(356));
		assertFalse("\np7(357)", yourMethods.p7(357));
		assertFalse("\np7(358)", yourMethods.p7(358));
		assertFalse("\np7(359)", yourMethods.p7(359));
		assertFalse("\np7(360)", yourMethods.p7(360));
		assertFalse("\np7(361)", yourMethods.p7(361));
		assertFalse("\np7(362)", yourMethods.p7(362));
		assertFalse("\np7(363)", yourMethods.p7(363));
		assertFalse("\np7(364)", yourMethods.p7(364));
		assertFalse("\np7(365)", yourMethods.p7(365));
		assertTrue("\np7(366)", yourMethods.p7(366));
		assertFalse("\np7(367)", yourMethods.p7(367));
		assertFalse("\np7(368)", yourMethods.p7(368));
		assertFalse("\np7(369)", yourMethods.p7(369));
		assertFalse("\np7(370)", yourMethods.p7(370));
		assertFalse("\np7(371)", yourMethods.p7(371));
		assertFalse("\np7(372)", yourMethods.p7(372));
		assertFalse("\np7(373)", yourMethods.p7(373));
		assertFalse("\np7(374)", yourMethods.p7(374));
		assertFalse("\np7(375)", yourMethods.p7(375));
		assertFalse("\np7(376)", yourMethods.p7(376));
		assertFalse("\np7(377)", yourMethods.p7(377));
		assertFalse("\np7(378)", yourMethods.p7(378));
		assertFalse("\np7(379)", yourMethods.p7(379));
		assertFalse("\np7(380)", yourMethods.p7(380));
		assertFalse("\np7(381)", yourMethods.p7(381));
		assertFalse("\np7(382)", yourMethods.p7(382));
		assertFalse("\np7(383)", yourMethods.p7(383));
		assertTrue("\np7(384)", yourMethods.p7(384));
		assertFalse("\np7(385)", yourMethods.p7(385));
		assertFalse("\np7(386)", yourMethods.p7(386));
		assertFalse("\np7(387)", yourMethods.p7(387));
		assertFalse("\np7(388)", yourMethods.p7(388));
		assertFalse("\np7(389)", yourMethods.p7(389));
		assertFalse("\np7(390)", yourMethods.p7(390));
		assertFalse("\np7(391)", yourMethods.p7(391));
		assertFalse("\np7(392)", yourMethods.p7(392));
		assertFalse("\np7(393)", yourMethods.p7(393));
		assertFalse("\np7(394)", yourMethods.p7(394));
		assertFalse("\np7(395)", yourMethods.p7(395));
		assertTrue("\np7(396)", yourMethods.p7(396));
		assertFalse("\np7(397)", yourMethods.p7(397));
		assertFalse("\np7(398)", yourMethods.p7(398));
		assertFalse("\np7(399)", yourMethods.p7(399));
		assertFalse("\np7(400)", yourMethods.p7(400));
		assertFalse("\np7(401)", yourMethods.p7(401));
		assertFalse("\np7(402)", yourMethods.p7(402));
		assertFalse("\np7(403)", yourMethods.p7(403));
		assertFalse("\np7(404)", yourMethods.p7(404));
		assertFalse("\np7(405)", yourMethods.p7(405));
		assertFalse("\np7(406)", yourMethods.p7(406));
		assertFalse("\np7(407)", yourMethods.p7(407));
		assertFalse("\np7(408)", yourMethods.p7(408));
		assertFalse("\np7(409)", yourMethods.p7(409));
		assertFalse("\np7(410)", yourMethods.p7(410));
		assertFalse("\np7(411)", yourMethods.p7(411));
		assertTrue("\np7(412)", yourMethods.p7(412));
		assertFalse("\np7(413)", yourMethods.p7(413));
		assertFalse("\np7(414)", yourMethods.p7(414));
		assertFalse("\np7(415)", yourMethods.p7(415));
		assertFalse("\np7(416)", yourMethods.p7(416));
		assertFalse("\np7(417)", yourMethods.p7(417));
		assertFalse("\np7(418)", yourMethods.p7(418));
		assertFalse("\np7(419)", yourMethods.p7(419));
		assertFalse("\np7(420)", yourMethods.p7(420));
		assertFalse("\np7(421)", yourMethods.p7(421));
		assertFalse("\np7(422)", yourMethods.p7(422));
		assertFalse("\np7(423)", yourMethods.p7(423));
		assertTrue("\np7(424)", yourMethods.p7(424));
		assertFalse("\np7(425)", yourMethods.p7(425));
		assertFalse("\np7(426)", yourMethods.p7(426));
		assertFalse("\np7(427)", yourMethods.p7(427));
		assertFalse("\np7(428)", yourMethods.p7(428));
		assertFalse("\np7(429)", yourMethods.p7(429));
		assertFalse("\np7(430)", yourMethods.p7(430));
		assertFalse("\np7(431)", yourMethods.p7(431));
		assertTrue("\np7(432)", yourMethods.p7(432));
		assertFalse("\np7(433)", yourMethods.p7(433));
		assertFalse("\np7(434)", yourMethods.p7(434));
		assertFalse("\np7(435)", yourMethods.p7(435));
		assertFalse("\np7(436)", yourMethods.p7(436));
		assertFalse("\np7(437)", yourMethods.p7(437));
		assertFalse("\np7(438)", yourMethods.p7(438));
		assertFalse("\np7(439)", yourMethods.p7(439));
		assertFalse("\np7(440)", yourMethods.p7(440));
		assertFalse("\np7(441)", yourMethods.p7(441));
		assertFalse("\np7(442)", yourMethods.p7(442));
		assertFalse("\np7(443)", yourMethods.p7(443));
		assertTrue("\np7(444)", yourMethods.p7(444));
		assertFalse("\np7(445)", yourMethods.p7(445));
		assertFalse("\np7(446)", yourMethods.p7(446));
		assertFalse("\np7(447)", yourMethods.p7(447));
		assertTrue("\np7(448)", yourMethods.p7(448));
		assertFalse("\np7(449)", yourMethods.p7(449));
		assertFalse("\np7(450)", yourMethods.p7(450));
		assertFalse("\np7(451)", yourMethods.p7(451));
		assertFalse("\np7(452)", yourMethods.p7(452));
		assertFalse("\np7(453)", yourMethods.p7(453));
		assertFalse("\np7(454)", yourMethods.p7(454));
		assertFalse("\np7(455)", yourMethods.p7(455));
		assertFalse("\np7(456)", yourMethods.p7(456));
		assertFalse("\np7(457)", yourMethods.p7(457));
		assertFalse("\np7(458)", yourMethods.p7(458));
		assertFalse("\np7(459)", yourMethods.p7(459));
		assertFalse("\np7(460)", yourMethods.p7(460));
		assertFalse("\np7(461)", yourMethods.p7(461));
		assertFalse("\np7(462)", yourMethods.p7(462));
		assertFalse("\np7(463)", yourMethods.p7(463));
		assertFalse("\np7(464)", yourMethods.p7(464));
		assertFalse("\np7(465)", yourMethods.p7(465));
		assertFalse("\np7(466)", yourMethods.p7(466));
		assertFalse("\np7(467)", yourMethods.p7(467));
		assertFalse("\np7(468)", yourMethods.p7(468));
		assertFalse("\np7(469)", yourMethods.p7(469));
		assertFalse("\np7(470)", yourMethods.p7(470));
		assertFalse("\np7(471)", yourMethods.p7(471));
		assertFalse("\np7(472)", yourMethods.p7(472));
		assertFalse("\np7(473)", yourMethods.p7(473));
		assertFalse("\np7(474)", yourMethods.p7(474));
		assertFalse("\np7(475)", yourMethods.p7(475));
		assertFalse("\np7(476)", yourMethods.p7(476));
		assertFalse("\np7(477)", yourMethods.p7(477));
		assertFalse("\np7(478)", yourMethods.p7(478));
		assertFalse("\np7(479)", yourMethods.p7(479));
		assertFalse("\np7(480)", yourMethods.p7(480));
		assertFalse("\np7(481)", yourMethods.p7(481));
		assertFalse("\np7(482)", yourMethods.p7(482));
		assertFalse("\np7(483)", yourMethods.p7(483));
		assertFalse("\np7(484)", yourMethods.p7(484));
		assertFalse("\np7(485)", yourMethods.p7(485));
		assertFalse("\np7(486)", yourMethods.p7(486));
		assertFalse("\np7(487)", yourMethods.p7(487));
		assertTrue("\np7(488)", yourMethods.p7(488));
		assertFalse("\np7(489)", yourMethods.p7(489));
		assertFalse("\np7(490)", yourMethods.p7(490));
		assertFalse("\np7(491)", yourMethods.p7(491));
		assertFalse("\np7(492)", yourMethods.p7(492));
		assertFalse("\np7(493)", yourMethods.p7(493));
		assertFalse("\np7(494)", yourMethods.p7(494));
		assertFalse("\np7(495)", yourMethods.p7(495));
		assertFalse("\np7(496)", yourMethods.p7(496));
		assertFalse("\np7(497)", yourMethods.p7(497));
		assertFalse("\np7(498)", yourMethods.p7(498));
		assertFalse("\np7(499)", yourMethods.p7(499));
		assertFalse("\np7(500)", yourMethods.p7(500));
	}
	
	public void test_p8() {
		String[] arrIn;
		String[] arrOut;
		String m = "\nDouble click test case test_p8 to see which case failed\nYour output was ";
		
		arrIn = strArr("bit,bot,but,bat,bet");
		arrOut = strArr("bat");
		assertTrue(m + convert_8(yourMethods.p8(arrIn, "a")), test_check_8(yourMethods.p8(arrIn, "a"), arrOut));

		arrIn = strArr("bit,bot,but,bat,bet");
		arrOut = strArr("bet");
		assertTrue(m + convert_8(yourMethods.p8(arrIn, "e")), test_check_8(yourMethods.p8(arrIn, "e"), arrOut));

		arrIn = strArr("bit,bot,but,bat,bet");
		arrOut = strArr("bit");
		assertTrue(m + convert_8(yourMethods.p8(arrIn, "i")), test_check_8(yourMethods.p8(arrIn, "i"), arrOut));

		arrIn = strArr("bit,bot,but,bat,bet");
		arrOut = strArr("bot");
		assertTrue(m + convert_8(yourMethods.p8(arrIn, "o")), test_check_8(yourMethods.p8(arrIn, "o"), arrOut));

		arrIn = strArr("bit,bot,but,bat,bet");
		arrOut = strArr("but");
		assertTrue(m + convert_8(yourMethods.p8(arrIn, "u")), test_check_8(yourMethods.p8(arrIn, "u"), arrOut));

		arrIn = strArr("bit,bot,but,bat,bet");
		arrOut = strArr("bit,bot,but,bat,bet");
		assertTrue(m + convert_8(yourMethods.p8(arrIn, "b")), test_check_8(yourMethods.p8(arrIn, "b"), arrOut));

		arrIn = strArr("bit,bot,but,bat,bet");
		arrOut = strArr("bit,bot,but,bat,bet");
		assertTrue(m + convert_8(yourMethods.p8(arrIn, "t")), test_check_8(yourMethods.p8(arrIn, "t"), arrOut));

		arrIn = strArr("bin,bot,but,bat,bet");
		arrOut = strArr("bot,but,bat,bet");
		assertTrue(m + convert_8(yourMethods.p8(arrIn, "t")), test_check_8(yourMethods.p8(arrIn, "t"), arrOut));

		arrIn = strArr("bit,bob,but,bat,bet");
		arrOut = strArr("bit,but,bat,bet");
		assertTrue(m + convert_8(yourMethods.p8(arrIn, "t")), test_check_8(yourMethods.p8(arrIn, "t"), arrOut));

		arrIn = strArr("bit,bot,bun,bat,bet");
		arrOut = strArr("bit,bot,bat,bet");
		assertTrue(m + convert_8(yourMethods.p8(arrIn, "t")), test_check_8(yourMethods.p8(arrIn, "t"), arrOut));

		arrIn = strArr("bit,bot,but,ban,bet");
		arrOut = strArr("bit,bot,but,bet");
		assertTrue(m + convert_8(yourMethods.p8(arrIn, "t")), test_check_8(yourMethods.p8(arrIn, "t"), arrOut));

		arrIn = strArr("bit,bot,but,bat,bee");
		arrOut = strArr("bit,bot,but,bat");
		assertTrue(m + convert_8(yourMethods.p8(arrIn, "t")), test_check_8(yourMethods.p8(arrIn, "t"), arrOut));

		arrIn = strArr("sk,tk,uk,vk,wk,xk,yk,zk");
		arrOut = strArr("sk,tk,uk,vk,wk,xk,yk,zk");
		assertTrue(m + convert_8(yourMethods.p8(arrIn, "k")), test_check_8(yourMethods.p8(arrIn, "k"), arrOut));

		arrIn = strArr("sk,t,uk,v,wk,x,yk,z");
		arrOut = strArr("sk,uk,wk,yk");
		assertTrue(m + convert_8(yourMethods.p8(arrIn, "k")), test_check_8(yourMethods.p8(arrIn, "k"), arrOut));

		arrIn = strArr("s,tk,u,vk,w,xk,y,zk");
		arrOut = strArr("tk,vk,xk,zk");
		assertTrue(m + convert_8(yourMethods.p8(arrIn, "k")), test_check_8(yourMethods.p8(arrIn, "k"), arrOut));

		arrIn = strArr("sk,t,uk,vk,wk,xk,yk,zk");
		arrOut = strArr("sk,uk,vk,wk,xk,yk,zk");
		assertTrue(m + convert_8(yourMethods.p8(arrIn, "k")), test_check_8(yourMethods.p8(arrIn, "k"), arrOut));

		arrIn = strArr("sk,tk,u,vk,w,xk,yk,zk");
		arrOut = strArr("sk,tk,vk,xk,yk,zk");
		assertTrue(m + convert_8(yourMethods.p8(arrIn, "k")), test_check_8(yourMethods.p8(arrIn, "k"), arrOut));

		arrIn = strArr("sk,t,uk,v,wk,xk,y,zk");
		arrOut = strArr("sk,uk,wk,xk,zk");
		assertTrue(m + convert_8(yourMethods.p8(arrIn, "k")), test_check_8(yourMethods.p8(arrIn, "k"), arrOut));

		arrIn = strArr("s,tk,u,v,wk,xk,y,zk");
		arrOut = strArr("tk,wk,xk,zk");
		assertTrue(m + convert_8(yourMethods.p8(arrIn, "k")), test_check_8(yourMethods.p8(arrIn, "k"), arrOut));

		arrIn = strArr("sk,t,u,v,wk,x,yk,z");
		arrOut = strArr("sk,wk,yk");
		assertTrue(m + convert_8(yourMethods.p8(arrIn, "k")), test_check_8(yourMethods.p8(arrIn, "k"), arrOut));

		arrIn = strArr("s,tk,u,vk,w,x,y,z");
		arrOut = strArr("tk,vk");
		assertTrue(m + convert_8(yourMethods.p8(arrIn, "k")), test_check_8(yourMethods.p8(arrIn, "k"), arrOut));
}
	
	private static TestSuite suite() {
		TestSuite suite = new TestSuite("Test for YourWork.java");
		suite.addTestSuite(TestCasesFile.class);
		return suite;
	}
}
